/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.fragment.entry.processor.editable.internal.mapper;

import com.liferay.fragment.entry.processor.editable.mapper.EditableElementMapper;
import com.liferay.fragment.entry.processor.helper.FragmentEntryProcessorHelper;
import com.liferay.fragment.processor.FragmentEntryProcessorContext;
import com.liferay.info.item.provider.InfoItemFieldValuesProvider;
import com.liferay.portal.kernel.exception.PortalException;
import com.liferay.portal.kernel.json.JSONObject;
import com.liferay.portal.kernel.model.Group;
import com.liferay.portal.kernel.model.Layout;
import com.liferay.portal.kernel.service.GroupLocalService;
import com.liferay.portal.kernel.service.LayoutLocalService;
import com.liferay.portal.kernel.theme.ThemeDisplay;
import com.liferay.portal.kernel.util.GetterUtil;
import com.liferay.portal.kernel.util.LocaleUtil;
import com.liferay.portal.kernel.util.Portal;
import com.liferay.portal.kernel.util.StringUtil;
import com.liferay.portal.kernel.util.Validator;
import java.util.HashMap;
import java.util.Locale;
import javax.servlet.http.HttpServletRequest;
import org.jsoup.nodes.Element;
import org.jsoup.nodes.Node;
import org.jsoup.select.Elements;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.Reference;

@Component(immediate=true, property={"type=link"}, service={EditableElementMapper.class})
public class LinkEditableElementMapper
implements EditableElementMapper {
    @Reference
    private FragmentEntryProcessorHelper _fragmentEntryProcessorHelper;
    @Reference
    private GroupLocalService _groupLocalService;
    @Reference
    private LayoutLocalService _layoutLocalService;
    @Reference
    private Portal _portal;

    @Override
    public void map(Element element, JSONObject configJSONObject, FragmentEntryProcessorContext fragmentEntryProcessorContext) throws PortalException {
        String target;
        String href = configJSONObject.getString("href");
        JSONObject hrefJSONObject = configJSONObject.getJSONObject("href");
        boolean assetDisplayPage = this._fragmentEntryProcessorHelper.isAssetDisplayPage(fragmentEntryProcessorContext.getMode());
        boolean collectionMapped = this._fragmentEntryProcessorHelper.isMappedCollection(configJSONObject);
        boolean layoutMapped = this._fragmentEntryProcessorHelper.isMappedLayout(configJSONObject);
        boolean mapped = this._fragmentEntryProcessorHelper.isMapped(configJSONObject);
        if (!(!Validator.isNull((String)href) || hrefJSONObject != null || assetDisplayPage || collectionMapped || layoutMapped || mapped)) {
            return;
        }
        if (collectionMapped) {
            href = GetterUtil.getString((Object)this._fragmentEntryProcessorHelper.getMappedCollectionValue(fragmentEntryProcessorContext.getDisplayObjectOptional(), configJSONObject, fragmentEntryProcessorContext.getLocale()));
        } else if (layoutMapped) {
            href = GetterUtil.getString((Object)this._getMappedLayoutValue(configJSONObject, fragmentEntryProcessorContext));
        } else if (mapped) {
            href = GetterUtil.getString((Object)this._fragmentEntryProcessorHelper.getMappedInfoItemFieldValue(configJSONObject, new HashMap(), fragmentEntryProcessorContext.getLocale(), fragmentEntryProcessorContext.getMode(), fragmentEntryProcessorContext.getPreviewClassPK(), fragmentEntryProcessorContext.getPreviewVersion()));
        } else if (assetDisplayPage && configJSONObject.has("mappedField")) {
            HttpServletRequest httpServletRequest = fragmentEntryProcessorContext.getHttpServletRequest();
            if (httpServletRequest != null) {
                String mappedField = configJSONObject.getString("mappedField");
                Object infoItem = httpServletRequest.getAttribute("INFO_ITEM");
                InfoItemFieldValuesProvider infoItemFieldValuesProvider = (InfoItemFieldValuesProvider)httpServletRequest.getAttribute("INFO_FIELD_VALUES_PROVIDER");
                href = GetterUtil.getString((Object)this._fragmentEntryProcessorHelper.getMappedInfoItemFieldValue(mappedField, infoItemFieldValuesProvider, fragmentEntryProcessorContext.getLocale(), infoItem));
            }
        } else if (hrefJSONObject != null) {
            String languageId = LocaleUtil.toLanguageId((Locale)fragmentEntryProcessorContext.getLocale());
            if (!hrefJSONObject.has(languageId)) {
                languageId = LocaleUtil.toLanguageId((Locale)LocaleUtil.getSiteDefault());
            }
            href = hrefJSONObject.getString(languageId);
        }
        Element linkElement = new Element("a");
        Elements elements = element.children();
        Element firstChildElement = elements.first();
        boolean processEditableTag = false;
        if (StringUtil.equalsIgnoreCase((String)element.tagName(), (String)"a")) {
            linkElement = element;
        } else if (StringUtil.equalsIgnoreCase((String)element.tagName(), (String)"lfr-editable")) {
            processEditableTag = true;
        }
        boolean replaceLink = false;
        if (firstChildElement != null && processEditableTag && StringUtil.equalsIgnoreCase((String)firstChildElement.tagName(), (String)"a")) {
            linkElement = firstChildElement;
            replaceLink = true;
        }
        if (Validator.isNotNull((String)(target = configJSONObject.getString("target")))) {
            if (StringUtil.equalsIgnoreCase((String)target, (String)"_parent") || StringUtil.equalsIgnoreCase((String)target, (String)"_top")) {
                target = "_self";
            }
            linkElement.attr("target", target);
        }
        if (Validator.isNull((String)href)) {
            return;
        }
        linkElement.attr("href", href);
        this._replaceLinkContent(element, firstChildElement, linkElement, replaceLink);
        if ((linkElement != element || processEditableTag) && Validator.isNotNull((String)element.html())) {
            element.html(linkElement.outerHtml());
        } else if (linkElement != element && Validator.isNull((String)element.html())) {
            element.replaceWith((Node)linkElement);
        }
    }

    private Object _getMappedLayoutValue(JSONObject jsonObject, FragmentEntryProcessorContext fragmentEntryProcessorContext) throws PortalException {
        if (!this._fragmentEntryProcessorHelper.isMappedLayout(jsonObject)) {
            return "";
        }
        HttpServletRequest httpServletRequest = fragmentEntryProcessorContext.getHttpServletRequest();
        if (httpServletRequest == null) {
            return "";
        }
        ThemeDisplay themeDisplay = (ThemeDisplay)httpServletRequest.getAttribute("LIFERAY_SHARED_THEME_DISPLAY");
        if (themeDisplay == null) {
            return "";
        }
        JSONObject layoutJSONObject = jsonObject.getJSONObject("layout");
        long groupId = layoutJSONObject.getLong("groupId");
        Group group = this._groupLocalService.fetchGroup(groupId);
        if (group == null) {
            return "#";
        }
        Layout layout = this._layoutLocalService.fetchLayout(groupId, layoutJSONObject.getBoolean("privateLayout"), layoutJSONObject.getLong("layoutId"));
        if (layout == null) {
            return "#";
        }
        return this._portal.getLayoutRelativeURL(layout, themeDisplay);
    }

    private void _replaceLinkContent(Element element, Element firstChildElement, Element linkElement, boolean replaceLink) {
        if (replaceLink && Validator.isNull((String)firstChildElement.html())) {
            linkElement.html(firstChildElement.outerHtml());
        } else if (replaceLink && Validator.isNotNull((String)firstChildElement.html())) {
            linkElement.html(firstChildElement.html());
        } else if (Validator.isNull((String)element.html())) {
            linkElement.html(element.outerHtml());
        } else {
            linkElement.html(element.html());
        }
    }
}

