/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.fragment.entry.processor.editable.internal.parser;

import com.liferay.fragment.entry.processor.editable.EditableFragmentEntryProcessor;
import com.liferay.fragment.entry.processor.editable.parser.EditableElementParser;
import com.liferay.fragment.entry.processor.editable.parser.util.EditableElementParserUtil;
import com.liferay.fragment.exception.FragmentEntryContentException;
import com.liferay.portal.kernel.json.JSONObject;
import com.liferay.portal.kernel.language.LanguageUtil;
import com.liferay.portal.kernel.util.ResourceBundleUtil;
import com.liferay.portal.kernel.util.StringUtil;
import com.liferay.portal.kernel.util.Validator;
import java.util.Objects;
import java.util.ResourceBundle;
import org.jsoup.nodes.Element;
import org.osgi.service.component.annotations.Component;

@Component(immediate=true, property={"type=text"}, service={EditableElementParser.class})
public class TextEditableElementParser
implements EditableElementParser {
    private static final String[] _TAGS_BLACKLIST = new String[]{"img", "a"};
    private static final String _TMPL_VALIDATE_TEXT_FIELD = StringUtil.read(EditableFragmentEntryProcessor.class, (String)"/META-INF/resources/fragment/entry/processor/editable/text_field_template.tmpl");

    @Override
    public String getFieldTemplate() {
        return _TMPL_VALIDATE_TEXT_FIELD;
    }

    @Override
    public String getValue(Element element) {
        String html = element.html();
        if (Validator.isNull((String)html.trim())) {
            ResourceBundle resourceBundle = ResourceBundleUtil.getBundle((String)"content.Language", this.getClass());
            return LanguageUtil.get((ResourceBundle)resourceBundle, (String)"example-text");
        }
        return html;
    }

    @Override
    public void replace(Element element, String value) {
        this.replace(element, value, null);
    }

    @Override
    public void replace(Element element, String value, JSONObject configJSONObject) {
        Element bodyElement = EditableElementParserUtil.getDocumentBody(value);
        if (configJSONObject == null) {
            element.html(bodyElement.html());
            return;
        }
        EditableElementParserUtil.addClass(element, configJSONObject, "text-", "textAlignment");
        EditableElementParserUtil.addClass(element, configJSONObject, "text-", "textColor");
        EditableElementParserUtil.addClass(element, configJSONObject, "", "textStyle");
        element.html(bodyElement.html());
    }

    @Override
    public void validate(Element element) throws FragmentEntryContentException {
        for (String tag : _TAGS_BLACKLIST) {
            if (!Objects.equals(element.tagName(), tag)) continue;
            ResourceBundle resourceBundle = ResourceBundleUtil.getBundle((String)"content.Language", this.getClass());
            throw new FragmentEntryContentException(LanguageUtil.format((ResourceBundle)resourceBundle, (String)"an-editable-of-type-x-cannot-be-used-in-a-tag-of-type-x", (Object[])new Object[]{this.getEditableElementType(), tag}, (boolean)false));
        }
    }

    protected String getEditableElementType() {
        return "text";
    }
}

