/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.fragment.entry.processor.editable.parser.impl;

import com.liferay.fragment.entry.processor.editable.EditableFragmentEntryProcessor;
import com.liferay.fragment.entry.processor.editable.parser.EditableElementParser;
import com.liferay.portal.kernel.util.StringUtil;
import org.jsoup.Jsoup;
import org.jsoup.nodes.Document;
import org.jsoup.nodes.Element;
import org.osgi.service.component.annotations.Component;

@Component(immediate=true, property={"type=text"}, service={EditableElementParser.class})
public class TextEditableElementParser
implements EditableElementParser {
    private static final String _TMPL_VALIDATE_TEXT_FIELD = StringUtil.read(EditableFragmentEntryProcessor.class, (String)"/META-INF/resources/fragment/entry/processor/editable/text_field_template.tmpl");

    @Override
    public String getFieldTemplate() {
        return _TMPL_VALIDATE_TEXT_FIELD;
    }

    @Override
    public String getValue(Element element) {
        return element.html();
    }

    @Override
    public void replace(Element element, String value) {
        Document document = Jsoup.parseBodyFragment((String)value);
        Document.OutputSettings outputSettings = new Document.OutputSettings();
        outputSettings.prettyPrint(false);
        document.outputSettings(outputSettings);
        element.html(document.text());
    }
}

