/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.fragment.entry.processor.drop.zone.listener;

import com.liferay.fragment.listener.FragmentEntryLinkListener;
import com.liferay.fragment.model.FragmentEntryLink;
import com.liferay.fragment.processor.DefaultFragmentEntryProcessorContext;
import com.liferay.fragment.processor.FragmentEntryProcessorContext;
import com.liferay.fragment.processor.FragmentEntryProcessorRegistry;
import com.liferay.layout.page.template.model.LayoutPageTemplateStructure;
import com.liferay.layout.page.template.service.LayoutPageTemplateStructureLocalService;
import com.liferay.layout.page.template.util.CheckUnlockedLayoutThreadLocal;
import com.liferay.layout.util.structure.DeletedLayoutStructureItem;
import com.liferay.layout.util.structure.FragmentDropZoneLayoutStructureItem;
import com.liferay.layout.util.structure.LayoutStructure;
import com.liferay.layout.util.structure.LayoutStructureItem;
import com.liferay.petra.lang.SafeCloseable;
import com.liferay.portal.kernel.exception.PortalException;
import com.liferay.portal.kernel.log.Log;
import com.liferay.portal.kernel.log.LogFactoryUtil;
import com.liferay.portal.kernel.service.ServiceContext;
import com.liferay.portal.kernel.service.ServiceContextThreadLocal;
import com.liferay.portal.kernel.theme.ThemeDisplay;
import com.liferay.portal.kernel.util.ListUtil;
import com.liferay.portal.kernel.util.Validator;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Objects;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.jsoup.Jsoup;
import org.jsoup.nodes.Document;
import org.jsoup.nodes.Element;
import org.jsoup.select.Elements;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.Reference;

@Component(service={FragmentEntryLinkListener.class})
public class DropZoneFragmentEntryLinkListener
implements FragmentEntryLinkListener {
    private static final Log _log = LogFactoryUtil.getLog(DropZoneFragmentEntryLinkListener.class);
    @Reference
    private FragmentEntryProcessorRegistry _fragmentEntryProcessorRegistry;
    @Reference
    private LayoutPageTemplateStructureLocalService _layoutPageTemplateStructureLocalService;

    public void onAddFragmentEntryLink(FragmentEntryLink fragmentEntryLink) {
        block2: {
            try {
                this.updateLayoutPageTemplateStructure(fragmentEntryLink, null);
            }
            catch (Exception exception) {
                if (!_log.isDebugEnabled()) break block2;
                _log.debug((Object)"Unable to update layout page template structure", (Throwable)exception);
            }
        }
    }

    public void onCopyFragmentEntryLink(FragmentEntryLink fragmentEntryLink, FragmentEntryLink originalFragmentEntryLink) {
        block2: {
            try {
                this.updateLayoutPageTemplateStructure(fragmentEntryLink, originalFragmentEntryLink);
            }
            catch (Exception exception) {
                if (!_log.isDebugEnabled()) break block2;
                _log.debug((Object)"Unable to update layout page template structure", (Throwable)exception);
            }
        }
    }

    public void onDeleteFragmentEntryLink(FragmentEntryLink fragmentEntryLink) {
    }

    public void onDuplicateFragmentEntryLink(FragmentEntryLink fragmentEntryLink, FragmentEntryLink originalFragmentEntryLink) {
        block2: {
            try {
                this.updateLayoutPageTemplateStructure(fragmentEntryLink, originalFragmentEntryLink);
            }
            catch (Exception exception) {
                if (!_log.isDebugEnabled()) break block2;
                _log.debug((Object)"Unable to update layout page template structure", (Throwable)exception);
            }
        }
    }

    public void onUpdateFragmentEntryLink(FragmentEntryLink fragmentEntryLink) {
    }

    public void onUpdateFragmentEntryLinkConfigurationValues(FragmentEntryLink fragmentEntryLink) {
        block2: {
            try {
                this.updateLayoutPageTemplateStructure(fragmentEntryLink, null);
            }
            catch (Exception exception) {
                if (!_log.isDebugEnabled()) break block2;
                _log.debug((Object)"Unable to update layout page template structure", (Throwable)exception);
            }
        }
    }

    protected void updateLayoutPageTemplateStructure(FragmentEntryLink fragmentEntryLink, FragmentEntryLink originalFragmentEntryLink) throws PortalException {
        FragmentDropZoneLayoutStructureItem fragmentDropZoneLayoutStructureItem;
        LinkedList childrenItemIds;
        Element element;
        Object dropZoneId;
        String processedHTML;
        Document document;
        Elements elements;
        ServiceContext serviceContext = ServiceContextThreadLocal.getServiceContext();
        if (serviceContext == null) {
            return;
        }
        HttpServletRequest httpServletRequest = serviceContext.getRequest();
        HttpServletResponse httpServletResponse = serviceContext.getResponse();
        ThemeDisplay themeDisplay = serviceContext.getThemeDisplay();
        if (httpServletRequest == null && themeDisplay != null) {
            httpServletRequest = themeDisplay.getRequest();
        }
        if (httpServletResponse == null && themeDisplay != null) {
            httpServletResponse = themeDisplay.getResponse();
        }
        if ((elements = (document = this._getDocument(processedHTML = this._fragmentEntryProcessorRegistry.processFragmentEntryLinkHTML(fragmentEntryLink, (FragmentEntryProcessorContext)new DefaultFragmentEntryProcessorContext(httpServletRequest, httpServletResponse, "EDIT", serviceContext.getLocale())))).getElementsByTag("lfr-drop-zone")).isEmpty()) {
            return;
        }
        LayoutStructure layoutStructure = this._getLayoutStructure(fragmentEntryLink);
        if (layoutStructure == null) {
            return;
        }
        LayoutStructureItem parentLayoutStructureItem = layoutStructure.getLayoutStructureItemByFragmentEntryLinkId(fragmentEntryLink.getFragmentEntryLinkId());
        if (parentLayoutStructureItem == null) {
            return;
        }
        LinkedList<String> elementDropZoneIds = new LinkedList<String>();
        Iterator iterator = elements.iterator();
        while (iterator.hasNext() && !Validator.isBlank((String)(dropZoneId = (element = (Element)iterator.next()).attr("data-lfr-drop-zone-id")))) {
            elementDropZoneIds.add((String)dropZoneId);
        }
        if (elementDropZoneIds.size() < elements.size()) {
            childrenItemIds = parentLayoutStructureItem.getChildrenItemIds();
            if (childrenItemIds.size() == elements.size()) {
                return;
            }
            if (childrenItemIds.size() > elements.size()) {
                layoutStructure.markLayoutStructureItemForDeletion(new ArrayList(childrenItemIds.subList(elements.size(), childrenItemIds.size())), Collections.emptyList());
            } else {
                for (int i = childrenItemIds.size(); i < elements.size(); ++i) {
                    this._addOrRestoreDropZoneLayoutStructureItem(layoutStructure, parentLayoutStructureItem);
                }
            }
            SafeCloseable safeCloseable = CheckUnlockedLayoutThreadLocal.setCheckUnlockedLayoutWithSafeCloseable((Boolean)false);
            dropZoneId = null;
            try {
                this._layoutPageTemplateStructureLocalService.updateLayoutPageTemplateStructureData(fragmentEntryLink.getGroupId(), fragmentEntryLink.getPlid(), fragmentEntryLink.getSegmentsExperienceId(), layoutStructure.toString());
            }
            catch (Throwable throwable) {
                dropZoneId = throwable;
                throw throwable;
            }
            finally {
                if (safeCloseable != null) {
                    if (dropZoneId != null) {
                        try {
                            safeCloseable.close();
                        }
                        catch (Throwable throwable) {
                            ((Throwable)dropZoneId).addSuppressed(throwable);
                        }
                    } else {
                        safeCloseable.close();
                    }
                }
            }
            return;
        }
        childrenItemIds = new LinkedList(parentLayoutStructureItem.getChildrenItemIds());
        LinkedHashMap<String, FragmentDropZoneLayoutStructureItem> fragmentDropZoneLayoutStructureItemsMap = new LinkedHashMap<String, FragmentDropZoneLayoutStructureItem>();
        LinkedHashMap<String, String> dropZoneIdsReplaceValuesMap = new LinkedHashMap<String, String>();
        LinkedList<FragmentDropZoneLayoutStructureItem> noExistingIdFragmentDropZoneLayoutStructureItems = new LinkedList<FragmentDropZoneLayoutStructureItem>();
        LinkedList<FragmentDropZoneLayoutStructureItem> noIdFragmentDropZoneLayoutStructureItems = new LinkedList<FragmentDropZoneLayoutStructureItem>();
        List<String> originalElementDropZoneIds = this._getElementDropZoneIds(originalFragmentEntryLink, httpServletRequest, httpServletResponse, serviceContext);
        for (String childrenItemId : childrenItemIds) {
            LayoutStructureItem layoutStructureItem = layoutStructure.getLayoutStructureItem(childrenItemId);
            if (!(layoutStructureItem instanceof FragmentDropZoneLayoutStructureItem)) continue;
            fragmentDropZoneLayoutStructureItem = (FragmentDropZoneLayoutStructureItem)layoutStructureItem;
            String fragmentDropZoneId = fragmentDropZoneLayoutStructureItem.getFragmentDropZoneId();
            if (Validator.isBlank((String)fragmentDropZoneId)) {
                noIdFragmentDropZoneLayoutStructureItems.add(fragmentDropZoneLayoutStructureItem);
                continue;
            }
            if (elementDropZoneIds.contains(fragmentDropZoneId)) {
                fragmentDropZoneLayoutStructureItemsMap.put(fragmentDropZoneId, fragmentDropZoneLayoutStructureItem);
                continue;
            }
            if (originalElementDropZoneIds.contains(fragmentDropZoneId)) {
                int index = originalElementDropZoneIds.indexOf(fragmentDropZoneId);
                String dropZoneId2 = null;
                if (index >= 0 && elementDropZoneIds.size() > index) {
                    dropZoneId2 = (String)elementDropZoneIds.get(index);
                }
                if (Validator.isNotNull(dropZoneId2)) {
                    dropZoneIdsReplaceValuesMap.put(dropZoneId2, fragmentDropZoneId);
                }
                fragmentDropZoneLayoutStructureItemsMap.put(fragmentDropZoneId, fragmentDropZoneLayoutStructureItem);
                continue;
            }
            noExistingIdFragmentDropZoneLayoutStructureItems.add(fragmentDropZoneLayoutStructureItem);
        }
        boolean update = false;
        for (int index = 0; index < elementDropZoneIds.size(); ++index) {
            String itemId;
            String dropZoneId3 = (String)elementDropZoneIds.get(index);
            fragmentDropZoneLayoutStructureItem = (FragmentDropZoneLayoutStructureItem)fragmentDropZoneLayoutStructureItemsMap.remove(dropZoneId3);
            String dropZoneIdsReplaceValue = (String)dropZoneIdsReplaceValuesMap.get(dropZoneId3);
            if (fragmentDropZoneLayoutStructureItem == null && Validator.isNotNull((String)dropZoneIdsReplaceValue)) {
                fragmentDropZoneLayoutStructureItem = (FragmentDropZoneLayoutStructureItem)fragmentDropZoneLayoutStructureItemsMap.remove(dropZoneIdsReplaceValue);
            }
            if (fragmentDropZoneLayoutStructureItem != null) {
                if (!Objects.equals(dropZoneId3, fragmentDropZoneLayoutStructureItem.getFragmentDropZoneId())) {
                    fragmentDropZoneLayoutStructureItem.setFragmentDropZoneId(dropZoneId3);
                    update = true;
                }
                if (index == childrenItemIds.indexOf(itemId = fragmentDropZoneLayoutStructureItem.getItemId())) continue;
                layoutStructure.moveLayoutStructureItem(itemId, parentLayoutStructureItem.getItemId(), index);
                update = true;
                continue;
            }
            fragmentDropZoneLayoutStructureItem = this._getDeletedFragmentDropZoneStructureItem(dropZoneId3, layoutStructure, parentLayoutStructureItem.getItemId());
            if (fragmentDropZoneLayoutStructureItem != null) {
                itemId = fragmentDropZoneLayoutStructureItem.getItemId();
                layoutStructure.unmarkLayoutStructureItemForDeletion(itemId);
                layoutStructure.moveLayoutStructureItem(itemId, parentLayoutStructureItem.getItemId(), index);
                update = true;
                continue;
            }
            if (ListUtil.isNotEmpty(noIdFragmentDropZoneLayoutStructureItems)) {
                fragmentDropZoneLayoutStructureItem = (FragmentDropZoneLayoutStructureItem)noIdFragmentDropZoneLayoutStructureItems.remove(0);
                fragmentDropZoneLayoutStructureItem.setFragmentDropZoneId(dropZoneId3);
                itemId = fragmentDropZoneLayoutStructureItem.getItemId();
                if (index != childrenItemIds.indexOf(itemId)) {
                    layoutStructure.moveLayoutStructureItem(itemId, parentLayoutStructureItem.getItemId(), index);
                }
                update = true;
                continue;
            }
            fragmentDropZoneLayoutStructureItem = (FragmentDropZoneLayoutStructureItem)layoutStructure.addFragmentDropZoneLayoutStructureItem(parentLayoutStructureItem.getItemId(), index);
            fragmentDropZoneLayoutStructureItem.setFragmentDropZoneId(dropZoneId3);
            update = true;
        }
        for (FragmentDropZoneLayoutStructureItem fragmentDropZoneLayoutStructureItem2 : noExistingIdFragmentDropZoneLayoutStructureItems) {
            layoutStructure.markLayoutStructureItemForDeletion(Collections.singletonList(fragmentDropZoneLayoutStructureItem2.getItemId()), Collections.emptyList());
            update = true;
        }
        for (FragmentDropZoneLayoutStructureItem fragmentDropZoneLayoutStructureItem2 : noIdFragmentDropZoneLayoutStructureItems) {
            layoutStructure.markLayoutStructureItemForDeletion(Collections.singletonList(fragmentDropZoneLayoutStructureItem2.getItemId()), Collections.emptyList());
            update = true;
        }
        if (update) {
            try (SafeCloseable safeCloseable = CheckUnlockedLayoutThreadLocal.setCheckUnlockedLayoutWithSafeCloseable((Boolean)false);){
                this._layoutPageTemplateStructureLocalService.updateLayoutPageTemplateStructureData(fragmentEntryLink.getGroupId(), fragmentEntryLink.getPlid(), fragmentEntryLink.getSegmentsExperienceId(), layoutStructure.toString());
            }
        }
    }

    private void _addOrRestoreDropZoneLayoutStructureItem(LayoutStructure layoutStructure, LayoutStructureItem parentLayoutStructureItem) {
        LayoutStructureItem existingLayoutStructureItem = null;
        List deletedLayoutStructureItems = layoutStructure.getDeletedLayoutStructureItems();
        for (DeletedLayoutStructureItem deletedLayoutStructureItem : deletedLayoutStructureItems) {
            LayoutStructureItem layoutStructureItem = layoutStructure.getLayoutStructureItem(deletedLayoutStructureItem.getItemId());
            if (!Objects.equals(layoutStructureItem.getParentItemId(), parentLayoutStructureItem.getItemId())) continue;
            existingLayoutStructureItem = layoutStructureItem;
            break;
        }
        if (existingLayoutStructureItem != null) {
            layoutStructure.unmarkLayoutStructureItemForDeletion(existingLayoutStructureItem.getItemId());
        } else {
            layoutStructure.addFragmentDropZoneLayoutStructureItem(parentLayoutStructureItem.getItemId(), -1);
        }
    }

    private FragmentDropZoneLayoutStructureItem _getDeletedFragmentDropZoneStructureItem(String fragmentDropZoneId, LayoutStructure layoutStructure, String parentItemId) {
        List deletedLayoutStructureItems = layoutStructure.getDeletedLayoutStructureItems();
        for (DeletedLayoutStructureItem deletedLayoutStructureItem : deletedLayoutStructureItems) {
            FragmentDropZoneLayoutStructureItem fragmentDropZoneLayoutStructureItem;
            LayoutStructureItem layoutStructureItem = layoutStructure.getLayoutStructureItem(deletedLayoutStructureItem.getItemId());
            if (!(layoutStructureItem instanceof FragmentDropZoneLayoutStructureItem) || !Objects.equals((fragmentDropZoneLayoutStructureItem = (FragmentDropZoneLayoutStructureItem)layoutStructureItem).getParentItemId(), parentItemId) || !Validator.isBlank((String)fragmentDropZoneId) && !Objects.equals(fragmentDropZoneId, fragmentDropZoneLayoutStructureItem.getFragmentDropZoneId())) continue;
            return fragmentDropZoneLayoutStructureItem;
        }
        return null;
    }

    private Document _getDocument(String html) {
        Document document = Jsoup.parseBodyFragment((String)html);
        Document.OutputSettings outputSettings = new Document.OutputSettings();
        outputSettings.prettyPrint(false);
        document.outputSettings(outputSettings);
        return document;
    }

    private List<String> _getElementDropZoneIds(FragmentEntryLink fragmentEntryLink, HttpServletRequest httpServletRequest, HttpServletResponse httpServletResponse, ServiceContext serviceContext) throws PortalException {
        Element element;
        String dropZoneId;
        if (fragmentEntryLink == null) {
            return Collections.emptyList();
        }
        String processedHTML = this._fragmentEntryProcessorRegistry.processFragmentEntryLinkHTML(fragmentEntryLink, (FragmentEntryProcessorContext)new DefaultFragmentEntryProcessorContext(httpServletRequest, httpServletResponse, "EDIT", serviceContext.getLocale()));
        Document document = this._getDocument(processedHTML);
        LinkedList<String> elementDropZoneIds = new LinkedList<String>();
        Iterator iterator = document.getElementsByTag("lfr-drop-zone").iterator();
        while (iterator.hasNext() && !Validator.isBlank((String)(dropZoneId = (element = (Element)iterator.next()).attr("data-lfr-drop-zone-id")))) {
            elementDropZoneIds.add(dropZoneId);
        }
        return elementDropZoneIds;
    }

    private LayoutStructure _getLayoutStructure(FragmentEntryLink fragmentEntryLink) {
        LayoutPageTemplateStructure layoutPageTemplateStructure = this._layoutPageTemplateStructureLocalService.fetchLayoutPageTemplateStructure(fragmentEntryLink.getGroupId(), fragmentEntryLink.getPlid());
        if (layoutPageTemplateStructure == null) {
            return null;
        }
        String data = layoutPageTemplateStructure.getData(fragmentEntryLink.getSegmentsExperienceId());
        if (Validator.isNull((String)data)) {
            return null;
        }
        return LayoutStructure.of((String)data);
    }
}

