/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.fragment.entry.processor.drop.zone;

import com.liferay.fragment.exception.FragmentEntryContentException;
import com.liferay.fragment.processor.DocumentFragmentEntryValidator;
import com.liferay.portal.kernel.exception.PortalException;
import com.liferay.portal.kernel.language.Language;
import com.liferay.portal.kernel.util.Validator;
import java.util.LinkedHashSet;
import java.util.Locale;
import org.jsoup.nodes.Document;
import org.jsoup.nodes.Element;
import org.jsoup.select.Elements;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.Reference;

@Component(property={"fragment.entry.processor.priority:Integer=6"}, service={DocumentFragmentEntryValidator.class})
public class DropZoneFragmentEntryValidator
implements DocumentFragmentEntryValidator {
    @Reference
    private Language _language;

    public void validateFragmentEntryHTML(Document document, String configuration, Locale locale) throws PortalException {
        Elements elements = document.getElementsByTag("lfr-drop-zone");
        if (elements.isEmpty()) {
            return;
        }
        LinkedHashSet<String> elementDropZoneIds = new LinkedHashSet<String>();
        for (Element element : elements) {
            String dropZoneId = element.attr("data-lfr-drop-zone-id");
            if (Validator.isBlank((String)dropZoneId)) continue;
            elementDropZoneIds.add(dropZoneId);
        }
        if (!elementDropZoneIds.isEmpty() && elementDropZoneIds.size() != elements.size()) {
            throw new FragmentEntryContentException(this._language.get(locale, "you-must-define-a-unique-id-for-each-drop-zone"));
        }
    }
}

