/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.fragment.entry.processor.drop.zone;

import com.liferay.fragment.model.FragmentEntryLink;
import com.liferay.fragment.processor.DocumentFragmentEntryProcessor;
import com.liferay.fragment.processor.FragmentEntryProcessorContext;
import com.liferay.fragment.renderer.FragmentDropZoneRenderer;
import com.liferay.info.form.InfoForm;
import com.liferay.layout.page.template.model.LayoutPageTemplateStructure;
import com.liferay.layout.page.template.service.LayoutPageTemplateStructureLocalService;
import com.liferay.layout.util.structure.FragmentDropZoneLayoutStructureItem;
import com.liferay.layout.util.structure.LayoutStructure;
import com.liferay.layout.util.structure.LayoutStructureItem;
import com.liferay.portal.kernel.exception.PortalException;
import com.liferay.portal.kernel.util.ListUtil;
import com.liferay.portal.kernel.util.Validator;
import java.util.LinkedHashMap;
import java.util.LinkedList;
import java.util.List;
import javax.servlet.http.HttpServletRequest;
import org.jsoup.nodes.Document;
import org.jsoup.nodes.Element;
import org.jsoup.nodes.Node;
import org.jsoup.select.Elements;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.Reference;

@Component(property={"fragment.entry.processor.priority:Integer=6"}, service={DocumentFragmentEntryProcessor.class})
public class DropZoneDocumentFragmentEntryProcessor
implements DocumentFragmentEntryProcessor {
    @Reference
    private FragmentDropZoneRenderer _fragmentDropZoneRenderer;
    @Reference
    private LayoutPageTemplateStructureLocalService _layoutPageTemplateStructureLocalService;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void processFragmentEntryLinkHTML(FragmentEntryLink fragmentEntryLink, Document document, FragmentEntryProcessorContext fragmentEntryProcessorContext) throws PortalException {
        LayoutStructureItem layoutStructureItem;
        if (fragmentEntryProcessorContext.isIndexMode()) {
            return;
        }
        Elements elements = document.getElementsByTag("lfr-drop-zone");
        if (elements.isEmpty()) {
            return;
        }
        HttpServletRequest httpServletRequest = fragmentEntryProcessorContext.getHttpServletRequest();
        LayoutStructure layoutStructure = null;
        if (httpServletRequest != null) {
            layoutStructure = (LayoutStructure)httpServletRequest.getAttribute("LAYOUT_STRUCTURE");
        }
        if (layoutStructure == null) {
            LayoutPageTemplateStructure layoutPageTemplateStructure = this._layoutPageTemplateStructureLocalService.fetchLayoutPageTemplateStructure(fragmentEntryLink.getGroupId(), fragmentEntryLink.getPlid());
            if (layoutPageTemplateStructure == null) {
                return;
            }
            layoutStructure = LayoutStructure.of((String)layoutPageTemplateStructure.getData(fragmentEntryLink.getSegmentsExperienceId()));
        }
        if ((layoutStructureItem = layoutStructure.getLayoutStructureItemByFragmentEntryLinkId(fragmentEntryLink.getFragmentEntryLinkId())) == null) {
            return;
        }
        List dropZoneItemIds = layoutStructureItem.getChildrenItemIds();
        if (fragmentEntryProcessorContext.isEditMode()) {
            boolean idsAvailable = true;
            for (Element element : elements) {
                String dropZoneId = element.attr("data-lfr-drop-zone-id");
                if (!Validator.isBlank((String)dropZoneId)) continue;
                idsAvailable = false;
                break;
            }
            if (!idsAvailable) {
                for (int i = 0; i < dropZoneItemIds.size() && i < elements.size(); ++i) {
                    Element element;
                    element = (Element)elements.get(i);
                    element.attr("uuid", (String)dropZoneItemIds.get(i));
                }
            } else {
                LinkedHashMap<String, String> fragmentDropZoneIdsMap = new LinkedHashMap<String, String>();
                LinkedList<String> noFragmentDropZoneItemIds = new LinkedList<String>();
                for (String dropZoneItemId : dropZoneItemIds) {
                    LayoutStructureItem childLayoutStructureItem = layoutStructure.getLayoutStructureItem(dropZoneItemId);
                    if (!(childLayoutStructureItem instanceof FragmentDropZoneLayoutStructureItem)) continue;
                    FragmentDropZoneLayoutStructureItem fragmentDropZoneLayoutStructureItem = (FragmentDropZoneLayoutStructureItem)childLayoutStructureItem;
                    String fragmentDropZoneId = fragmentDropZoneLayoutStructureItem.getFragmentDropZoneId();
                    if (Validator.isBlank((String)fragmentDropZoneId)) {
                        noFragmentDropZoneItemIds.add(dropZoneItemId);
                        continue;
                    }
                    fragmentDropZoneIdsMap.put(fragmentDropZoneId, dropZoneItemId);
                }
                for (int i = 0; i < elements.size(); ++i) {
                    Element element = (Element)elements.get(i);
                    String dropZoneId = element.attr("data-lfr-drop-zone-id");
                    if (fragmentDropZoneIdsMap.containsKey(dropZoneId)) {
                        element.attr("uuid", (String)fragmentDropZoneIdsMap.get(dropZoneId));
                        continue;
                    }
                    if (!ListUtil.isNotEmpty(noFragmentDropZoneItemIds)) continue;
                    element.attr("uuid", (String)noFragmentDropZoneItemIds.remove(0));
                }
            }
            return;
        }
        InfoForm originalInfoForm = null;
        if (httpServletRequest != null) {
            originalInfoForm = (InfoForm)httpServletRequest.getAttribute("INFO_FORM");
            httpServletRequest.setAttribute("INFO_FORM", (Object)fragmentEntryProcessorContext.getInfoForm());
        }
        try {
            for (int i = 0; i < elements.size(); ++i) {
                Element element = (Element)elements.get(i);
                String dropZoneHTML = "";
                if (ListUtil.isNotEmpty((List)dropZoneItemIds) && i < dropZoneItemIds.size()) {
                    dropZoneHTML = this._fragmentDropZoneRenderer.renderDropZone(fragmentEntryProcessorContext.getHttpServletRequest(), fragmentEntryProcessorContext.getHttpServletResponse(), (String)dropZoneItemIds.get(i), fragmentEntryProcessorContext.getMode(), true);
                }
                Element dropZoneElement = new Element("div");
                dropZoneElement.html(dropZoneHTML);
                element.replaceWith((Node)dropZoneElement);
            }
        }
        finally {
            if (httpServletRequest != null) {
                httpServletRequest.setAttribute("INFO_FORM", (Object)originalInfoForm);
            }
        }
    }
}

