/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.fragment.entry.processor.drop.zone;

import com.liferay.fragment.model.FragmentEntryLink;
import com.liferay.fragment.processor.FragmentEntryProcessor;
import com.liferay.fragment.processor.FragmentEntryProcessorContext;
import com.liferay.fragment.renderer.FragmentDropZoneRenderer;
import com.liferay.layout.page.template.model.LayoutPageTemplateStructure;
import com.liferay.layout.page.template.service.LayoutPageTemplateStructureLocalService;
import com.liferay.layout.util.structure.LayoutStructure;
import com.liferay.layout.util.structure.LayoutStructureItem;
import com.liferay.portal.kernel.exception.PortalException;
import com.liferay.portal.kernel.json.JSONArray;
import com.liferay.portal.kernel.json.JSONUtil;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import org.jsoup.Jsoup;
import org.jsoup.nodes.Document;
import org.jsoup.nodes.Element;
import org.jsoup.nodes.Node;
import org.jsoup.select.Elements;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.Reference;

@Component(immediate=true, property={"fragment.entry.processor.priority:Integer=6"}, service={FragmentEntryProcessor.class})
public class DropZoneFragmentEntryProcessor
implements FragmentEntryProcessor {
    @Reference
    private FragmentDropZoneRenderer _fragmentDropZoneRenderer;
    @Reference
    private LayoutPageTemplateStructureLocalService _layoutPageTemplateStructureLocalService;

    public JSONArray getAvailableTagsJSONArray() {
        return JSONUtil.put((Object)JSONUtil.put((String)"content", (Object)"<lfr-drop-zone></lfr-drop-zone>").put("name", "lfr-drop-zone"));
    }

    public String processFragmentEntryLinkHTML(FragmentEntryLink fragmentEntryLink, String html, FragmentEntryProcessorContext fragmentEntryProcessorContext) throws PortalException {
        Document document = this._getDocument(html);
        Elements elements = document.select("lfr-drop-zone");
        if (elements.size() <= 0) {
            return html;
        }
        LayoutPageTemplateStructure layoutPageTemplateStructure = this._layoutPageTemplateStructureLocalService.fetchLayoutPageTemplateStructure(fragmentEntryLink.getGroupId(), fragmentEntryLink.getPlid());
        if (layoutPageTemplateStructure == null) {
            return html;
        }
        LayoutStructure layoutStructure = LayoutStructure.of((String)layoutPageTemplateStructure.getData(fragmentEntryLink.getSegmentsExperienceId()));
        LayoutStructureItem layoutStructureItem = layoutStructure.getLayoutStructureItemByFragmentEntryLinkId(fragmentEntryLink.getFragmentEntryLinkId());
        if (layoutStructureItem == null) {
            return html;
        }
        List dropZoneItemIds = layoutStructureItem.getChildrenItemIds();
        if (Objects.equals(fragmentEntryProcessorContext.getMode(), "EDIT")) {
            for (int i = 0; i < dropZoneItemIds.size() && i < elements.size(); ++i) {
                Element element = (Element)elements.get(i);
                element.attr("uuid", (String)dropZoneItemIds.get(i));
            }
            Element bodyElement = document.body();
            return bodyElement.html();
        }
        Optional fieldValuesOptional = fragmentEntryProcessorContext.getFieldValuesOptional();
        for (int i = 0; i < elements.size(); ++i) {
            Element element = (Element)elements.get(i);
            String dropZoneHTML = this._fragmentDropZoneRenderer.renderDropZone(fragmentEntryProcessorContext.getHttpServletRequest(), fragmentEntryProcessorContext.getHttpServletResponse(), (Map)fieldValuesOptional.orElse(null), fragmentEntryLink.getGroupId(), fragmentEntryLink.getPlid(), (String)dropZoneItemIds.get(i), fragmentEntryProcessorContext.getMode(), true);
            Element dropZoneElement = new Element("div");
            dropZoneElement.html(dropZoneHTML);
            element.replaceWith((Node)dropZoneElement);
        }
        Element bodyElement = document.body();
        return bodyElement.html();
    }

    public void validateFragmentEntryHTML(String html, String configuration) {
    }

    private Document _getDocument(String html) {
        Document document = Jsoup.parseBodyFragment((String)html);
        Document.OutputSettings outputSettings = new Document.OutputSettings();
        outputSettings.prettyPrint(false);
        document.outputSettings(outputSettings);
        return document;
    }
}

