/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.fragment.entry.processor.background.image;

import com.liferay.fragment.entry.processor.helper.FragmentEntryProcessorHelper;
import com.liferay.fragment.exception.FragmentEntryContentException;
import com.liferay.fragment.model.FragmentEntryLink;
import com.liferay.fragment.processor.FragmentEntryProcessor;
import com.liferay.fragment.processor.FragmentEntryProcessorContext;
import com.liferay.info.item.InfoItemReference;
import com.liferay.info.type.WebImage;
import com.liferay.petra.string.StringBundler;
import com.liferay.portal.kernel.exception.PortalException;
import com.liferay.portal.kernel.json.JSONFactory;
import com.liferay.portal.kernel.json.JSONObject;
import com.liferay.portal.kernel.json.JSONUtil;
import com.liferay.portal.kernel.language.Language;
import com.liferay.portal.kernel.util.ResourceBundleUtil;
import com.liferay.portal.kernel.util.Validator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Objects;
import java.util.Optional;
import java.util.ResourceBundle;
import org.jsoup.Jsoup;
import org.jsoup.nodes.Document;
import org.jsoup.nodes.Element;
import org.jsoup.select.Elements;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.Reference;

@Component(immediate=true, property={"fragment.entry.processor.priority:Integer=5"}, service={FragmentEntryProcessor.class})
public class BackgroundImageFragmentEntryProcessor
implements FragmentEntryProcessor {
    @Reference
    private FragmentEntryProcessorHelper _fragmentEntryProcessorHelper;
    @Reference
    private JSONFactory _jsonFactory;
    @Reference
    private Language _language;

    public JSONObject getDefaultEditableValuesJSONObject(String html, String configuration) {
        JSONObject defaultEditableValuesJSONObject = this._jsonFactory.createJSONObject();
        Document document = this._getDocument(html);
        for (Element element : document.select("[data-lfr-background-image-id]")) {
            String id = element.attr("data-lfr-background-image-id");
            defaultEditableValuesJSONObject.put(id, this._jsonFactory.createJSONObject());
        }
        return defaultEditableValuesJSONObject;
    }

    public String processFragmentEntryLinkHTML(FragmentEntryLink fragmentEntryLink, String html, FragmentEntryProcessorContext fragmentEntryProcessorContext) throws PortalException {
        JSONObject jsonObject = this._jsonFactory.createJSONObject(fragmentEntryLink.getEditableValues());
        Document document = this._getDocument(html);
        HashMap infoDisplaysFieldValues = new HashMap();
        for (Element element : document.select("[data-lfr-background-image-id]")) {
            String id = element.attr("data-lfr-background-image-id");
            Class<?> clazz = this.getClass();
            JSONObject editableValuesJSONObject = jsonObject.getJSONObject(clazz.getName());
            if (editableValuesJSONObject == null || !editableValuesJSONObject.has(id)) continue;
            JSONObject editableValueJSONObject = editableValuesJSONObject.getJSONObject(id);
            String value = "";
            Object fieldValue = this._fragmentEntryProcessorHelper.getFieldValue(editableValueJSONObject, infoDisplaysFieldValues, fragmentEntryProcessorContext);
            if (fieldValue != null) {
                value = this._getImageURL(fieldValue);
            }
            if (Validator.isNull((String)value)) {
                value = this._fragmentEntryProcessorHelper.getEditableValue(editableValueJSONObject, fragmentEntryProcessorContext.getLocale());
            }
            if (!Validator.isNotNull((String)value)) continue;
            long fileEntryId = 0L;
            if (JSONUtil.isValid((String)value)) {
                JSONObject valueJSONObject = this._jsonFactory.createJSONObject(value);
                fileEntryId = valueJSONObject.getLong("fileEntryId");
                if (fileEntryId == 0L) {
                    fileEntryId = this._fragmentEntryProcessorHelper.getFileEntryId(valueJSONObject.getString("className"), valueJSONObject.getLong("classPK"));
                }
                value = valueJSONObject.getString("url", value);
            }
            StringBundler sb = new StringBundler(6);
            sb.append("background-image: url(");
            sb.append(value);
            sb.append("); background-size: cover;");
            if (fileEntryId == 0L) {
                fileEntryId = this._fragmentEntryProcessorHelper.getFileEntryId(editableValueJSONObject.getLong("classNameId"), editableValueJSONObject.getLong("classPK"), editableValueJSONObject.getString("fieldId"), fragmentEntryProcessorContext.getLocale());
            }
            Optional contextInfoItemReferenceOptional = fragmentEntryProcessorContext.getContextInfoItemReferenceOptional();
            if (fileEntryId == 0L && contextInfoItemReferenceOptional.isPresent()) {
                fileEntryId = this._fragmentEntryProcessorHelper.getFileEntryId((InfoItemReference)contextInfoItemReferenceOptional.get(), editableValueJSONObject.getString("collectionFieldId"), fragmentEntryProcessorContext.getLocale());
            }
            if (fileEntryId == 0L && contextInfoItemReferenceOptional.isPresent()) {
                fileEntryId = this._fragmentEntryProcessorHelper.getFileEntryId((InfoItemReference)contextInfoItemReferenceOptional.get(), editableValueJSONObject.getString("mappedField"), fragmentEntryProcessorContext.getLocale());
            }
            if (fileEntryId > 0L) {
                sb.append(" --background-image-file-entry-id: ");
                sb.append(fileEntryId);
                sb.append(";");
            }
            element.attr("style", sb.toString());
        }
        if (Objects.equals(fragmentEntryProcessorContext.getMode(), "VIEW")) {
            for (Element element : document.select("[data-lfr-background-image-id]")) {
                element.removeAttr("data-lfr-background-image-id");
            }
        }
        Element bodyElement = document.body();
        return bodyElement.html();
    }

    public void validateFragmentEntryHTML(String html, String configuration) throws PortalException {
        Document document = this._getDocument(html);
        Elements elements = document.select("[data-lfr-background-image-id]");
        HashSet<String> ids = new HashSet<String>();
        for (Element element : elements) {
            if (ids.add(element.attr("data-lfr-background-image-id"))) continue;
            ResourceBundle resourceBundle = ResourceBundleUtil.getBundle((String)"content.Language", this.getClass());
            throw new FragmentEntryContentException(this._language.get(resourceBundle, "you-must-define-a-unique-id-for-each-background-image-element"));
        }
    }

    private Document _getDocument(String html) {
        Document document = Jsoup.parseBodyFragment((String)html);
        Document.OutputSettings outputSettings = new Document.OutputSettings();
        outputSettings.prettyPrint(false);
        document.outputSettings(outputSettings);
        return document;
    }

    private String _getImageURL(Object fieldValue) {
        if (fieldValue instanceof JSONObject) {
            JSONObject fieldValueJSONObject = (JSONObject)fieldValue;
            return fieldValueJSONObject.getString("url");
        }
        if (fieldValue instanceof WebImage) {
            WebImage webImage = (WebImage)fieldValue;
            return String.valueOf(webImage.toJSONObject());
        }
        return String.valueOf(fieldValue);
    }
}

