/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.fragment.entry.processor.background.image;

import com.liferay.fragment.entry.processor.helper.FragmentEntryProcessorHelper;
import com.liferay.fragment.exception.FragmentEntryContentException;
import com.liferay.fragment.model.FragmentEntryLink;
import com.liferay.fragment.processor.FragmentEntryProcessor;
import com.liferay.fragment.processor.FragmentEntryProcessorContext;
import com.liferay.portal.kernel.exception.PortalException;
import com.liferay.portal.kernel.json.JSONFactoryUtil;
import com.liferay.portal.kernel.json.JSONObject;
import com.liferay.portal.kernel.language.LanguageUtil;
import com.liferay.portal.kernel.util.ResourceBundleUtil;
import com.liferay.portal.kernel.util.Validator;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.ResourceBundle;
import java.util.Set;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.jsoup.Jsoup;
import org.jsoup.nodes.Document;
import org.jsoup.nodes.Element;
import org.jsoup.select.Elements;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.Reference;

@Component(immediate=true, property={"fragment.entry.processor.priority:Integer=5"}, service={FragmentEntryProcessor.class})
public class BackgroundImageFragmentEntryProcessor
implements FragmentEntryProcessor {
    @Reference
    private FragmentEntryProcessorHelper _fragmentEntryProcessorHelper;

    public JSONObject getDefaultEditableValuesJSONObject(String html, String configuration) {
        JSONObject defaultEditableValuesJSONObject = JSONFactoryUtil.createJSONObject();
        Document document = this._getDocument(html);
        for (Element element : document.select("[data-lfr-background-image-id]")) {
            String id = element.attr("data-lfr-background-image-id");
            defaultEditableValuesJSONObject.put(id, JSONFactoryUtil.createJSONObject());
        }
        return defaultEditableValuesJSONObject;
    }

    public String processFragmentEntryLinkHTML(FragmentEntryLink fragmentEntryLink, String html, FragmentEntryProcessorContext fragmentEntryProcessorContext) throws PortalException {
        JSONObject jsonObject = JSONFactoryUtil.createJSONObject((String)fragmentEntryLink.getEditableValues());
        Document document = this._getDocument(html);
        HashMap infoDisplaysFieldValues = new HashMap();
        for (Element element : document.select("[data-lfr-background-image-id]")) {
            Object fieldValue;
            String id = element.attr("data-lfr-background-image-id");
            Class<?> clazz = this.getClass();
            JSONObject editableValuesJSONObject = jsonObject.getJSONObject(clazz.getName());
            if (editableValuesJSONObject == null || !editableValuesJSONObject.has(id)) continue;
            JSONObject editableValueJSONObject = editableValuesJSONObject.getJSONObject(id);
            String value = "";
            if (this._fragmentEntryProcessorHelper.isAssetDisplayPage(fragmentEntryProcessorContext.getMode())) {
                String mappedField = editableValueJSONObject.getString("mappedField");
                Optional fieldValuesOptional = fragmentEntryProcessorContext.getFieldValuesOptional();
                Map fieldValues = fieldValuesOptional.orElse(new HashMap());
                Object fieldValue2 = fieldValues.get(mappedField);
                if (fieldValue2 instanceof JSONObject) {
                    JSONObject fieldValueJSONObject = (JSONObject)fieldValue2;
                    value = fieldValueJSONObject.getString("url");
                }
            }
            if (this._fragmentEntryProcessorHelper.isMapped(editableValueJSONObject) && (fieldValue = this._fragmentEntryProcessorHelper.getMappedValue(editableValueJSONObject, infoDisplaysFieldValues, fragmentEntryProcessorContext)) != null) {
                if (fieldValue instanceof JSONObject) {
                    JSONObject fieldValueJSONObject = (JSONObject)fieldValue;
                    value = fieldValueJSONObject.getString("url");
                } else {
                    value = String.valueOf(fieldValue);
                }
            }
            if (Validator.isNull((String)value)) {
                value = this._fragmentEntryProcessorHelper.getEditableValue(editableValueJSONObject, fragmentEntryProcessorContext.getLocale(), fragmentEntryProcessorContext.getSegmentsExperienceIds());
            }
            if (!Validator.isNotNull((String)value)) continue;
            if (value.startsWith("{")) {
                JSONObject valueJSONObject = JSONFactoryUtil.createJSONObject((String)value);
                value = valueJSONObject.getString("url", value);
            }
            element.attr("style", "background-image: url(" + value + "); background-size: cover");
        }
        if (Objects.equals(fragmentEntryProcessorContext.getMode(), "ASSET_DISPLAY_PAGE") || Objects.equals(fragmentEntryProcessorContext.getMode(), "VIEW")) {
            for (Element element : document.select("[data-lfr-background-image-id]")) {
                element.removeAttr("data-lfr-background-image-id");
            }
        }
        Element bodyElement = document.body();
        return bodyElement.html();
    }

    public void validateFragmentEntryHTML(String html, String configuration) throws PortalException {
        Document document = this._getDocument(html);
        Elements elements = document.select("[data-lfr-background-image-id]");
        Stream uniqueElementsStream = elements.stream();
        Map<String, Long> idsMap = uniqueElementsStream.collect(Collectors.groupingBy(element -> element.attr("data-lfr-background-image-id"), Collectors.counting()));
        Set<String> ids = idsMap.keySet();
        Stream<Object> idsStream = ids.stream();
        if ((idsStream = idsStream.filter(id -> (Long)idsMap.get(id) > 1L)).count() > 0L) {
            ResourceBundle resourceBundle = ResourceBundleUtil.getBundle((String)"content.Language", this.getClass());
            throw new FragmentEntryContentException(LanguageUtil.get((ResourceBundle)resourceBundle, (String)"you-must-define-a-unique-id-for-each-background-image-element"));
        }
    }

    private Document _getDocument(String html) {
        Document document = Jsoup.parseBodyFragment((String)html);
        Document.OutputSettings outputSettings = new Document.OutputSettings();
        outputSettings.prettyPrint(false);
        document.outputSettings(outputSettings);
        return document;
    }
}

