Liferay.Loader.define("fragment-display-web@1.0.3/js/FragmentEntryDisplay.es", ['exports', 'metal-component/src/all/component', 'metal-state/src/all/state', 'metal-soy/src/Soy', './FragmentEntryDisplay.soy', 'layout-admin-web/js/fragments_editor/fragment_entry_link/FragmentEntryLink.es'], function (exports, _component, _state, _Soy, _FragmentEntryDisplay) {
	'use strict';

	Object.defineProperty(exports, "__esModule", {
		value: true
	});
	exports.FragmentEntryDisplay = undefined;

	var _component2 = _interopRequireDefault(_component);

	var _Soy2 = _interopRequireDefault(_Soy);

	var _FragmentEntryDisplay2 = _interopRequireDefault(_FragmentEntryDisplay);

	function _interopRequireDefault(obj) {
		return obj && obj.__esModule ? obj : {
			default: obj
		};
	}

	function _defineProperty(obj, key, value) {
		if (key in obj) {
			Object.defineProperty(obj, key, {
				value: value,
				enumerable: true,
				configurable: true,
				writable: true
			});
		} else {
			obj[key] = value;
		}

		return obj;
	}

	var _extends = Object.assign || function (target) {
		for (var i = 1; i < arguments.length; i++) {
			var source = arguments[i];

			for (var key in source) {
				if (Object.prototype.hasOwnProperty.call(source, key)) {
					target[key] = source[key];
				}
			}
		}

		return target;
	};

	function _classCallCheck(instance, Constructor) {
		if (!(instance instanceof Constructor)) {
			throw new TypeError("Cannot call a class as a function");
		}
	}

	var _createClass = function () {
		function defineProperties(target, props) {
			for (var i = 0; i < props.length; i++) {
				var descriptor = props[i];
				descriptor.enumerable = descriptor.enumerable || false;
				descriptor.configurable = true;
				if ("value" in descriptor) descriptor.writable = true;
				Object.defineProperty(target, descriptor.key, descriptor);
			}
		}

		return function (Constructor, protoProps, staticProps) {
			if (protoProps) defineProperties(Constructor.prototype, protoProps);
			if (staticProps) defineProperties(Constructor, staticProps);
			return Constructor;
		};
	}();

	function _possibleConstructorReturn(self, call) {
		if (!self) {
			throw new ReferenceError("this hasn't been initialised - super() hasn't been called");
		}

		return call && (typeof call === "object" || typeof call === "function") ? call : self;
	}

	function _inherits(subClass, superClass) {
		if (typeof superClass !== "function" && superClass !== null) {
			throw new TypeError("Super expression must either be null or a function, not " + typeof superClass);
		}

		subClass.prototype = Object.create(superClass && superClass.prototype, {
			constructor: {
				value: subClass,
				enumerable: false,
				writable: true,
				configurable: true
			}
		});
		if (superClass) Object.setPrototypeOf ? Object.setPrototypeOf(subClass, superClass) : subClass.__proto__ = superClass;
	}

	var FragmentEntryDisplay = function (_Component) {
		_inherits(FragmentEntryDisplay, _Component);

		function FragmentEntryDisplay() {
			_classCallCheck(this, FragmentEntryDisplay);

			return _possibleConstructorReturn(this, (FragmentEntryDisplay.__proto__ || Object.getPrototypeOf(FragmentEntryDisplay)).apply(this, arguments));
		}

		_createClass(FragmentEntryDisplay, [{
			key: '_handleEditableChanged',
			value: function _handleEditableChanged(data) {
				var editableValues = this.fragmentEntryLink.editableValues || {};

				var newEditableValue = _extends({}, editableValues[data.editableId] || {}, { defaultValue: data.value });

				var newEditableValues = _extends({}, editableValues, _defineProperty({}, data.editableId, newEditableValue));

				this.fragmentEntryLink = _extends({}, this.fragmentEntryLink, { editableValues: newEditableValues });

				this._updateFragmentEntryLink();
			}
		}, {
			key: '_updateFragmentEntryLink',
			value: function _updateFragmentEntryLink() {
				var formData = new FormData();

				formData.append(this.portletNamespace + 'fragmentEntryLinkId', this.fragmentEntryLink.fragmentEntryLinkId);

				formData.append(this.portletNamespace + 'editableValues', JSON.stringify(this.fragmentEntryLink.editableValues));

				fetch(this.editFragmentEntryLinkURL, {
					body: formData,
					credentials: 'include',
					method: 'POST'
				});
			}
		}]);

		return FragmentEntryDisplay;
	}(_component2.default);

	/**
  * State definition.
  * @review
  * @static
  * @type {!Object}
  */

	FragmentEntryDisplay.STATE = {

		/**
   * Default configuration for AlloyEditor instances.
   * @default {}
   * @instance
   * @memberOf FragmentEntryDisplay
   * @review
   * @type {object}
   */

		defaultEditorConfiguration: _state.Config.object().value({}),

		/**
   * URL for updating a distinct fragment entries of the editor.
   * @default undefined
   * @instance
   * @memberOf FragmentEntryDisplay
   * @review
   * @type {!string}
   */

		editFragmentEntryLinkURL: _state.Config.string().required(),

		/**
   * FragmentEntryLink entity
   * @default undefined
   * @instance
   * @memberOf FragmentEntryDisplay
   * @review
   * @type {{
   * 		config: object,
   * 		content: any,
   * 		editableValues: object,
   * 		fragmentEntryId: string,
   * 		fragmentEntryLinkId: string,
   * 		name: string,
   * 		position: number
   * 	}}
   */

		fragmentEntryLink: _state.Config.shapeOf({
			config: _state.Config.object().value({}),
			content: _state.Config.any().value(''),
			editableValues: _state.Config.object().value({}),
			fragmentEntryId: _state.Config.string().required(),
			fragmentEntryLinkId: _state.Config.string().required(),
			name: _state.Config.string().required(),
			position: _state.Config.number().required()
		}),

		/**
   * Image selector url
   * @default undefined
   * @instance
   * @memberOf FragmentEntryDisplay
   * @review
   * @type {!string}
   */

		imageSelectorURL: _state.Config.string().required(),

		/**
   * Portlet namespace needed for prefixing form inputs
   * @default undefined
   * @instance
   * @memberOf FragmentEntryDisplay
   * @review
   * @type {!string}
   */

		portletNamespace: _state.Config.string().required(),

		/**
   * Path of the available icons.
   * @default undefined
   * @instance
   * @memberOf FragmentEntryDisplay
   * @review
   * @type {!string}
   */

		spritemap: _state.Config.string().required()

	};

	_Soy2.default.register(FragmentEntryDisplay, _FragmentEntryDisplay2.default);

	exports.FragmentEntryDisplay = FragmentEntryDisplay;
	exports.default = FragmentEntryDisplay;
});
//# sourceMappingURL=FragmentEntryDisplay.es.js.map
