/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.fragment.display.web.internal.portlet.action;

import com.liferay.fragment.model.FragmentEntry;
import com.liferay.fragment.model.FragmentEntryLink;
import com.liferay.fragment.service.FragmentEntryLinkLocalService;
import com.liferay.fragment.service.FragmentEntryLocalService;
import com.liferay.item.selector.ItemSelector;
import com.liferay.portal.kernel.exception.PortalException;
import com.liferay.portal.kernel.model.PortletPreferences;
import com.liferay.portal.kernel.portlet.ConfigurationAction;
import com.liferay.portal.kernel.portlet.DefaultConfigurationAction;
import com.liferay.portal.kernel.service.PortletPreferencesLocalService;
import com.liferay.portal.kernel.service.ServiceContext;
import com.liferay.portal.kernel.service.ServiceContextFactory;
import com.liferay.portal.kernel.theme.ThemeDisplay;
import com.liferay.portal.kernel.util.GetterUtil;
import com.liferay.portal.kernel.util.ParamUtil;
import com.liferay.portal.kernel.util.Portal;
import javax.portlet.ActionRequest;
import javax.portlet.ActionResponse;
import javax.portlet.PortletConfig;
import javax.portlet.PortletRequest;
import javax.servlet.ServletContext;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.Reference;

@Component(immediate=true, property={"javax.portlet.name=com_liferay_fragment_display_web_portlet_FragmentEntryDisplayPortlet"}, service={ConfigurationAction.class})
public class FragmentEntryDisplayConfigurationAction
extends DefaultConfigurationAction {
    @Reference
    private FragmentEntryLinkLocalService _fragmentEntryLinkLocalService;
    @Reference
    private FragmentEntryLocalService _fragmentEntryLocalService;
    @Reference
    private ItemSelector _itemSelector;
    @Reference
    private Portal _portal;
    @Reference
    private PortletPreferencesLocalService _portletPreferencesLocalService;

    public void include(PortletConfig portletConfig, HttpServletRequest request, HttpServletResponse response) throws Exception {
        request.setAttribute("ITEM_SELECTOR", (Object)this._itemSelector);
        super.include(portletConfig, request, response);
    }

    public void processAction(PortletConfig portletConfig, ActionRequest actionRequest, ActionResponse actionResponse) throws Exception {
        long fragmentEntryLinkId = this._getFragmentEntryLinkId(actionRequest);
        this.setPreference((PortletRequest)actionRequest, "fragmentEntryLinkId", String.valueOf(fragmentEntryLinkId));
        super.processAction(portletConfig, actionRequest, actionResponse);
    }

    @Reference(target="(osgi.web.symbolicname=com.liferay.fragment.display.web)", unbind="-")
    public void setServletContext(ServletContext servletContext) {
        super.setServletContext(servletContext);
    }

    private long _getFragmentEntryLinkId(ActionRequest actionRequest) throws PortalException {
        ThemeDisplay themeDisplay = (ThemeDisplay)actionRequest.getAttribute("LIFERAY_SHARED_THEME_DISPLAY");
        long fragmentEntryId = ParamUtil.getLong((PortletRequest)actionRequest, (String)"fragmentEntryId");
        long fragmentEntryLinkId = GetterUtil.getLong((String)this.getParameter((PortletRequest)actionRequest, "fragmentEntryLinkId"));
        FragmentEntry fragmentEntry = this._fragmentEntryLocalService.fetchFragmentEntry(fragmentEntryId);
        FragmentEntryLink fragmentEntryLink = this._fragmentEntryLinkLocalService.fetchFragmentEntryLink(fragmentEntryLinkId);
        if (fragmentEntryLink != null && fragmentEntryLink.getFragmentEntryId() == fragmentEntryId) {
            return fragmentEntryLinkId;
        }
        if (fragmentEntryLink != null) {
            this._fragmentEntryLinkLocalService.deleteFragmentEntryLink(fragmentEntryLinkId);
        }
        if (fragmentEntry == null) {
            return 0L;
        }
        String portletResource = ParamUtil.getString((PortletRequest)actionRequest, (String)"portletResource");
        PortletPreferences preferences = this._portletPreferencesLocalService.getPortletPreferences(0L, 3, themeDisplay.getPlid(), portletResource);
        long classNameId = this._portal.getClassNameId(PortletPreferences.class);
        ServiceContext serviceContext = ServiceContextFactory.getInstance((PortletRequest)actionRequest);
        fragmentEntryLink = this._fragmentEntryLinkLocalService.addFragmentEntryLink(serviceContext.getUserId(), themeDisplay.getScopeGroupId(), fragmentEntryId, classNameId, preferences.getPortletPreferencesId(), fragmentEntry.getCss(), fragmentEntry.getHtml(), fragmentEntry.getJs(), "", 0, serviceContext);
        return fragmentEntryLink.getFragmentEntryLinkId();
    }
}

