/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.fragment.display.web.internal.display.context;

import com.liferay.fragment.display.web.internal.util.SoyContextFactoryUtil;
import com.liferay.fragment.item.selector.criterion.FragmentItemSelectorCriterion;
import com.liferay.fragment.model.FragmentEntry;
import com.liferay.fragment.model.FragmentEntryLink;
import com.liferay.fragment.service.FragmentEntryLinkLocalServiceUtil;
import com.liferay.fragment.service.FragmentEntryLocalServiceUtil;
import com.liferay.fragment.service.FragmentEntryServiceUtil;
import com.liferay.fragment.util.FragmentEntryRenderUtil;
import com.liferay.item.selector.ItemSelector;
import com.liferay.item.selector.ItemSelectorCriterion;
import com.liferay.item.selector.criteria.FileEntryItemSelectorReturnType;
import com.liferay.item.selector.criteria.URLItemSelectorReturnType;
import com.liferay.item.selector.criteria.UUIDItemSelectorReturnType;
import com.liferay.item.selector.criteria.image.criterion.ImageItemSelectorCriterion;
import com.liferay.item.selector.criteria.url.criterion.URLItemSelectorCriterion;
import com.liferay.portal.kernel.editor.configuration.EditorConfiguration;
import com.liferay.portal.kernel.editor.configuration.EditorConfigurationFactoryUtil;
import com.liferay.portal.kernel.exception.PortalException;
import com.liferay.portal.kernel.json.JSONFactoryUtil;
import com.liferay.portal.kernel.model.Layout;
import com.liferay.portal.kernel.portlet.PortletIdCodec;
import com.liferay.portal.kernel.portlet.RequestBackedPortletURLFactory;
import com.liferay.portal.kernel.portlet.RequestBackedPortletURLFactoryUtil;
import com.liferay.portal.kernel.security.permission.PermissionChecker;
import com.liferay.portal.kernel.service.permission.LayoutPermissionUtil;
import com.liferay.portal.kernel.service.permission.PortletPermissionUtil;
import com.liferay.portal.kernel.theme.PortletDisplay;
import com.liferay.portal.kernel.theme.ThemeDisplay;
import com.liferay.portal.kernel.util.ParamUtil;
import com.liferay.portal.kernel.util.PortalUtil;
import com.liferay.portal.kernel.util.PrefsParamUtil;
import com.liferay.portal.template.soy.utils.SoyContext;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import javax.portlet.PortletPreferences;
import javax.portlet.PortletRequest;
import javax.portlet.PortletResponse;
import javax.portlet.PortletURL;
import javax.portlet.RenderRequest;
import javax.portlet.RenderResponse;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;

public class FragmentEntryDisplayContext {
    private Long _fragmentEntryId;
    private Long _fragmentEntryLinkId;
    private final ItemSelector _itemSelector;
    private final PortletPreferences _portletPreferences;
    private final RenderRequest _renderRequest;
    private final RenderResponse _renderResponse;

    public FragmentEntryDisplayContext(RenderRequest renderRequest, RenderResponse renderResponse, PortletPreferences portletPreferences) {
        this._renderRequest = renderRequest;
        this._renderResponse = renderResponse;
        this._portletPreferences = portletPreferences;
        this._itemSelector = (ItemSelector)renderRequest.getAttribute("ITEM_SELECTOR");
    }

    public String getEventName() {
        return "selectFragmentEntry";
    }

    public FragmentEntry getFragmentEntry() {
        long fragmentEntryId = this.getFragmentEntryId();
        if (fragmentEntryId != 0L) {
            return FragmentEntryLocalServiceUtil.fetchFragmentEntry((long)fragmentEntryId);
        }
        FragmentEntryLink fragmentEntryLink = this.getFragmentEntryLink();
        if (fragmentEntryLink != null) {
            return FragmentEntryLocalServiceUtil.fetchFragmentEntry((long)fragmentEntryLink.getFragmentEntryId());
        }
        return null;
    }

    public long getFragmentEntryId() {
        if (this._fragmentEntryId != null) {
            return this._fragmentEntryId;
        }
        this._fragmentEntryId = ParamUtil.getLong((PortletRequest)this._renderRequest, (String)"fragmentEntryId");
        return this._fragmentEntryId;
    }

    public FragmentEntryLink getFragmentEntryLink() {
        return FragmentEntryLinkLocalServiceUtil.fetchFragmentEntryLink((long)this.getFragmentEntryLinkId());
    }

    public long getFragmentEntryLinkId() {
        if (this._fragmentEntryLinkId != null) {
            return this._fragmentEntryLinkId;
        }
        this._fragmentEntryLinkId = PrefsParamUtil.getLong((PortletPreferences)this._portletPreferences, (PortletRequest)this._renderRequest, (String)"fragmentEntryLinkId");
        return this._fragmentEntryLinkId;
    }

    public String getItemSelectorURL() {
        ItemSelector itemSelector = (ItemSelector)this._renderRequest.getAttribute("ITEM_SELECTOR");
        FragmentItemSelectorCriterion fragmentItemSelectorCriterion = new FragmentItemSelectorCriterion();
        ArrayList<UUIDItemSelectorReturnType> desiredItemSelectorReturnTypes = new ArrayList<UUIDItemSelectorReturnType>();
        desiredItemSelectorReturnTypes.add(new UUIDItemSelectorReturnType());
        fragmentItemSelectorCriterion.setDesiredItemSelectorReturnTypes(desiredItemSelectorReturnTypes);
        PortletURL itemSelectorURL = itemSelector.getItemSelectorURL(RequestBackedPortletURLFactoryUtil.create((PortletRequest)this._renderRequest), this.getEventName(), new ItemSelectorCriterion[]{fragmentItemSelectorCriterion});
        return itemSelectorURL.toString();
    }

    public SoyContext getSoyContext() throws PortalException {
        ThemeDisplay themeDisplay = (ThemeDisplay)this._renderRequest.getAttribute("LIFERAY_SHARED_THEME_DISPLAY");
        SoyContext soyContext = SoyContextFactoryUtil.createSoyContext();
        soyContext.put((Object)"defaultEditorConfigurations", this._getDefaultConfigurations());
        PortletURL editFragmentEntryLinkURL = this._renderResponse.createActionURL();
        editFragmentEntryLinkURL.setParameter("javax.portlet.action", "/fragment_display/edit_fragment_entry_link");
        soyContext.put((Object)"editFragmentEntryLinkURL", (Object)editFragmentEntryLinkURL.toString());
        soyContext.put((Object)"fragmentEntryLink", (Object)this._getSoyContextFragmentEntryLink());
        PortletURL itemSelectorURL = this._itemSelector.getItemSelectorURL(RequestBackedPortletURLFactoryUtil.create((PortletRequest)this._renderRequest), this._renderResponse.getNamespace() + "selectImage", new ItemSelectorCriterion[]{this._getImageItemSelectorCriterion(), this._getURLItemSelectorCriterion()});
        soyContext.put((Object)"imageSelectorURL", (Object)itemSelectorURL.toString());
        soyContext.put((Object)"portletNamespace", (Object)this._renderResponse.getNamespace());
        soyContext.put((Object)"spritemap", (Object)(themeDisplay.getPathThemeImages() + "/lexicon/icons.svg"));
        return soyContext;
    }

    public boolean hasEditPermission() throws PortalException {
        ThemeDisplay themeDisplay = (ThemeDisplay)this._renderRequest.getAttribute("LIFERAY_SHARED_THEME_DISPLAY");
        if (!LayoutPermissionUtil.contains((PermissionChecker)themeDisplay.getPermissionChecker(), (long)themeDisplay.getPlid(), (String)"UPDATE")) {
            return false;
        }
        PortletDisplay portletDisplay = themeDisplay.getPortletDisplay();
        return PortletPermissionUtil.contains((PermissionChecker)themeDisplay.getPermissionChecker(), (Layout)themeDisplay.getLayout(), (String)portletDisplay.getId(), (String)"CONFIGURATION");
    }

    public boolean isShowConfigurationLink() throws PortalException {
        ThemeDisplay themeDisplay = (ThemeDisplay)this._renderRequest.getAttribute("LIFERAY_SHARED_THEME_DISPLAY");
        PortletDisplay portletDisplay = themeDisplay.getPortletDisplay();
        return PortletPermissionUtil.contains((PermissionChecker)themeDisplay.getPermissionChecker(), (Layout)themeDisplay.getLayout(), (String)portletDisplay.getId(), (String)"CONFIGURATION");
    }

    private Map<String, Object> _getDefaultConfigurations() {
        HashMap<String, Object> configurations = new HashMap<String, Object>();
        ThemeDisplay themeDisplay = (ThemeDisplay)this._renderRequest.getAttribute("LIFERAY_SHARED_THEME_DISPLAY");
        PortletDisplay portletDisplay = themeDisplay.getPortletDisplay();
        EditorConfiguration richTextEditorConfiguration = EditorConfigurationFactoryUtil.getEditorConfiguration((String)PortletIdCodec.decodePortletName((String)portletDisplay.getId()), (String)"fragmenEntryLinkRichTextEditor", (String)"", new HashMap(), (ThemeDisplay)themeDisplay, (RequestBackedPortletURLFactory)RequestBackedPortletURLFactoryUtil.create((PortletRequest)this._renderRequest));
        configurations.put("rich-text", richTextEditorConfiguration.getData());
        EditorConfiguration editorConfiguration = EditorConfigurationFactoryUtil.getEditorConfiguration((String)PortletIdCodec.decodePortletName((String)portletDisplay.getId()), (String)"fragmenEntryLinkEditor", (String)"", new HashMap(), (ThemeDisplay)themeDisplay, (RequestBackedPortletURLFactory)RequestBackedPortletURLFactoryUtil.create((PortletRequest)this._renderRequest));
        configurations.put("text", editorConfiguration.getData());
        return configurations;
    }

    private ItemSelectorCriterion _getImageItemSelectorCriterion() {
        ImageItemSelectorCriterion imageItemSelectorCriterion = new ImageItemSelectorCriterion();
        ArrayList<FileEntryItemSelectorReturnType> desiredItemSelectorReturnTypes = new ArrayList<FileEntryItemSelectorReturnType>();
        desiredItemSelectorReturnTypes.add(new FileEntryItemSelectorReturnType());
        imageItemSelectorCriterion.setDesiredItemSelectorReturnTypes(desiredItemSelectorReturnTypes);
        return imageItemSelectorCriterion;
    }

    private SoyContext _getSoyContextFragmentEntryLink() throws PortalException {
        SoyContext soyContext = SoyContextFactoryUtil.createSoyContext();
        HttpServletRequest request = PortalUtil.getHttpServletRequest((PortletRequest)this._renderRequest);
        HttpServletResponse response = PortalUtil.getHttpServletResponse((PortletResponse)this._renderResponse);
        FragmentEntryLink fragmentEntryLink = this.getFragmentEntryLink();
        soyContext.putHTML("content", FragmentEntryRenderUtil.renderFragmentEntryLink((FragmentEntryLink)fragmentEntryLink, (HttpServletRequest)request, (HttpServletResponse)response));
        soyContext.put((Object)"editableValues", (Object)JSONFactoryUtil.createJSONObject((String)fragmentEntryLink.getEditableValues()));
        soyContext.put((Object)"fragmentEntryId", (Object)fragmentEntryLink.getFragmentEntryId());
        soyContext.put((Object)"fragmentEntryLinkId", (Object)fragmentEntryLink.getFragmentEntryLinkId());
        FragmentEntry fragmentEntry = FragmentEntryServiceUtil.fetchFragmentEntry((long)fragmentEntryLink.getFragmentEntryId());
        soyContext.put((Object)"name", (Object)fragmentEntry.getName());
        soyContext.put((Object)"position", (Object)fragmentEntryLink.getPosition());
        return soyContext;
    }

    private ItemSelectorCriterion _getURLItemSelectorCriterion() {
        URLItemSelectorCriterion urlItemSelectorCriterion = new URLItemSelectorCriterion();
        ArrayList<URLItemSelectorReturnType> desiredItemSelectorReturnTypes = new ArrayList<URLItemSelectorReturnType>();
        desiredItemSelectorReturnTypes.add(new URLItemSelectorReturnType());
        urlItemSelectorCriterion.setDesiredItemSelectorReturnTypes(desiredItemSelectorReturnTypes);
        return urlItemSelectorCriterion;
    }
}

