/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.fragment.input.template.parser;

import com.liferay.document.library.kernel.service.DLAppLocalService;
import com.liferay.fragment.input.template.parser.InputTemplateNode;
import com.liferay.fragment.model.FragmentEntryLink;
import com.liferay.fragment.util.configuration.FragmentConfigurationField;
import com.liferay.fragment.util.configuration.FragmentEntryConfigurationParser;
import com.liferay.info.exception.InfoFormValidationException;
import com.liferay.info.field.InfoField;
import com.liferay.info.field.type.FileInfoFieldType;
import com.liferay.info.field.type.InfoFieldType;
import com.liferay.info.field.type.NumberInfoFieldType;
import com.liferay.info.field.type.RelationshipInfoFieldType;
import com.liferay.info.field.type.SelectInfoFieldType;
import com.liferay.info.form.InfoForm;
import com.liferay.item.selector.ItemSelector;
import com.liferay.item.selector.ItemSelectorCriterion;
import com.liferay.item.selector.ItemSelectorReturnType;
import com.liferay.item.selector.criteria.FileEntryItemSelectorReturnType;
import com.liferay.item.selector.criteria.file.criterion.FileItemSelectorCriterion;
import com.liferay.petra.string.StringBundler;
import com.liferay.portal.kernel.exception.PortalException;
import com.liferay.portal.kernel.language.LanguageUtil;
import com.liferay.portal.kernel.log.Log;
import com.liferay.portal.kernel.log.LogFactoryUtil;
import com.liferay.portal.kernel.portlet.RequestBackedPortletURLFactory;
import com.liferay.portal.kernel.portlet.RequestBackedPortletURLFactoryUtil;
import com.liferay.portal.kernel.repository.model.FileEntry;
import com.liferay.portal.kernel.servlet.SessionErrors;
import com.liferay.portal.kernel.servlet.SessionMessages;
import com.liferay.portal.kernel.util.GetterUtil;
import com.liferay.portal.kernel.util.StringUtil;
import com.liferay.portal.kernel.util.TempFileEntryUtil;
import com.liferay.portal.kernel.util.Validator;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Locale;
import java.util.Map;
import java.util.Optional;
import javax.servlet.http.HttpServletRequest;

public class FragmentEntryInputTemplateNodeContextHelper {
    private static final Log _log = LogFactoryUtil.getLog(FragmentEntryInputTemplateNodeContextHelper.class);
    private final String _defaultInputLabel;
    private final DLAppLocalService _dlAppLocalService;
    private final FragmentEntryConfigurationParser _fragmentEntryConfigurationParser;
    private final ItemSelector _itemSelector;

    public FragmentEntryInputTemplateNodeContextHelper(String defaultInputLabel, DLAppLocalService dlAppLocalService, FragmentEntryConfigurationParser fragmentEntryConfigurationParser, ItemSelector itemSelector) {
        this._defaultInputLabel = defaultInputLabel;
        this._dlAppLocalService = dlAppLocalService;
        this._fragmentEntryConfigurationParser = fragmentEntryConfigurationParser;
        this._itemSelector = itemSelector;
    }

    public InputTemplateNode toInputTemplateNode(FragmentEntryLink fragmentEntryLink, HttpServletRequest httpServletRequest, Optional<InfoForm> infoFormOptional, Locale locale) {
        Map infoFormParameterMap;
        String errorMessage = "";
        InfoField infoField = null;
        InfoForm infoForm = infoFormOptional.orElse(null);
        if (infoForm != null) {
            String fieldName = GetterUtil.getString((Object)this._fragmentEntryConfigurationParser.getFieldValue(fragmentEntryLink.getEditableValues(), new FragmentConfigurationField("inputFieldId", "string", "", false, "text"), locale));
            infoField = infoForm.getInfoField(fieldName);
        }
        if (infoField != null && SessionErrors.contains((HttpServletRequest)httpServletRequest, (String)infoField.getUniqueId())) {
            InfoFormValidationException infoFormValidationException = (InfoFormValidationException)SessionErrors.get((HttpServletRequest)httpServletRequest, (String)infoField.getUniqueId());
            errorMessage = infoFormValidationException.getLocalizedMessage(locale);
            SessionErrors.remove((HttpServletRequest)httpServletRequest, (String)infoField.getUniqueId());
        }
        String inputHelpText = GetterUtil.getString((Object)this._fragmentEntryConfigurationParser.getFieldValue(fragmentEntryLink.getEditableValues(), new FragmentConfigurationField("inputHelpText", "string", LanguageUtil.get((Locale)locale, (String)"add-your-help-text-here"), true, "text"), locale));
        String defaultInputLabel = this._defaultInputLabel;
        if (infoField != null) {
            defaultInputLabel = infoField.getLabel(locale);
        }
        String inputLabel = GetterUtil.getString((Object)this._fragmentEntryConfigurationParser.getFieldValue(fragmentEntryLink.getEditableValues(), new FragmentConfigurationField("inputLabel", "string", defaultInputLabel, true, "text"), locale));
        String name = "name";
        if (infoField != null) {
            name = infoField.getName();
        }
        boolean required = false;
        if (infoField != null && infoField.isRequired() || GetterUtil.getBoolean((Object)this._fragmentEntryConfigurationParser.getFieldValue(fragmentEntryLink.getEditableValues(), new FragmentConfigurationField("inputRequired", "boolean", "false", false, "checkbox"), locale))) {
            required = true;
        }
        boolean inputShowHelpText = GetterUtil.getBoolean((Object)this._fragmentEntryConfigurationParser.getFieldValue(fragmentEntryLink.getEditableValues(), new FragmentConfigurationField("inputShowHelpText", "boolean", "false", false, "checkbox"), locale));
        boolean inputShowLabel = GetterUtil.getBoolean((Object)this._fragmentEntryConfigurationParser.getFieldValue(fragmentEntryLink.getEditableValues(), new FragmentConfigurationField("inputShowLabel", "boolean", "true", false, "checkbox"), locale));
        if (infoField == null) {
            return new InputTemplateNode(errorMessage, inputHelpText, inputLabel, name, required, inputShowHelpText, inputShowLabel, "type", "");
        }
        InfoFieldType infoFieldType = infoField.getInfoFieldType();
        String label = "";
        String value = "";
        if (infoFieldType instanceof SelectInfoFieldType) {
            Optional optionsOptional = infoField.getAttributeOptional(SelectInfoFieldType.OPTIONS);
            for (SelectInfoFieldType.Option option : optionsOptional.orElse(Collections.emptyList())) {
                if (!option.isActive()) continue;
                label = option.getLabel(locale);
                value = option.getValue();
                break;
            }
        }
        if ((infoFormParameterMap = (Map)SessionMessages.get((HttpServletRequest)httpServletRequest, (String)"infoFormParameterMap")) != null) {
            label = (String)infoFormParameterMap.get(infoField.getName() + "-label");
            value = (String)infoFormParameterMap.get(infoField.getName());
        }
        InputTemplateNode inputTemplateNode = new InputTemplateNode(errorMessage, inputHelpText, inputLabel, name, required, inputShowHelpText, inputShowLabel, infoFieldType.getName(), value);
        if (infoFieldType instanceof FileInfoFieldType) {
            Optional acceptedFileExtensionsOptional = infoField.getAttributeOptional(FileInfoFieldType.ALLOWED_FILE_EXTENSIONS);
            String allowedFileExtensions = acceptedFileExtensionsOptional.orElse("");
            if (Validator.isNotNull((String)allowedFileExtensions)) {
                StringBundler sb = new StringBundler();
                for (String allowedFileExtension : StringUtil.split((String)allowedFileExtensions)) {
                    sb.append(".");
                    sb.append(allowedFileExtension.trim());
                    sb.append(",");
                }
                sb.setIndex(sb.index() - 1);
                allowedFileExtensions = sb.toString();
            }
            inputTemplateNode.addAttribute("allowedFileExtensions", allowedFileExtensions);
            Optional maximumFileSizeOptional = infoField.getAttributeOptional(FileInfoFieldType.MAX_FILE_SIZE);
            inputTemplateNode.addAttribute("maxFileSize", maximumFileSizeOptional.orElse(0L));
            Optional fileSourceTypeOptional = infoField.getAttributeOptional(FileInfoFieldType.FILE_SOURCE);
            FileInfoFieldType.FileSourceType fileSourceType = fileSourceTypeOptional.orElse(null);
            if (fileSourceType != null) {
                String fileName = null;
                FileEntry fileEntry = null;
                boolean selectFromDocumentLibrary = false;
                if (Validator.isNotNull((String)value)) {
                    fileEntry = this._fetchFileEntry(GetterUtil.getLong((String)value));
                }
                if (fileSourceType == FileInfoFieldType.FileSourceType.DOCUMENTS_AND_MEDIA) {
                    selectFromDocumentLibrary = true;
                    if (fileEntry != null) {
                        fileName = fileEntry.getFileName();
                    }
                } else if (fileSourceType == FileInfoFieldType.FileSourceType.USER_COMPUTER && fileEntry != null) {
                    fileName = TempFileEntryUtil.getOriginalTempFileName((String)fileEntry.getFileName());
                }
                if (fileName != null) {
                    inputTemplateNode.addAttribute("fileName", fileName);
                }
                inputTemplateNode.addAttribute("selectFromDocumentLibrary", selectFromDocumentLibrary);
                if (selectFromDocumentLibrary) {
                    FileItemSelectorCriterion fileItemSelectorCriterion = new FileItemSelectorCriterion();
                    fileItemSelectorCriterion.setDesiredItemSelectorReturnTypes(new ItemSelectorReturnType[]{new FileEntryItemSelectorReturnType()});
                    RequestBackedPortletURLFactory requestBackedPortletURLFactory = RequestBackedPortletURLFactoryUtil.create((HttpServletRequest)httpServletRequest);
                    inputTemplateNode.addAttribute("selectFromDocumentLibraryURL", String.valueOf(this._itemSelector.getItemSelectorURL(requestBackedPortletURLFactory, fragmentEntryLink.getNamespace() + "selectFileEntry", new ItemSelectorCriterion[]{fileItemSelectorCriterion})));
                }
            }
        } else if (infoField.getInfoFieldType() instanceof NumberInfoFieldType) {
            String dataType = "integer";
            Optional decimalOptional = infoField.getAttributeOptional(NumberInfoFieldType.DECIMAL);
            if (decimalOptional.orElse(false).booleanValue()) {
                dataType = "decimal";
                Optional decimalPartMaxLengthOptional = infoField.getAttributeOptional(NumberInfoFieldType.DECIMAL_PART_MAX_LENGTH);
                decimalPartMaxLengthOptional.ifPresent(decimalPartMaxLength -> inputTemplateNode.addAttribute("step", this._getStep((Integer)decimalPartMaxLength)));
            }
            inputTemplateNode.addAttribute("dataType", dataType);
            Optional maxValueOptional = infoField.getAttributeOptional(NumberInfoFieldType.MAX_VALUE);
            maxValueOptional.ifPresent(maxValue -> inputTemplateNode.addAttribute("max", maxValue));
            Optional minValueOptional = infoField.getAttributeOptional(NumberInfoFieldType.MIN_VALUE);
            minValueOptional.ifPresent(minValue -> inputTemplateNode.addAttribute("min", minValue));
        } else if (infoField.getInfoFieldType() instanceof RelationshipInfoFieldType) {
            Optional optionsLabelFieldNameOptional = infoField.getAttributeOptional(RelationshipInfoFieldType.LABEL_FIELD_NAME);
            inputTemplateNode.addAttribute("relationshipLabelFieldName", optionsLabelFieldNameOptional.orElse(null));
            Optional optionsURLOptional = infoField.getAttributeOptional(RelationshipInfoFieldType.URL);
            inputTemplateNode.addAttribute("relationshipURL", optionsURLOptional.orElse(null));
            Optional optionsValueFieldNameOptional = infoField.getAttributeOptional(RelationshipInfoFieldType.VALUE_FIELD_NAME);
            inputTemplateNode.addAttribute("relationshipValueFieldName", optionsValueFieldNameOptional.orElse(null));
            if (Validator.isNotNull((String)label)) {
                inputTemplateNode.addAttribute("selectedOptionLabel", label);
            }
        } else if (infoField.getInfoFieldType() instanceof SelectInfoFieldType) {
            ArrayList<InputTemplateNode.Option> options = new ArrayList<InputTemplateNode.Option>();
            Optional optionsOptional = infoField.getAttributeOptional(SelectInfoFieldType.OPTIONS);
            for (SelectInfoFieldType.Option option : optionsOptional.orElse(Collections.emptyList())) {
                options.add(new InputTemplateNode.Option(option.getLabel(locale), option.getValue()));
                if (value == null || !value.equals(option.getValue())) continue;
                inputTemplateNode.addAttribute("selectedOptionLabel", option.getLabel(locale));
            }
            inputTemplateNode.addAttribute("options", options);
        }
        return inputTemplateNode;
    }

    private FileEntry _fetchFileEntry(long fileEntryId) {
        try {
            return this._dlAppLocalService.getFileEntry(fileEntryId);
        }
        catch (PortalException portalException) {
            if (_log.isWarnEnabled()) {
                _log.warn((Object)("Unable to get file entry " + fileEntryId), (Throwable)portalException);
            }
            return null;
        }
    }

    private String _getStep(Integer decimalPartMaxLength) {
        if (decimalPartMaxLength == null) {
            return "";
        }
        if (decimalPartMaxLength <= 0) {
            return "0";
        }
        return StringBundler.concat((String[])new String[]{"0.", StringUtil.merge(Collections.nCopies(decimalPartMaxLength - 1, "0"), (String)""), "1"});
    }
}

