/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.fragment.contributor;

import com.liferay.fragment.constants.FragmentConstants;
import com.liferay.fragment.contributor.FragmentCollectionContributor;
import com.liferay.fragment.exception.InvalidFragmentCompositionKeyException;
import com.liferay.fragment.model.FragmentComposition;
import com.liferay.fragment.model.FragmentEntry;
import com.liferay.fragment.service.FragmentCompositionLocalService;
import com.liferay.fragment.service.FragmentEntryLocalService;
import com.liferay.petra.io.StreamUtil;
import com.liferay.petra.string.StringBundler;
import com.liferay.portal.kernel.json.JSONFactoryUtil;
import com.liferay.portal.kernel.json.JSONObject;
import com.liferay.portal.kernel.language.LanguageUtil;
import com.liferay.portal.kernel.log.Log;
import com.liferay.portal.kernel.log.LogFactoryUtil;
import com.liferay.portal.kernel.resource.bundle.ResourceBundleLoader;
import com.liferay.portal.kernel.resource.bundle.ResourceBundleLoaderUtil;
import com.liferay.portal.kernel.util.FileUtil;
import com.liferay.portal.kernel.util.LocaleUtil;
import com.liferay.portal.kernel.util.MapUtil;
import com.liferay.portal.kernel.util.PortalUtil;
import com.liferay.portal.kernel.util.StringUtil;
import com.liferay.portal.kernel.util.Validator;
import java.io.InputStream;
import java.net.URL;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Optional;
import java.util.ResourceBundle;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import javax.servlet.ServletContext;
import org.osgi.framework.Bundle;
import org.osgi.framework.BundleContext;
import org.osgi.service.component.annotations.Activate;
import org.osgi.service.component.annotations.Reference;

public abstract class BaseFragmentCollectionContributor
implements FragmentCollectionContributor {
    @Reference
    protected FragmentCompositionLocalService fragmentCompositionLocalService;
    @Reference
    protected FragmentEntryLocalService fragmentEntryLocalService;
    private static final Log _log = LogFactoryUtil.getLog(BaseFragmentCollectionContributor.class);
    private Bundle _bundle;
    private Map<String, Map<Locale, String>> _fragmentCompositionNames;
    private List<FragmentComposition> _fragmentCompositions;
    private Map<Integer, List<FragmentEntry>> _fragmentEntries;
    private Map<String, Map<Locale, String>> _fragmentEntryNames;
    private volatile boolean _initialized;
    private Map<Locale, String> _names;

    @Override
    public List<FragmentComposition> getFragmentCompositions() {
        this._initialize();
        return Collections.unmodifiableList(this._fragmentCompositions);
    }

    @Override
    public List<FragmentComposition> getFragmentCompositions(Locale locale) {
        return this._getFragmentCompositions(this.getFragmentCompositions(), locale);
    }

    @Override
    public List<FragmentEntry> getFragmentEntries() {
        this._initialize();
        ArrayList<FragmentEntry> fragmentEntries = new ArrayList<FragmentEntry>();
        for (Map.Entry<Integer, List<FragmentEntry>> entry : this._fragmentEntries.entrySet()) {
            fragmentEntries.addAll((Collection<FragmentEntry>)entry.getValue());
        }
        return fragmentEntries;
    }

    @Override
    public List<FragmentEntry> getFragmentEntries(int type) {
        this._initialize();
        return this._fragmentEntries.getOrDefault(type, Collections.emptyList());
    }

    @Override
    public List<FragmentEntry> getFragmentEntries(int type, Locale locale) {
        return this._getFragmentEntries(this.getFragmentEntries(type), locale);
    }

    @Override
    public List<FragmentEntry> getFragmentEntries(Locale locale) {
        return this._getFragmentEntries(this.getFragmentEntries(), locale);
    }

    @Override
    public String getName() {
        this._initialize();
        String name = this._names.get(LocaleUtil.getDefault());
        if (Validator.isNotNull((String)name)) {
            return name;
        }
        return this.getFragmentCollectionKey();
    }

    @Override
    public String getName(Locale locale) {
        this._initialize();
        String name = this._names.get(locale);
        if (Validator.isNotNull((String)name)) {
            return name;
        }
        return this.getName();
    }

    @Override
    public Map<Locale, String> getNames() {
        this._initialize();
        if (this._names != null) {
            return Collections.unmodifiableMap(this._names);
        }
        return Collections.emptyMap();
    }

    @Override
    public ResourceBundleLoader getResourceBundleLoader() {
        ServletContext servletContext = this.getServletContext();
        return Optional.ofNullable(ResourceBundleLoaderUtil.getResourceBundleLoaderByServletContextName((String)servletContext.getServletContextName())).orElse(ResourceBundleLoaderUtil.getPortalResourceBundleLoader());
    }

    public abstract ServletContext getServletContext();

    @Activate
    protected void activate(BundleContext bundleContext) {
        this._bundle = bundleContext.getBundle();
    }

    protected void readAndCheckFragmentCollectionStructure() {
        block7: {
            try {
                URL url;
                Map<Locale, String> names = this._getContributedCollectionNames();
                Enumeration fragmentEntriesEnumeration = this._bundle.findEntries("", "fragment.json", true);
                Enumeration fragmentCompositionsEnumeration = this._bundle.findEntries("", "fragment-composition.json", true);
                this._fragmentCompositionNames = new HashMap<String, Map<Locale, String>>();
                this._fragmentCompositions = new ArrayList<FragmentComposition>();
                this._fragmentEntries = new HashMap<Integer, List<FragmentEntry>>();
                this._fragmentEntryNames = new HashMap<String, Map<Locale, String>>();
                if (MapUtil.isEmpty(names) || fragmentCompositionsEnumeration != null && !fragmentCompositionsEnumeration.hasMoreElements() && fragmentEntriesEnumeration != null && !fragmentEntriesEnumeration.hasMoreElements()) {
                    return;
                }
                this._names = names;
                if (fragmentEntriesEnumeration != null) {
                    while (fragmentEntriesEnumeration.hasMoreElements()) {
                        url = (URL)fragmentEntriesEnumeration.nextElement();
                        FragmentEntry fragmentEntry = this._getFragmentEntry(url);
                        List fragmentEntryList = this._fragmentEntries.computeIfAbsent(fragmentEntry.getType(), type -> new ArrayList());
                        fragmentEntryList.add(fragmentEntry);
                    }
                }
                if (fragmentCompositionsEnumeration != null) {
                    while (fragmentCompositionsEnumeration.hasMoreElements()) {
                        url = (URL)fragmentCompositionsEnumeration.nextElement();
                        this._fragmentCompositions.add(this._getFragmentComposition(url));
                    }
                }
            }
            catch (Exception exception) {
                if (!_log.isDebugEnabled()) break block7;
                _log.debug((Throwable)exception);
            }
        }
    }

    private Map<Locale, String> _getContributedCollectionNames() throws Exception {
        Class<?> clazz = this.getClass();
        String json = StreamUtil.toString((InputStream)clazz.getResourceAsStream("dependencies/collection.json"));
        JSONObject jsonObject = JSONFactoryUtil.createJSONObject((String)json);
        String name = jsonObject.getString("name");
        HashMap<Locale, String> names = new HashMap<Locale, String>();
        this._setLocalizedNames(name, names, this.getResourceBundleLoader());
        return names;
    }

    private FragmentComposition _getFragmentComposition(URL url) throws Exception {
        JSONObject jsonObject = JSONFactoryUtil.createJSONObject((String)StreamUtil.toString((InputStream)url.openStream()));
        String fragmentCompositionKey = jsonObject.getString("fragmentCompositionKey");
        if (Validator.isNull((String)fragmentCompositionKey)) {
            throw new InvalidFragmentCompositionKeyException();
        }
        fragmentCompositionKey = StringBundler.concat((String[])new String[]{this.getFragmentCollectionKey(), "-composition-", jsonObject.getString("fragmentCompositionKey")});
        Map names = this._fragmentCompositionNames.getOrDefault(fragmentCompositionKey, new HashMap());
        String name = jsonObject.getString("name");
        this._setLocalizedNames(name, names, this.getResourceBundleLoader());
        this._fragmentCompositionNames.put(fragmentCompositionKey, names);
        String definition = this._read(FileUtil.getPath((String)url.getPath()), jsonObject.getString("fragmentCompositionDefinitionPath"), "fragment-composition-definition.json");
        String thumbnailURL = this._getImagePreviewURL(jsonObject.getString("thumbnail"));
        FragmentComposition fragmentComposition = this.fragmentCompositionLocalService.createFragmentComposition(0L);
        fragmentComposition.setFragmentCompositionKey(fragmentCompositionKey);
        fragmentComposition.setName(name);
        fragmentComposition.setData(definition);
        fragmentComposition.setIcon(jsonObject.getString("icon", "edit-layout"));
        fragmentComposition.setImagePreviewURL(thumbnailURL);
        return fragmentComposition;
    }

    private List<FragmentComposition> _getFragmentCompositions(List<FragmentComposition> fragmentCompositions, Locale locale) {
        Stream stream = fragmentCompositions.stream();
        return stream.map(fragmentComposition -> {
            Map names = this._fragmentCompositionNames.getOrDefault(fragmentComposition.getFragmentCompositionKey(), Collections.emptyMap());
            fragmentComposition.setName(names.getOrDefault(locale, names.getOrDefault(LocaleUtil.toLanguageId((Locale)LocaleUtil.getDefault()), fragmentComposition.getName())));
            return fragmentComposition;
        }).collect(Collectors.toList());
    }

    private List<FragmentEntry> _getFragmentEntries(List<FragmentEntry> fragmentEntries, Locale locale) {
        Stream stream = fragmentEntries.stream();
        return stream.map(fragmentEntry -> {
            Map names = this._fragmentEntryNames.getOrDefault(fragmentEntry.getFragmentEntryKey(), Collections.emptyMap());
            fragmentEntry.setName(names.getOrDefault(locale, names.getOrDefault(LocaleUtil.toLanguageId((Locale)LocaleUtil.getDefault()), fragmentEntry.getName())));
            return fragmentEntry;
        }).collect(Collectors.toList());
    }

    private FragmentEntry _getFragmentEntry(URL url) throws Exception {
        JSONObject jsonObject = JSONFactoryUtil.createJSONObject((String)StreamUtil.toString((InputStream)url.openStream()));
        String fragmentEntryKey = StringBundler.concat((String[])new String[]{this.getFragmentCollectionKey(), "-", jsonObject.getString("fragmentEntryKey")});
        Map names = this._fragmentEntryNames.getOrDefault(fragmentEntryKey, new HashMap());
        String name = jsonObject.getString("name");
        this._setLocalizedNames(name, names, this.getResourceBundleLoader());
        this._fragmentEntryNames.put(fragmentEntryKey, names);
        String path = FileUtil.getPath((String)url.getPath());
        String css = this._read(path, jsonObject.getString("cssPath"), "index.css");
        String html = this._read(path, jsonObject.getString("htmlPath"), "index.html");
        String js = this._read(path, jsonObject.getString("jsPath"), "index.js");
        boolean cacheable = jsonObject.getBoolean("cacheable");
        String configuration = this._read(path, jsonObject.getString("configurationPath"), "configuration.json");
        if (Validator.isNull((String)configuration)) {
            configuration = this._read(path, jsonObject.getString("configurationPath"), "index.json");
        }
        String thumbnailURL = this._getImagePreviewURL(jsonObject.getString("thumbnail"));
        int type = FragmentConstants.getTypeFromLabel(jsonObject.getString("type"));
        FragmentEntry fragmentEntry = this.fragmentEntryLocalService.createFragmentEntry(0L);
        fragmentEntry.setFragmentEntryKey(fragmentEntryKey);
        fragmentEntry.setName(name);
        fragmentEntry.setCss(css);
        fragmentEntry.setHtml(html);
        fragmentEntry.setJs(js);
        fragmentEntry.setCacheable(cacheable);
        fragmentEntry.setConfiguration(configuration);
        fragmentEntry.setIcon(jsonObject.getString("icon", "code"));
        fragmentEntry.setType(type);
        fragmentEntry.setTypeOptions(jsonObject.getString("typeOptions"));
        fragmentEntry.setImagePreviewURL(thumbnailURL);
        return fragmentEntry;
    }

    private String _getImagePreviewURL(String fileName) {
        URL url = this._bundle.getResource("META-INF/resources/thumbnails/" + fileName);
        if (url == null) {
            return "";
        }
        ServletContext servletContext = this.getServletContext();
        return StringBundler.concat((String[])new String[]{PortalUtil.getPathProxy(), servletContext.getContextPath(), "/thumbnails/", fileName});
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void _initialize() {
        if (this._initialized) {
            return;
        }
        BaseFragmentCollectionContributor baseFragmentCollectionContributor = this;
        synchronized (baseFragmentCollectionContributor) {
            if (this._initialized) {
                return;
            }
            this.readAndCheckFragmentCollectionStructure();
            this._initialized = true;
        }
    }

    private String _read(String path, String fileName, String defaultFileName) throws Exception {
        Class<?> clazz = this.getClass();
        StringBundler sb = new StringBundler(3);
        sb.append(path);
        sb.append("/");
        if (Validator.isNotNull((String)fileName)) {
            sb.append(fileName);
        } else {
            sb.append(defaultFileName);
        }
        InputStream inputStream = clazz.getResourceAsStream(sb.toString());
        if (inputStream != null) {
            return StringUtil.read((InputStream)inputStream);
        }
        return "";
    }

    private void _setLocalizedNames(String name, Map<Locale, String> names, ResourceBundleLoader resourceBundleLoader) {
        HashSet<Locale> availableLocales = new HashSet<Locale>(LanguageUtil.getAvailableLocales());
        availableLocales.add(LocaleUtil.getDefault());
        for (Locale locale : availableLocales) {
            if (!Validator.isNotNull((String)name)) continue;
            String languageId = LocaleUtil.toLanguageId((Locale)locale);
            ResourceBundle resourceBundle = resourceBundleLoader.loadResourceBundle(LocaleUtil.fromLanguageId((String)languageId));
            names.put(LocaleUtil.fromLanguageId((String)languageId), LanguageUtil.get((ResourceBundle)resourceBundle, (String)name, (String)name));
        }
    }
}

