/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.fragment.util;

import com.liferay.fragment.model.FragmentEntry;
import com.liferay.fragment.model.FragmentEntryLink;
import com.liferay.fragment.processor.FragmentEntryProcessorRegistry;
import com.liferay.osgi.util.ServiceTrackerFactory;
import com.liferay.portal.kernel.exception.PortalException;
import com.liferay.portal.kernel.io.unsync.UnsyncStringWriter;
import com.liferay.portal.kernel.template.StringTemplateResource;
import com.liferay.portal.kernel.template.Template;
import com.liferay.portal.kernel.template.TemplateManager;
import com.liferay.portal.kernel.template.TemplateManagerUtil;
import com.liferay.portal.kernel.template.TemplateResource;
import com.liferay.portal.kernel.util.MapUtil;
import com.liferay.portal.kernel.util.StringBundler;
import com.liferay.portal.kernel.util.Validator;
import java.io.Writer;
import java.util.HashMap;
import java.util.Map;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.osgi.util.tracker.ServiceTracker;

public class FragmentEntryRenderUtil {
    private static final ServiceTracker<FragmentEntryProcessorRegistry, FragmentEntryProcessorRegistry> _serviceTracker = ServiceTrackerFactory.open(FragmentEntryProcessorRegistry.class);

    public static FragmentEntryProcessorRegistry getService() {
        return (FragmentEntryProcessorRegistry)_serviceTracker.getService();
    }

    public static String renderFragmentEntry(FragmentEntry fragmentEntry) {
        return FragmentEntryRenderUtil.renderFragmentEntry(fragmentEntry.getFragmentEntryId(), 0L, fragmentEntry.getCss(), fragmentEntry.getHtml(), fragmentEntry.getJs());
    }

    public static String renderFragmentEntry(long fragmentEntryId, long fragmentEntryInstanceId, String css, String html, String js) {
        StringBundler sb = new StringBundler(14);
        sb.append("<div id=\"");
        StringBundler fragmentIdSB = new StringBundler(4);
        fragmentIdSB.append("fragment-");
        fragmentIdSB.append(fragmentEntryId);
        fragmentIdSB.append("-");
        fragmentIdSB.append(fragmentEntryInstanceId);
        sb.append(fragmentIdSB.toString());
        sb.append("\" >");
        sb.append(html);
        sb.append("</div>");
        if (Validator.isNotNull((String)css)) {
            sb.append("<style>");
            sb.append(css);
            sb.append("</style>");
        }
        if (Validator.isNotNull((String)js)) {
            sb.append("<script>(function() {");
            sb.append("var fragmentElement = document.querySelector('#");
            sb.append(fragmentIdSB.toString());
            sb.append("');");
            sb.append(js);
            sb.append(";}());</script>");
        }
        return sb.toString();
    }

    public static String renderFragmentEntryLink(FragmentEntryLink fragmentEntryLink, HttpServletRequest request, HttpServletResponse response) throws PortalException {
        return FragmentEntryRenderUtil.renderFragmentEntryLink(fragmentEntryLink, "EDIT", request, response);
    }

    public static String renderFragmentEntryLink(FragmentEntryLink fragmentEntryLink, String mode, HttpServletRequest request, HttpServletResponse response) throws PortalException {
        return FragmentEntryRenderUtil.renderFragmentEntryLink(fragmentEntryLink, mode, new HashMap<String, Object>(), request, response);
    }

    public static String renderFragmentEntryLink(FragmentEntryLink fragmentEntryLink, String mode, Map<String, Object> parameterMap, HttpServletRequest request, HttpServletResponse response) throws PortalException {
        FragmentEntryProcessorRegistry fragmentEntryProcessorRegistry = FragmentEntryRenderUtil.getService();
        String html = fragmentEntryProcessorRegistry.processFragmentEntryLinkHTML(fragmentEntryLink, mode);
        if (Validator.isNotNull((String)html)) {
            html = FragmentEntryRenderUtil._processTemplate(html, parameterMap, request, response);
        }
        return FragmentEntryRenderUtil.renderFragmentEntry(fragmentEntryLink.getFragmentEntryId(), fragmentEntryLink.getPosition(), fragmentEntryLink.getCss(), html, fragmentEntryLink.getJs());
    }

    private static String _processTemplate(String html, Map<String, Object> parameterMap, HttpServletRequest request, HttpServletResponse response) throws PortalException {
        html = "[#ftl]\n" + html;
        StringTemplateResource templateResource = new StringTemplateResource("template_id", html);
        Template template = TemplateManagerUtil.getTemplate((String)"ftl", (TemplateResource)templateResource, (boolean)false);
        TemplateManager templateManager = TemplateManagerUtil.getTemplateManager((String)"ftl");
        templateManager.addTaglibSupport((Map)template, request, response);
        templateManager.addTaglibTheme((Map)template, "taglibLiferay", request, response);
        UnsyncStringWriter unsyncStringWriter = new UnsyncStringWriter();
        template.put((Object)"writer", (Object)unsyncStringWriter);
        if (MapUtil.isNotEmpty(parameterMap)) {
            template.putAll(parameterMap);
        }
        template.prepare(request);
        template.processTemplate((Writer)unsyncStringWriter);
        return unsyncStringWriter.toString();
    }
}

