/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.forms.apio.internal.helper;

import com.google.gson.Gson;
import com.liferay.apio.architect.file.BinaryFile;
import com.liferay.apio.architect.functional.Try;
import com.liferay.document.library.kernel.service.DLAppService;
import com.liferay.dynamic.data.mapping.model.DDMFormField;
import com.liferay.dynamic.data.mapping.model.DDMFormInstance;
import com.liferay.dynamic.data.mapping.model.LocalizedValue;
import com.liferay.dynamic.data.mapping.model.UnlocalizedValue;
import com.liferay.dynamic.data.mapping.model.Value;
import com.liferay.dynamic.data.mapping.storage.DDMFormFieldValue;
import com.liferay.forms.apio.internal.architect.form.MediaObjectCreatorForm;
import com.liferay.forms.apio.internal.model.FileEntryValue;
import com.liferay.portal.kernel.repository.model.FileEntry;
import com.liferay.portal.kernel.service.ServiceContext;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.stream.Stream;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.Reference;

@Component(immediate=true, service={UploadFileHelper.class})
public class UploadFileHelper {
    @Reference
    private DLAppService _dlAppService;

    public void linkFiles(List<DDMFormField> ddmFormFields, List<DDMFormFieldValue> ddmFormFieldValues) {
        Stream ddmFormFieldsStream = ddmFormFields.stream();
        ddmFormFieldsStream.filter(formField -> formField.getType().equals("document_library")).map(field -> this._findField(field.getName(), ddmFormFieldValues)).forEach(optional -> optional.ifPresent(this::_setFileEntryAsFormFieldValue));
    }

    public FileEntry uploadFile(DDMFormInstance ddmFormInstance, MediaObjectCreatorForm mediaObjectCreatorForm) {
        Optional<Long> folderIdOptional = mediaObjectCreatorForm.getFolderIdOptional();
        long folderId = folderIdOptional.orElse(0L);
        BinaryFile binaryFile = mediaObjectCreatorForm.getBinaryFile();
        return (FileEntry)Try.fromFallible(() -> ((DDMFormInstance)ddmFormInstance).getGroupId()).map(repositoryId -> this._dlAppService.addFileEntry(repositoryId.longValue(), folderId, mediaObjectCreatorForm.getName(), binaryFile.getMimeType(), mediaObjectCreatorForm.getTitle(), mediaObjectCreatorForm.getDescription(), null, binaryFile.getInputStream(), binaryFile.getSize(), new ServiceContext())).orElse(null);
    }

    private Value _calculateDDMFormFieldValue(String jsonValue, DDMFormField ddmFormField) {
        if (ddmFormField.isLocalizable()) {
            LocalizedValue localizedValue = new LocalizedValue();
            localizedValue.addString(localizedValue.getDefaultLocale(), jsonValue);
            return localizedValue;
        }
        return new UnlocalizedValue(jsonValue);
    }

    private Long _extractFileEntryId(DDMFormFieldValue ddmFormFieldValue) {
        return (Long)Try.fromFallible(() -> ((DDMFormFieldValue)ddmFormFieldValue).getValue()).map(Value::getValues).map(Map::values).map(Collection::stream).mapOptional(Stream::findFirst).map(fileEntryUrl -> fileEntryUrl.substring(fileEntryUrl.lastIndexOf("/") + 1)).map(Long::valueOf).orElse(null);
    }

    private Optional<DDMFormFieldValue> _findField(String formFieldName, List<DDMFormFieldValue> ddmFormFieldValues) {
        Stream ddmFormFieldValuesStream = ddmFormFieldValues.stream();
        return ddmFormFieldValuesStream.filter(value -> formFieldName.equals(value.getName())).findFirst();
    }

    private void _setFileEntryAsFormFieldValue(DDMFormFieldValue ddmFormFieldValue) {
        Gson gson = new Gson();
        Try.fromFallible(() -> this._extractFileEntryId(ddmFormFieldValue)).map(arg_0 -> ((DLAppService)this._dlAppService).getFileEntry(arg_0)).map(fileEntry -> new FileEntryValue(fileEntry.getFileEntryId(), fileEntry.getGroupId(), fileEntry.getTitle(), fileEntry.getMimeType(), fileEntry.getUuid(), fileEntry.getVersion())).map(arg_0 -> ((Gson)gson).toJson(arg_0)).map(jsonValue -> this._calculateDDMFormFieldValue((String)jsonValue, ddmFormFieldValue.getDDMFormField())).ifSuccess(arg_0 -> ((DDMFormFieldValue)ddmFormFieldValue).setValue(arg_0));
    }
}

