/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.forms.apio.internal.architect.resource;

import com.liferay.apio.architect.credentials.Credentials;
import com.liferay.apio.architect.custom.actions.CustomRoute;
import com.liferay.apio.architect.function.throwable.ThrowableBiFunction;
import com.liferay.apio.architect.functional.Try;
import com.liferay.apio.architect.language.AcceptLanguage;
import com.liferay.apio.architect.pagination.PageItems;
import com.liferay.apio.architect.pagination.Pagination;
import com.liferay.apio.architect.representor.Representor;
import com.liferay.apio.architect.resource.NestedCollectionResource;
import com.liferay.apio.architect.routes.ItemRoutes;
import com.liferay.apio.architect.routes.NestedCollectionRoutes;
import com.liferay.content.space.apio.architect.identifier.ContentSpaceIdentifier;
import com.liferay.dynamic.data.mapping.form.renderer.DDMFormRenderingContext;
import com.liferay.dynamic.data.mapping.model.DDMFormInstance;
import com.liferay.dynamic.data.mapping.model.DDMFormInstanceModel;
import com.liferay.dynamic.data.mapping.model.DDMFormInstanceRecord;
import com.liferay.dynamic.data.mapping.model.DDMFormInstanceVersion;
import com.liferay.dynamic.data.mapping.model.DDMStructure;
import com.liferay.dynamic.data.mapping.model.DDMStructureVersionModel;
import com.liferay.dynamic.data.mapping.service.DDMFormInstanceService;
import com.liferay.dynamic.data.mapping.service.DDMFormInstanceVersionService;
import com.liferay.forms.apio.architect.identifier.FormContextIdentifier;
import com.liferay.forms.apio.architect.identifier.FormInstanceIdentifier;
import com.liferay.forms.apio.architect.identifier.FormInstanceRecordIdentifier;
import com.liferay.forms.apio.architect.identifier.StructureIdentifier;
import com.liferay.forms.apio.internal.architect.form.FetchLatestDraftForm;
import com.liferay.forms.apio.internal.architect.form.FormContextForm;
import com.liferay.forms.apio.internal.architect.form.MediaObjectCreatorForm;
import com.liferay.forms.apio.internal.architect.route.EvaluateContextPostRoute;
import com.liferay.forms.apio.internal.architect.route.FetchLatestDraftRoute;
import com.liferay.forms.apio.internal.architect.route.UploadFilePostRoute;
import com.liferay.forms.apio.internal.helper.EvaluateContextHelper;
import com.liferay.forms.apio.internal.helper.FetchLatestRecordHelper;
import com.liferay.forms.apio.internal.helper.UploadFileHelper;
import com.liferay.forms.apio.internal.model.FormContextWrapper;
import com.liferay.media.object.apio.architect.identifier.MediaObjectIdentifier;
import com.liferay.person.apio.architect.identifier.PersonIdentifier;
import com.liferay.portal.apio.permission.HasPermission;
import com.liferay.portal.apio.permission.HasPermissionUtil;
import com.liferay.portal.apio.user.CurrentUser;
import com.liferay.portal.kernel.model.Company;
import com.liferay.portal.kernel.repository.model.FileEntry;
import com.liferay.portal.kernel.theme.ThemeDisplay;
import com.liferay.portal.kernel.util.LocaleUtil;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.function.BiFunction;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.Reference;

@Component(immediate=true, service={NestedCollectionResource.class})
public class FormInstanceNestedCollectionResource
implements NestedCollectionResource<DDMFormInstance, Long, FormInstanceIdentifier, Long, ContentSpaceIdentifier> {
    @Reference
    private DDMFormInstanceService _ddmFormInstanceService;
    @Reference
    private DDMFormInstanceVersionService _ddmFormInstanceVersionService;
    @Reference
    private EvaluateContextHelper _evaluateContextHelper;
    @Reference
    private FetchLatestRecordHelper _fetchLatestRecordVersionHelper;
    @Reference(target="(model.class.name=com.liferay.dynamic.data.mapping.model.DDMFormInstanceRecord)")
    private HasPermission<Long> _hasPermission;
    @Reference
    private UploadFileHelper _uploadFileHelper;

    public NestedCollectionRoutes<DDMFormInstance, Long, Long> collectionRoutes(NestedCollectionRoutes.Builder<DDMFormInstance, Long, Long> builder) {
        return builder.addGetter(this::_getPageItems, Company.class).build();
    }

    public String getName() {
        return "form";
    }

    public ItemRoutes<DDMFormInstance, Long> itemRoutes(ItemRoutes.Builder<DDMFormInstance, Long> builder) {
        return builder.addGetter(arg_0 -> ((DDMFormInstanceService)this._ddmFormInstanceService).getFormInstance(arg_0)).addCustomRoute((CustomRoute)new EvaluateContextPostRoute(), this::_evaluateContext, AcceptLanguage.class, DDMFormRenderingContext.class, ThemeDisplay.class, FormContextIdentifier.class, this._getPermissionBiFunction(), FormContextForm::buildForm).addCustomRoute((CustomRoute)new FetchLatestDraftRoute(), this::_fetchDDMFormInstanceRecord, CurrentUser.class, FormInstanceRecordIdentifier.class, this._getPermissionBiFunction(), FetchLatestDraftForm::buildForm).addCustomRoute((CustomRoute)new UploadFilePostRoute(), this::_uploadFile, MediaObjectIdentifier.class, this._getPermissionBiFunction(), MediaObjectCreatorForm::buildForm).build();
    }

    public Representor<DDMFormInstance> representor(Representor.Builder<DDMFormInstance, Long> builder) {
        return (Representor)((Representor.FirstStep)((Representor.FirstStep)((Representor.FirstStep)((Representor.FirstStep)((Representor.FirstStep)((Representor.FirstStep)((Representor.FirstStep)((Representor.FirstStep)((Representor.FirstStep)builder.types("Form", new String[0]).identifier(DDMFormInstanceModel::getFormInstanceId).addBidirectionalModel("contentSpace", "forms", ContentSpaceIdentifier.class, DDMFormInstanceModel::getGroupId).addDate("dateCreated", DDMFormInstanceModel::getCreateDate)).addDate("dateModified", DDMFormInstanceModel::getModifiedDate)).addDate("datePublished", DDMFormInstanceModel::getLastPublishDate)).addLinkedModel("creator", PersonIdentifier.class, DDMFormInstanceModel::getUserId)).addLinkedModel("structure", StructureIdentifier.class, this::_getStructureId)).addLocalizedStringByLocale("description", DDMFormInstanceModel::getDescription)).addLocalizedStringByLocale("name", DDMFormInstanceModel::getName)).addString("defaultLanguage", DDMFormInstanceModel::getDefaultLanguageId)).addStringList("availableLanguages", formInstance -> Arrays.asList(LocaleUtil.toW3cLanguageIds((String[])formInstance.getAvailableLanguageIds())))).build();
    }

    private FormContextWrapper _evaluateContext(Long ddmFormInstanceId, FormContextForm formContextForm, AcceptLanguage acceptLanguage, DDMFormRenderingContext ddmFormRenderingContext, ThemeDisplay themeDisplay) {
        return (FormContextWrapper)Try.fromFallible(() -> this._ddmFormInstanceService.getFormInstance(ddmFormInstanceId.longValue())).map(DDMFormInstance::getStructure).map(ddmStructure -> this._evaluateContextHelper.evaluateContext(formContextForm.getFieldValues(), (DDMStructure)ddmStructure, ddmFormRenderingContext, acceptLanguage.getPreferredLocale())).orElse(null);
    }

    private DDMFormInstanceRecord _fetchDDMFormInstanceRecord(Long ddmFormInstanceId, FetchLatestDraftForm fetchLatestDraftForm, CurrentUser currentUser) {
        return (DDMFormInstanceRecord)Try.fromFallible(() -> this._ddmFormInstanceService.getFormInstance(ddmFormInstanceId.longValue())).map(ddmFormInstance -> this._fetchLatestRecordVersionHelper.fetchLatestDraftRecord((DDMFormInstance)ddmFormInstance, currentUser)).orElse(null);
    }

    private PageItems<DDMFormInstance> _getPageItems(Pagination pagination, long groupId, Company company) {
        List ddmFormInstances = this._ddmFormInstanceService.getFormInstances(company.getCompanyId(), groupId, pagination.getStartPosition(), pagination.getEndPosition());
        int count = this._ddmFormInstanceService.getFormInstancesCount(company.getCompanyId(), groupId);
        return new PageItems((Collection)ddmFormInstances, count);
    }

    private BiFunction<Credentials, Long, Boolean> _getPermissionBiFunction() {
        return HasPermissionUtil.failOnException((ThrowableBiFunction)this._hasPermission.forAddingIn(FormInstanceRecordIdentifier.class));
    }

    private Long _getStructureId(DDMFormInstance ddmFormInstance) {
        return (Long)Try.fromFallible(() -> this._ddmFormInstanceVersionService.getLatestFormInstanceVersion(ddmFormInstance.getFormInstanceId(), 0)).map(DDMFormInstanceVersion::getStructureVersion).map(DDMStructureVersionModel::getStructureId).orElse(null);
    }

    private FileEntry _uploadFile(Long ddmFormInstanceId, MediaObjectCreatorForm mediaObjectCreatorForm) {
        return (FileEntry)Try.fromFallible(() -> this._ddmFormInstanceService.getFormInstance(ddmFormInstanceId.longValue())).map(ddmFormInstance -> this._uploadFileHelper.uploadFile((DDMFormInstance)ddmFormInstance, mediaObjectCreatorForm)).orElse(null);
    }
}

