/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.folder.apio.internal.architect.resource;

import com.liferay.apio.architect.pagination.PageItems;
import com.liferay.apio.architect.pagination.Pagination;
import com.liferay.apio.architect.representor.Representor;
import com.liferay.apio.architect.resource.NestedCollectionResource;
import com.liferay.apio.architect.routes.ItemRoutes;
import com.liferay.apio.architect.routes.NestedCollectionRoutes;
import com.liferay.document.library.kernel.service.DLAppService;
import com.liferay.folder.apio.architect.identifier.FolderIdentifier;
import com.liferay.folder.apio.architect.identifier.RootFolderIdentifier;
import com.liferay.folder.apio.internal.architect.form.FolderForm;
import com.liferay.portal.apio.idempotent.Idempotent;
import com.liferay.portal.apio.permission.HasPermission;
import com.liferay.portal.kernel.exception.PortalException;
import com.liferay.portal.kernel.repository.model.Folder;
import com.liferay.portal.kernel.service.ServiceContext;
import java.util.Collection;
import java.util.List;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.Reference;

@Component(immediate=true)
public class FolderNestedCollectionResource
implements NestedCollectionResource<Folder, Long, FolderIdentifier, Long, RootFolderIdentifier> {
    @Reference
    private DLAppService _dlAppService;
    @Reference(target="(model.class.name=com.liferay.portal.kernel.repository.model.Folder)")
    private HasPermission<Long> _hasPermission;

    public NestedCollectionRoutes<Folder, Long, Long> collectionRoutes(NestedCollectionRoutes.Builder<Folder, Long, Long> builder) {
        return builder.addGetter(this::_getPageItems).addCreator(this::_addFolder, this._hasPermission.forAddingIn(RootFolderIdentifier.class), FolderForm::buildForm).build();
    }

    public String getName() {
        return "folder";
    }

    public ItemRoutes<Folder, Long> itemRoutes(ItemRoutes.Builder<Folder, Long> builder) {
        return builder.addGetter(arg_0 -> ((DLAppService)this._dlAppService).getFolder(arg_0)).addRemover(Idempotent.idempotent(arg_0 -> ((DLAppService)this._dlAppService).deleteFolder(arg_0)), (arg_0, arg_1) -> this._hasPermission.forDeleting(arg_0, arg_1)).addUpdater(this::_updateFolder, (arg_0, arg_1) -> this._hasPermission.forUpdating(arg_0, arg_1), FolderForm::buildForm).build();
    }

    public Representor<Folder> representor(Representor.Builder<Folder, Long> builder) {
        return (Representor)((Representor.FirstStep)((Representor.FirstStep)((Representor.FirstStep)((Representor.FirstStep)builder.types("Folder", new String[0]).identifier(Folder::getFolderId).addDate("dateCreated", Folder::getCreateDate)).addDate("dateModified", Folder::getCreateDate)).addDate("datePublished", Folder::getCreateDate)).addRelatedCollection("folders", FolderIdentifier.class).addString("name", Folder::getName)).build();
    }

    private Folder _addFolder(long groupId, FolderForm folderForm) throws PortalException {
        long parentFolderId = 0L;
        return this._dlAppService.addFolder(groupId, parentFolderId, folderForm.getName(), folderForm.getDescription(), new ServiceContext());
    }

    private PageItems<Folder> _getPageItems(Pagination pagination, long groupId) throws PortalException {
        List folders = this._dlAppService.getFolders(groupId, 0L, pagination.getStartPosition(), pagination.getEndPosition(), null);
        int count = this._dlAppService.getFoldersCount(groupId, 0L);
        return new PageItems((Collection)folders, count);
    }

    private Folder _updateFolder(long folderId, FolderForm folderForm) throws PortalException {
        return this._dlAppService.updateFolder(folderId, folderForm.getName(), folderForm.getDescription(), new ServiceContext());
    }
}

