/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.exportimport.test.util.lar;

import com.liferay.exportimport.kernel.lar.ExportImportPathUtil;
import com.liferay.exportimport.kernel.lar.PortletDataContext;
import com.liferay.exportimport.kernel.lar.PortletDataException;
import com.liferay.exportimport.kernel.lar.StagedModelDataHandler;
import com.liferay.exportimport.kernel.lar.StagedModelDataHandlerRegistryUtil;
import com.liferay.exportimport.kernel.lar.StagedModelDataHandlerUtil;
import com.liferay.exportimport.test.util.lar.BaseStagedModelDataHandlerTestCase;
import com.liferay.portal.kernel.model.Group;
import com.liferay.portal.kernel.model.StagedModel;
import com.liferay.portal.kernel.model.WorkflowedModel;
import com.liferay.portal.kernel.util.ArrayUtil;
import com.liferay.portal.kernel.workflow.WorkflowThreadLocal;
import com.liferay.portal.kernel.xml.Element;
import com.liferay.portal.kernel.xml.SAXReaderUtil;
import com.liferay.portal.kernel.xml.XPath;
import java.util.List;
import org.junit.Assert;
import org.junit.Test;

public abstract class BaseWorkflowedStagedModelDataHandlerTestCase
extends BaseStagedModelDataHandlerTestCase {
    @Test
    public void testExportWorkflowedStagedModels() throws Exception {
        this.initExport();
        List<StagedModel> stagedModels = null;
        boolean workflowEnabled = WorkflowThreadLocal.isEnabled();
        try {
            WorkflowThreadLocal.setEnabled((boolean)true);
            stagedModels = this.addWorkflowedStagedModels(this.stagingGroup);
        }
        finally {
            WorkflowThreadLocal.setEnabled((boolean)workflowEnabled);
        }
        for (StagedModel stagedModel : stagedModels) {
            Assert.assertTrue((String)"Staged model is not a workflowed model", (boolean)(stagedModel instanceof WorkflowedModel));
            try {
                StagedModelDataHandlerUtil.exportStagedModel((PortletDataContext)this.portletDataContext, (StagedModel)stagedModel);
            }
            catch (PortletDataException portletDataException) {
                Assert.assertEquals((String)"An unexpected error occurred during the export", (long)9L, (long)portletDataException.getType());
            }
            this.validateWorkflowedExport(this.portletDataContext, stagedModel);
        }
    }

    protected abstract List<StagedModel> addWorkflowedStagedModels(Group var1) throws Exception;

    protected Element getExportStagedModelElement(PortletDataContext portletDataContext, StagedModel stagedModel) {
        Element rootElement = portletDataContext.getExportDataRootElement();
        Class modelClass = stagedModel.getModelClass();
        Element modelElement = rootElement.element(modelClass.getSimpleName());
        Assert.assertNotNull((String)"Unable to find model element", (Object)modelElement);
        XPath xPath = SAXReaderUtil.createXPath((String)("staged-model[@path ='" + ExportImportPathUtil.getModelPath((StagedModel)stagedModel) + "']"));
        return (Element)xPath.selectSingleNode((Object)modelElement);
    }

    protected void validateWorkflowedExport(PortletDataContext portletDataContext, StagedModel stagedModel) throws Exception {
        StagedModelDataHandler stagedModelDataHandler = StagedModelDataHandlerRegistryUtil.getStagedModelDataHandler((String)stagedModel.getModelClassName());
        WorkflowedModel workflowedModel = (WorkflowedModel)stagedModel;
        Element exportStagedModelElement = this.getExportStagedModelElement(portletDataContext, stagedModel);
        if (ArrayUtil.contains((int[])stagedModelDataHandler.getExportableStatuses(), (int)workflowedModel.getStatus())) {
            Assert.assertNotNull((String)"Staged model should be exported", (Object)exportStagedModelElement);
        } else {
            Assert.assertNull((String)"Staged model should not be exported", (Object)exportStagedModelElement);
        }
    }
}

