/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.exportimport.internal.util;

import com.liferay.portal.kernel.exception.PortalException;
import com.liferay.portal.kernel.log.Log;
import com.liferay.portal.kernel.log.LogFactoryUtil;
import com.liferay.portal.kernel.model.ResourcePermission;
import com.liferay.portal.kernel.security.permission.ResourceActionsUtil;
import com.liferay.portal.kernel.service.ResourcePermissionLocalServiceUtil;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;

public class ExportImportPermissionUtil {
    public static final String ROLE_TEAM_PREFIX = "ROLE_TEAM_,*";
    private static final Log _log = LogFactoryUtil.getLog(ExportImportPermissionUtil.class);

    public static Map<Long, Set<String>> getRoleIdsToActionIds(long companyId, String resourceName, long resourcePK) {
        return ExportImportPermissionUtil.getRoleIdsToActionIds(companyId, resourceName, String.valueOf(resourcePK));
    }

    public static Map<Long, Set<String>> getRoleIdsToActionIds(long companyId, String resourceName, String resourcePK) {
        HashMap<Long, Set<String>> existingRoleIdsToActionIds;
        block2: {
            List existingActionIds = ResourceActionsUtil.getModelResourceActions((String)resourceName);
            existingRoleIdsToActionIds = new HashMap();
            try {
                existingRoleIdsToActionIds = ExportImportPermissionUtil.getRoleIdsToActionIds(companyId, resourceName, resourcePK, existingActionIds);
            }
            catch (PortalException portalException) {
                if (!_log.isDebugEnabled()) break block2;
                _log.debug((Object)portalException, (Throwable)portalException);
            }
        }
        return existingRoleIdsToActionIds;
    }

    public static Map<Long, Set<String>> getRoleIdsToActionIds(long companyId, String className, String primKey, List<String> actionIds) throws PortalException {
        return ResourcePermissionLocalServiceUtil.getAvailableResourcePermissionActionIds((long)companyId, (String)className, (int)4, (String)primKey, actionIds);
    }

    public static String getTeamRoleName(String roleName) {
        return ROLE_TEAM_PREFIX + roleName;
    }

    public static boolean isTeamRoleName(String roleName) {
        return roleName.startsWith(ROLE_TEAM_PREFIX);
    }

    public static Map<Long, String[]> mergeImportedPermissionsWithExistingPermissions(Map<Long, Set<String>> existingRoleIdsToActionIds, Map<Long, String[]> importedRoleIdsToActionIds) {
        HashMap<Long, String[]> mergedRoleIdsToActionIds = new HashMap<Long, String[]>();
        for (Map.Entry<Long, Set<String>> roleIdsToActionIds : existingRoleIdsToActionIds.entrySet()) {
            long roleId = roleIdsToActionIds.getKey();
            if (importedRoleIdsToActionIds.containsKey(roleId)) {
                String[] actionIds = importedRoleIdsToActionIds.remove(roleId);
                mergedRoleIdsToActionIds.put(roleId, actionIds);
                continue;
            }
            mergedRoleIdsToActionIds.put(roleId, new String[0]);
        }
        mergedRoleIdsToActionIds.putAll(importedRoleIdsToActionIds);
        return mergedRoleIdsToActionIds;
    }

    public static void updateResourcePermissions(long companyId, long groupId, String resourceName, long resourcePK, Map<Long, String[]> roleIdsToActionIds) throws PortalException {
        ExportImportPermissionUtil.updateResourcePermissions(companyId, groupId, resourceName, String.valueOf(resourcePK), roleIdsToActionIds);
    }

    public static void updateResourcePermissions(long companyId, long groupId, String resourceName, String resourcePK, Map<Long, String[]> roleIdsToActionIds) throws PortalException {
        List resourcePermissions = ResourcePermissionLocalServiceUtil.getResourcePermissions((long)companyId, (String)resourceName, (int)4, (String)resourcePK);
        HashMap<Long, String[]> mergedRoleIdsToActionIds = new HashMap<Long, String[]>(roleIdsToActionIds);
        for (ResourcePermission resourcePermission : resourcePermissions) {
            mergedRoleIdsToActionIds.putIfAbsent(resourcePermission.getRoleId(), new String[0]);
        }
        ResourcePermissionLocalServiceUtil.setResourcePermissions((long)companyId, (String)resourceName, (int)4, (String)resourcePK, mergedRoleIdsToActionIds);
    }
}

