/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.exportimport.staging;

import com.liferay.exportimport.kernel.staging.LayoutStaging;
import com.liferay.portal.kernel.exception.PortalException;
import com.liferay.portal.kernel.model.Group;
import com.liferay.portal.kernel.model.Layout;
import com.liferay.portal.kernel.model.LayoutRevision;
import com.liferay.portal.kernel.model.LayoutSet;
import com.liferay.portal.kernel.model.LayoutSetBranch;
import com.liferay.portal.kernel.model.LayoutSetStagingHandler;
import com.liferay.portal.kernel.model.LayoutStagingHandler;
import com.liferay.portal.kernel.security.pacl.DoPrivileged;
import com.liferay.portal.kernel.service.LayoutSetBranchLocalService;
import com.liferay.portal.kernel.util.GetterUtil;
import com.liferay.portal.kernel.util.ProxyUtil;
import com.liferay.portal.kernel.util.UnicodeProperties;
import java.lang.reflect.InvocationHandler;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.Reference;

@DoPrivileged
@Component(immediate=true)
public class LayoutStagingImpl
implements LayoutStaging {
    private LayoutSetBranchLocalService _layoutSetBranchLocalService;

    public LayoutRevision getLayoutRevision(Layout layout) {
        LayoutStagingHandler layoutStagingHandler = this.getLayoutStagingHandler(layout);
        if (layoutStagingHandler == null) {
            return null;
        }
        return layoutStagingHandler.getLayoutRevision();
    }

    public LayoutSetBranch getLayoutSetBranch(LayoutSet layoutSet) {
        LayoutSetStagingHandler layoutSetStagingHandler = this.getLayoutSetStagingHandler(layoutSet);
        if (layoutSetStagingHandler == null) {
            return null;
        }
        return layoutSetStagingHandler.getLayoutSetBranch();
    }

    public LayoutSetStagingHandler getLayoutSetStagingHandler(LayoutSet layoutSet) {
        if (!ProxyUtil.isProxyClass(layoutSet.getClass())) {
            return null;
        }
        InvocationHandler invocationHandler = ProxyUtil.getInvocationHandler((Object)layoutSet);
        if (!(invocationHandler instanceof LayoutSetStagingHandler)) {
            return null;
        }
        return (LayoutSetStagingHandler)invocationHandler;
    }

    public LayoutStagingHandler getLayoutStagingHandler(Layout layout) {
        if (layout == null) {
            return null;
        }
        if (!ProxyUtil.isProxyClass(layout.getClass())) {
            return null;
        }
        InvocationHandler invocationHandler = ProxyUtil.getInvocationHandler((Object)layout);
        if (!(invocationHandler instanceof LayoutStagingHandler)) {
            return null;
        }
        return (LayoutStagingHandler)invocationHandler;
    }

    public boolean isBranchingLayout(Layout layout) {
        try {
            return this.isBranchingLayoutSet(layout.getGroup(), layout.isPrivateLayout());
        }
        catch (Exception e) {
            throw new IllegalStateException(e);
        }
    }

    public boolean isBranchingLayoutSet(Group group, boolean privateLayout) {
        UnicodeProperties typeSettingsProperties;
        boolean isStagingGroup = false;
        if (group.isStagingGroup() && !group.isStagedRemotely()) {
            isStagingGroup = true;
            group = group.getLiveGroup();
        }
        if ((typeSettingsProperties = group.getTypeSettingsProperties()).isEmpty()) {
            return false;
        }
        boolean branchingEnabled = false;
        branchingEnabled = privateLayout ? GetterUtil.getBoolean((String)typeSettingsProperties.getProperty("branchingPrivate")) : GetterUtil.getBoolean((String)typeSettingsProperties.getProperty("branchingPublic"));
        if (!branchingEnabled || !group.isStaged() || !group.isStagedRemotely() && !isStagingGroup) {
            return false;
        }
        Group stagingGroup = group;
        if (isStagingGroup) {
            stagingGroup = group.getStagingGroup();
        }
        try {
            this._layoutSetBranchLocalService.getMasterLayoutSetBranch(stagingGroup.getGroupId(), privateLayout);
            return true;
        }
        catch (PortalException pe) {
            return false;
        }
    }

    @Reference(unbind="-")
    protected void setLayoutSetBranchLocalService(LayoutSetBranchLocalService layoutSetBranchLocalService) {
        this._layoutSetBranchLocalService = layoutSetBranchLocalService;
    }
}

