/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.exportimport.staged.model.repository.base;

import com.liferay.exportimport.kernel.lar.ExportImportClassedModelUtil;
import com.liferay.exportimport.kernel.lar.PortletDataContext;
import com.liferay.exportimport.kernel.lar.PortletDataException;
import com.liferay.exportimport.staged.model.repository.StagedModelRepository;
import com.liferay.portal.kernel.dao.orm.ExportActionableDynamicQuery;
import com.liferay.portal.kernel.exception.PortalException;
import com.liferay.portal.kernel.log.Log;
import com.liferay.portal.kernel.log.LogFactoryUtil;
import com.liferay.portal.kernel.model.Group;
import com.liferay.portal.kernel.model.StagedGroupedModel;
import com.liferay.portal.kernel.model.StagedModel;
import com.liferay.portal.kernel.service.GroupLocalServiceUtil;
import com.liferay.trash.kernel.util.TrashUtil;
import java.util.List;

public abstract class BaseStagedModelRepository<T extends StagedModel>
implements StagedModelRepository<T> {
    private static final Log _log = LogFactoryUtil.getLog(BaseStagedModelRepository.class);

    public abstract T addStagedModel(PortletDataContext var1, T var2) throws PortalException;

    public abstract void deleteStagedModel(String var1, long var2, String var4, String var5) throws PortalException;

    public abstract void deleteStagedModel(T var1) throws PortalException;

    public abstract void deleteStagedModels(PortletDataContext var1) throws PortalException;

    public T fetchMissingReference(String uuid, long groupId) {
        block9: {
            T existingStagedModel = this.fetchStagedModelByUuidAndGroupId(uuid, groupId);
            if (existingStagedModel != null && !this.isStagedModelInTrash(existingStagedModel)) {
                return existingStagedModel;
            }
            try {
                Group group;
                Group originalGroup = GroupLocalServiceUtil.getGroup((long)groupId);
                for (group = originalGroup.getParentGroup(); group != null && (existingStagedModel = this.fetchStagedModelByUuidAndGroupId(uuid, group.getGroupId())) == null; group = group.getParentGroup()) {
                }
                if (existingStagedModel != null && !this.isStagedModelInTrash(existingStagedModel)) {
                    return existingStagedModel;
                }
                List<T> existingStagedModels = this.fetchStagedModelsByUuidAndCompanyId(uuid, originalGroup.getCompanyId());
                for (StagedModel stagedModel : existingStagedModels) {
                    try {
                        StagedGroupedModel stagedGroupedModel;
                        if (!(stagedModel instanceof StagedGroupedModel ? !(group = GroupLocalServiceUtil.getGroup((long)(stagedGroupedModel = (StagedGroupedModel)stagedModel).getGroupId())).isStagingGroup() && !this.isStagedModelInTrash(stagedModel) : !this.isStagedModelInTrash(stagedModel))) continue;
                        return (T)stagedModel;
                    }
                    catch (PortalException pe) {
                        if (!_log.isDebugEnabled()) continue;
                        _log.debug((Object)pe, (Throwable)pe);
                    }
                }
            }
            catch (Exception e) {
                if (_log.isDebugEnabled()) {
                    _log.debug((Object)e, (Throwable)e);
                }
                if (!_log.isWarnEnabled()) break block9;
                _log.warn((Object)("Unable to fetch missing reference staged model from group " + groupId));
            }
        }
        return null;
    }

    public T fetchStagedModelByUuidAndGroupId(String uuid, long groupId) {
        return null;
    }

    public abstract List<T> fetchStagedModelsByUuidAndCompanyId(String var1, long var2);

    public abstract ExportActionableDynamicQuery getExportActionableDynamicQuery(PortletDataContext var1);

    public void restoreStagedModel(PortletDataContext portletDataContext, T stagedModel) throws PortletDataException {
    }

    public abstract T saveStagedModel(T var1) throws PortalException;

    public abstract T updateStagedModel(PortletDataContext var1, T var2) throws PortalException;

    protected boolean isStagedModelInTrash(T stagedModel) {
        String className = ExportImportClassedModelUtil.getClassName(stagedModel);
        long classPK = ExportImportClassedModelUtil.getClassPK(stagedModel);
        try {
            return TrashUtil.isInTrash((String)className, (long)classPK);
        }
        catch (PortalException pe) {
            if (_log.isDebugEnabled()) {
                _log.debug((Object)pe, (Throwable)pe);
            }
            return false;
        }
    }
}

