/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.exportimport.lar;

import com.liferay.exportimport.internal.util.ExportImportPermissionUtil;
import com.liferay.exportimport.kernel.lar.ExportImportPathUtil;
import com.liferay.exportimport.kernel.lar.PortletDataContext;
import com.liferay.exportimport.kernel.staging.MergeLayoutPrototypesThreadLocal;
import com.liferay.exportimport.lar.LayoutCache;
import com.liferay.portal.kernel.exception.NoSuchTeamException;
import com.liferay.portal.kernel.log.Log;
import com.liferay.portal.kernel.log.LogFactoryUtil;
import com.liferay.portal.kernel.model.Group;
import com.liferay.portal.kernel.model.Layout;
import com.liferay.portal.kernel.model.PortletConstants;
import com.liferay.portal.kernel.model.Role;
import com.liferay.portal.kernel.model.Team;
import com.liferay.portal.kernel.service.GroupLocalServiceUtil;
import com.liferay.portal.kernel.service.RoleLocalServiceUtil;
import com.liferay.portal.kernel.service.ServiceContext;
import com.liferay.portal.kernel.service.TeamLocalServiceUtil;
import com.liferay.portal.kernel.service.permission.PortletPermissionUtil;
import com.liferay.portal.kernel.util.GetterUtil;
import com.liferay.portal.kernel.util.KeyValuePair;
import com.liferay.portal.kernel.util.LocalizationUtil;
import com.liferay.portal.kernel.xml.Document;
import com.liferay.portal.kernel.xml.Element;
import com.liferay.portal.kernel.xml.SAXReaderUtil;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;

public class PermissionImporter {
    private static final Log _log = LogFactoryUtil.getLog(PermissionImporter.class);
    private static final PermissionImporter _instance = new PermissionImporter();

    public static PermissionImporter getInstance() {
        return _instance;
    }

    public void checkRoles(LayoutCache layoutCache, long companyId, long groupId, long userId, Element portletElement) throws Exception {
        Element permissionsElement = portletElement.element("permissions");
        if (permissionsElement == null) {
            return;
        }
        List roleElements = permissionsElement.elements("role");
        for (Element roleElement : roleElements) {
            this.checkRole(layoutCache, companyId, groupId, userId, roleElement);
        }
    }

    public void importPortletPermissions(LayoutCache layoutCache, long companyId, long groupId, long userId, Layout layout, Element portletElement, String portletId) throws Exception {
        Element permissionsElement = portletElement.element("permissions");
        if (layout != null && permissionsElement != null) {
            String resourceName = PortletConstants.getRootPortletId((String)portletId);
            String resourcePrimKey = PortletPermissionUtil.getPrimaryKey((long)layout.getPlid(), (String)portletId);
            this.importPermissions(layoutCache, companyId, groupId, userId, layout, resourceName, resourcePrimKey, permissionsElement);
        }
    }

    public void readPortletDataPermissions(PortletDataContext portletDataContext) throws Exception {
        String xml = portletDataContext.getZipEntryAsString(ExportImportPathUtil.getSourceRootPath((PortletDataContext)portletDataContext) + "/portlet-data-permissions.xml");
        if (xml == null) {
            return;
        }
        Document document = SAXReaderUtil.read((String)xml);
        Element rootElement = document.getRootElement();
        List portletDataElements = rootElement.elements("portlet-data");
        for (Element portletDataElement : portletDataElements) {
            String resourceName = portletDataElement.attributeValue("resource-name");
            long resourcePK = GetterUtil.getLong((String)portletDataElement.attributeValue("resource-pk"));
            ArrayList<KeyValuePair> permissions = new ArrayList<KeyValuePair>();
            List permissionsElements = portletDataElement.elements("permissions");
            for (Element permissionsElement : permissionsElements) {
                String roleName = permissionsElement.attributeValue("role-name");
                String actions = permissionsElement.attributeValue("actions");
                KeyValuePair permission = new KeyValuePair(roleName, actions);
                permissions.add(permission);
            }
            portletDataContext.addPermissions(resourceName, resourcePK, permissions);
        }
    }

    protected Role checkRole(LayoutCache layoutCache, long companyId, long groupId, long userId, Element roleElement) throws Exception {
        String name = roleElement.attributeValue("name");
        Role role = null;
        if (ExportImportPermissionUtil.isTeamRoleName(name)) {
            name = name.substring("ROLE_TEAM_,*".length());
            String description = roleElement.attributeValue("description");
            Team team = null;
            try {
                team = TeamLocalServiceUtil.getTeam((long)groupId, (String)name);
            }
            catch (NoSuchTeamException nste) {
                if (_log.isDebugEnabled()) {
                    _log.debug((Object)nste, (Throwable)nste);
                }
                team = TeamLocalServiceUtil.addTeam((long)userId, (long)groupId, (String)name, (String)description, (ServiceContext)new ServiceContext());
            }
            role = RoleLocalServiceUtil.getTeamRole((long)companyId, (long)team.getTeamId());
            return role;
        }
        String uuid = roleElement.attributeValue("uuid");
        role = layoutCache.getUuidRole(companyId, uuid);
        if (role == null) {
            role = layoutCache.getNameRole(companyId, name);
        }
        if (role != null || MergeLayoutPrototypesThreadLocal.isInProgress()) {
            return role;
        }
        String title = roleElement.attributeValue("title");
        Map titleMap = LocalizationUtil.getLocalizationMap((String)title);
        String description = roleElement.attributeValue("description");
        Map descriptionMap = LocalizationUtil.getLocalizationMap((String)description);
        int type = GetterUtil.getInteger((String)roleElement.attributeValue("type"));
        String subtype = roleElement.attributeValue("subtype");
        ServiceContext serviceContext = new ServiceContext();
        serviceContext.setUuid(uuid);
        role = RoleLocalServiceUtil.addRole((long)userId, null, (long)0L, (String)name, (Map)titleMap, (Map)descriptionMap, (int)type, (String)subtype, (ServiceContext)serviceContext);
        return role;
    }

    protected List<String> getActions(Element element) {
        ArrayList<String> actions = new ArrayList<String>();
        List actionKeyElements = element.elements("action-key");
        for (Element actionKeyElement : actionKeyElements) {
            actions.add(actionKeyElement.getText());
        }
        return actions;
    }

    protected void importPermissions(LayoutCache layoutCache, long companyId, long groupId, long userId, Layout layout, String resourceName, String resourcePrimKey, Element permissionsElement) throws Exception {
        Map<Long, Set<String>> existingRoleIdsToActionIds = ExportImportPermissionUtil.getRoleIdsToActionIds(companyId, resourceName, resourcePrimKey);
        HashMap<Long, String[]> importedRoleIdsToActionIds = new HashMap<Long, String[]>();
        List roleElements = permissionsElement.elements("role");
        for (Element roleElement : roleElements) {
            String roleName;
            Group group;
            Role role = this.checkRole(layoutCache, companyId, groupId, userId, roleElement);
            if (role == null || !(group = GroupLocalServiceUtil.getGroup((long)groupId)).isLayoutPrototype() && !group.isLayoutSetPrototype() && layout.isPrivateLayout() && (roleName = role.getName()).equals("Guest")) continue;
            List<String> actions = this.getActions(roleElement);
            importedRoleIdsToActionIds.put(role.getRoleId(), actions.toArray(new String[actions.size()]));
        }
        Map<Long, String[]> roleIdsToActionIds = ExportImportPermissionUtil.mergeImportedPermissionsWithExistingPermissions(existingRoleIdsToActionIds, importedRoleIdsToActionIds);
        ExportImportPermissionUtil.updateResourcePermissions(companyId, groupId, resourceName, resourcePrimKey, roleIdsToActionIds);
    }

    private PermissionImporter() {
    }
}

