/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.exportimport.lar;

import com.liferay.exportimport.content.processor.ExportImportContentProcessor;
import com.liferay.exportimport.content.processor.ExportImportContentProcessorRegistryUtil;
import com.liferay.exportimport.kernel.lar.ExportImportDateUtil;
import com.liferay.exportimport.kernel.lar.ExportImportProcessCallbackRegistryUtil;
import com.liferay.exportimport.kernel.lar.ExportImportThreadLocal;
import com.liferay.exportimport.kernel.lar.PortletDataContext;
import com.liferay.exportimport.kernel.lar.PortletDataException;
import com.liferay.exportimport.staged.model.repository.StagedModelRepository;
import com.liferay.portal.kernel.exception.PortalException;
import com.liferay.portal.kernel.model.StagedGroupedModel;
import com.liferay.portal.kernel.model.StagedModel;
import com.liferay.portal.kernel.service.ServiceContext;
import com.liferay.portal.kernel.service.ServiceContextThreadLocal;
import com.liferay.portal.kernel.util.DateRange;
import com.liferay.portal.kernel.util.MapUtil;
import java.util.Collections;
import java.util.Date;
import java.util.List;
import java.util.Map;
import java.util.concurrent.Callable;

public abstract class BaseStagedModelDataHandler<T extends StagedModel>
extends com.liferay.exportimport.kernel.lar.BaseStagedModelDataHandler<T> {
    public void deleteStagedModel(String uuid, long groupId, String className, String extraData) throws PortalException {
        StagedModelRepository<T> stagedModelRepository = this.getStagedModelRepository();
        if (stagedModelRepository == null) {
            return;
        }
        stagedModelRepository.deleteStagedModel(uuid, groupId, className, extraData);
    }

    public void deleteStagedModel(T stagedModel) throws PortalException {
        StagedModelRepository<T> stagedModelRepository = this.getStagedModelRepository();
        if (stagedModelRepository == null) {
            return;
        }
        stagedModelRepository.deleteStagedModel(stagedModel);
    }

    public void exportStagedModel(PortletDataContext portletDataContext, T stagedModel) throws PortletDataException {
        super.exportStagedModel(portletDataContext, stagedModel);
        boolean updateLastPublishDate = MapUtil.getBoolean((Map)portletDataContext.getParameterMap(), (String)"UPDATE_LAST_PUBLISH_DATE");
        if (ExportImportThreadLocal.isStagingInProcess() && updateLastPublishDate && stagedModel instanceof StagedGroupedModel) {
            ExportImportProcessCallbackRegistryUtil.registerCallback((Callable)new UpdateStagedModelLastPublishDateCallable(this, stagedModel, portletDataContext.getDateRange()));
        }
    }

    public T fetchMissingReference(String uuid, long groupId) {
        StagedModelRepository<T> stagedModelRepository = this.getStagedModelRepository();
        if (stagedModelRepository == null) {
            return (T)super.fetchMissingReference(uuid, groupId);
        }
        return (T)stagedModelRepository.fetchMissingReference(uuid, groupId);
    }

    public T fetchStagedModelByUuidAndGroupId(String uuid, long groupId) {
        StagedModelRepository<T> stagedModelRepository = this.getStagedModelRepository();
        if (stagedModelRepository == null) {
            return (T)super.fetchStagedModelByUuidAndGroupId(uuid, groupId);
        }
        return (T)stagedModelRepository.fetchStagedModelByUuidAndGroupId(uuid, groupId);
    }

    public List<T> fetchStagedModelsByUuidAndCompanyId(String uuid, long companyId) {
        StagedModelRepository<T> stagedModelRepository = this.getStagedModelRepository();
        if (stagedModelRepository == null) {
            return Collections.emptyList();
        }
        return stagedModelRepository.fetchStagedModelsByUuidAndCompanyId(uuid, companyId);
    }

    public void restoreStagedModel(PortletDataContext portletDataContext, T stagedModel) throws PortletDataException {
        StagedModelRepository<T> stagedModelRepository = this.getStagedModelRepository();
        if (stagedModelRepository == null) {
            super.restoreStagedModel(portletDataContext, stagedModel);
            return;
        }
        stagedModelRepository.restoreStagedModel(portletDataContext, stagedModel);
    }

    protected ExportImportContentProcessor getExportImportContentProcessor(Class<T> clazz) {
        ExportImportContentProcessor exportImportContentProcessor = ExportImportContentProcessorRegistryUtil.getExportImportContentProcessor((String)clazz.getName());
        return exportImportContentProcessor;
    }

    protected StagedModelRepository<T> getStagedModelRepository() {
        return null;
    }

    private static class UpdateStagedModelLastPublishDateCallable
    implements Callable<Void> {
        private final long _companyId;
        private final DateRange _dateRange;
        private final long _groupId;
        private final String _uuid;
        final /* synthetic */ BaseStagedModelDataHandler this$0;

        public UpdateStagedModelLastPublishDateCallable(T stagedModel, DateRange dateRange) {
            this.this$0 = var1_1;
            this._companyId = stagedModel.getCompanyId();
            this._dateRange = dateRange;
            this._groupId = ((StagedGroupedModel)stagedModel).getGroupId();
            this._uuid = stagedModel.getUuid();
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public Void call() throws PortalException {
            StagedModelRepository stagedModelRepository = this.this$0.getStagedModelRepository();
            if (stagedModelRepository == null) {
                return null;
            }
            StagedModel stagedModel = stagedModelRepository.fetchStagedModelByUuidAndGroupId(this._uuid, this._groupId);
            if (stagedModel == null) {
                return null;
            }
            Date endDate = null;
            if (this._dateRange != null) {
                endDate = this._dateRange.getEndDate();
            }
            ExportImportDateUtil.updateLastPublishDate((StagedGroupedModel)((StagedGroupedModel)stagedModel), (DateRange)this._dateRange, (Date)endDate);
            ServiceContext serviceContext = new ServiceContext();
            serviceContext.setModifiedDate(stagedModel.getModifiedDate());
            ServiceContextThreadLocal.pushServiceContext((ServiceContext)serviceContext);
            try {
                stagedModelRepository.saveStagedModel(stagedModel);
            }
            finally {
                ServiceContextThreadLocal.popServiceContext();
            }
            return null;
        }
    }
}

