/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.exportimport.controller;

import com.liferay.asset.kernel.model.adapter.StagedAssetLink;
import com.liferay.asset.kernel.service.AssetEntryLocalService;
import com.liferay.asset.kernel.service.AssetLinkLocalService;
import com.liferay.expando.kernel.exception.NoSuchTableException;
import com.liferay.expando.kernel.model.ExpandoColumn;
import com.liferay.expando.kernel.model.ExpandoTable;
import com.liferay.expando.kernel.service.ExpandoColumnLocalService;
import com.liferay.expando.kernel.service.ExpandoTableLocalService;
import com.liferay.expando.kernel.util.ExpandoConverterUtil;
import com.liferay.exportimport.kernel.controller.ExportImportController;
import com.liferay.exportimport.kernel.controller.ImportController;
import com.liferay.exportimport.kernel.exception.LARFileException;
import com.liferay.exportimport.kernel.exception.LARTypeException;
import com.liferay.exportimport.kernel.exception.LayoutImportException;
import com.liferay.exportimport.kernel.exception.MissingReferenceException;
import com.liferay.exportimport.kernel.lar.ExportImportHelperUtil;
import com.liferay.exportimport.kernel.lar.ExportImportPathUtil;
import com.liferay.exportimport.kernel.lar.ExportImportThreadLocal;
import com.liferay.exportimport.kernel.lar.ManifestSummary;
import com.liferay.exportimport.kernel.lar.MissingReferences;
import com.liferay.exportimport.kernel.lar.PortletDataContext;
import com.liferay.exportimport.kernel.lar.PortletDataContextFactoryUtil;
import com.liferay.exportimport.kernel.lar.PortletDataHandler;
import com.liferay.exportimport.kernel.lar.PortletDataHandlerStatusMessageSenderUtil;
import com.liferay.exportimport.kernel.lar.StagedModelDataHandlerUtil;
import com.liferay.exportimport.kernel.lar.UserIdStrategy;
import com.liferay.exportimport.kernel.lifecycle.ExportImportLifecycleManager;
import com.liferay.exportimport.kernel.model.ExportImportConfiguration;
import com.liferay.exportimport.kernel.staging.MergeLayoutPrototypesThreadLocal;
import com.liferay.exportimport.lar.DeletionSystemEventImporter;
import com.liferay.exportimport.lar.LayoutCache;
import com.liferay.exportimport.lar.PermissionImporter;
import com.liferay.exportimport.portlet.data.handler.provider.PortletDataHandlerProvider;
import com.liferay.exportimport.portlet.preferences.processor.Capability;
import com.liferay.exportimport.portlet.preferences.processor.ExportImportPortletPreferencesProcessor;
import com.liferay.exportimport.portlet.preferences.processor.ExportImportPortletPreferencesProcessorRegistryUtil;
import com.liferay.portal.kernel.backgroundtask.BackgroundTaskThreadLocal;
import com.liferay.portal.kernel.exception.LocaleException;
import com.liferay.portal.kernel.exception.NoSuchPortletPreferencesException;
import com.liferay.portal.kernel.exception.PortalException;
import com.liferay.portal.kernel.exception.PortletIdException;
import com.liferay.portal.kernel.exception.SystemException;
import com.liferay.portal.kernel.language.LanguageUtil;
import com.liferay.portal.kernel.lock.Lock;
import com.liferay.portal.kernel.log.Log;
import com.liferay.portal.kernel.log.LogFactoryUtil;
import com.liferay.portal.kernel.model.Group;
import com.liferay.portal.kernel.model.Layout;
import com.liferay.portal.kernel.model.PortletConstants;
import com.liferay.portal.kernel.model.PortletItem;
import com.liferay.portal.kernel.model.PortletPreferences;
import com.liferay.portal.kernel.model.User;
import com.liferay.portal.kernel.portlet.PortletPreferencesFactoryUtil;
import com.liferay.portal.kernel.search.Indexer;
import com.liferay.portal.kernel.search.IndexerRegistryUtil;
import com.liferay.portal.kernel.service.GroupLocalService;
import com.liferay.portal.kernel.service.LayoutLocalService;
import com.liferay.portal.kernel.service.PortletItemLocalService;
import com.liferay.portal.kernel.service.PortletLocalService;
import com.liferay.portal.kernel.service.PortletPreferencesLocalService;
import com.liferay.portal.kernel.service.ServiceContext;
import com.liferay.portal.kernel.service.ServiceContextThreadLocal;
import com.liferay.portal.kernel.service.UserLocalService;
import com.liferay.portal.kernel.service.persistence.PortletPreferencesUtil;
import com.liferay.portal.kernel.util.ArrayUtil;
import com.liferay.portal.kernel.util.GetterUtil;
import com.liferay.portal.kernel.util.ListUtil;
import com.liferay.portal.kernel.util.LocaleUtil;
import com.liferay.portal.kernel.util.MapUtil;
import com.liferay.portal.kernel.util.PortalUtil;
import com.liferay.portal.kernel.util.ReleaseInfo;
import com.liferay.portal.kernel.util.StringBundler;
import com.liferay.portal.kernel.util.StringUtil;
import com.liferay.portal.kernel.util.Validator;
import com.liferay.portal.kernel.xml.Attribute;
import com.liferay.portal.kernel.xml.Document;
import com.liferay.portal.kernel.xml.DocumentException;
import com.liferay.portal.kernel.xml.Element;
import com.liferay.portal.kernel.xml.SAXReaderUtil;
import com.liferay.portal.kernel.zip.ZipReader;
import com.liferay.portal.kernel.zip.ZipReaderFactoryUtil;
import com.liferay.portal.model.impl.PortletPreferencesImpl;
import java.io.File;
import java.io.Serializable;
import java.util.Arrays;
import java.util.Collection;
import java.util.Enumeration;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import org.apache.commons.lang.time.StopWatch;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.Reference;

@Component(immediate=true, property={"model.class.name=com.liferay.portal.kernel.model.Portlet"}, service={ExportImportController.class, PortletImportController.class})
public class PortletImportController
implements ImportController {
    private static final Log _log = LogFactoryUtil.getLog(PortletImportController.class);
    private AssetEntryLocalService _assetEntryLocalService;
    private AssetLinkLocalService _assetLinkLocalService;
    private final DeletionSystemEventImporter _deletionSystemEventImporter = DeletionSystemEventImporter.getInstance();
    private ExpandoColumnLocalService _expandoColumnLocalService;
    private ExpandoTableLocalService _expandoTableLocalService;
    private ExportImportLifecycleManager _exportImportLifecycleManager;
    private GroupLocalService _groupLocalService;
    private LayoutLocalService _layoutLocalService;
    private final PermissionImporter _permissionImporter = PermissionImporter.getInstance();
    @Reference
    private PortletDataHandlerProvider _portletDataHandlerProvider;
    private PortletItemLocalService _portletItemLocalService;
    private PortletPreferencesLocalService _portletPreferencesLocalService;
    private UserLocalService _userLocalService;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void importDataDeletions(ExportImportConfiguration exportImportConfiguration, File file) throws Exception {
        ZipReader zipReader = null;
        try {
            ExportImportThreadLocal.setPortletDataDeletionImportInProcess((boolean)true);
            Map settingsMap = exportImportConfiguration.getSettingsMap();
            Map parameterMap = (Map)settingsMap.get("parameterMap");
            String portletId = MapUtil.getString((Map)settingsMap, (String)"portletId");
            long targetPlid = MapUtil.getLong((Map)settingsMap, (String)"targetPlid");
            long targetGroupId = MapUtil.getLong((Map)settingsMap, (String)"targetGroupId");
            Layout layout = this._layoutLocalService.getLayout(targetPlid);
            zipReader = ZipReaderFactoryUtil.getZipReader((File)file);
            this.validateFile(layout.getCompanyId(), targetGroupId, portletId, zipReader);
            PortletDataContext portletDataContext = this.getPortletDataContext(exportImportConfiguration, file);
            boolean deletePortletData = MapUtil.getBoolean((Map)parameterMap, (String)"DELETE_PORTLET_DATA");
            if (deletePortletData) {
                if (_log.isDebugEnabled()) {
                    _log.debug((Object)"Deleting portlet data");
                }
                this.deletePortletData(portletDataContext);
            }
            this.populateDeletionStagedModelTypes(portletDataContext);
            this._deletionSystemEventImporter.importDeletionSystemEvents(portletDataContext);
        }
        finally {
            ExportImportThreadLocal.setPortletDataDeletionImportInProcess((boolean)false);
            if (zipReader != null) {
                zipReader.close();
            }
        }
    }

    public void importFile(ExportImportConfiguration exportImportConfiguration, File file) throws Exception {
        PortletDataContext portletDataContext = null;
        try {
            ExportImportThreadLocal.setPortletImportInProcess((boolean)true);
            portletDataContext = this.getPortletDataContext(exportImportConfiguration, file);
            this._exportImportLifecycleManager.fireExportImportLifecycleEvent(12, this.getProcessFlag(), new Serializable[]{PortletDataContextFactoryUtil.clonePortletDataContext((PortletDataContext)portletDataContext)});
            Map settingsMap = exportImportConfiguration.getSettingsMap();
            long userId = MapUtil.getLong((Map)settingsMap, (String)"userId");
            this.doImportPortletInfo(portletDataContext, userId);
            ExportImportThreadLocal.setPortletImportInProcess((boolean)false);
            this._exportImportLifecycleManager.fireExportImportLifecycleEvent(11, this.getProcessFlag(), new Serializable[]{PortletDataContextFactoryUtil.clonePortletDataContext((PortletDataContext)portletDataContext), Long.valueOf(userId)});
        }
        catch (Throwable t) {
            ExportImportThreadLocal.setPortletImportInProcess((boolean)false);
            this._exportImportLifecycleManager.fireExportImportLifecycleEvent(10, this.getProcessFlag(), new Serializable[]{PortletDataContextFactoryUtil.clonePortletDataContext((PortletDataContext)portletDataContext), t});
            throw t;
        }
    }

    public String importPortletData(PortletDataContext portletDataContext, PortletPreferences portletPreferences, Element portletDataElement) throws Exception {
        String portletData;
        PortletDataHandler portletDataHandler = this._portletDataHandlerProvider.provide(portletDataContext.getCompanyId(), portletDataContext.getPortletId());
        if (portletDataHandler == null || portletDataHandler.isDataPortletInstanceLevel()) {
            if (_log.isDebugEnabled()) {
                StringBundler sb = new StringBundler(4);
                sb.append("Do not import portlet data for ");
                sb.append(portletDataContext.getPortletId());
                sb.append(" because the portlet does not have a portlet data ");
                sb.append("handler");
                _log.debug((Object)sb.toString());
            }
            return null;
        }
        if (_log.isDebugEnabled()) {
            _log.debug((Object)("Importing data for " + portletDataContext.getPortletId()));
        }
        com.liferay.portlet.PortletPreferencesImpl portletPreferencesImpl = null;
        if (portletPreferences != null) {
            portletPreferencesImpl = (com.liferay.portlet.PortletPreferencesImpl)PortletPreferencesFactoryUtil.fromDefaultXML((String)portletPreferences.getPreferences());
        }
        if (Validator.isNull((String)(portletData = portletDataContext.getZipEntryAsString(portletDataElement.attributeValue("path"))))) {
            return null;
        }
        portletPreferencesImpl = (com.liferay.portlet.PortletPreferencesImpl)portletDataHandler.importData(portletDataContext, portletDataContext.getPortletId(), (javax.portlet.PortletPreferences)portletPreferencesImpl, portletData);
        if (portletPreferencesImpl == null) {
            return null;
        }
        return PortletPreferencesFactoryUtil.toXML((javax.portlet.PortletPreferences)portletPreferencesImpl);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public MissingReferences validateFile(ExportImportConfiguration exportImportConfiguration, File file) throws Exception {
        ZipReader zipReader = null;
        try {
            ExportImportThreadLocal.setPortletValidationInProcess((boolean)true);
            Map settingsMap = exportImportConfiguration.getSettingsMap();
            String portletId = MapUtil.getString((Map)settingsMap, (String)"portletId");
            long targetGroupId = MapUtil.getLong((Map)settingsMap, (String)"targetGroupId");
            long targetPlid = MapUtil.getLong((Map)settingsMap, (String)"targetPlid");
            Layout layout = this._layoutLocalService.getLayout(targetPlid);
            zipReader = ZipReaderFactoryUtil.getZipReader((File)file);
            this.validateFile(layout.getCompanyId(), targetGroupId, portletId, zipReader);
            PortletDataContext portletDataContext = this.getPortletDataContext(exportImportConfiguration, file);
            MissingReferences missingReferences = ExportImportHelperUtil.validateMissingReferences((PortletDataContext)portletDataContext);
            Map dependencyMissingReferences = missingReferences.getDependencyMissingReferences();
            if (!dependencyMissingReferences.isEmpty()) {
                throw new MissingReferenceException(missingReferences);
            }
            MissingReferences missingReferences2 = missingReferences;
            return missingReferences2;
        }
        finally {
            ExportImportThreadLocal.setPortletValidationInProcess((boolean)false);
            if (zipReader != null) {
                zipReader.close();
            }
        }
    }

    protected void deletePortletData(PortletDataContext portletDataContext) throws Exception {
        String xml;
        long ownerId = 0L;
        int ownerType = 3;
        PortletPreferences portletPreferences = PortletPreferencesUtil.fetchByO_O_P_P((long)ownerId, (int)ownerType, (long)portletDataContext.getPlid(), (String)portletDataContext.getPortletId());
        if (portletPreferences == null) {
            portletPreferences = new PortletPreferencesImpl();
        }
        if ((xml = this.deletePortletData(portletDataContext, portletPreferences)) != null) {
            this._portletPreferencesLocalService.updatePreferences(ownerId, ownerType, portletDataContext.getPlid(), portletDataContext.getPortletId(), xml);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected String deletePortletData(PortletDataContext portletDataContext, PortletPreferences portletPreferences) throws Exception {
        Group group = this._groupLocalService.getGroup(portletDataContext.getGroupId());
        if (!group.isStagedPortlet(portletDataContext.getPortletId())) {
            if (_log.isDebugEnabled()) {
                _log.debug((Object)("Do not delete portlet data for " + portletDataContext.getPortletId() + " because the portlet is not staged"));
            }
            return null;
        }
        PortletDataHandler portletDataHandler = this._portletDataHandlerProvider.provide(portletDataContext.getCompanyId(), portletDataContext.getPortletId());
        if (portletDataHandler == null) {
            if (_log.isDebugEnabled()) {
                StringBundler sb = new StringBundler(4);
                sb.append("Do not delete portlet data for ");
                sb.append(portletDataContext.getPortletId());
                sb.append(" because the portlet does not have a ");
                sb.append("PortletDataHandler");
                _log.debug((Object)sb.toString());
            }
            return null;
        }
        if (_log.isDebugEnabled()) {
            _log.debug((Object)("Deleting data for " + portletDataContext.getPortletId()));
        }
        com.liferay.portlet.PortletPreferencesImpl portletPreferencesImpl = (com.liferay.portlet.PortletPreferencesImpl)PortletPreferencesFactoryUtil.fromDefaultXML((String)portletPreferences.getPreferences());
        try {
            portletPreferencesImpl = (com.liferay.portlet.PortletPreferencesImpl)portletDataHandler.deleteData(portletDataContext, portletDataContext.getPortletId(), (javax.portlet.PortletPreferences)portletPreferencesImpl);
        }
        finally {
            portletDataContext.setGroupId(portletDataContext.getScopeGroupId());
        }
        if (portletPreferencesImpl == null) {
            return null;
        }
        return PortletPreferencesFactoryUtil.toXML((javax.portlet.PortletPreferences)portletPreferencesImpl);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void doImportPortletInfo(PortletDataContext portletDataContext, long userId) throws Exception {
        boolean importPortletSetup;
        String layoutsImportMode;
        Map parameterMap = portletDataContext.getParameterMap();
        boolean importPermissions = MapUtil.getBoolean((Map)parameterMap, (String)"PERMISSIONS");
        StopWatch stopWatch = new StopWatch();
        stopWatch.start();
        ServiceContext serviceContext = ServiceContextThreadLocal.getServiceContext();
        if (serviceContext == null) {
            serviceContext = new ServiceContext();
            serviceContext.setCompanyId(portletDataContext.getCompanyId());
            serviceContext.setSignedIn(false);
            serviceContext.setUserId(userId);
            ServiceContextThreadLocal.pushServiceContext((ServiceContext)serviceContext);
        }
        this.validateFile(portletDataContext.getCompanyId(), portletDataContext.getGroupId(), portletDataContext.getPortletId(), portletDataContext.getZipReader());
        Map groupIds = portletDataContext.getNewPrimaryKeysMap(Group.class);
        groupIds.put(portletDataContext.getSourceGroupId(), portletDataContext.getGroupId());
        ManifestSummary manifestSummary = ExportImportHelperUtil.getManifestSummary((PortletDataContext)portletDataContext);
        if (BackgroundTaskThreadLocal.hasBackgroundTask()) {
            PortletDataHandlerStatusMessageSenderUtil.sendStatusMessage((String)"portlet", (String)portletDataContext.getPortletId(), (ManifestSummary)manifestSummary);
        }
        portletDataContext.setManifestSummary(manifestSummary);
        Element rootElement = portletDataContext.getImportDataRootElement();
        Element portletElement = null;
        try {
            portletElement = rootElement.element("portlet");
            Document portletDocument = SAXReaderUtil.read((String)portletDataContext.getZipEntryAsString(portletElement.attributeValue("path")));
            portletElement = portletDocument.getRootElement();
        }
        catch (DocumentException de) {
            throw new SystemException((Throwable)de);
        }
        LayoutCache layoutCache = new LayoutCache();
        if (importPermissions) {
            this._permissionImporter.checkRoles(layoutCache, portletDataContext.getCompanyId(), portletDataContext.getGroupId(), userId, portletElement);
            this._permissionImporter.readPortletDataPermissions(portletDataContext);
        }
        if (!(layoutsImportMode = MapUtil.getString((Map)parameterMap, (String)"LAYOUTS_IMPORT_MODE")).equals("CREATED_FROM_PROTOTYPE")) {
            this.readExpandoTables(portletDataContext);
        }
        this.readLocks(portletDataContext);
        Element portletDataElement = portletElement.element("portlet-data");
        Map importPortletControlsMap = ExportImportHelperUtil.getImportPortletControlsMap((long)portletDataContext.getCompanyId(), (String)portletDataContext.getPortletId(), (Map)parameterMap, (Element)portletDataElement, (ManifestSummary)manifestSummary);
        Layout layout = this._layoutLocalService.getLayout(portletDataContext.getPlid());
        try {
            this.importPortletPreferences(portletDataContext, layout.getCompanyId(), portletDataContext.getGroupId(), layout, portletElement, true, (Boolean)importPortletControlsMap.get("PORTLET_ARCHIVED_SETUPS"), (Boolean)importPortletControlsMap.get("PORTLET_DATA"), (Boolean)importPortletControlsMap.get("PORTLET_SETUP"), (Boolean)importPortletControlsMap.get("PORTLET_USER_PREFERENCES"));
            if (((Boolean)importPortletControlsMap.get("PORTLET_DATA")).booleanValue()) {
                if (_log.isDebugEnabled()) {
                    _log.debug((Object)"Importing portlet data");
                }
                this.importPortletData(portletDataContext, portletDataElement);
            }
        }
        finally {
            this.resetPortletScope(portletDataContext, portletDataContext.getGroupId());
        }
        if (importPermissions) {
            if (_log.isDebugEnabled()) {
                _log.debug((Object)"Importing portlet permissions");
            }
            this._permissionImporter.importPortletPermissions(layoutCache, portletDataContext.getCompanyId(), portletDataContext.getGroupId(), userId, layout, portletElement, portletDataContext.getPortletId());
            if (userId > 0L) {
                Indexer indexer = IndexerRegistryUtil.nullSafeGetIndexer(User.class);
                User user = this._userLocalService.fetchUser(userId);
                indexer.reindex((Object)user);
            }
        }
        if (_log.isDebugEnabled()) {
            _log.debug((Object)"Importing asset links");
        }
        this.importAssetLinks(portletDataContext);
        this._deletionSystemEventImporter.importDeletionSystemEvents(portletDataContext);
        if (_log.isInfoEnabled()) {
            _log.info((Object)("Importing portlet takes " + stopWatch.getTime() + " ms"));
        }
        if (importPortletSetup = ((Boolean)importPortletControlsMap.get("PORTLET_SETUP")).booleanValue()) {
            try {
                List serviceElements = rootElement.elements("service");
                for (Element serviceElement : serviceElements) {
                    Document serviceDocument = SAXReaderUtil.read((String)portletDataContext.getZipEntryAsString(serviceElement.attributeValue("path")));
                    this.importServicePortletPreferences(portletDataContext, serviceDocument.getRootElement());
                }
            }
            catch (DocumentException de) {
                throw new SystemException((Throwable)de);
            }
        }
        ZipReader zipReader = portletDataContext.getZipReader();
        zipReader.close();
    }

    protected PortletDataContext getPortletDataContext(ExportImportConfiguration exportImportConfiguration, File file) throws PortalException {
        Map settingsMap = exportImportConfiguration.getSettingsMap();
        Map parameterMap = (Map)settingsMap.get("parameterMap");
        String portletId = MapUtil.getString((Map)settingsMap, (String)"portletId");
        long targetPlid = MapUtil.getLong((Map)settingsMap, (String)"targetPlid");
        long targetGroupId = MapUtil.getLong((Map)settingsMap, (String)"targetGroupId");
        long userId = MapUtil.getLong((Map)settingsMap, (String)"userId");
        Layout layout = this._layoutLocalService.getLayout(targetPlid);
        String userIdStrategyString = MapUtil.getString((Map)parameterMap, (String)"USER_ID_STRATEGY");
        UserIdStrategy userIdStrategy = ExportImportHelperUtil.getUserIdStrategy((long)userId, (String)userIdStrategyString);
        ZipReader zipReader = ZipReaderFactoryUtil.getZipReader((File)file);
        PortletDataContext portletDataContext = PortletDataContextFactoryUtil.createImportPortletDataContext((long)layout.getCompanyId(), (long)targetGroupId, (Map)parameterMap, (UserIdStrategy)userIdStrategy, (ZipReader)zipReader);
        portletDataContext.setOldPlid(targetPlid);
        portletDataContext.setPlid(targetPlid);
        portletDataContext.setPortletId(portletId);
        portletDataContext.setPrivateLayout(layout.isPrivateLayout());
        return portletDataContext;
    }

    protected PortletPreferences getPortletPreferences(long companyId, long ownerId, int ownerType, long plid, String serviceName) throws PortalException {
        PortletPreferences portletPreferences = null;
        try {
            portletPreferences = ownerType == 5 || ownerType == 1 || ownerType == 2 ? this._portletPreferencesLocalService.getPortletPreferences(ownerId, ownerType, 0L, serviceName) : this._portletPreferencesLocalService.getPortletPreferences(ownerId, ownerType, plid, serviceName);
        }
        catch (NoSuchPortletPreferencesException nsppe) {
            if (_log.isDebugEnabled()) {
                _log.debug((Object)nsppe, (Throwable)nsppe);
            }
            portletPreferences = this._portletPreferencesLocalService.addPortletPreferences(companyId, ownerId, ownerType, plid, serviceName, null, null);
        }
        return portletPreferences;
    }

    protected int getProcessFlag() {
        if (ExportImportThreadLocal.isPortletStagingInProcess()) {
            return 36;
        }
        return 35;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void importAssetLinks(PortletDataContext portletDataContext) throws Exception {
        String xml = portletDataContext.getZipEntryAsString(ExportImportPathUtil.getSourceRootPath((PortletDataContext)portletDataContext) + "/links.xml");
        if (xml == null) {
            return;
        }
        Element importDataRootElement = portletDataContext.getImportDataRootElement();
        try {
            Document document = SAXReaderUtil.read((String)xml);
            Element rootElement = document.getRootElement();
            portletDataContext.setImportDataRootElement(rootElement);
            Element linksElement = portletDataContext.getImportDataGroupElement(StagedAssetLink.class);
            List linkElements = linksElement.elements();
            for (Element linkElement : linkElements) {
                StagedModelDataHandlerUtil.importStagedModel((PortletDataContext)portletDataContext, (Element)linkElement);
            }
        }
        finally {
            portletDataContext.setImportDataRootElement(importDataRootElement);
        }
    }

    protected void importPortletData(PortletDataContext portletDataContext, Element portletDataElement) throws Exception {
        String xml;
        long ownerId = 0L;
        int ownerType = 3;
        PortletPreferences portletPreferences = PortletPreferencesUtil.fetchByO_O_P_P((long)ownerId, (int)ownerType, (long)portletDataContext.getPlid(), (String)portletDataContext.getPortletId());
        if (portletPreferences == null) {
            portletPreferences = new PortletPreferencesImpl();
        }
        if (Validator.isNotNull((String)(xml = this.importPortletData(portletDataContext, portletPreferences, portletDataElement)))) {
            this._portletPreferencesLocalService.updatePreferences(ownerId, ownerType, portletDataContext.getPlid(), portletDataContext.getPortletId(), xml);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void importPortletPreferences(PortletDataContext portletDataContext, long companyId, long groupId, Layout layout, Element parentElement, boolean preserveScopeLayoutId, boolean importPortletArchivedSetups, boolean importPortletData, boolean importPortletSetup, boolean importPortletUserPreferences) throws Exception {
        long plid = 0L;
        String scopeType = "";
        String scopeLayoutUuid = "";
        if (layout != null) {
            plid = layout.getPlid();
            if (preserveScopeLayoutId) {
                javax.portlet.PortletPreferences jxPortletPreferences = PortletPreferencesFactoryUtil.getLayoutPortletSetup((Layout)layout, (String)portletDataContext.getPortletId());
                scopeType = GetterUtil.getString((String)jxPortletPreferences.getValue("lfrScopeType", null));
                scopeLayoutUuid = GetterUtil.getString((String)jxPortletPreferences.getValue("lfrScopeLayoutUuid", null));
                portletDataContext.setScopeType(scopeType);
                portletDataContext.setScopeLayoutUuid(scopeLayoutUuid);
            }
        }
        List portletPreferencesElements = parentElement.elements("portlet-preferences");
        for (Element portletPreferencesElement : portletPreferencesElements) {
            boolean defaultUser;
            String userUuid;
            String path = portletPreferencesElement.attributeValue("path");
            if (!portletDataContext.isPathNotProcessed(path)) continue;
            String xml = null;
            Element element = null;
            try {
                xml = portletDataContext.getZipEntryAsString(path);
                Document preferencesDocument = SAXReaderUtil.read((String)xml);
                element = preferencesDocument.getRootElement();
            }
            catch (DocumentException de) {
                throw new SystemException((Throwable)de);
            }
            long ownerId = GetterUtil.getLong((String)element.attributeValue("owner-id"));
            int ownerType = GetterUtil.getInteger((String)element.attributeValue("owner-type"));
            if (ownerType == 1 || !importPortletSetup || ownerType == 5 && !importPortletArchivedSetups || ownerType == 4 && ownerId != 0L && !importPortletUserPreferences) continue;
            long curPlid = plid;
            String curPortletId = portletDataContext.getPortletId();
            if (ownerType == 2) {
                curPlid = 0L;
                curPortletId = portletDataContext.getRootPortletId();
                ownerId = portletDataContext.getScopeGroupId();
            }
            if (ownerType == 5) {
                userUuid = element.attributeValue("archive-user-uuid");
                long userId = portletDataContext.getUserId(userUuid);
                String name = element.attributeValue("archive-name");
                curPortletId = portletDataContext.getRootPortletId();
                PortletItem portletItem = this._portletItemLocalService.updatePortletItem(userId, groupId, name, curPortletId, PortletPreferences.class.getName());
                curPlid = 0L;
                ownerId = portletItem.getPortletItemId();
            }
            if (ownerType == 4) {
                userUuid = element.attributeValue("user-uuid");
                ownerId = portletDataContext.getUserId(userUuid);
            }
            if (defaultUser = GetterUtil.getBoolean((String)element.attributeValue("default-user"))) {
                ownerId = this._userLocalService.getDefaultUserId(companyId);
            }
            javax.portlet.PortletPreferences jxPortletPreferences = PortletPreferencesFactoryUtil.fromXML((long)companyId, (long)ownerId, (int)ownerType, (long)curPlid, (String)curPortletId, (String)xml);
            Element importDataRootElement = portletDataContext.getImportDataRootElement();
            try {
                ExportImportPortletPreferencesProcessor exportImportPortletPreferencesProcessor;
                Element preferenceDataElement = portletPreferencesElement.element("preference-data");
                if (preferenceDataElement != null) {
                    portletDataContext.setImportDataRootElement(preferenceDataElement);
                }
                if ((exportImportPortletPreferencesProcessor = ExportImportPortletPreferencesProcessorRegistryUtil.getExportImportPortletPreferencesProcessor((String)PortletConstants.getRootPortletId((String)curPortletId))) != null) {
                    List importCapabilities = exportImportPortletPreferencesProcessor.getImportCapabilities();
                    if (ListUtil.isNotEmpty((List)importCapabilities)) {
                        for (Capability importCapability : importCapabilities) {
                            importCapability.process(portletDataContext, jxPortletPreferences);
                        }
                    }
                    exportImportPortletPreferencesProcessor.processImportPortletPreferences(portletDataContext, jxPortletPreferences);
                } else {
                    PortletDataHandler portletDataHandler = this._portletDataHandlerProvider.provide(portletDataContext.getCompanyId(), curPortletId);
                    if (portletDataHandler != null) {
                        jxPortletPreferences = portletDataHandler.processImportPortletPreferences(portletDataContext, curPortletId, jxPortletPreferences);
                    }
                }
            }
            finally {
                portletDataContext.setImportDataRootElement(importDataRootElement);
            }
            this.updatePortletPreferences(portletDataContext, ownerId, ownerType, curPlid, curPortletId, PortletPreferencesFactoryUtil.toXML((javax.portlet.PortletPreferences)jxPortletPreferences), importPortletData);
        }
        if (preserveScopeLayoutId && layout != null) {
            javax.portlet.PortletPreferences jxPortletPreferences = PortletPreferencesFactoryUtil.getLayoutPortletSetup((Layout)layout, (String)portletDataContext.getPortletId());
            try {
                jxPortletPreferences.setValue("lfrScopeType", scopeType);
                jxPortletPreferences.setValue("lfrScopeLayoutUuid", scopeLayoutUuid);
                jxPortletPreferences.store();
            }
            finally {
                portletDataContext.setScopeType(scopeType);
                portletDataContext.setScopeLayoutUuid(scopeLayoutUuid);
            }
        }
    }

    protected void importServicePortletPreferences(PortletDataContext portletDataContext, Element serviceElement) throws PortalException {
        long ownerId = GetterUtil.getLong((String)serviceElement.attributeValue("owner-id"));
        int ownerType = GetterUtil.getInteger((String)serviceElement.attributeValue("owner-type"));
        String serviceName = serviceElement.attributeValue("service-name");
        PortletPreferences portletPreferences = this.getPortletPreferences(portletDataContext.getCompanyId(), ownerId, ownerType, 0L, serviceName);
        for (Attribute attribute : serviceElement.attributes()) {
            serviceElement.remove(attribute);
        }
        String xml = serviceElement.asXML();
        portletPreferences.setPreferences(xml);
        this._portletPreferencesLocalService.updatePortletPreferences(portletPreferences);
    }

    protected void populateDeletionStagedModelTypes(PortletDataContext portletDataContext) throws Exception {
        PortletDataHandler portletDataHandler = this._portletDataHandlerProvider.provide(portletDataContext.getCompanyId(), portletDataContext.getPortletId());
        if (portletDataHandler == null) {
            return;
        }
        portletDataContext.addDeletionSystemEventStagedModelTypes(portletDataHandler.getDeletionSystemEventStagedModelTypes());
    }

    protected void readExpandoTables(PortletDataContext portletDataContext) throws Exception {
        String xml = portletDataContext.getZipEntryAsString(ExportImportPathUtil.getSourceRootPath((PortletDataContext)portletDataContext) + "/expando-tables.xml");
        if (xml == null) {
            return;
        }
        Document document = SAXReaderUtil.read((String)xml);
        Element rootElement = document.getRootElement();
        List expandoTableElements = rootElement.elements("expando-table");
        for (Element expandoTableElement : expandoTableElements) {
            String className = expandoTableElement.attributeValue("class-name");
            ExpandoTable expandoTable = null;
            try {
                expandoTable = this._expandoTableLocalService.getDefaultTable(portletDataContext.getCompanyId(), className);
            }
            catch (NoSuchTableException nste) {
                if (_log.isDebugEnabled()) {
                    _log.debug((Object)nste, (Throwable)nste);
                }
                expandoTable = this._expandoTableLocalService.addDefaultTable(portletDataContext.getCompanyId(), className);
            }
            List expandoColumnElements = expandoTableElement.elements("expando-column");
            for (Element expandoColumnElement : expandoColumnElements) {
                long columnId = GetterUtil.getLong((String)expandoColumnElement.attributeValue("column-id"));
                String name = expandoColumnElement.attributeValue("name");
                int type = GetterUtil.getInteger((String)expandoColumnElement.attributeValue("type"));
                String defaultData = expandoColumnElement.elementText("default-data");
                String typeSettings = expandoColumnElement.elementText("type-settings");
                Serializable defaultDataObject = ExpandoConverterUtil.getAttributeFromString((int)type, (String)defaultData);
                ExpandoColumn expandoColumn = this._expandoColumnLocalService.getColumn(expandoTable.getTableId(), name);
                if (expandoColumn != null) {
                    this._expandoColumnLocalService.updateColumn(expandoColumn.getColumnId(), name, type, (Object)defaultDataObject);
                } else {
                    expandoColumn = this._expandoColumnLocalService.addColumn(expandoTable.getTableId(), name, type, (Object)defaultDataObject);
                }
                this._expandoColumnLocalService.updateTypeSettings(expandoColumn.getColumnId(), typeSettings);
                portletDataContext.importPermissions(ExpandoColumn.class, columnId, expandoColumn.getColumnId());
            }
        }
    }

    protected void readLocks(PortletDataContext portletDataContext) throws Exception {
        String xml = portletDataContext.getZipEntryAsString(ExportImportPathUtil.getSourceRootPath((PortletDataContext)portletDataContext) + "/locks.xml");
        if (xml == null) {
            return;
        }
        Document document = SAXReaderUtil.read((String)xml);
        Element rootElement = document.getRootElement();
        List assetElements = rootElement.elements("asset");
        for (Element assetElement : assetElements) {
            String path = assetElement.attributeValue("path");
            String className = assetElement.attributeValue("class-name");
            String key = assetElement.attributeValue("key");
            Lock lock = (Lock)portletDataContext.getZipEntryAsObject(path);
            if (lock == null) continue;
            portletDataContext.addLocks(className, key, lock);
        }
    }

    protected void resetPortletScope(PortletDataContext portletDataContext, long groupId) {
        portletDataContext.setScopeGroupId(groupId);
        portletDataContext.setScopeLayoutUuid("");
        portletDataContext.setScopeType("");
    }

    @Reference(unbind="-")
    protected void setAssetEntryLocalService(AssetEntryLocalService assetEntryLocalService) {
        this._assetEntryLocalService = assetEntryLocalService;
    }

    @Reference(unbind="-")
    protected void setAssetLinkLocalService(AssetLinkLocalService assetLinkLocalService) {
        this._assetLinkLocalService = assetLinkLocalService;
    }

    @Reference(unbind="-")
    protected void setExpandoColumnLocalService(ExpandoColumnLocalService expandoColumnLocalService) {
        this._expandoColumnLocalService = expandoColumnLocalService;
    }

    @Reference(unbind="-")
    protected void setExpandoTableLocalService(ExpandoTableLocalService expandoTableLocalService) {
        this._expandoTableLocalService = expandoTableLocalService;
    }

    @Reference(unbind="-")
    protected void setExportImportLifecycleManager(ExportImportLifecycleManager exportImportLifecycleManager) {
        this._exportImportLifecycleManager = exportImportLifecycleManager;
    }

    @Reference(unbind="-")
    protected void setGroupLocalService(GroupLocalService groupLocalService) {
        this._groupLocalService = groupLocalService;
    }

    @Reference(unbind="-")
    protected void setLayoutLocalService(LayoutLocalService layoutLocalService) {
        this._layoutLocalService = layoutLocalService;
    }

    @Reference(unbind="-")
    protected void setPortletItemLocalService(PortletItemLocalService portletItemLocalService) {
        this._portletItemLocalService = portletItemLocalService;
    }

    @Deprecated
    @Reference(unbind="-")
    protected void setPortletLocalService(PortletLocalService portletLocalService) {
    }

    @Reference(unbind="-")
    protected void setPortletPreferencesLocalService(PortletPreferencesLocalService portletPreferencesLocalService) {
        this._portletPreferencesLocalService = portletPreferencesLocalService;
    }

    @Reference(unbind="-")
    protected void setUserLocalService(UserLocalService userLocalService) {
        this._userLocalService = userLocalService;
    }

    protected void updatePortletPreferences(PortletDataContext portletDataContext, long ownerId, int ownerType, long plid, String portletId, String xml, boolean importData) throws Exception {
        PortletDataHandler portletDataHandler = this._portletDataHandlerProvider.provide(portletDataContext.getCompanyId(), portletId);
        if (importData || !MergeLayoutPrototypesThreadLocal.isInProgress()) {
            this._portletPreferencesLocalService.updatePreferences(ownerId, ownerType, plid, portletId, xml);
            return;
        }
        Object[] dataPortletPreferences = portletDataHandler.getDataPortletPreferences();
        javax.portlet.PortletPreferences portletPreferences = this._portletPreferencesLocalService.getPreferences(portletDataContext.getCompanyId(), ownerId, ownerType, plid, portletId);
        javax.portlet.PortletPreferences jxPortletPreferences = PortletPreferencesFactoryUtil.fromXML((long)portletDataContext.getCompanyId(), (long)ownerId, (int)ownerType, (long)plid, (String)portletId, (String)xml);
        Enumeration enu = jxPortletPreferences.getNames();
        while (enu.hasMoreElements()) {
            String name = (String)enu.nextElement();
            String scopeLayoutUuid = portletDataContext.getScopeLayoutUuid();
            String scopeType = portletDataContext.getScopeType();
            if (ArrayUtil.contains((Object[])dataPortletPreferences, (Object)name) && (!Validator.isNull((String)scopeLayoutUuid) || !scopeType.equals("company"))) continue;
            String[] values = jxPortletPreferences.getValues(name, null);
            portletPreferences.setValues(name, values);
        }
        this._portletPreferencesLocalService.updatePreferences(ownerId, ownerType, plid, portletId, portletPreferences);
    }

    protected void validateFile(long companyId, long groupId, String portletId, ZipReader zipReader) throws Exception {
        String xml = zipReader.getEntryAsString("/manifest.xml");
        if (xml == null) {
            throw new LARFileException("manifest.xml not found in the LAR");
        }
        Element rootElement = null;
        try {
            Document document = SAXReaderUtil.read((String)xml);
            rootElement = document.getRootElement();
        }
        catch (Exception e) {
            throw new LARFileException((Throwable)e);
        }
        int buildNumber = ReleaseInfo.getBuildNumber();
        Element headerElement = rootElement.element("header");
        int importBuildNumber = GetterUtil.getInteger((String)headerElement.attributeValue("build-number"));
        if (buildNumber != importBuildNumber) {
            throw new LayoutImportException("LAR build number " + importBuildNumber + " does not match portal build number " + buildNumber);
        }
        String larType = headerElement.attributeValue("type");
        if (!larType.equals("portlet")) {
            throw new LARTypeException(larType);
        }
        String rootPortletId = headerElement.attributeValue("root-portlet-id");
        if (!PortletConstants.getRootPortletId((String)portletId).equals(rootPortletId)) {
            throw new PortletIdException("Invalid portlet id " + rootPortletId);
        }
        PortletDataHandler portletDataHandler = this._portletDataHandlerProvider.provide(companyId, portletId);
        if (portletDataHandler.isDataLocalized()) {
            List<Locale> sourceAvailableLocales = Arrays.asList(LocaleUtil.fromLanguageIds((String[])StringUtil.split((String)headerElement.attributeValue("available-locales"))));
            for (Locale sourceAvailableLocale : sourceAvailableLocales) {
                if (LanguageUtil.isAvailableLocale((long)PortalUtil.getSiteGroupId((long)groupId), (Locale)sourceAvailableLocale)) continue;
                LocaleException le = new LocaleException(2, "Locale " + sourceAvailableLocale + " is not available in company " + companyId);
                le.setSourceAvailableLocales(sourceAvailableLocales);
                le.setTargetAvailableLocales((Collection)LanguageUtil.getAvailableLocales((long)PortalUtil.getSiteGroupId((long)groupId)));
                throw le;
            }
        }
    }
}

