/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.exportimport.controller;

import com.liferay.asset.kernel.model.AssetLink;
import com.liferay.asset.kernel.model.adapter.StagedAssetLink;
import com.liferay.asset.kernel.service.AssetEntryLocalService;
import com.liferay.asset.kernel.service.AssetLinkLocalService;
import com.liferay.expando.kernel.model.ExpandoColumn;
import com.liferay.exportimport.kernel.controller.ExportController;
import com.liferay.exportimport.kernel.controller.ExportImportController;
import com.liferay.exportimport.kernel.exception.LayoutImportException;
import com.liferay.exportimport.kernel.lar.ExportImportDateUtil;
import com.liferay.exportimport.kernel.lar.ExportImportHelperUtil;
import com.liferay.exportimport.kernel.lar.ExportImportPathUtil;
import com.liferay.exportimport.kernel.lar.ExportImportProcessCallbackRegistryUtil;
import com.liferay.exportimport.kernel.lar.ExportImportThreadLocal;
import com.liferay.exportimport.kernel.lar.ManifestSummary;
import com.liferay.exportimport.kernel.lar.PortletDataContext;
import com.liferay.exportimport.kernel.lar.PortletDataContextFactoryUtil;
import com.liferay.exportimport.kernel.lar.PortletDataException;
import com.liferay.exportimport.kernel.lar.PortletDataHandler;
import com.liferay.exportimport.kernel.lar.PortletDataHandlerStatusMessageSenderUtil;
import com.liferay.exportimport.kernel.lifecycle.ExportImportLifecycleManager;
import com.liferay.exportimport.kernel.model.ExportImportConfiguration;
import com.liferay.exportimport.lar.DeletionSystemEventExporter;
import com.liferay.exportimport.lar.PermissionExporter;
import com.liferay.exportimport.portlet.data.handler.provider.PortletDataHandlerProvider;
import com.liferay.exportimport.portlet.preferences.processor.Capability;
import com.liferay.exportimport.portlet.preferences.processor.ExportImportPortletPreferencesProcessor;
import com.liferay.exportimport.portlet.preferences.processor.ExportImportPortletPreferencesProcessorRegistryUtil;
import com.liferay.petra.xml.DocUtil;
import com.liferay.portal.kernel.backgroundtask.BackgroundTaskThreadLocal;
import com.liferay.portal.kernel.dao.orm.ExportActionableDynamicQuery;
import com.liferay.portal.kernel.exception.NoSuchPortletPreferencesException;
import com.liferay.portal.kernel.exception.PortalException;
import com.liferay.portal.kernel.exception.SystemException;
import com.liferay.portal.kernel.language.LanguageUtil;
import com.liferay.portal.kernel.lock.Lock;
import com.liferay.portal.kernel.log.Log;
import com.liferay.portal.kernel.log.LogFactoryUtil;
import com.liferay.portal.kernel.model.ClassedModel;
import com.liferay.portal.kernel.model.Group;
import com.liferay.portal.kernel.model.Layout;
import com.liferay.portal.kernel.model.LayoutTypePortlet;
import com.liferay.portal.kernel.model.Portlet;
import com.liferay.portal.kernel.model.PortletItem;
import com.liferay.portal.kernel.model.PortletPreferences;
import com.liferay.portal.kernel.model.StagedModel;
import com.liferay.portal.kernel.model.User;
import com.liferay.portal.kernel.model.adapter.ModelAdapterUtil;
import com.liferay.portal.kernel.portlet.PortletPreferencesFactoryUtil;
import com.liferay.portal.kernel.service.GroupLocalService;
import com.liferay.portal.kernel.service.LayoutLocalService;
import com.liferay.portal.kernel.service.PortletItemLocalService;
import com.liferay.portal.kernel.service.PortletLocalService;
import com.liferay.portal.kernel.service.PortletPreferencesLocalService;
import com.liferay.portal.kernel.service.ServiceContext;
import com.liferay.portal.kernel.service.ServiceContextThreadLocal;
import com.liferay.portal.kernel.service.UserLocalService;
import com.liferay.portal.kernel.util.DateRange;
import com.liferay.portal.kernel.util.GetterUtil;
import com.liferay.portal.kernel.util.ListUtil;
import com.liferay.portal.kernel.util.MapUtil;
import com.liferay.portal.kernel.util.PortalUtil;
import com.liferay.portal.kernel.util.ReleaseInfo;
import com.liferay.portal.kernel.util.StringBundler;
import com.liferay.portal.kernel.util.StringUtil;
import com.liferay.portal.kernel.util.Time;
import com.liferay.portal.kernel.util.UnicodeProperties;
import com.liferay.portal.kernel.util.Validator;
import com.liferay.portal.kernel.xml.Document;
import com.liferay.portal.kernel.xml.Element;
import com.liferay.portal.kernel.xml.Node;
import com.liferay.portal.kernel.xml.SAXReaderUtil;
import com.liferay.portal.kernel.zip.ZipWriter;
import java.io.File;
import java.io.IOException;
import java.io.Serializable;
import java.util.Collection;
import java.util.Date;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.concurrent.Callable;
import org.apache.commons.lang.time.StopWatch;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.Reference;

@Component(immediate=true, property={"model.class.name=com.liferay.portal.kernel.model.Portlet"}, service={ExportImportController.class, PortletExportController.class})
public class PortletExportController
implements ExportController {
    private static final Log _log = LogFactoryUtil.getLog(PortletExportController.class);
    private AssetEntryLocalService _assetEntryLocalService;
    private AssetLinkLocalService _assetLinkLocalService;
    private final DeletionSystemEventExporter _deletionSystemEventExporter = DeletionSystemEventExporter.getInstance();
    private ExportImportLifecycleManager _exportImportLifecycleManager;
    private GroupLocalService _groupLocalService;
    private LayoutLocalService _layoutLocalService;
    private final PermissionExporter _permissionExporter = PermissionExporter.getInstance();
    @Reference
    private PortletDataHandlerProvider _portletDataHandlerProvider;
    private PortletItemLocalService _portletItemLocalService;
    private PortletLocalService _portletLocalService;
    private PortletPreferencesLocalService _portletPreferencesLocalService;
    private UserLocalService _userLocalService;

    public File export(ExportImportConfiguration exportImportConfiguration) throws Exception {
        PortletDataContext portletDataContext = null;
        try {
            ExportImportThreadLocal.setPortletExportInProcess((boolean)true);
            portletDataContext = this.getPortletDataContext(exportImportConfiguration);
            this._exportImportLifecycleManager.fireExportImportLifecycleEvent(9, this.getProcessFlag(), new Serializable[]{PortletDataContextFactoryUtil.clonePortletDataContext((PortletDataContext)portletDataContext)});
            File file = this.doExport(portletDataContext);
            ExportImportThreadLocal.setPortletExportInProcess((boolean)false);
            this._exportImportLifecycleManager.fireExportImportLifecycleEvent(8, this.getProcessFlag(), new Serializable[]{PortletDataContextFactoryUtil.clonePortletDataContext((PortletDataContext)portletDataContext)});
            return file;
        }
        catch (Throwable t) {
            ExportImportThreadLocal.setPortletExportInProcess((boolean)false);
            this._exportImportLifecycleManager.fireExportImportLifecycleEvent(7, this.getProcessFlag(), new Serializable[]{PortletDataContextFactoryUtil.clonePortletDataContext((PortletDataContext)portletDataContext), t});
            throw t;
        }
    }

    public void exportPortletData(PortletDataContext portletDataContext, Portlet portlet, Layout layout, javax.portlet.PortletPreferences jxPortletPreferences, Element parentElement) throws Exception {
        if (portlet == null) {
            return;
        }
        PortletDataHandler portletDataHandler = portlet.getPortletDataHandlerInstance();
        if (portletDataHandler == null || portletDataHandler.isDataPortletInstanceLevel()) {
            return;
        }
        Group group = layout.getGroup();
        if (group.isStagingGroup()) {
            group = group.getLiveGroup();
        }
        String portletId = portlet.getPortletId();
        if (ExportImportThreadLocal.isStagingInProcess() && !group.isStagedPortlet(portletId)) {
            if (_log.isDebugEnabled()) {
                _log.debug((Object)("Not exporting data for " + portletId + " because it is configured not to be staged"));
            }
            return;
        }
        if (_log.isDebugEnabled()) {
            _log.debug((Object)("Exporting data for " + portletId));
        }
        StringBundler sb = new StringBundler(4);
        sb.append(ExportImportPathUtil.getPortletPath((PortletDataContext)portletDataContext, (String)portletId));
        sb.append("/");
        if (portlet.isPreferencesUniquePerLayout()) {
            sb.append(layout.getPlid());
        } else {
            sb.append(portletDataContext.getScopeGroupId());
        }
        sb.append("/portlet-data.xml");
        String path = sb.toString();
        if (portletDataContext.hasPrimaryKey(String.class, path)) {
            return;
        }
        Date originalStartDate = portletDataContext.getStartDate();
        Date portletLastPublishDate = ExportImportDateUtil.getLastPublishDate((PortletDataContext)portletDataContext, (javax.portlet.PortletPreferences)jxPortletPreferences);
        portletDataContext.setStartDate(portletLastPublishDate);
        long groupId = portletDataContext.getGroupId();
        portletDataContext.setGroupId(portletDataContext.getScopeGroupId());
        portletDataContext.clearScopedPrimaryKeys();
        String data = null;
        try {
            data = portletDataHandler.exportData(portletDataContext, portletId, jxPortletPreferences);
        }
        catch (PortletDataException pde) {
            throw pde;
        }
        catch (Exception e) {
            throw new SystemException((Throwable)e);
        }
        finally {
            portletDataContext.setGroupId(groupId);
            portletDataContext.setStartDate(originalStartDate);
        }
        if (Validator.isNull((String)data)) {
            if (_log.isDebugEnabled()) {
                _log.debug((Object)("Not exporting data for " + portletId + " because null data was returned"));
            }
            return;
        }
        Element portletDataElement = parentElement.addElement("portlet-data");
        portletDataElement.addAttribute("path", path);
        portletDataContext.addZipEntry(path, data);
        boolean updateLastPublishDate = MapUtil.getBoolean((Map)portletDataContext.getParameterMap(), (String)"UPDATE_LAST_PUBLISH_DATE");
        if (ExportImportThreadLocal.isStagingInProcess() && updateLastPublishDate) {
            DateRange adjustedDateRange = new DateRange(portletLastPublishDate, portletDataContext.getEndDate());
            ExportImportProcessCallbackRegistryUtil.registerCallback((Callable)new UpdatePortletLastPublishDateCallable(adjustedDateRange, portletDataContext.getEndDate(), portletDataContext.getGroupId(), layout.getPlid(), portletId));
        }
    }

    protected File doExport(PortletDataContext portletDataContext) throws Exception {
        boolean exportPermissions = MapUtil.getBoolean((Map)portletDataContext.getParameterMap(), (String)"PERMISSIONS");
        if (_log.isDebugEnabled()) {
            _log.debug((Object)("Export permissions " + exportPermissions));
        }
        StopWatch stopWatch = new StopWatch();
        stopWatch.start();
        Layout layout = this._layoutLocalService.getLayout(portletDataContext.getPlid());
        if (!(layout.isTypeControlPanel() || layout.isTypePanel() || layout.isTypePortlet())) {
            throw new LayoutImportException("Layout type " + layout.getType() + " is not valid");
        }
        ServiceContext serviceContext = ServiceContextThreadLocal.getServiceContext();
        if (serviceContext == null) {
            serviceContext = new ServiceContext();
            serviceContext.setCompanyId(layout.getCompanyId());
            serviceContext.setSignedIn(false);
            long defaultUserId = this._userLocalService.getDefaultUserId(layout.getCompanyId());
            serviceContext.setUserId(defaultUserId);
            ServiceContextThreadLocal.pushServiceContext((ServiceContext)serviceContext);
        }
        long layoutSetBranchId = MapUtil.getLong((Map)portletDataContext.getParameterMap(), (String)"layoutSetBranchId");
        serviceContext.setAttribute("layoutSetBranchId", (Serializable)Long.valueOf(layoutSetBranchId));
        long scopeGroupId = portletDataContext.getGroupId();
        javax.portlet.PortletPreferences jxPortletPreferences = PortletPreferencesFactoryUtil.getLayoutPortletSetup((Layout)layout, (String)portletDataContext.getPortletId());
        String scopeType = GetterUtil.getString((String)jxPortletPreferences.getValue("lfrScopeType", null));
        String scopeLayoutUuid = GetterUtil.getString((String)jxPortletPreferences.getValue("lfrScopeLayoutUuid", null));
        if (Validator.isNotNull((String)scopeType)) {
            Group scopeGroup = null;
            if (scopeType.equals("company")) {
                scopeGroup = this._groupLocalService.getCompanyGroup(layout.getCompanyId());
            } else if (Validator.isNotNull((String)scopeLayoutUuid)) {
                scopeGroup = layout.getScopeGroup();
            }
            if (scopeGroup != null) {
                scopeGroupId = scopeGroup.getGroupId();
            }
        }
        portletDataContext.setScopeType(scopeType);
        portletDataContext.setScopeLayoutUuid(scopeLayoutUuid);
        Document document = SAXReaderUtil.createDocument();
        Element rootElement = document.addElement("root");
        portletDataContext.setExportDataRootElement(rootElement);
        Element headerElement = rootElement.addElement("header");
        headerElement.addAttribute("available-locales", StringUtil.merge((Collection)LanguageUtil.getAvailableLocales((long)PortalUtil.getSiteGroupId((long)portletDataContext.getScopeGroupId()))));
        headerElement.addAttribute("build-number", String.valueOf(ReleaseInfo.getBuildNumber()));
        headerElement.addAttribute("export-date", Time.getRFC822());
        if (portletDataContext.hasDateRange()) {
            headerElement.addAttribute("start-date", String.valueOf(portletDataContext.getStartDate()));
            headerElement.addAttribute("end-date", String.valueOf(portletDataContext.getEndDate()));
        }
        headerElement.addAttribute("type", "portlet");
        headerElement.addAttribute("company-id", String.valueOf(portletDataContext.getCompanyId()));
        headerElement.addAttribute("company-group-id", String.valueOf(portletDataContext.getCompanyGroupId()));
        headerElement.addAttribute("group-id", String.valueOf(scopeGroupId));
        headerElement.addAttribute("user-personal-site-group-id", String.valueOf(portletDataContext.getUserPersonalSiteGroupId()));
        headerElement.addAttribute("private-layout", String.valueOf(layout.isPrivateLayout()));
        headerElement.addAttribute("root-portlet-id", portletDataContext.getRootPortletId());
        Element missingReferencesElement = rootElement.addElement("missing-references");
        portletDataContext.setMissingReferencesElement(missingReferencesElement);
        Map exportPortletControlsMap = ExportImportHelperUtil.getExportPortletControlsMap((long)layout.getCompanyId(), (String)portletDataContext.getPortletId(), (Map)portletDataContext.getParameterMap());
        this.exportPortlet(portletDataContext, layout, rootElement, exportPermissions, (Boolean)exportPortletControlsMap.get("PORTLET_ARCHIVED_SETUPS"), (Boolean)exportPortletControlsMap.get("PORTLET_DATA"), (Boolean)exportPortletControlsMap.get("PORTLET_SETUP"), (Boolean)exportPortletControlsMap.get("PORTLET_USER_PREFERENCES"));
        this.exportService(portletDataContext, rootElement, (Boolean)exportPortletControlsMap.get("PORTLET_SETUP"));
        this.exportAssetLinks(portletDataContext);
        this.exportExpandoTables(portletDataContext);
        this.exportLocks(portletDataContext);
        this._deletionSystemEventExporter.exportDeletionSystemEvents(portletDataContext);
        if (exportPermissions) {
            this._permissionExporter.exportPortletDataPermissions(portletDataContext);
        }
        ExportImportHelperUtil.writeManifestSummary((Document)document, (ManifestSummary)portletDataContext.getManifestSummary());
        if (_log.isInfoEnabled()) {
            _log.info((Object)("Exporting portlet took " + stopWatch.getTime() + " ms"));
        }
        try {
            portletDataContext.addZipEntry("/manifest.xml", document.formattedString());
        }
        catch (IOException ioe) {
            throw new SystemException((Throwable)ioe);
        }
        ZipWriter zipWriter = portletDataContext.getZipWriter();
        return zipWriter.getFile();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void exportAssetLinks(PortletDataContext portletDataContext) throws Exception {
        Document document = SAXReaderUtil.createDocument();
        Element rootElement = document.addElement("links");
        Element exportDataRootElement = portletDataContext.getExportDataRootElement();
        try {
            portletDataContext.setExportDataRootElement(rootElement);
            ExportActionableDynamicQuery linkActionableDynamicQuery = this._assetLinkLocalService.getExportActionbleDynamicQuery(portletDataContext);
            linkActionableDynamicQuery.performActions();
            Iterator iterator = portletDataContext.getAssetLinkIds().iterator();
            while (iterator.hasNext()) {
                long linkId = (Long)iterator.next();
                AssetLink assetLink = this._assetLinkLocalService.getAssetLink(linkId);
                StagedAssetLink stagedAssetLink = (StagedAssetLink)ModelAdapterUtil.adapt((Object)assetLink, AssetLink.class, StagedAssetLink.class);
                portletDataContext.addClassedModel(portletDataContext.getExportDataElement((ClassedModel)stagedAssetLink), ExportImportPathUtil.getModelPath((StagedModel)stagedAssetLink), (ClassedModel)stagedAssetLink);
            }
        }
        finally {
            portletDataContext.setExportDataRootElement(exportDataRootElement);
        }
        portletDataContext.addZipEntry(ExportImportPathUtil.getRootPath((PortletDataContext)portletDataContext) + "/links.xml", document.formattedString());
    }

    protected void exportExpandoTables(PortletDataContext portletDataContext) throws Exception {
        Document document = SAXReaderUtil.createDocument();
        Element rootElement = document.addElement("expando-tables");
        Map expandoColumnsMap = portletDataContext.getExpandoColumns();
        for (Map.Entry entry : expandoColumnsMap.entrySet()) {
            String className = (String)entry.getKey();
            Element expandoTableElement = rootElement.addElement("expando-table");
            expandoTableElement.addAttribute("class-name", className);
            List expandoColumns = (List)entry.getValue();
            for (ExpandoColumn expandoColumn : expandoColumns) {
                Element expandoColumnElement = expandoTableElement.addElement("expando-column");
                expandoColumnElement.addAttribute("column-id", String.valueOf(expandoColumn.getColumnId()));
                expandoColumnElement.addAttribute("name", expandoColumn.getName());
                expandoColumnElement.addAttribute("type", String.valueOf(expandoColumn.getType()));
                DocUtil.add((Element)expandoColumnElement, (String)"default-data", (String)expandoColumn.getDefaultData());
                Element typeSettingsElement = expandoColumnElement.addElement("type-settings");
                UnicodeProperties typeSettingsProperties = expandoColumn.getTypeSettingsProperties();
                typeSettingsElement.addCDATA(typeSettingsProperties.toString());
            }
        }
        portletDataContext.addZipEntry(ExportImportPathUtil.getRootPath((PortletDataContext)portletDataContext) + "/expando-tables.xml", document.formattedString());
    }

    protected void exportLocks(PortletDataContext portletDataContext) throws Exception {
        Document document = SAXReaderUtil.createDocument();
        Element rootElement = document.addElement("locks");
        Map locksMap = portletDataContext.getLocks();
        for (Map.Entry entry : locksMap.entrySet()) {
            Lock lock = (Lock)entry.getValue();
            String entryKey = (String)entry.getKey();
            int pos = entryKey.indexOf(35);
            String className = entryKey.substring(0, pos);
            String key = entryKey.substring(pos + 1);
            String path = this.getLockPath(portletDataContext, className, key, lock);
            Element assetElement = rootElement.addElement("asset");
            assetElement.addAttribute("path", path);
            assetElement.addAttribute("class-name", className);
            assetElement.addAttribute("key", key);
            portletDataContext.addZipEntry(path, (Object)lock);
        }
        portletDataContext.addZipEntry(ExportImportPathUtil.getRootPath((PortletDataContext)portletDataContext) + "/locks.xml", document.formattedString());
    }

    protected void exportPortlet(PortletDataContext portletDataContext, Layout layout, Element parentElement, boolean exportPermissions, boolean exportPortletArchivedSetups, boolean exportPortletData, boolean exportPortletSetup, boolean exportPortletUserPreferences) throws Exception {
        block26: {
            Portlet portlet;
            long plid = 0L;
            long layoutId = 0L;
            if (layout != null) {
                plid = layout.getPlid();
                layoutId = layout.getLayoutId();
            }
            if ((portlet = this._portletLocalService.getPortletById(portletDataContext.getCompanyId(), portletDataContext.getPortletId())) == null || portlet.isUndeployedPortlet()) {
                if (_log.isDebugEnabled()) {
                    _log.debug((Object)("Do not export portlet " + portletDataContext.getPortletId() + " because the portlet is not deployed"));
                }
                return;
            }
            if (!portlet.isInstanceable() && !portlet.isPreferencesUniquePerLayout() && portletDataContext.hasNotUniquePerLayout(portletDataContext.getPortletId())) {
                return;
            }
            if (BackgroundTaskThreadLocal.hasBackgroundTask()) {
                PortletDataContext clonedPortletDataContext = PortletDataContextFactoryUtil.clonePortletDataContext((PortletDataContext)portletDataContext);
                ManifestSummary manifestSummary = clonedPortletDataContext.getManifestSummary();
                manifestSummary.resetCounters();
                PortletDataHandler portletDataHandler = portlet.getPortletDataHandlerInstance();
                portletDataHandler.prepareManifestSummary(clonedPortletDataContext);
                PortletDataHandlerStatusMessageSenderUtil.sendStatusMessage((String)"portlet", (String)portletDataContext.getPortletId(), (ManifestSummary)manifestSummary);
            }
            Document document = SAXReaderUtil.createDocument();
            Element portletElement = document.addElement("portlet");
            portletElement.addAttribute("portlet-id", portletDataContext.getPortletId());
            portletElement.addAttribute("root-portlet-id", portletDataContext.getRootPortletId());
            portletElement.addAttribute("old-plid", String.valueOf(plid));
            portletElement.addAttribute("scope-group-id", String.valueOf(portletDataContext.getScopeGroupId()));
            portletElement.addAttribute("scope-layout-type", portletDataContext.getScopeType());
            portletElement.addAttribute("scope-layout-uuid", portletDataContext.getScopeLayoutUuid());
            portletElement.addAttribute("private-layout", String.valueOf(layout.isPrivateLayout()));
            if (exportPortletData) {
                javax.portlet.PortletPreferences jxPortletPreferences = null;
                if (ExportImportThreadLocal.isInitialLayoutStagingInProcess()) {
                    Group liveGroup = layout.getGroup();
                    Group stagingGroup = liveGroup.getStagingGroup();
                    layout.setGroupId(stagingGroup.getGroupId());
                    jxPortletPreferences = PortletPreferencesFactoryUtil.getStrictPortletSetup((Layout)layout, (String)portletDataContext.getPortletId());
                    layout.setGroupId(liveGroup.getGroupId());
                } else {
                    jxPortletPreferences = PortletPreferencesFactoryUtil.getStrictPortletSetup((Layout)layout, (String)portletDataContext.getPortletId());
                }
                if (!portlet.isPreferencesUniquePerLayout()) {
                    StringBundler sb = new StringBundler(5);
                    sb.append(portletDataContext.getPortletId());
                    sb.append("@");
                    sb.append(portletDataContext.getScopeType());
                    sb.append("@");
                    sb.append(portletDataContext.getScopeLayoutUuid());
                    String dataKey = sb.toString();
                    if (!portletDataContext.hasNotUniquePerLayout(dataKey)) {
                        portletDataContext.putNotUniquePerLayout(dataKey);
                        this.exportPortletData(portletDataContext, portlet, layout, jxPortletPreferences, portletElement);
                    }
                } else {
                    this.exportPortletData(portletDataContext, portlet, layout, jxPortletPreferences, portletElement);
                }
            }
            if (exportPortletSetup) {
                this.exportPortletPreferences(portletDataContext, portletDataContext.getCompanyId(), 1, false, layout, plid, portlet.getRootPortletId(), portletElement);
                this.exportPortletPreferences(portletDataContext, portletDataContext.getScopeGroupId(), 2, false, layout, 0L, portlet.getRootPortletId(), portletElement);
                this.exportPortletPreferences(portletDataContext, 0L, 3, false, layout, plid, portletDataContext.getPortletId(), portletElement);
            }
            if (exportPortletUserPreferences) {
                List portletPreferencesList = this._portletPreferencesLocalService.getPortletPreferences(4, plid, portletDataContext.getPortletId());
                for (PortletPreferences portletPreferences : portletPreferencesList) {
                    boolean defaultUser = false;
                    if (portletPreferences.getOwnerId() == 0L) {
                        defaultUser = true;
                    }
                    this.exportPortletPreferences(portletDataContext, portletPreferences.getOwnerId(), 4, defaultUser, layout, plid, portletDataContext.getPortletId(), portletElement);
                }
                try {
                    PortletPreferences groupPortletPreferences = this._portletPreferencesLocalService.getPortletPreferences(portletDataContext.getScopeGroupId(), 2, 0L, portlet.getRootPortletId());
                    this.exportPortletPreference(portletDataContext, portletDataContext.getScopeGroupId(), 2, false, groupPortletPreferences, portlet.getRootPortletId(), 0L, portletElement);
                }
                catch (NoSuchPortletPreferencesException groupPortletPreferences) {
                    // empty catch block
                }
            }
            if (exportPortletArchivedSetups) {
                List portletItems = this._portletItemLocalService.getPortletItems(portletDataContext.getGroupId(), portletDataContext.getRootPortletId(), PortletPreferences.class.getName());
                for (PortletItem portletItem : portletItems) {
                    this.exportPortletPreferences(portletDataContext, portletItem.getPortletItemId(), 5, false, null, plid, portletItem.getPortletId(), portletElement);
                }
            }
            if (exportPermissions) {
                this._permissionExporter.exportPortletPermissions(portletDataContext, portletDataContext.getPortletId(), layout, portletElement);
            }
            StringBundler pathSB = new StringBundler(4);
            pathSB.append(ExportImportPathUtil.getPortletPath((PortletDataContext)portletDataContext));
            pathSB.append("/");
            pathSB.append(plid);
            pathSB.append("/portlet.xml");
            String path = pathSB.toString();
            Element element = parentElement.addElement("portlet");
            element.addAttribute("portlet-id", portletDataContext.getPortletId());
            element.addAttribute("layout-id", String.valueOf(layoutId));
            element.addAttribute("path", path);
            element.addAttribute("portlet-data", String.valueOf(exportPortletData));
            PortletDataHandler portletDataHandler = portlet.getPortletDataHandlerInstance();
            element.addAttribute("schema-version", portletDataHandler.getSchemaVersion());
            StringBundler configurationOptionsSB = new StringBundler(6);
            if (exportPortletSetup) {
                configurationOptionsSB.append("setup");
                configurationOptionsSB.append(",");
            }
            if (exportPortletArchivedSetups) {
                configurationOptionsSB.append("archived-setups");
                configurationOptionsSB.append(",");
            }
            if (exportPortletUserPreferences) {
                configurationOptionsSB.append("user-preferences");
                configurationOptionsSB.append(",");
            }
            if (configurationOptionsSB.index() > 0) {
                configurationOptionsSB.setIndex(configurationOptionsSB.index() - 1);
            }
            element.addAttribute("portlet-configuration", configurationOptionsSB.toString());
            try {
                portletDataContext.addZipEntry(path, document.formattedString());
            }
            catch (IOException ioe) {
                if (!_log.isWarnEnabled()) break block26;
                _log.warn((Object)ioe.getMessage());
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void exportPortletPreference(PortletDataContext portletDataContext, long ownerId, int ownerType, boolean defaultUser, PortletPreferences portletPreferences, String portletId, long plid, Element parentElement) throws Exception {
        String preferencesXML = portletPreferences.getPreferences();
        if (Validator.isNull((String)preferencesXML)) {
            preferencesXML = "<portlet-preferences />";
        }
        javax.portlet.PortletPreferences jxPortletPreferences = PortletPreferencesFactoryUtil.fromDefaultXML((String)preferencesXML);
        Portlet portlet = this._portletLocalService.getPortletById(portletDataContext.getCompanyId(), portletId);
        Element portletPreferencesElement = parentElement.addElement("portlet-preferences");
        if (portlet != null && portlet.getPortletDataHandlerInstance() != null) {
            Element exportDataRootElement = portletDataContext.getExportDataRootElement();
            try {
                portletDataContext.clearScopedPrimaryKeys();
                Element preferenceDataElement = portletPreferencesElement.addElement("preference-data");
                portletDataContext.setExportDataRootElement(preferenceDataElement);
                ExportImportPortletPreferencesProcessor exportImportPortletPreferencesProcessor = ExportImportPortletPreferencesProcessorRegistryUtil.getExportImportPortletPreferencesProcessor((String)portlet.getRootPortletId());
                if (exportImportPortletPreferencesProcessor != null) {
                    List exportCapabilities = exportImportPortletPreferencesProcessor.getExportCapabilities();
                    if (ListUtil.isNotEmpty((List)exportCapabilities)) {
                        for (Capability exportCapability : exportCapabilities) {
                            exportCapability.process(portletDataContext, jxPortletPreferences);
                        }
                    }
                    exportImportPortletPreferencesProcessor.processExportPortletPreferences(portletDataContext, jxPortletPreferences);
                } else {
                    PortletDataHandler portletDataHandler = portlet.getPortletDataHandlerInstance();
                    jxPortletPreferences = portletDataHandler.processExportPortletPreferences(portletDataContext, portletId, jxPortletPreferences);
                }
            }
            finally {
                portletDataContext.setExportDataRootElement(exportDataRootElement);
            }
        }
        Document document = SAXReaderUtil.read((String)PortletPreferencesFactoryUtil.toXML((javax.portlet.PortletPreferences)jxPortletPreferences));
        Element rootElement = document.getRootElement();
        rootElement.addAttribute("owner-id", String.valueOf(ownerId));
        rootElement.addAttribute("owner-type", String.valueOf(ownerType));
        rootElement.addAttribute("default-user", String.valueOf(defaultUser));
        rootElement.addAttribute("plid", String.valueOf(plid));
        rootElement.addAttribute("portlet-id", portletId);
        if (ownerType == 5) {
            PortletItem portletItem = this._portletItemLocalService.getPortletItem(ownerId);
            rootElement.addAttribute("archive-user-uuid", portletItem.getUserUuid());
            rootElement.addAttribute("archive-name", portletItem.getName());
        } else if (ownerType == 4) {
            User user = this._userLocalService.fetchUserById(ownerId);
            if (user == null) {
                return;
            }
            rootElement.addAttribute("user-uuid", user.getUserUuid());
        }
        List nodes = document.selectNodes("/portlet-preferences/preference[name/text() = 'last-publish-date']");
        for (Node node : nodes) {
            document.remove(node);
        }
        String path = ExportImportPathUtil.getPortletPreferencesPath((PortletDataContext)portletDataContext, (String)portletId, (long)ownerId, (int)ownerType, (long)plid);
        portletPreferencesElement.addAttribute("path", path);
        portletDataContext.addZipEntry(path, document.formattedString("\t", false, false));
    }

    protected void exportPortletPreferences(PortletDataContext portletDataContext, long ownerId, int ownerType, boolean defaultUser, Layout layout, long plid, String portletId, Element parentElement) throws Exception {
        PortletPreferences portletPreferences = null;
        try {
            portletPreferences = this.getPortletPreferences(ownerId, ownerType, plid, portletId);
        }
        catch (NoSuchPortletPreferencesException nsppe) {
            return;
        }
        LayoutTypePortlet layoutTypePortlet = null;
        if (layout != null) {
            layoutTypePortlet = (LayoutTypePortlet)layout.getLayoutType();
        }
        if (layoutTypePortlet == null || layoutTypePortlet.hasPortletId(portletId)) {
            this.exportPortletPreference(portletDataContext, ownerId, ownerType, defaultUser, portletPreferences, portletId, plid, parentElement);
        }
    }

    protected void exportService(PortletDataContext portletDataContext, Element rootElement, boolean exportServiceSetup) throws Exception {
        if (!exportServiceSetup) {
            return;
        }
        PortletDataHandler portletDataHandler = this._portletDataHandlerProvider.provide(portletDataContext.getPortletId());
        if (portletDataHandler == null) {
            return;
        }
        String serviceName = portletDataHandler.getServiceName();
        if (Validator.isNotNull((String)serviceName)) {
            this.exportServicePortletPreferences(portletDataContext, portletDataContext.getCompanyId(), 1, serviceName, rootElement);
            this.exportServicePortletPreferences(portletDataContext, portletDataContext.getScopeGroupId(), 2, serviceName, rootElement);
        }
    }

    protected void exportServicePortletPreference(PortletDataContext portletDataContext, long ownerId, int ownerType, PortletPreferences portletPreferences, String serviceName, Element parentElement) throws Exception {
        String preferencesXML = portletPreferences.getPreferences();
        if (Validator.isNull((String)preferencesXML)) {
            preferencesXML = "<portlet-preferences />";
        }
        javax.portlet.PortletPreferences jxPortletPreferences = PortletPreferencesFactoryUtil.fromDefaultXML((String)preferencesXML);
        Document document = SAXReaderUtil.read((String)PortletPreferencesFactoryUtil.toXML((javax.portlet.PortletPreferences)jxPortletPreferences));
        Element rootElement = document.getRootElement();
        rootElement.addAttribute("owner-id", String.valueOf(ownerId));
        rootElement.addAttribute("owner-type", String.valueOf(ownerType));
        rootElement.addAttribute("default-user", String.valueOf(false));
        rootElement.addAttribute("service-name", serviceName);
        if (ownerType == 5) {
            PortletItem portletItem = this._portletItemLocalService.getPortletItem(ownerId);
            rootElement.addAttribute("archive-user-uuid", portletItem.getUserUuid());
            rootElement.addAttribute("archive-name", portletItem.getName());
        } else if (ownerType == 4) {
            User user = this._userLocalService.fetchUserById(ownerId);
            if (user == null) {
                return;
            }
            rootElement.addAttribute("user-uuid", user.getUserUuid());
        }
        List nodes = document.selectNodes("/portlet-preferences/preference[name/text() = 'last-publish-date']");
        for (Node node : nodes) {
            document.remove(node);
        }
        Element serviceElement = parentElement.addElement("service");
        String path = ExportImportPathUtil.getServicePortletPreferencesPath((PortletDataContext)portletDataContext, (String)serviceName, (long)ownerId, (int)ownerType);
        serviceElement.addAttribute("path", path);
        serviceElement.addAttribute("service-name", serviceName);
        portletDataContext.addZipEntry(path, document.formattedString());
    }

    protected void exportServicePortletPreferences(PortletDataContext portletDataContext, long ownerId, int ownerType, String serviceName, Element parentElement) throws Exception {
        PortletPreferences portletPreferences = null;
        try {
            portletPreferences = this.getPortletPreferences(ownerId, ownerType, 0L, serviceName);
        }
        catch (NoSuchPortletPreferencesException nsppe) {
            return;
        }
        this.exportServicePortletPreference(portletDataContext, ownerId, ownerType, portletPreferences, serviceName, parentElement);
    }

    protected String getLockPath(PortletDataContext portletDataContext, String className, String key, Lock lock) {
        StringBundler sb = new StringBundler(8);
        sb.append(ExportImportPathUtil.getRootPath((PortletDataContext)portletDataContext));
        sb.append("/locks/");
        sb.append(PortalUtil.getClassNameId((String)className));
        sb.append('/');
        sb.append(key);
        sb.append('/');
        sb.append(lock.getLockId());
        sb.append(".xml");
        return sb.toString();
    }

    protected PortletDataContext getPortletDataContext(ExportImportConfiguration exportImportConfiguration) throws PortalException {
        Map settingsMap = exportImportConfiguration.getSettingsMap();
        long sourcePlid = MapUtil.getLong((Map)settingsMap, (String)"sourcePlid");
        long sourceGroupId = MapUtil.getLong((Map)settingsMap, (String)"sourceGroupId");
        String portletId = MapUtil.getString((Map)settingsMap, (String)"portletId");
        Map parameterMap = (Map)settingsMap.get("parameterMap");
        DateRange dateRange = ExportImportDateUtil.getDateRange((ExportImportConfiguration)exportImportConfiguration);
        Layout layout = this._layoutLocalService.getLayout(sourcePlid);
        ZipWriter zipWriter = ExportImportHelperUtil.getPortletZipWriter((String)portletId);
        PortletDataContext portletDataContext = PortletDataContextFactoryUtil.createExportPortletDataContext((long)layout.getCompanyId(), (long)sourceGroupId, (Map)parameterMap, (Date)dateRange.getStartDate(), (Date)dateRange.getEndDate(), (ZipWriter)zipWriter);
        portletDataContext.setOldPlid(sourcePlid);
        portletDataContext.setPlid(sourcePlid);
        portletDataContext.setPortletId(portletId);
        return portletDataContext;
    }

    protected PortletPreferences getPortletPreferences(long ownerId, int ownerType, long plid, String portletId) throws PortalException {
        PortletPreferences portletPreferences = null;
        portletPreferences = ownerType == 5 || ownerType == 1 || ownerType == 2 ? this._portletPreferencesLocalService.getPortletPreferences(ownerId, ownerType, 0L, portletId) : this._portletPreferencesLocalService.getPortletPreferences(ownerId, ownerType, plid, portletId);
        return portletPreferences;
    }

    protected int getProcessFlag() {
        if (ExportImportThreadLocal.isPortletStagingInProcess()) {
            return 36;
        }
        return 34;
    }

    @Reference(unbind="-")
    protected void setAssetEntryLocalService(AssetEntryLocalService assetEntryLocalService) {
        this._assetEntryLocalService = assetEntryLocalService;
    }

    @Reference(unbind="-")
    protected void setAssetLinkLocalService(AssetLinkLocalService assetLinkLocalService) {
        this._assetLinkLocalService = assetLinkLocalService;
    }

    @Reference(unbind="-")
    protected void setExportImportLifecycleManager(ExportImportLifecycleManager exportImportLifecycleManager) {
        this._exportImportLifecycleManager = exportImportLifecycleManager;
    }

    @Reference(unbind="-")
    protected void setGroupLocalService(GroupLocalService groupLocalService) {
        this._groupLocalService = groupLocalService;
    }

    @Reference(unbind="-")
    protected void setLayoutLocalService(LayoutLocalService layoutLocalService) {
        this._layoutLocalService = layoutLocalService;
    }

    @Reference(unbind="-")
    protected void setPortletItemLocalService(PortletItemLocalService portletItemLocalService) {
        this._portletItemLocalService = portletItemLocalService;
    }

    @Reference(unbind="-")
    protected void setPortletLocalService(PortletLocalService portletLocalService) {
        this._portletLocalService = portletLocalService;
    }

    @Reference(unbind="-")
    protected void setPortletPreferencesLocalService(PortletPreferencesLocalService portletPreferencesLocalService) {
        this._portletPreferencesLocalService = portletPreferencesLocalService;
    }

    @Reference(unbind="-")
    protected void setUserLocalService(UserLocalService userLocalService) {
        this._userLocalService = userLocalService;
    }

    private class UpdatePortletLastPublishDateCallable
    implements Callable<Void> {
        private final DateRange _dateRange;
        private final Date _endDate;
        private final long _groupId;
        private final long _plid;
        private final String _portletId;

        public UpdatePortletLastPublishDateCallable(DateRange dateRange, Date endDate, long groupId, long plid, String portletId) {
            this._dateRange = dateRange;
            this._endDate = endDate;
            this._groupId = groupId;
            this._plid = plid;
            this._portletId = portletId;
        }

        @Override
        public Void call() throws PortalException {
            Group group = PortletExportController.this._groupLocalService.getGroup(this._groupId);
            Layout layout = PortletExportController.this._layoutLocalService.fetchLayout(this._plid);
            if (group.hasStagingGroup()) {
                group = group.getStagingGroup();
                if (layout != null) {
                    layout = PortletExportController.this._layoutLocalService.fetchLayoutByUuidAndGroupId(layout.getUuid(), group.getGroupId(), layout.isPrivateLayout());
                }
            }
            javax.portlet.PortletPreferences jxPortletPreferences = null;
            jxPortletPreferences = layout == null ? PortletPreferencesFactoryUtil.getStrictPortletSetup((long)group.getCompanyId(), (long)group.getGroupId(), (String)this._portletId) : PortletPreferencesFactoryUtil.getStrictPortletSetup((Layout)layout, (String)this._portletId);
            ExportImportDateUtil.updateLastPublishDate((String)this._portletId, (javax.portlet.PortletPreferences)jxPortletPreferences, (DateRange)this._dateRange, (Date)this._endDate);
            return null;
        }
    }
}

