/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.exportimport.controller;

import com.liferay.exportimport.controller.PortletImportController;
import com.liferay.exportimport.kernel.controller.ExportImportController;
import com.liferay.exportimport.kernel.controller.ImportController;
import com.liferay.exportimport.kernel.exception.LARFileException;
import com.liferay.exportimport.kernel.exception.LARTypeException;
import com.liferay.exportimport.kernel.exception.LayoutImportException;
import com.liferay.exportimport.kernel.exception.MissingReferenceException;
import com.liferay.exportimport.kernel.lar.ExportImportHelperUtil;
import com.liferay.exportimport.kernel.lar.ExportImportThreadLocal;
import com.liferay.exportimport.kernel.lar.ManifestSummary;
import com.liferay.exportimport.kernel.lar.MissingReferences;
import com.liferay.exportimport.kernel.lar.PortletDataContext;
import com.liferay.exportimport.kernel.lar.PortletDataContextFactoryUtil;
import com.liferay.exportimport.kernel.lar.PortletDataHandler;
import com.liferay.exportimport.kernel.lar.PortletDataHandlerStatusMessageSenderUtil;
import com.liferay.exportimport.kernel.lar.StagedModelDataHandlerUtil;
import com.liferay.exportimport.kernel.lar.StagedModelType;
import com.liferay.exportimport.kernel.lar.UserIdStrategy;
import com.liferay.exportimport.kernel.lifecycle.ExportImportLifecycleManager;
import com.liferay.exportimport.kernel.model.ExportImportConfiguration;
import com.liferay.exportimport.lar.DeletionSystemEventImporter;
import com.liferay.exportimport.lar.LayoutCache;
import com.liferay.exportimport.lar.PermissionImporter;
import com.liferay.exportimport.lar.ThemeImporter;
import com.liferay.exportimport.portlet.data.handler.provider.PortletDataHandlerProvider;
import com.liferay.portal.kernel.backgroundtask.BackgroundTaskThreadLocal;
import com.liferay.portal.kernel.exception.LayoutPrototypeException;
import com.liferay.portal.kernel.exception.LocaleException;
import com.liferay.portal.kernel.exception.NoSuchLayoutException;
import com.liferay.portal.kernel.exception.NoSuchLayoutPrototypeException;
import com.liferay.portal.kernel.exception.NoSuchLayoutSetPrototypeException;
import com.liferay.portal.kernel.exception.PortalException;
import com.liferay.portal.kernel.language.LanguageUtil;
import com.liferay.portal.kernel.log.Log;
import com.liferay.portal.kernel.log.LogFactoryUtil;
import com.liferay.portal.kernel.model.Group;
import com.liferay.portal.kernel.model.Layout;
import com.liferay.portal.kernel.model.LayoutPrototype;
import com.liferay.portal.kernel.model.LayoutSet;
import com.liferay.portal.kernel.model.LayoutSetPrototype;
import com.liferay.portal.kernel.model.Portlet;
import com.liferay.portal.kernel.plugin.Version;
import com.liferay.portal.kernel.service.GroupLocalService;
import com.liferay.portal.kernel.service.LayoutLocalService;
import com.liferay.portal.kernel.service.LayoutPrototypeLocalService;
import com.liferay.portal.kernel.service.LayoutSetLocalService;
import com.liferay.portal.kernel.service.LayoutSetPrototypeLocalService;
import com.liferay.portal.kernel.service.PortletLocalService;
import com.liferay.portal.kernel.service.ServiceContext;
import com.liferay.portal.kernel.service.ServiceContextThreadLocal;
import com.liferay.portal.kernel.service.persistence.LayoutUtil;
import com.liferay.portal.kernel.util.ArrayUtil;
import com.liferay.portal.kernel.util.GetterUtil;
import com.liferay.portal.kernel.util.LocaleUtil;
import com.liferay.portal.kernel.util.MapUtil;
import com.liferay.portal.kernel.util.ReleaseInfo;
import com.liferay.portal.kernel.util.StringBundler;
import com.liferay.portal.kernel.util.StringUtil;
import com.liferay.portal.kernel.util.Tuple;
import com.liferay.portal.kernel.util.UnicodeProperties;
import com.liferay.portal.kernel.util.Validator;
import com.liferay.portal.kernel.xml.Document;
import com.liferay.portal.kernel.xml.Element;
import com.liferay.portal.kernel.xml.SAXReaderUtil;
import com.liferay.portal.kernel.zip.ZipReader;
import com.liferay.portal.kernel.zip.ZipReaderFactoryUtil;
import com.liferay.sites.kernel.util.SitesUtil;
import java.io.File;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Objects;
import java.util.function.BiPredicate;
import org.apache.commons.lang.time.StopWatch;
import org.osgi.framework.Bundle;
import org.osgi.framework.FrameworkUtil;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.Reference;

@Component(immediate=true, property={"model.class.name=com.liferay.portal.kernel.model.Layout"}, service={ExportImportController.class, LayoutImportController.class})
public class LayoutImportController
implements ImportController {
    private static final Log _log = LogFactoryUtil.getLog(LayoutImportController.class);
    private final DeletionSystemEventImporter _deletionSystemEventImporter = DeletionSystemEventImporter.getInstance();
    private ExportImportLifecycleManager _exportImportLifecycleManager;
    private GroupLocalService _groupLocalService;
    private LayoutLocalService _layoutLocalService;
    private LayoutPrototypeLocalService _layoutPrototypeLocalService;
    private LayoutSetLocalService _layoutSetLocalService;
    private LayoutSetPrototypeLocalService _layoutSetPrototypeLocalService;
    private final PermissionImporter _permissionImporter = PermissionImporter.getInstance();
    @Reference
    private PortletDataHandlerProvider _portletDataHandlerProvider;
    private PortletImportController _portletImportController;
    private PortletLocalService _portletLocalService;
    private final ThemeImporter _themeImporter = ThemeImporter.getInstance();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void importDataDeletions(ExportImportConfiguration exportImportConfiguration, File file) throws Exception {
        ZipReader zipReader = null;
        try {
            ExportImportThreadLocal.setLayoutDataDeletionImportInProcess((boolean)true);
            Map settingsMap = exportImportConfiguration.getSettingsMap();
            long targetGroupId = MapUtil.getLong((Map)settingsMap, (String)"targetGroupId");
            boolean privateLayout = MapUtil.getBoolean((Map)settingsMap, (String)"privateLayout");
            Map parameterMap = (Map)settingsMap.get("parameterMap");
            LayoutSet layoutSet = this._layoutSetLocalService.getLayoutSet(targetGroupId, privateLayout);
            zipReader = ZipReaderFactoryUtil.getZipReader((File)file);
            this.validateFile(layoutSet.getCompanyId(), targetGroupId, parameterMap, zipReader);
            PortletDataContext portletDataContext = this.getPortletDataContext(exportImportConfiguration, file);
            boolean deletePortletData = MapUtil.getBoolean((Map)parameterMap, (String)"DELETE_PORTLET_DATA");
            if (deletePortletData) {
                if (_log.isDebugEnabled()) {
                    _log.debug((Object)"Deleting portlet data");
                }
                this.deletePortletData(portletDataContext);
            }
            this.populateDeletionStagedModelTypes(portletDataContext);
            this._deletionSystemEventImporter.importDeletionSystemEvents(portletDataContext);
        }
        finally {
            ExportImportThreadLocal.setLayoutDataDeletionImportInProcess((boolean)false);
            if (zipReader != null) {
                zipReader.close();
            }
        }
    }

    public void importFile(ExportImportConfiguration exportImportConfiguration, File file) throws Exception {
        PortletDataContext portletDataContext = null;
        try {
            ExportImportThreadLocal.setLayoutImportInProcess((boolean)true);
            portletDataContext = this.getPortletDataContext(exportImportConfiguration, file);
            this._exportImportLifecycleManager.fireExportImportLifecycleEvent(6, this.getProcessFlag(), new Serializable[]{PortletDataContextFactoryUtil.clonePortletDataContext((PortletDataContext)portletDataContext)});
            Map settingsMap = exportImportConfiguration.getSettingsMap();
            long userId = MapUtil.getLong((Map)settingsMap, (String)"userId");
            this.doImportFile(portletDataContext, userId);
            ExportImportThreadLocal.setLayoutImportInProcess((boolean)false);
            this._exportImportLifecycleManager.fireExportImportLifecycleEvent(5, this.getProcessFlag(), new Serializable[]{PortletDataContextFactoryUtil.clonePortletDataContext((PortletDataContext)portletDataContext), Long.valueOf(userId)});
        }
        catch (Throwable t) {
            ExportImportThreadLocal.setLayoutImportInProcess((boolean)false);
            this._exportImportLifecycleManager.fireExportImportLifecycleEvent(4, this.getProcessFlag(), new Serializable[]{PortletDataContextFactoryUtil.clonePortletDataContext((PortletDataContext)portletDataContext), t});
            throw t;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public MissingReferences validateFile(ExportImportConfiguration exportImportConfiguration, File file) throws Exception {
        ZipReader zipReader = null;
        try {
            ExportImportThreadLocal.setLayoutValidationInProcess((boolean)true);
            Map settingsMap = exportImportConfiguration.getSettingsMap();
            long targetGroupId = MapUtil.getLong((Map)settingsMap, (String)"targetGroupId");
            boolean privateLayout = MapUtil.getBoolean((Map)settingsMap, (String)"privateLayout");
            Map parameterMap = (Map)settingsMap.get("parameterMap");
            LayoutSet layoutSet = this._layoutSetLocalService.getLayoutSet(targetGroupId, privateLayout);
            zipReader = ZipReaderFactoryUtil.getZipReader((File)file);
            this.validateFile(layoutSet.getCompanyId(), targetGroupId, parameterMap, zipReader);
            PortletDataContext portletDataContext = this.getPortletDataContext(exportImportConfiguration, file);
            portletDataContext.setPrivateLayout(privateLayout);
            MissingReferences missingReferences = ExportImportHelperUtil.validateMissingReferences((PortletDataContext)portletDataContext);
            Map dependencyMissingReferences = missingReferences.getDependencyMissingReferences();
            if (!dependencyMissingReferences.isEmpty()) {
                throw new MissingReferenceException(missingReferences);
            }
            MissingReferences missingReferences2 = missingReferences;
            return missingReferences2;
        }
        finally {
            ExportImportThreadLocal.setLayoutValidationInProcess((boolean)false);
            if (zipReader != null) {
                zipReader.close();
            }
        }
    }

    protected void deleteMissingLayouts(PortletDataContext portletDataContext, List<String> sourceLayoutUuids, List<Layout> previousLayouts, ServiceContext serviceContext) throws Exception {
        if (_log.isDebugEnabled() && !sourceLayoutUuids.isEmpty()) {
            _log.debug((Object)"Delete missing layouts");
        }
        Map layoutPlids = portletDataContext.getNewPrimaryKeysMap(Layout.class);
        for (Layout layout : previousLayouts) {
            if (sourceLayoutUuids.contains(layout.getUuid()) || layoutPlids.containsValue(layout.getPlid())) continue;
            try {
                this._layoutLocalService.deleteLayout(layout, false, serviceContext);
            }
            catch (NoSuchLayoutException noSuchLayoutException) {}
        }
    }

    protected void deletePortletData(PortletDataContext portletDataContext) throws Exception {
        Element rootElement = portletDataContext.getImportDataRootElement();
        Element portletsElement = rootElement.element("portlets");
        List portletElements = portletsElement.elements("portlet");
        Map layouts = portletDataContext.getNewPrimaryKeysMap(Layout.class + ".layout");
        if (_log.isDebugEnabled() && !portletElements.isEmpty()) {
            _log.debug((Object)"Deleting portlet data");
        }
        for (Element portletElement : portletElements) {
            long layoutId = GetterUtil.getLong((String)portletElement.attributeValue("layout-id"));
            long plid = 0L;
            Layout layout = (Layout)layouts.get(layoutId);
            if (layout != null) {
                plid = layout.getPlid();
            }
            portletDataContext.setPlid(plid);
            portletDataContext.setPortletId(portletElement.attributeValue("portlet-id"));
            this._portletImportController.deletePortletData(portletDataContext);
        }
    }

    protected void doImportFile(PortletDataContext portletDataContext, long userId) throws Exception {
        Map parameterMap = portletDataContext.getParameterMap();
        boolean deleteMissingLayouts = MapUtil.getBoolean((Map)parameterMap, (String)"DELETE_MISSING_LAYOUTS", (boolean)Boolean.TRUE);
        boolean layoutSetPrototypeLinkEnabled = MapUtil.getBoolean((Map)parameterMap, (String)"LAYOUT_SET_PROTOTYPE_LINK_ENABLED");
        Group group = this._groupLocalService.getGroup(portletDataContext.getGroupId());
        if (group.isLayoutSetPrototype()) {
            layoutSetPrototypeLinkEnabled = false;
        }
        boolean layoutSetPrototypeSettings = MapUtil.getBoolean((Map)parameterMap, (String)"LAYOUT_SET_PROTOTYPE_SETTINGS");
        boolean layoutSetSettings = MapUtil.getBoolean((Map)parameterMap, (String)"LAYOUT_SET_SETTINGS");
        String layoutsImportMode = MapUtil.getString((Map)parameterMap, (String)"LAYOUTS_IMPORT_MODE", (String)"MERGE_BY_LAYOUT_UUID");
        boolean logo = MapUtil.getBoolean((Map)parameterMap, (String)"LOGO");
        boolean permissions = MapUtil.getBoolean((Map)parameterMap, (String)"PERMISSIONS");
        if (_log.isDebugEnabled()) {
            _log.debug((Object)("Import permissions " + permissions));
        }
        StopWatch stopWatch = new StopWatch();
        stopWatch.start();
        LayoutCache layoutCache = new LayoutCache();
        LayoutSet layoutSet = this._layoutSetLocalService.getLayoutSet(portletDataContext.getGroupId(), portletDataContext.isPrivateLayout());
        long companyId = layoutSet.getCompanyId();
        ServiceContext serviceContext = ServiceContextThreadLocal.getServiceContext();
        if (serviceContext == null) {
            serviceContext = new ServiceContext();
        }
        serviceContext.setCompanyId(companyId);
        serviceContext.setSignedIn(false);
        serviceContext.setUserId(userId);
        ServiceContextThreadLocal.pushServiceContext((ServiceContext)serviceContext);
        this.validateFile(companyId, portletDataContext.getGroupId(), parameterMap, portletDataContext.getZipReader());
        Map groupIds = portletDataContext.getNewPrimaryKeysMap(Group.class);
        groupIds.put(portletDataContext.getSourceGroupId(), portletDataContext.getGroupId());
        ManifestSummary manifestSummary = ExportImportHelperUtil.getManifestSummary((PortletDataContext)portletDataContext);
        portletDataContext.setManifestSummary(manifestSummary);
        Element rootElement = portletDataContext.getImportDataRootElement();
        Element headerElement = rootElement.element("header");
        String layoutSetPrototypeUuid = headerElement.attributeValue("layout-set-prototype-uuid");
        String larType = headerElement.attributeValue("type");
        if (group.isLayoutPrototype() && larType.equals("layout-prototype")) {
            LayoutPrototype existingLayoutPrototype;
            String layoutPrototypeUuid;
            LayoutPrototype layoutPrototype;
            block52: {
                deleteMissingLayouts = false;
                layoutPrototype = this._layoutPrototypeLocalService.getLayoutPrototype(group.getClassPK());
                layoutPrototypeUuid = GetterUtil.getString((String)headerElement.attributeValue("type-uuid"));
                existingLayoutPrototype = null;
                if (Validator.isNotNull((String)layoutPrototypeUuid)) {
                    try {
                        existingLayoutPrototype = this._layoutPrototypeLocalService.getLayoutPrototypeByUuidAndCompanyId(layoutPrototypeUuid, companyId);
                    }
                    catch (NoSuchLayoutPrototypeException nslpe) {
                        if (!_log.isDebugEnabled()) break block52;
                        _log.debug((Object)nslpe, (Throwable)nslpe);
                    }
                }
            }
            if (existingLayoutPrototype == null) {
                List layouts = this._layoutLocalService.getLayoutsByLayoutPrototypeUuid(layoutPrototype.getUuid());
                layoutPrototype.setUuid(layoutPrototypeUuid);
                this._layoutPrototypeLocalService.updateLayoutPrototype(layoutPrototype);
                for (Layout layout : layouts) {
                    layout.setLayoutPrototypeUuid(layoutPrototypeUuid);
                    this._layoutLocalService.updateLayout(layout);
                }
            }
        } else if (group.isLayoutSetPrototype() && larType.equals("layout-set-prototype")) {
            LayoutSetPrototype existingLayoutSetPrototype;
            String importedLayoutSetPrototypeUuid;
            LayoutSetPrototype layoutSetPrototype;
            block53: {
                layoutSetPrototype = this._layoutSetPrototypeLocalService.getLayoutSetPrototype(group.getClassPK());
                importedLayoutSetPrototypeUuid = GetterUtil.getString((String)headerElement.attributeValue("type-uuid"));
                existingLayoutSetPrototype = null;
                if (Validator.isNotNull((String)importedLayoutSetPrototypeUuid)) {
                    try {
                        existingLayoutSetPrototype = this._layoutSetPrototypeLocalService.getLayoutSetPrototypeByUuidAndCompanyId(importedLayoutSetPrototypeUuid, companyId);
                    }
                    catch (NoSuchLayoutSetPrototypeException nslspe) {
                        if (!_log.isDebugEnabled()) break block53;
                        _log.debug((Object)nslspe, (Throwable)nslspe);
                    }
                }
            }
            if (existingLayoutSetPrototype == null) {
                List layoutSets = this._layoutSetLocalService.getLayoutSetsByLayoutSetPrototypeUuid(layoutSetPrototype.getUuid());
                layoutSetPrototype.setUuid(importedLayoutSetPrototypeUuid);
                this._layoutSetPrototypeLocalService.updateLayoutSetPrototype(layoutSetPrototype);
                Iterator iterator = layoutSets.iterator();
                while (iterator.hasNext()) {
                    LayoutSet curLayoutSet = (LayoutSet)iterator.next();
                    curLayoutSet.setLayoutSetPrototypeUuid(importedLayoutSetPrototypeUuid);
                    this._layoutSetLocalService.updateLayoutSet(curLayoutSet);
                }
            }
        } else if (larType.equals("layout-set-prototype")) {
            layoutSetPrototypeSettings = true;
            layoutSetPrototypeUuid = GetterUtil.getString((String)headerElement.attributeValue("type-uuid"));
        }
        if (layoutSetPrototypeSettings && Validator.isNotNull((String)layoutSetPrototypeUuid)) {
            layoutSet.setLayoutSetPrototypeUuid(layoutSetPrototypeUuid);
            layoutSet.setLayoutSetPrototypeLinkEnabled(layoutSetPrototypeLinkEnabled);
            this._layoutSetLocalService.updateLayoutSet(layoutSet);
        }
        if (logo) {
            String logoPath = headerElement.attributeValue("logo-path");
            byte[] iconBytes = portletDataContext.getZipEntryAsByteArray(logoPath);
            if (ArrayUtil.isNotEmpty((byte[])iconBytes)) {
                this._layoutSetLocalService.updateLogo(portletDataContext.getGroupId(), portletDataContext.isPrivateLayout(), true, iconBytes);
            } else {
                this._layoutSetLocalService.updateLogo(portletDataContext.getGroupId(), portletDataContext.isPrivateLayout(), false, (File)null);
            }
        }
        this._themeImporter.importTheme(portletDataContext, layoutSet);
        if (layoutSetSettings) {
            String settings = GetterUtil.getString((String)headerElement.elementText("settings"));
            this._layoutSetLocalService.updateSettings(portletDataContext.getGroupId(), portletDataContext.isPrivateLayout(), settings);
        }
        Element portletsElement = rootElement.element("portlets");
        List portletElements = portletsElement.elements("portlet");
        if (BackgroundTaskThreadLocal.hasBackgroundTask()) {
            ArrayList portletIds = new ArrayList();
            for (Element portletElement : portletElements) {
                String portletId = portletElement.attributeValue("portlet-id");
                Portlet portlet = this._portletLocalService.getPortletById(portletDataContext.getCompanyId(), portletId);
                if (!portlet.isActive() || portlet.isUndeployedPortlet()) continue;
                portletIds.add(portletId);
            }
            PortletDataHandlerStatusMessageSenderUtil.sendStatusMessage((String)"layout", (String[])ArrayUtil.toStringArray((Collection)portletIds), (ManifestSummary)manifestSummary);
        }
        if (permissions) {
            for (Element portletElement : portletElements) {
                String portletPath = portletElement.attributeValue("path");
                Document portletDocument = SAXReaderUtil.read((String)portletDataContext.getZipEntryAsString(portletPath));
                this._permissionImporter.checkRoles(layoutCache, companyId, portletDataContext.getGroupId(), userId, portletDocument.getRootElement());
            }
            this._permissionImporter.readPortletDataPermissions(portletDataContext);
        }
        if (!layoutsImportMode.equals("CREATED_FROM_PROTOTYPE")) {
            this._portletImportController.readExpandoTables(portletDataContext);
        }
        this._portletImportController.readLocks(portletDataContext);
        HashSet<Layout> modifiedLayouts = new HashSet<Layout>();
        List previousLayouts = LayoutUtil.findByG_P((long)portletDataContext.getGroupId(), (boolean)portletDataContext.isPrivateLayout());
        if (Validator.isNotNull((String)layoutSetPrototypeUuid) && layoutSetPrototypeLinkEnabled) {
            LayoutSetPrototype layoutSetPrototype = this._layoutSetPrototypeLocalService.getLayoutSetPrototypeByUuidAndCompanyId(layoutSetPrototypeUuid, companyId);
            for (Layout layout : previousLayouts) {
                String sourcePrototypeLayoutUuid = layout.getSourcePrototypeLayoutUuid();
                if (Validator.isNull((String)layout.getSourcePrototypeLayoutUuid())) continue;
                if (SitesUtil.isLayoutModifiedSinceLastMerge((Layout)layout)) {
                    modifiedLayouts.add(layout);
                    continue;
                }
                Layout sourcePrototypeLayout = LayoutUtil.fetchByUUID_G_P((String)sourcePrototypeLayoutUuid, (long)layoutSetPrototype.getGroupId(), (boolean)true);
                if (sourcePrototypeLayout != null) continue;
                this._layoutLocalService.deleteLayout(layout, false, serviceContext);
            }
        }
        Element layoutsElement = portletDataContext.getImportDataGroupElement(Layout.class);
        List layoutElements = layoutsElement.elements();
        if (_log.isDebugEnabled() && !layoutElements.isEmpty()) {
            _log.debug((Object)"Importing layouts");
        }
        ArrayList<String> sourceLayoutsUuids = new ArrayList<String>();
        for (Object layoutElement : layoutElements) {
            this.importLayout(portletDataContext, sourceLayoutsUuids, (Element)layoutElement);
        }
        if (_log.isDebugEnabled() && !portletElements.isEmpty()) {
            _log.debug((Object)"Importing portlets");
        }
        Map layouts = portletDataContext.getNewPrimaryKeysMap(Layout.class + ".layout");
        for (Element portletElement : portletElements) {
            String portletPath = portletElement.attributeValue("path");
            String portletId = portletElement.attributeValue("portlet-id");
            long layoutId = GetterUtil.getLong((String)portletElement.attributeValue("layout-id"));
            long oldPlid = GetterUtil.getLong((String)portletElement.attributeValue("old-plid"));
            Portlet portlet = this._portletLocalService.getPortletById(portletDataContext.getCompanyId(), portletId);
            if (!portlet.isActive() || portlet.isUndeployedPortlet()) continue;
            Layout layout = (Layout)layouts.get(layoutId);
            long plid = 0L;
            if (layout != null) {
                plid = layout.getPlid();
                if (modifiedLayouts.contains(layout)) continue;
            }
            portletDataContext.setPlid(plid);
            portletDataContext.setOldPlid(oldPlid);
            portletDataContext.setPortletId(portletId);
            if (BackgroundTaskThreadLocal.hasBackgroundTask()) {
                PortletDataHandlerStatusMessageSenderUtil.sendStatusMessage((String)"portlet", (String)portletId, (ManifestSummary)manifestSummary);
            }
            Document portletDocument = SAXReaderUtil.read((String)portletDataContext.getZipEntryAsString(portletPath));
            portletElement = portletDocument.getRootElement();
            this.setPortletScope(portletDataContext, portletElement);
            long portletPreferencesGroupId = portletDataContext.getGroupId();
            Element portletDataElement = portletElement.element("portlet-data");
            Map importPortletControlsMap = ExportImportHelperUtil.getImportPortletControlsMap((long)companyId, (String)portletId, (Map)parameterMap, (Element)portletDataElement, (ManifestSummary)manifestSummary);
            if (layout != null) {
                portletPreferencesGroupId = layout.getGroupId();
            }
            try {
                this._exportImportLifecycleManager.fireExportImportLifecycleEvent(12, this.getProcessFlag(), new Serializable[]{PortletDataContextFactoryUtil.clonePortletDataContext((PortletDataContext)portletDataContext)});
                this._portletImportController.importPortletPreferences(portletDataContext, layoutSet.getCompanyId(), portletPreferencesGroupId, layout, portletElement, false, (Boolean)importPortletControlsMap.get("PORTLET_ARCHIVED_SETUPS"), (Boolean)importPortletControlsMap.get("PORTLET_DATA"), (Boolean)importPortletControlsMap.get("PORTLET_SETUP"), (Boolean)importPortletControlsMap.get("PORTLET_USER_PREFERENCES"));
                if (((Boolean)importPortletControlsMap.get("PORTLET_DATA")).booleanValue()) {
                    this._portletImportController.importPortletData(portletDataContext, portletDataElement);
                }
                this._exportImportLifecycleManager.fireExportImportLifecycleEvent(11, this.getProcessFlag(), new Serializable[]{PortletDataContextFactoryUtil.clonePortletDataContext((PortletDataContext)portletDataContext)});
            }
            catch (Throwable t) {
                this._exportImportLifecycleManager.fireExportImportLifecycleEvent(10, this.getProcessFlag(), new Serializable[]{PortletDataContextFactoryUtil.clonePortletDataContext((PortletDataContext)portletDataContext), t});
                throw t;
            }
            finally {
                this._portletImportController.resetPortletScope(portletDataContext, portletPreferencesGroupId);
            }
            if (permissions) {
                this._permissionImporter.importPortletPermissions(layoutCache, companyId, portletDataContext.getGroupId(), userId, layout, portletElement, portletId);
            }
            this._portletImportController.importPortletPreferences(portletDataContext, layoutSet.getCompanyId(), portletDataContext.getGroupId(), null, portletElement, false, (Boolean)importPortletControlsMap.get("PORTLET_ARCHIVED_SETUPS"), (Boolean)importPortletControlsMap.get("PORTLET_DATA"), (Boolean)importPortletControlsMap.get("PORTLET_SETUP"), (Boolean)importPortletControlsMap.get("PORTLET_USER_PREFERENCES"));
        }
        if (_log.isDebugEnabled() && !portletElements.isEmpty()) {
            _log.debug((Object)"Importing services");
        }
        Element servicesElement = rootElement.element("services");
        List serviceElements = servicesElement.elements("service");
        for (Element serviceElement : serviceElements) {
            String path = serviceElement.attributeValue("path");
            Document serviceDocument = SAXReaderUtil.read((String)portletDataContext.getZipEntryAsString(path));
            serviceElement = serviceDocument.getRootElement();
            this._portletImportController.importServicePortletPreferences(portletDataContext, serviceElement);
        }
        this._portletImportController.importAssetLinks(portletDataContext);
        if (deleteMissingLayouts) {
            this.deleteMissingLayouts(portletDataContext, sourceLayoutsUuids, previousLayouts, serviceContext);
        }
        layoutSet = this._layoutSetLocalService.updatePageCount(portletDataContext.getGroupId(), portletDataContext.isPrivateLayout());
        this._groupLocalService.updateSite(portletDataContext.getGroupId(), true);
        this.updateLayoutPriorities(portletDataContext, layoutElements, portletDataContext.isPrivateLayout());
        if (layoutsImportMode.equals("CREATED_FROM_PROTOTYPE")) {
            long lastMergeTime = System.currentTimeMillis();
            for (Layout layout : layouts.values()) {
                if (modifiedLayouts.contains(layout = this._layoutLocalService.getLayout(layout.getPlid()))) continue;
                UnicodeProperties typeSettingsProperties = layout.getTypeSettingsProperties();
                typeSettingsProperties.setProperty("last-merge-time", String.valueOf(lastMergeTime));
                LayoutUtil.update((Layout)layout);
            }
            UnicodeProperties settingsProperties = (layoutSet = this._layoutSetLocalService.getLayoutSet(layoutSet.getLayoutSetId())).getSettingsProperties();
            String mergeFailFriendlyURLLayouts = settingsProperties.getProperty("merge-fail-friendly-url-layouts");
            if (Validator.isNull((String)mergeFailFriendlyURLLayouts) && modifiedLayouts.isEmpty()) {
                settingsProperties.setProperty("last-merge-time", String.valueOf(lastMergeTime));
                this._layoutSetLocalService.updateLayoutSet(layoutSet);
            }
        }
        if (_log.isInfoEnabled()) {
            _log.info((Object)("Importing layouts takes " + stopWatch.getTime() + " ms"));
        }
        ZipReader zipReader = portletDataContext.getZipReader();
        zipReader.close();
    }

    protected PortletDataContext getPortletDataContext(ExportImportConfiguration exportImportConfiguration, File file) throws PortalException {
        Map settingsMap = exportImportConfiguration.getSettingsMap();
        long userId = MapUtil.getLong((Map)settingsMap, (String)"userId");
        long targetGroupId = MapUtil.getLong((Map)settingsMap, (String)"targetGroupId");
        boolean privateLayout = MapUtil.getBoolean((Map)settingsMap, (String)"privateLayout");
        Map parameterMap = (Map)settingsMap.get("parameterMap");
        Group group = this._groupLocalService.getGroup(targetGroupId);
        String userIdStrategyString = MapUtil.getString((Map)parameterMap, (String)"USER_ID_STRATEGY");
        UserIdStrategy userIdStrategy = ExportImportHelperUtil.getUserIdStrategy((long)userId, (String)userIdStrategyString);
        ZipReader zipReader = ZipReaderFactoryUtil.getZipReader((File)file);
        PortletDataContext portletDataContext = PortletDataContextFactoryUtil.createImportPortletDataContext((long)group.getCompanyId(), (long)targetGroupId, (Map)parameterMap, (UserIdStrategy)userIdStrategy, (ZipReader)zipReader);
        portletDataContext.setPrivateLayout(privateLayout);
        return portletDataContext;
    }

    protected int getProcessFlag() {
        if (ExportImportThreadLocal.isLayoutStagingInProcess()) {
            return 32;
        }
        return 31;
    }

    protected void importLayout(PortletDataContext portletDataContext, List<String> sourceLayoutsUuids, Element layoutElement) throws Exception {
        String action = layoutElement.attributeValue("action");
        if (!action.equals("skip")) {
            StagedModelDataHandlerUtil.importStagedModel((PortletDataContext)portletDataContext, (Element)layoutElement);
        }
        if (!action.equals("delete")) {
            sourceLayoutsUuids.add(layoutElement.attributeValue("uuid"));
        }
    }

    protected void populateDeletionStagedModelTypes(PortletDataContext portletDataContext) throws Exception {
        Element rootElement = portletDataContext.getImportDataRootElement();
        Element portletsElement = rootElement.element("portlets");
        List portletElements = portletsElement.elements("portlet");
        for (Element portletElement : portletElements) {
            PortletDataHandler portletDataHandler;
            String portletId = portletElement.attributeValue("portlet-id");
            Portlet portlet = this._portletLocalService.getPortletById(portletDataContext.getCompanyId(), portletId);
            if (portlet == null || !portlet.isActive() || portlet.isUndeployedPortlet() || (portletDataHandler = this._portletDataHandlerProvider.provide(portletDataContext.getCompanyId(), portletId)) == null) continue;
            portletDataContext.addDeletionSystemEventStagedModelTypes(portletDataHandler.getDeletionSystemEventStagedModelTypes());
        }
        portletDataContext.addDeletionSystemEventStagedModelTypes(new StagedModelType[]{new StagedModelType(Layout.class)});
    }

    @Reference(unbind="-")
    protected void setExportImportLifecycleManager(ExportImportLifecycleManager exportImportLifecycleManager) {
        this._exportImportLifecycleManager = exportImportLifecycleManager;
    }

    @Reference(unbind="-")
    protected void setGroupLocalService(GroupLocalService groupLocalService) {
        this._groupLocalService = groupLocalService;
    }

    @Reference(unbind="-")
    protected void setLayoutLocalService(LayoutLocalService layoutLocalService) {
        this._layoutLocalService = layoutLocalService;
    }

    @Reference(unbind="-")
    protected void setLayoutPrototypeLocalService(LayoutPrototypeLocalService layoutPrototypeLocalService) {
        this._layoutPrototypeLocalService = layoutPrototypeLocalService;
    }

    @Reference(unbind="-")
    protected void setLayoutSetLocalService(LayoutSetLocalService layoutSetLocalService) {
        this._layoutSetLocalService = layoutSetLocalService;
    }

    @Reference(unbind="-")
    protected void setLayoutSetPrototypeLocalService(LayoutSetPrototypeLocalService layoutSetPrototypeLocalService) {
        this._layoutSetPrototypeLocalService = layoutSetPrototypeLocalService;
    }

    @Reference(unbind="-")
    protected void setPortletImportController(PortletImportController portletImportController) {
        this._portletImportController = portletImportController;
    }

    @Reference(unbind="-")
    protected void setPortletLocalService(PortletLocalService portletLocalService) {
        this._portletLocalService = portletLocalService;
    }

    protected void setPortletScope(PortletDataContext portletDataContext, Element portletElement) {
        String scopeLayoutUuid = GetterUtil.getString((String)portletElement.attributeValue("scope-layout-uuid"));
        String scopeLayoutType = GetterUtil.getString((String)portletElement.attributeValue("scope-layout-type"));
        portletDataContext.setScopeLayoutUuid(scopeLayoutUuid);
        portletDataContext.setScopeType(scopeLayoutType);
        try {
            Group scopeGroup;
            block12: {
                scopeGroup = null;
                if (scopeLayoutType.equals("company")) {
                    scopeGroup = this._groupLocalService.getCompanyGroup(portletDataContext.getCompanyId());
                } else if (Validator.isNotNull((String)scopeLayoutUuid)) {
                    Layout scopeLayout = this._layoutLocalService.getLayoutByUuidAndGroupId(scopeLayoutUuid, portletDataContext.getGroupId(), portletDataContext.isPrivateLayout());
                    scopeGroup = this._groupLocalService.checkScopeGroup(scopeLayout, portletDataContext.getUserId(null));
                    Group group = scopeLayout.getGroup();
                    if (group.isStaged() && !group.isStagedRemotely()) {
                        try {
                            boolean privateLayout = GetterUtil.getBoolean((String)portletElement.attributeValue("private-layout"));
                            Layout oldLayout = this._layoutLocalService.getLayoutByUuidAndGroupId(scopeLayoutUuid, portletDataContext.getSourceGroupId(), privateLayout);
                            Group oldScopeGroup = oldLayout.getScopeGroup();
                            if (group.isStagingGroup()) {
                                scopeGroup.setLiveGroupId(oldScopeGroup.getGroupId());
                                this._groupLocalService.updateGroup(scopeGroup);
                            } else {
                                oldScopeGroup.setLiveGroupId(scopeGroup.getGroupId());
                                this._groupLocalService.updateGroup(oldScopeGroup);
                            }
                        }
                        catch (NoSuchLayoutException nsle) {
                            if (!_log.isWarnEnabled()) break block12;
                            _log.warn((Throwable)nsle);
                        }
                    }
                }
            }
            if (scopeGroup != null) {
                portletDataContext.setScopeGroupId(scopeGroup.getGroupId());
                Map groupIds = portletDataContext.getNewPrimaryKeysMap(Group.class);
                long oldScopeGroupId = GetterUtil.getLong((String)portletElement.attributeValue("scope-group-id"));
                groupIds.put(oldScopeGroupId, scopeGroup.getGroupId());
            }
        }
        catch (PortalException scopeGroup) {
        }
        catch (Exception e) {
            _log.error((Object)e, (Throwable)e);
        }
    }

    protected void updateLayoutPriorities(PortletDataContext portletDataContext, List<Element> layoutElements, boolean privateLayout) {
        Map layouts = portletDataContext.getNewPrimaryKeysMap(Layout.class + ".layout");
        HashMap<Long, Integer> layoutPriorities = new HashMap<Long, Integer>();
        int maxPriority = Integer.MIN_VALUE;
        for (Element layoutElement : layoutElements) {
            long layoutId;
            Layout layout;
            String action = layoutElement.attributeValue("action");
            if (action.equals("skip")) {
                return;
            }
            if (!action.equals("add") || (layout = (Layout)layouts.get(layoutId = GetterUtil.getLong((String)layoutElement.attributeValue("layout-id")))) == null) continue;
            int layoutPriority = GetterUtil.getInteger((String)layoutElement.attributeValue("layout-priority"));
            layoutPriorities.put(layout.getPlid(), layoutPriority);
            if (maxPriority >= layoutPriority) continue;
            maxPriority = layoutPriority;
        }
        List layoutSetLayouts = this._layoutLocalService.getLayouts(portletDataContext.getGroupId(), privateLayout);
        for (Layout layout : layoutSetLayouts) {
            if (layoutPriorities.containsKey(layout.getPlid())) {
                layout.setPriority(((Integer)layoutPriorities.get(layout.getPlid())).intValue());
            } else {
                layout.setPriority(++maxPriority);
            }
            this._layoutLocalService.updateLayout(layout);
        }
    }

    protected void validateFile(long companyId, long groupId, Map<String, String[]> parameterMap, ZipReader zipReader) throws Exception {
        String larType;
        String xml = zipReader.getEntryAsString("/manifest.xml");
        if (xml == null) {
            throw new LARFileException("manifest.xml not found in the LAR");
        }
        Element rootElement = null;
        try {
            Document document = SAXReaderUtil.read((String)xml);
            rootElement = document.getRootElement();
        }
        catch (Exception e) {
            throw new LARFileException((Throwable)e);
        }
        Element headerElement = rootElement.element("header");
        int importBuildNumber = GetterUtil.getInteger((String)headerElement.attributeValue("build-number"));
        if (importBuildNumber < 7000) {
            int buildNumber = ReleaseInfo.getBuildNumber();
            if (buildNumber != importBuildNumber) {
                StringBundler sb = new StringBundler(4);
                sb.append("LAR build number ");
                sb.append(importBuildNumber);
                sb.append(" does not match portal build number ");
                sb.append(buildNumber);
                throw new LayoutImportException(sb.toString());
            }
        } else {
            BiPredicate<Version, Version> majorVersionBiPredicate = (currentVersion, importVersion) -> Objects.equals(currentVersion.getMajor(), importVersion.getMajor());
            BiPredicate<Version, Version> minorVersionBiPredicate = (currentVersion, importVersion) -> {
                int currentMinorVersion = GetterUtil.getInteger((String)currentVersion.getMinor(), (int)-1);
                int importedMinorVersion = GetterUtil.getInteger((String)importVersion.getMinor(), (int)-1);
                return (currentMinorVersion != -1 || importedMinorVersion != -1) && currentMinorVersion >= importedMinorVersion;
            };
            BiPredicate<Version, Version> manifestVersionBiPredicate = (currentVersion, importVersion) -> {
                BiPredicate<Version, Version> versionBiPredicate = majorVersionBiPredicate.and(minorVersionBiPredicate);
                return versionBiPredicate.test((Version)currentVersion, (Version)importVersion);
            };
            Bundle bundle = FrameworkUtil.getBundle(LayoutImportController.class);
            String currentBundleVersion = String.valueOf(bundle.getVersion());
            String importBundleVersion = GetterUtil.getString((String)headerElement.attributeValue("bundle-version"), (String)"3.0.0");
            if (!manifestVersionBiPredicate.test(Version.getInstance((String)currentBundleVersion), Version.getInstance((String)importBundleVersion))) {
                StringBundler sb = new StringBundler(4);
                sb.append("LAR bundle version ");
                sb.append(importBundleVersion);
                sb.append(" does not match deployed export/import bundle version ");
                sb.append(currentBundleVersion);
                throw new LayoutImportException(sb.toString());
            }
        }
        if (!((larType = headerElement.attributeValue("type")).equals("layout-prototype") || larType.equals("layout-set") || larType.equals("layout-set-prototype"))) {
            throw new LARTypeException(larType);
        }
        Group group = this._groupLocalService.fetchGroup(groupId);
        String layoutsImportMode = MapUtil.getString(parameterMap, (String)"LAYOUTS_IMPORT_MODE");
        if (larType.equals("layout-prototype") && !group.isLayoutPrototype() && !layoutsImportMode.equals("CREATED_FROM_PROTOTYPE")) {
            throw new LARTypeException("A page template can only be imported to a page template");
        }
        if (larType.equals("layout-set")) {
            if (group.isLayoutPrototype() || group.isLayoutSetPrototype()) {
                throw new LARTypeException("A site can only be imported to a site");
            }
            long sourceCompanyGroupId = GetterUtil.getLong((String)headerElement.attributeValue("company-group-id"));
            long sourceGroupId = GetterUtil.getLong((String)headerElement.attributeValue("group-id"));
            boolean companySourceGroup = false;
            if (sourceCompanyGroupId == sourceGroupId) {
                companySourceGroup = true;
            } else if (!(!group.isStaged() && !group.hasStagingGroup() || group.isStagedRemotely() && group.hasRemoteStagingGroup())) {
                Group sourceGroup = this._groupLocalService.fetchGroup(sourceGroupId);
                companySourceGroup = sourceGroup.isCompany();
            }
            if (group.isCompany() ^ companySourceGroup) {
                throw new LARTypeException("A company site can only be imported to a company site");
            }
        }
        if (larType.equals("layout-set-prototype") && !group.isLayoutSetPrototype() && !layoutsImportMode.equals("CREATED_FROM_PROTOTYPE")) {
            throw new LARTypeException("A site template can only be imported to a site template");
        }
        Element portletsElement = rootElement.element("portlets");
        List portletElements = portletsElement.elements("portlet");
        for (Object portletElement : portletElements) {
            String portletId = GetterUtil.getString((String)portletElement.attributeValue("portlet-id"));
            if (Validator.isNull((String)portletId)) continue;
            String schemaVersion = GetterUtil.getString((String)portletElement.attributeValue("schema-version"));
            PortletDataHandler portletDataHandler = this._portletDataHandlerProvider.provide(companyId, portletId);
            if (portletDataHandler == null || portletDataHandler.validateSchemaVersion(schemaVersion)) continue;
            StringBundler sb = new StringBundler(6);
            sb.append("Portlet's schema version ");
            sb.append(schemaVersion);
            sb.append(" in the LAR is not valid for the deployed portlet ");
            sb.append(portletId);
            sb.append(" with schema version ");
            sb.append(portletDataHandler.getSchemaVersion());
            throw new LayoutImportException(sb.toString());
        }
        List<Locale> sourceAvailableLocales = Arrays.asList(LocaleUtil.fromLanguageIds((String[])StringUtil.split((String)headerElement.attributeValue("available-locales"))));
        for (Locale sourceAvailableLocale : sourceAvailableLocales) {
            if (LanguageUtil.isAvailableLocale((long)groupId, (Locale)sourceAvailableLocale)) continue;
            LocaleException le = new LocaleException(2);
            le.setSourceAvailableLocales(sourceAvailableLocales);
            le.setTargetAvailableLocales((Collection)LanguageUtil.getAvailableLocales((long)groupId));
            throw le;
        }
        Element layoutsElement = rootElement.element(Layout.class.getSimpleName());
        this.validateLayoutPrototypes(companyId, headerElement, layoutsElement);
    }

    @Deprecated
    protected void validateLayoutPrototypes(long companyId, Element layoutsElement) throws Exception {
        throw new UnsupportedOperationException("This method is deprecated and replaced by #validateLayoutPrototypes(long, Element, Element)");
    }

    protected void validateLayoutPrototypes(long companyId, Element headerElement, Element layoutsElement) throws Exception {
        ArrayList<Tuple> missingLayoutPrototypes = new ArrayList<Tuple>();
        String layoutSetPrototypeUuid = headerElement.attributeValue("layout-set-prototype-uuid");
        if (Validator.isNotNull((String)layoutSetPrototypeUuid)) {
            try {
                this._layoutSetPrototypeLocalService.getLayoutSetPrototypeByUuidAndCompanyId(layoutSetPrototypeUuid, companyId);
            }
            catch (NoSuchLayoutSetPrototypeException nslspe) {
                if (_log.isDebugEnabled()) {
                    _log.debug((Object)nslspe, (Throwable)nslspe);
                }
                String layoutSetPrototypeName = headerElement.attributeValue("layout-set-prototype-name");
                missingLayoutPrototypes.add(new Tuple(new Object[]{LayoutSetPrototype.class.getName(), layoutSetPrototypeUuid, layoutSetPrototypeName}));
            }
        }
        List layoutElements = layoutsElement.elements();
        for (Element layoutElement : layoutElements) {
            String layoutPrototypeUuid;
            String action = layoutElement.attributeValue("action");
            if (action.equals("skip") || !Validator.isNotNull((String)(layoutPrototypeUuid = GetterUtil.getString((String)layoutElement.attributeValue("layout-prototype-uuid"))))) continue;
            try {
                this._layoutPrototypeLocalService.getLayoutPrototypeByUuidAndCompanyId(layoutPrototypeUuid, companyId);
            }
            catch (NoSuchLayoutPrototypeException nslpe) {
                if (_log.isDebugEnabled()) {
                    _log.debug((Object)nslpe, (Throwable)nslpe);
                }
                String layoutPrototypeName = GetterUtil.getString((String)layoutElement.attributeValue("layout-prototype-name"));
                missingLayoutPrototypes.add(new Tuple(new Object[]{LayoutPrototype.class.getName(), layoutPrototypeUuid, layoutPrototypeName}));
            }
        }
        if (!missingLayoutPrototypes.isEmpty()) {
            throw new LayoutPrototypeException(missingLayoutPrototypes);
        }
    }
}

