/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.exportimport.content.processor.base;

import com.liferay.document.library.kernel.exception.NoSuchFileEntryException;
import com.liferay.document.library.kernel.model.DLFileEntry;
import com.liferay.document.library.kernel.service.DLAppLocalServiceUtil;
import com.liferay.document.library.kernel.service.DLFileEntryLocalServiceUtil;
import com.liferay.document.library.kernel.util.DLUtil;
import com.liferay.exportimport.content.processor.ExportImportContentProcessor;
import com.liferay.exportimport.kernel.lar.ExportImportPathUtil;
import com.liferay.exportimport.kernel.lar.PortletDataContext;
import com.liferay.exportimport.kernel.lar.StagedModelDataHandlerUtil;
import com.liferay.portal.kernel.exception.NoSuchLayoutException;
import com.liferay.portal.kernel.exception.PortalException;
import com.liferay.portal.kernel.log.Log;
import com.liferay.portal.kernel.log.LogFactoryUtil;
import com.liferay.portal.kernel.model.ClassedModel;
import com.liferay.portal.kernel.model.Company;
import com.liferay.portal.kernel.model.Group;
import com.liferay.portal.kernel.model.Layout;
import com.liferay.portal.kernel.model.LayoutSet;
import com.liferay.portal.kernel.model.StagedModel;
import com.liferay.portal.kernel.repository.model.FileEntry;
import com.liferay.portal.kernel.repository.model.FileVersion;
import com.liferay.portal.kernel.service.CompanyLocalServiceUtil;
import com.liferay.portal.kernel.service.GroupLocalServiceUtil;
import com.liferay.portal.kernel.service.LayoutLocalServiceUtil;
import com.liferay.portal.kernel.service.ServiceContext;
import com.liferay.portal.kernel.service.ServiceContextThreadLocal;
import com.liferay.portal.kernel.theme.ThemeDisplay;
import com.liferay.portal.kernel.util.ArrayUtil;
import com.liferay.portal.kernel.util.GetterUtil;
import com.liferay.portal.kernel.util.HttpUtil;
import com.liferay.portal.kernel.util.LocaleUtil;
import com.liferay.portal.kernel.util.MapUtil;
import com.liferay.portal.kernel.util.PortalUtil;
import com.liferay.portal.kernel.util.PredicateFilter;
import com.liferay.portal.kernel.util.PropsUtil;
import com.liferay.portal.kernel.util.StringBundler;
import com.liferay.portal.kernel.util.StringUtil;
import com.liferay.portal.kernel.util.Validator;
import com.liferay.portal.kernel.xml.Element;
import com.liferay.portal.util.PropsValues;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class BaseTextExportImportContentProcessor
implements ExportImportContentProcessor<String> {
    protected static final String DATA_HANDLER_COMPANY_SECURE_URL = "@data_handler_company_secure_url@";
    protected static final String DATA_HANDLER_COMPANY_URL = "@data_handler_company_url@";
    protected static final String DATA_HANDLER_GROUP_FRIENDLY_URL = "@data_handler_group_friendly_url@";
    protected static final String DATA_HANDLER_PATH_CONTEXT = "@data_handler_path_context@";
    protected static final String DATA_HANDLER_PRIVATE_GROUP_SERVLET_MAPPING = "@data_handler_private_group_servlet_mapping@";
    protected static final String DATA_HANDLER_PRIVATE_LAYOUT_SET_SECURE_URL = "@data_handler_private_layout_set_secure_url@";
    protected static final String DATA_HANDLER_PRIVATE_LAYOUT_SET_URL = "@data_handler_private_layout_set_url@";
    protected static final String DATA_HANDLER_PRIVATE_USER_SERVLET_MAPPING = "@data_handler_private_user_servlet_mapping@";
    protected static final String DATA_HANDLER_PUBLIC_LAYOUT_SET_SECURE_URL = "@data_handler_public_layout_set_secure_url@";
    protected static final String DATA_HANDLER_PUBLIC_LAYOUT_SET_URL = "@data_handler_public_layout_set_url@";
    protected static final String DATA_HANDLER_PUBLIC_SERVLET_MAPPING = "@data_handler_public_servlet_mapping@";
    protected static final char[] DL_REFERENCE_LEGACY_STOP_CHARS = new char[]{'\'', ']', '}', ')', '>', '<', '|', '\"', ' '};
    protected static final char[] DL_REFERENCE_STOP_CHARS = new char[]{'\'', ']', '}', ')', '>', '<', '|', '?', '\"', ' '};
    protected static final char[] LAYOUT_REFERENCE_STOP_CHARS = new char[]{'\'', ']', '}', ')', '>', '<', '|', '?', '\"', ' '};
    protected static final String PRIVATE_GROUP_SERVLET_MAPPING = PropsUtil.get((String)"layout.friendly.url.private.group.servlet.mapping") + "/";
    protected static final String PRIVATE_USER_SERVLET_MAPPING = PropsUtil.get((String)"layout.friendly.url.private.user.servlet.mapping") + "/";
    protected static final String PUBLIC_GROUP_SERVLET_MAPPING = PropsUtil.get((String)"layout.friendly.url.public.servlet.mapping") + "/";
    protected static final Pattern exportLinksToLayoutPattern = Pattern.compile("\\[([\\d]+)@(private(-group|-user)?|public)(@([\\d]+))?\\]");
    protected static final Pattern importLinksToLayoutPattern = Pattern.compile("\\[([\\d]+)@(private(-group|-user)?|public)@([\\d]+)(@([\\d]+))?\\]");
    private static final Log _log = LogFactoryUtil.getLog(BaseTextExportImportContentProcessor.class);

    public String replaceExportContentReferences(PortletDataContext portletDataContext, StagedModel stagedModel, String content, boolean exportReferencedContent, boolean escapeContent) throws Exception {
        content = this.replaceExportDLReferences(portletDataContext, stagedModel, content, exportReferencedContent);
        content = this.replaceExportLayoutReferences(portletDataContext, stagedModel, content);
        content = this.replaceExportLinksToLayouts(portletDataContext, stagedModel, content);
        if (escapeContent) {
            content = StringUtil.replace((String)content, (String)"&amp;", (String)"&");
        }
        return content;
    }

    public String replaceImportContentReferences(PortletDataContext portletDataContext, StagedModel stagedModel, String content) throws Exception {
        content = this.replaceImportDLReferences(portletDataContext, stagedModel, content);
        content = this.replaceImportLayoutReferences(portletDataContext, content);
        content = this.replaceImportLinksToLayouts(portletDataContext, content);
        return content;
    }

    public void validateContentReferences(long groupId, String content) throws PortalException {
        this.validateDLReferences(groupId, content);
        this.validateLayoutReferences(groupId, content);
        this.validateLinksToLayoutsReferences(content);
    }

    protected void deleteTimestampParameters(StringBuilder sb, int beginPos) {
        if ((beginPos = sb.indexOf("]", beginPos)) == -1 || beginPos == sb.length() - 1 || sb.charAt(beginPos + 1) != '?') {
            return;
        }
        int endPos = StringUtil.indexOfAny((String)sb.toString(), (char[])DL_REFERENCE_LEGACY_STOP_CHARS, (int)(beginPos + 2));
        if (endPos == -1) {
            return;
        }
        String urlParams = sb.substring(beginPos + 1, endPos);
        urlParams = HttpUtil.removeParameter((String)urlParams, (String)"t");
        sb.replace(beginPos + 1, endPos, urlParams);
    }

    protected Map<String, String[]> getDLReferenceParameters(long groupId, String content, int beginPos, int endPos) {
        boolean legacyURL = true;
        char[] stopChars = DL_REFERENCE_LEGACY_STOP_CHARS;
        if (content.startsWith("/documents/", beginPos)) {
            legacyURL = false;
            stopChars = DL_REFERENCE_STOP_CHARS;
        }
        if ((endPos = StringUtil.indexOfAny((String)content, (char[])stopChars, (int)beginPos, (int)endPos)) == -1) {
            return null;
        }
        Map<String, Object> map = new HashMap<String, String[]>();
        String dlReference = content.substring(beginPos, endPos);
        while (dlReference.contains("&amp;")) {
            dlReference = dlReference.replace("&amp;", "&");
        }
        if (!legacyURL) {
            String[] pathArray = dlReference.split("/");
            if (pathArray.length < 3) {
                return map;
            }
            map.put("groupId", new String[]{pathArray[2]});
            if (pathArray.length == 4) {
                map.put("uuid", new String[]{pathArray[3]});
            } else if (pathArray.length == 5) {
                map.put("folderId", new String[]{pathArray[3]});
                map.put("title", new String[]{HttpUtil.decodeURL((String)pathArray[4])});
            } else if (pathArray.length > 5) {
                map.put("uuid", new String[]{pathArray[5]});
            }
        } else {
            dlReference = dlReference.substring(dlReference.indexOf(63) + 1);
            map = HttpUtil.parameterMapFromString((String)dlReference);
            Object[] imageIds = null;
            if (map.containsKey("img_id")) {
                imageIds = (String[])map.get("img_id");
            } else if (map.containsKey("i_id")) {
                imageIds = (String[])map.get("i_id");
            }
            imageIds = (String[])ArrayUtil.filter((Object[])imageIds, (PredicateFilter)new PredicateFilter<String>(){

                public boolean filter(String imageId) {
                    return Validator.isNotNull((String)imageId);
                }
            });
            if (ArrayUtil.isNotEmpty((Object[])imageIds)) {
                map.put("image_id", imageIds);
            }
        }
        map.put("endPos", new String[]{String.valueOf(endPos)});
        String groupIdString = MapUtil.getString(map, (String)"groupId");
        if (groupIdString.equals("@group_id@")) {
            groupIdString = String.valueOf(groupId);
            map.put("groupId", new String[]{groupIdString});
        }
        return map;
    }

    protected FileEntry getFileEntry(Map<String, String[]> map) {
        FileEntry fileEntry;
        block12: {
            if (MapUtil.isEmpty(map)) {
                return null;
            }
            fileEntry = null;
            try {
                DLFileEntry dlFileEntry;
                String uuid = MapUtil.getString(map, (String)"uuid");
                long groupId = MapUtil.getLong(map, (String)"groupId");
                if (Validator.isNotNull((String)uuid)) {
                    fileEntry = DLAppLocalServiceUtil.getFileEntryByUuidAndGroupId((String)uuid, (long)groupId);
                } else if (map.containsKey("folderId")) {
                    long folderId = MapUtil.getLong(map, (String)"folderId");
                    String name = MapUtil.getString(map, (String)"name");
                    String title = MapUtil.getString(map, (String)"title");
                    if (Validator.isNotNull((String)title)) {
                        fileEntry = DLAppLocalServiceUtil.getFileEntry((long)groupId, (long)folderId, (String)title);
                    } else {
                        DLFileEntry dlFileEntry2 = DLFileEntryLocalServiceUtil.fetchFileEntryByName((long)groupId, (long)folderId, (String)name);
                        if (dlFileEntry2 != null) {
                            fileEntry = DLAppLocalServiceUtil.getFileEntry((long)dlFileEntry2.getFileEntryId());
                        }
                    }
                } else if (map.containsKey("image_id") && (dlFileEntry = DLFileEntryLocalServiceUtil.fetchFileEntryByAnyImageId((long)MapUtil.getLong(map, (String)"image_id"))) != null) {
                    fileEntry = DLAppLocalServiceUtil.getFileEntry((long)dlFileEntry.getFileEntryId());
                }
            }
            catch (Exception e) {
                if (_log.isDebugEnabled()) {
                    _log.debug((Object)e, (Throwable)e);
                }
                if (!_log.isWarnEnabled()) break block12;
                _log.warn((Object)e.getMessage());
            }
        }
        return fileEntry;
    }

    protected String replaceExportDLReferences(PortletDataContext portletDataContext, StagedModel stagedModel, String content, boolean exportReferencedContent) throws Exception {
        Group group = GroupLocalServiceUtil.getGroup((long)portletDataContext.getGroupId());
        if (group.isStagingGroup()) {
            group = group.getLiveGroup();
        }
        if (group.isStaged() && !group.isStagedRemotely() && !group.isStagedPortlet("com_liferay_document_library_web_portlet_DLPortlet")) {
            return content;
        }
        StringBuilder sb = new StringBuilder(content);
        String contextPath = PortalUtil.getPathContext();
        String[] patterns = new String[]{contextPath.concat("/c/document_library/get_file?"), contextPath.concat("/documents/"), contextPath.concat("/image/image_gallery?")};
        int beginPos = -1;
        int endPos = content.length();
        while ((beginPos = StringUtil.lastIndexOfAny((String)content, (String[])patterns, (int)endPos)) != -1) {
            block9: {
                Map<String, String[]> dlReferenceParameters = this.getDLReferenceParameters(portletDataContext.getScopeGroupId(), content, beginPos + contextPath.length(), endPos);
                FileEntry fileEntry = this.getFileEntry(dlReferenceParameters);
                if (fileEntry == null) {
                    endPos = beginPos - 1;
                    continue;
                }
                endPos = MapUtil.getInteger(dlReferenceParameters, (String)"endPos");
                try {
                    if (exportReferencedContent) {
                        StagedModelDataHandlerUtil.exportReferenceStagedModel((PortletDataContext)portletDataContext, (StagedModel)stagedModel, (StagedModel)fileEntry, (String)"dependency");
                    } else {
                        Element entityElement = portletDataContext.getExportDataElement((ClassedModel)stagedModel);
                        portletDataContext.addReferenceElement((ClassedModel)stagedModel, entityElement, (ClassedModel)fileEntry, "dependency", true);
                    }
                    String path = ExportImportPathUtil.getModelPath((StagedModel)fileEntry);
                    sb.replace(beginPos, endPos, "[$dl-reference=" + path + "$]");
                    this.deleteTimestampParameters(sb, beginPos);
                }
                catch (Exception e) {
                    if (_log.isDebugEnabled()) {
                        _log.debug((Object)e, (Throwable)e);
                    }
                    if (!_log.isWarnEnabled()) break block9;
                    StringBundler exceptionSB = new StringBundler(6);
                    exceptionSB.append("Unable to process file entry ");
                    exceptionSB.append(fileEntry.getFileEntryId());
                    exceptionSB.append(" for staged model ");
                    exceptionSB.append(stagedModel.getModelClassName());
                    exceptionSB.append(" with primary key ");
                    exceptionSB.append((Object)stagedModel.getPrimaryKeyObj());
                    _log.warn((Object)exceptionSB.toString());
                }
            }
            endPos = beginPos - 1;
        }
        return sb.toString();
    }

    protected String replaceExportHostname(long groupId, String url, StringBundler urlSB) throws PortalException {
        if (!HttpUtil.hasProtocol((String)url)) {
            return url;
        }
        boolean secure = HttpUtil.isSecure((String)url);
        int serverPort = PortalUtil.getPortalServerPort((boolean)secure);
        if (serverPort == -1) {
            return url;
        }
        Group group = GroupLocalServiceUtil.getGroup((long)groupId);
        LayoutSet publicLayoutSet = group.getPublicLayoutSet();
        String publicLayoutSetVirtualHostname = publicLayoutSet.getVirtualHostname();
        String portalUrl = "";
        if (Validator.isNotNull((String)publicLayoutSetVirtualHostname) && url.startsWith(portalUrl = PortalUtil.getPortalURL((String)publicLayoutSetVirtualHostname, (int)serverPort, (boolean)secure))) {
            if (secure) {
                urlSB.append(DATA_HANDLER_PUBLIC_LAYOUT_SET_SECURE_URL);
            } else {
                urlSB.append(DATA_HANDLER_PUBLIC_LAYOUT_SET_URL);
            }
            return url.substring(portalUrl.length());
        }
        LayoutSet privateLayoutSet = group.getPrivateLayoutSet();
        String privateLayoutSetVirtualHostname = privateLayoutSet.getVirtualHostname();
        if (Validator.isNotNull((String)privateLayoutSetVirtualHostname) && url.startsWith(portalUrl = PortalUtil.getPortalURL((String)privateLayoutSetVirtualHostname, (int)serverPort, (boolean)secure))) {
            if (secure) {
                urlSB.append(DATA_HANDLER_PRIVATE_LAYOUT_SET_SECURE_URL);
            } else {
                urlSB.append(DATA_HANDLER_PRIVATE_LAYOUT_SET_URL);
            }
            return url.substring(portalUrl.length());
        }
        Company company = CompanyLocalServiceUtil.getCompany((long)group.getCompanyId());
        String companyVirtualHostname = company.getVirtualHostname();
        if (Validator.isNotNull((String)companyVirtualHostname) && url.startsWith(portalUrl = PortalUtil.getPortalURL((String)companyVirtualHostname, (int)serverPort, (boolean)secure))) {
            if (secure) {
                urlSB.append(DATA_HANDLER_COMPANY_SECURE_URL);
            } else {
                urlSB.append(DATA_HANDLER_COMPANY_URL);
            }
            return url.substring(portalUrl.length());
        }
        portalUrl = PortalUtil.getPortalURL((String)"localhost", (int)serverPort, (boolean)secure);
        if (url.startsWith(portalUrl)) {
            return url.substring(portalUrl.length());
        }
        return url;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    protected String replaceExportLayoutReferences(PortletDataContext portletDataContext, StagedModel stagedModel, String content) throws Exception {
        Group group = GroupLocalServiceUtil.getGroup((long)portletDataContext.getScopeGroupId());
        StringBuilder sb = new StringBuilder(content);
        String[] patterns = new String[]{"href=", "[["};
        int beginPos = -1;
        int endPos = content.length();
        int offset = 0;
        while (true) {
            if (beginPos > -1) {
                endPos = beginPos - 1;
            }
            if ((beginPos = StringUtil.lastIndexOfAny((String)content, (String[])patterns, (int)endPos)) == -1) return sb.toString();
            if (content.startsWith("href=", beginPos)) {
                offset = 5;
                char c = content.charAt(beginPos + offset);
                if (c == '\'' || c == '\"') {
                    ++offset;
                }
            } else if (content.charAt(beginPos) == '[') {
                offset = 2;
            }
            endPos = StringUtil.indexOfAny((String)content, (char[])LAYOUT_REFERENCE_STOP_CHARS, (int)(beginPos + offset), (int)endPos);
            if (endPos == -1) continue;
            String url = content.substring(beginPos + offset, endPos);
            StringBundler urlSB = new StringBundler(6);
            try {
                url = this.replaceExportHostname(portletDataContext.getScopeGroupId(), url, urlSB);
                if (!url.startsWith("/")) continue;
                String pathContext = PortalUtil.getPathContext();
                if (pathContext.length() > 1) {
                    if (!url.startsWith(pathContext)) continue;
                    urlSB.append(DATA_HANDLER_PATH_CONTEXT);
                    url = url.substring(pathContext.length());
                    return url;
                }
            }
            catch (Exception e) {
                if (_log.isDebugEnabled()) {
                    _log.debug((Object)e, (Throwable)e);
                    continue;
                }
                if (!_log.isWarnEnabled()) continue;
                StringBundler exceptionSB = new StringBundler(6);
                exceptionSB.append("Unable to process layout URL ");
                exceptionSB.append(url);
                exceptionSB.append(" for staged model ");
                exceptionSB.append(stagedModel.getModelClassName());
                exceptionSB.append(" with primary key ");
                exceptionSB.append((Object)stagedModel.getPrimaryKeyObj());
                _log.warn((Object)exceptionSB.toString());
                continue;
            }
            finally {
                if (urlSB.length() > 0) {
                    urlSB.append(url);
                    url = urlSB.toString();
                }
                sb.replace(beginPos + offset, endPos, url);
                continue;
            }
            break;
        }
    }

    protected String replaceExportLinksToLayouts(PortletDataContext portletDataContext, StagedModel stagedModel, String content) throws Exception {
        ArrayList<String> oldLinksToLayout = new ArrayList<String>();
        ArrayList<String> newLinksToLayout = new ArrayList<String>();
        Matcher matcher = exportLinksToLayoutPattern.matcher(content);
        while (matcher.find()) {
            long layoutId = GetterUtil.getLong((String)matcher.group(1));
            String type = matcher.group(2);
            boolean privateLayout = type.startsWith("private");
            try {
                Layout layout = LayoutLocalServiceUtil.getLayout((long)portletDataContext.getScopeGroupId(), (boolean)privateLayout, (long)layoutId);
                String oldLinkToLayout = matcher.group(0);
                StringBundler sb = new StringBundler(3);
                sb.append(type);
                sb.append("@");
                sb.append(layout.getPlid());
                String newLinkToLayout = StringUtil.replace((String)oldLinkToLayout, (String)type, (String)sb.toString());
                oldLinksToLayout.add(oldLinkToLayout);
                newLinksToLayout.add(newLinkToLayout);
                Element entityElement = portletDataContext.getExportDataElement((ClassedModel)stagedModel);
                portletDataContext.addReferenceElement((ClassedModel)stagedModel, entityElement, (ClassedModel)layout, "dependency", true);
            }
            catch (Exception e) {
                if (!_log.isDebugEnabled() && !_log.isWarnEnabled()) continue;
                String message = "Unable to get layout with ID " + layoutId + " in group " + portletDataContext.getScopeGroupId();
                if (_log.isDebugEnabled()) {
                    _log.debug((Object)message, (Throwable)e);
                    continue;
                }
                _log.warn((Object)message);
            }
        }
        content = StringUtil.replace((String)content, (String[])ArrayUtil.toStringArray((Object[])oldLinksToLayout.toArray()), (String[])ArrayUtil.toStringArray((Object[])newLinksToLayout.toArray()));
        return content;
    }

    protected String replaceImportDLReferences(PortletDataContext portletDataContext, StagedModel stagedModel, String content) throws Exception {
        List referenceElements = portletDataContext.getReferenceElements(stagedModel, DLFileEntry.class);
        for (Element referenceElement : referenceElements) {
            String path;
            long classPK;
            block10: {
                classPK = GetterUtil.getLong((String)referenceElement.attributeValue("class-pk"));
                Element referenceDataElement = portletDataContext.getReferenceDataElement(stagedModel, DLFileEntry.class, classPK);
                path = null;
                if (referenceDataElement != null) {
                    path = referenceDataElement.attributeValue("path");
                }
                long groupId = GetterUtil.getLong((String)referenceElement.attributeValue("group-id"));
                if (Validator.isNull((String)path)) {
                    String className = referenceElement.attributeValue("class-name");
                    path = ExportImportPathUtil.getModelPath((long)groupId, (String)className, (long)classPK);
                }
                if (!content.contains("[$dl-reference=" + path + "$]")) continue;
                try {
                    StagedModelDataHandlerUtil.importReferenceStagedModel((PortletDataContext)portletDataContext, (StagedModel)stagedModel, DLFileEntry.class, (long)classPK);
                }
                catch (Exception e) {
                    if (_log.isDebugEnabled()) {
                        _log.debug((Object)e, (Throwable)e);
                    }
                    if (!_log.isWarnEnabled()) break block10;
                    StringBundler sb = new StringBundler(6);
                    sb.append("Unable to process file entry ");
                    sb.append(classPK);
                    sb.append(" for ");
                    sb.append(stagedModel.getModelClassName());
                    sb.append(" with primary key ");
                    sb.append((Object)stagedModel.getPrimaryKeyObj());
                    _log.warn((Object)sb.toString());
                }
            }
            Map dlFileEntryIds = portletDataContext.getNewPrimaryKeysMap(DLFileEntry.class);
            long fileEntryId = MapUtil.getLong((Map)dlFileEntryIds, (long)classPK, (long)classPK);
            FileEntry importedFileEntry = null;
            try {
                importedFileEntry = DLAppLocalServiceUtil.getFileEntry((long)fileEntryId);
            }
            catch (PortalException pe) {
                if (_log.isDebugEnabled()) {
                    _log.debug((Object)pe, (Throwable)pe);
                    continue;
                }
                if (!_log.isWarnEnabled()) continue;
                _log.warn((Object)pe.getMessage());
                continue;
            }
            String url = DLUtil.getPreviewURL((FileEntry)importedFileEntry, (FileVersion)importedFileEntry.getFileVersion(), null, (String)"", (boolean)false, (boolean)false);
            if (url.contains("?")) {
                content = StringUtil.replace((String)content, (String)"$]?", (String)"$]&");
            }
            content = StringUtil.replace((String)content, (String)("[$dl-reference=" + path + "$]"), (String)url);
        }
        return content;
    }

    protected String replaceImportLayoutReferences(PortletDataContext portletDataContext, String content) throws Exception {
        String companyPortalURL = "";
        String privateLayoutSetPortalURL = "";
        String publicLayoutSetPortalURL = "";
        Group group = GroupLocalServiceUtil.getGroup((long)portletDataContext.getScopeGroupId());
        Company company = CompanyLocalServiceUtil.getCompany((long)group.getCompanyId());
        LayoutSet privateLayoutSet = group.getPrivateLayoutSet();
        LayoutSet publicLayoutSet = group.getPublicLayoutSet();
        int serverPort = PortalUtil.getPortalServerPort((boolean)false);
        if (serverPort != -1) {
            if (Validator.isNotNull((String)company.getVirtualHostname())) {
                companyPortalURL = PortalUtil.getPortalURL((String)company.getVirtualHostname(), (int)serverPort, (boolean)false);
            }
            if (Validator.isNotNull((String)privateLayoutSet.getVirtualHostname())) {
                privateLayoutSetPortalURL = PortalUtil.getPortalURL((String)privateLayoutSet.getVirtualHostname(), (int)serverPort, (boolean)false);
            }
            if (Validator.isNotNull((String)publicLayoutSet.getVirtualHostname())) {
                publicLayoutSetPortalURL = PortalUtil.getPortalURL((String)publicLayoutSet.getVirtualHostname(), (int)serverPort, (boolean)false);
            }
        }
        int secureSecurePort = PortalUtil.getPortalServerPort((boolean)true);
        String companySecurePortalURL = "";
        String privateLayoutSetSecurePortalURL = "";
        String publicLayoutSetSecurePortalURL = "";
        if (secureSecurePort != -1) {
            if (Validator.isNotNull((String)company.getVirtualHostname())) {
                companySecurePortalURL = PortalUtil.getPortalURL((String)company.getVirtualHostname(), (int)secureSecurePort, (boolean)true);
            }
            if (Validator.isNotNull((String)privateLayoutSet.getVirtualHostname())) {
                privateLayoutSetSecurePortalURL = PortalUtil.getPortalURL((String)privateLayoutSet.getVirtualHostname(), (int)secureSecurePort, (boolean)true);
            }
            if (Validator.isNotNull((String)publicLayoutSet.getVirtualHostname())) {
                publicLayoutSetSecurePortalURL = PortalUtil.getPortalURL((String)publicLayoutSet.getVirtualHostname(), (int)secureSecurePort, (boolean)true);
            }
        }
        content = StringUtil.replace((String)content, (String)DATA_HANDLER_COMPANY_SECURE_URL, (String)companySecurePortalURL);
        content = StringUtil.replace((String)content, (String)DATA_HANDLER_COMPANY_URL, (String)companyPortalURL);
        content = StringUtil.replace((String)content, (String)DATA_HANDLER_GROUP_FRIENDLY_URL, (String)group.getFriendlyURL());
        content = StringUtil.replace((String)content, (String)DATA_HANDLER_PATH_CONTEXT, (String)PortalUtil.getPathContext());
        content = StringUtil.replace((String)content, (String)DATA_HANDLER_PRIVATE_GROUP_SERVLET_MAPPING, (String)PropsValues.LAYOUT_FRIENDLY_URL_PRIVATE_GROUP_SERVLET_MAPPING);
        content = StringUtil.replace((String)content, (String)DATA_HANDLER_PRIVATE_LAYOUT_SET_SECURE_URL, (String)privateLayoutSetSecurePortalURL);
        content = StringUtil.replace((String)content, (String)DATA_HANDLER_PRIVATE_LAYOUT_SET_URL, (String)privateLayoutSetPortalURL);
        content = StringUtil.replace((String)content, (String)DATA_HANDLER_PRIVATE_USER_SERVLET_MAPPING, (String)PropsValues.LAYOUT_FRIENDLY_URL_PRIVATE_USER_SERVLET_MAPPING);
        content = StringUtil.replace((String)content, (String)DATA_HANDLER_PUBLIC_LAYOUT_SET_SECURE_URL, (String)publicLayoutSetSecurePortalURL);
        content = StringUtil.replace((String)content, (String)DATA_HANDLER_PUBLIC_LAYOUT_SET_URL, (String)publicLayoutSetPortalURL);
        content = StringUtil.replace((String)content, (String)DATA_HANDLER_PUBLIC_SERVLET_MAPPING, (String)PropsValues.LAYOUT_FRIENDLY_URL_PUBLIC_SERVLET_MAPPING);
        return content;
    }

    protected String replaceImportLinksToLayouts(PortletDataContext portletDataContext, String content) throws Exception {
        ArrayList<String> oldLinksToLayout = new ArrayList<String>();
        ArrayList<String> newLinksToLayout = new ArrayList<String>();
        Matcher matcher = importLinksToLayoutPattern.matcher(content);
        Map layoutPlids = portletDataContext.getNewPrimaryKeysMap(Layout.class);
        String layoutsImportMode = MapUtil.getString((Map)portletDataContext.getParameterMap(), (String)"LAYOUTS_IMPORT_MODE", (String)"MERGE_BY_LAYOUT_UUID");
        while (matcher.find()) {
            long oldLayoutId;
            long oldGroupId;
            long oldPlid = GetterUtil.getLong((String)matcher.group(4));
            Long newPlid = MapUtil.getLong((Map)layoutPlids, (long)oldPlid);
            long newGroupId = oldGroupId = GetterUtil.getLong((String)matcher.group(6));
            long newLayoutId = oldLayoutId = GetterUtil.getLong((String)matcher.group(1));
            Layout layout = LayoutLocalServiceUtil.fetchLayout((long)newPlid);
            if (layout != null) {
                newGroupId = layout.getGroupId();
                newLayoutId = layout.getLayoutId();
            } else if (_log.isWarnEnabled()) {
                _log.warn((Object)("Unable to get layout with plid " + oldPlid));
            }
            String oldLinkToLayout = matcher.group(0);
            String newLinkToLayout = StringUtil.replaceFirst((String)oldLinkToLayout, (String[])new String[]{"@" + oldPlid, String.valueOf(oldLayoutId)}, (String[])new String[]{"", String.valueOf(newLayoutId)});
            if (layout != null && layout.isPublicLayout() && layoutsImportMode.equals("CREATED_FROM_PROTOTYPE")) {
                newLinkToLayout = StringUtil.replace((String)newLinkToLayout, (String)"private-group", (String)"public");
            }
            if (oldGroupId != 0L && oldGroupId != newGroupId) {
                newLinkToLayout = StringUtil.replaceLast((String)newLinkToLayout, (String)String.valueOf(oldGroupId), (String)String.valueOf(newGroupId));
            }
            oldLinksToLayout.add(oldLinkToLayout);
            newLinksToLayout.add(newLinkToLayout);
        }
        content = StringUtil.replace((String)content, (String[])ArrayUtil.toStringArray((Object[])oldLinksToLayout.toArray()), (String[])ArrayUtil.toStringArray((Object[])newLinksToLayout.toArray()));
        return content;
    }

    protected void validateDLReferences(long groupId, String content) throws PortalException {
        String portalURL = PortalUtil.getPathContext();
        ServiceContext serviceContext = ServiceContextThreadLocal.getServiceContext();
        if (serviceContext != null && serviceContext.getThemeDisplay() != null) {
            ThemeDisplay themeDisplay = serviceContext.getThemeDisplay();
            portalURL = PortalUtil.getPortalURL((ThemeDisplay)themeDisplay) + PortalUtil.getPathContext();
        }
        String[] patterns = new String[]{portalURL.concat("/c/document_library/get_file?"), portalURL.concat("/documents/"), portalURL.concat("/image/image_gallery?")};
        int beginPos = -1;
        int endPos = content.length();
        while ((beginPos = StringUtil.lastIndexOfAny((String)content, (String[])patterns, (int)endPos)) != -1) {
            Map<String, String[]> dlReferenceParameters = this.getDLReferenceParameters(groupId, content, beginPos + portalURL.length(), endPos);
            FileEntry fileEntry = this.getFileEntry(dlReferenceParameters);
            if (fileEntry == null) {
                throw new NoSuchFileEntryException();
            }
            endPos = beginPos - 1;
        }
    }

    protected void validateLayoutReferences(long groupId, String content) throws PortalException {
        block19: {
            Group group = GroupLocalServiceUtil.getGroup((long)groupId);
            String[] patterns = new String[]{"href=", "[["};
            int beginPos = -1;
            int endPos = content.length();
            int offset = 0;
            while (true) {
                Layout layout;
                String groupFriendlyURL;
                String urlWithoutLocale;
                if (beginPos > -1) {
                    endPos = beginPos - 1;
                }
                if ((beginPos = StringUtil.lastIndexOfAny((String)content, (String[])patterns, (int)endPos)) == -1) break block19;
                if (content.startsWith("href=", beginPos)) {
                    offset = 5;
                    char c = content.charAt(beginPos + offset);
                    if (c == '\'' || c == '\"') {
                        ++offset;
                    }
                } else if (content.charAt(beginPos) == '[') {
                    offset = 2;
                }
                endPos = StringUtil.indexOfAny((String)content, (char[])LAYOUT_REFERENCE_STOP_CHARS, (int)(beginPos + offset), (int)endPos);
                if (endPos == -1) continue;
                String url = content.substring(beginPos + offset, endPos);
                StringBundler urlSB = new StringBundler(1);
                if (!(url = this.replaceExportHostname(groupId, url, urlSB)).startsWith("/")) continue;
                String pathContext = PortalUtil.getPathContext();
                if (pathContext.length() > 1) {
                    if (!url.startsWith(pathContext)) continue;
                    url = url.substring(pathContext.length());
                }
                if (!url.startsWith("/")) continue;
                int pos = url.indexOf("/", 1);
                String localePath = "";
                Locale locale = null;
                if (pos != -1) {
                    localePath = url.substring(0, pos);
                    locale = LocaleUtil.fromLanguageId((String)localePath.substring(1), (boolean)true, (boolean)false);
                }
                if (locale != null && ((urlWithoutLocale = url.substring(localePath.length())).startsWith(PRIVATE_GROUP_SERVLET_MAPPING) || urlWithoutLocale.startsWith(PRIVATE_USER_SERVLET_MAPPING) || urlWithoutLocale.startsWith(PUBLIC_GROUP_SERVLET_MAPPING))) {
                    url = urlWithoutLocale;
                }
                boolean privateLayout = false;
                if (url.startsWith(PRIVATE_GROUP_SERVLET_MAPPING)) {
                    url = url.substring(PRIVATE_GROUP_SERVLET_MAPPING.length() - 1);
                    privateLayout = true;
                } else if (url.startsWith(PRIVATE_USER_SERVLET_MAPPING)) {
                    url = url.substring(PRIVATE_USER_SERVLET_MAPPING.length() - 1);
                    privateLayout = true;
                } else if (url.startsWith(PUBLIC_GROUP_SERVLET_MAPPING)) {
                    url = url.substring(PUBLIC_GROUP_SERVLET_MAPPING.length() - 1);
                } else {
                    String urlSBString = urlSB.toString();
                    LayoutSet layoutSet = null;
                    if (urlSBString.contains(DATA_HANDLER_PUBLIC_LAYOUT_SET_SECURE_URL) || urlSBString.contains(DATA_HANDLER_PUBLIC_LAYOUT_SET_URL)) {
                        layoutSet = group.getPublicLayoutSet();
                    } else if (urlSBString.contains(DATA_HANDLER_PRIVATE_LAYOUT_SET_SECURE_URL) || urlSBString.contains(DATA_HANDLER_PRIVATE_LAYOUT_SET_URL)) {
                        layoutSet = group.getPrivateLayoutSet();
                    }
                    if (layoutSet == null) continue;
                    privateLayout = layoutSet.isPrivateLayout();
                }
                if (url.equals(groupFriendlyURL = group.getFriendlyURL())) continue;
                if (url.startsWith(groupFriendlyURL + "/")) {
                    url = url.substring(groupFriendlyURL.length());
                }
                if ((layout = LayoutLocalServiceUtil.fetchLayoutByFriendlyURL((long)groupId, (boolean)privateLayout, (String)url)) == null) break;
            }
            throw new NoSuchLayoutException();
        }
    }

    protected void validateLinksToLayoutsReferences(String content) throws PortalException {
        Matcher matcher = exportLinksToLayoutPattern.matcher(content);
        while (matcher.find()) {
            long layoutId;
            String type;
            boolean privateLayout;
            long groupId = GetterUtil.getLong((String)matcher.group(5));
            Layout layout = LayoutLocalServiceUtil.fetchLayout((long)groupId, (boolean)(privateLayout = (type = matcher.group(2)).startsWith("private")), (long)(layoutId = GetterUtil.getLong((String)matcher.group(1))));
            if (layout != null) continue;
            throw new NoSuchLayoutException();
        }
    }
}

