/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.exportimport.background.task.display;

import com.liferay.portal.kernel.backgroundtask.BackgroundTask;
import com.liferay.portal.kernel.backgroundtask.display.BaseBackgroundTaskDisplay;
import com.liferay.portal.kernel.language.LanguageUtil;
import com.liferay.portal.kernel.security.permission.ResourceActionsUtil;
import com.liferay.portal.kernel.template.TemplateResource;
import com.liferay.portal.kernel.template.URLTemplateResource;
import com.liferay.portal.kernel.util.HtmlUtil;
import com.liferay.portal.kernel.util.MapUtil;
import com.liferay.portal.kernel.util.StringBundler;
import com.liferay.portal.kernel.util.Validator;
import java.util.HashMap;
import java.util.Locale;
import java.util.Map;
import java.util.Objects;

public class ExportImportBackgroundTaskDisplay
extends BaseBackgroundTaskDisplay {
    private static final String _DETIALS_TEMPLATE = "com/liferay/exportimport/background/task/display/dependencies/export_import_background_task_details.ftl";
    private static final int _EXPORT_PHASE_MAX_PERCENTAGE = 50;
    private final long _allProgressBarCountersTotal;
    private final String _cmd;
    private final long _currentProgressBarCountersTotal;
    private String _messageKey;
    private int _percentage;
    private final String _phase;
    private final String _stagedModelName;
    private final String _stagedModelType;

    public ExportImportBackgroundTaskDisplay(BackgroundTask backgroundTask) {
        super(backgroundTask);
        Map taskContextMap = backgroundTask.getTaskContextMap();
        this._cmd = MapUtil.getString((Map)taskContextMap, (String)"cmd");
        this._percentage = -1;
        if (this.backgroundTaskStatus == null) {
            this._allProgressBarCountersTotal = 0L;
            this._currentProgressBarCountersTotal = 0L;
            this._phase = null;
            this._stagedModelName = null;
            this._stagedModelType = null;
            return;
        }
        long allModelAdditionCountersTotal = this.getBackgroundTaskStatusAttributeLong("allModelAdditionCountersTotal");
        long allPortletAdditionCounter = this.getBackgroundTaskStatusAttributeLong("allPortletAdditionCounter");
        this._allProgressBarCountersTotal = allModelAdditionCountersTotal + allPortletAdditionCounter;
        long currentModelAdditionCountersTotal = this.getBackgroundTaskStatusAttributeLong("currentModelAdditionCountersTotal");
        long currentPortletAdditionCounter = this.getBackgroundTaskStatusAttributeLong("currentPortletAdditionCounter");
        this._currentProgressBarCountersTotal = currentModelAdditionCountersTotal + currentPortletAdditionCounter;
        this._phase = this.getBackgroundTaskStatusAttributeString("phase");
        this._stagedModelName = this.getBackgroundTaskStatusAttributeString("stagedModelName");
        this._stagedModelType = this.getBackgroundTaskStatusAttributeString("stagedModelType");
    }

    public int getPercentage() {
        if (this._percentage > -1) {
            return this._percentage;
        }
        this._percentage = 100;
        if (this._allProgressBarCountersTotal > 0L) {
            int base = 100;
            if (this._phase.equals("export") && !Objects.equals(this._cmd, "publish_to_remote")) {
                base = 50;
            }
            this._percentage = Math.round((float)this._currentProgressBarCountersTotal / (float)this._allProgressBarCountersTotal * (float)base);
        }
        return this._percentage;
    }

    public boolean hasPercentage() {
        if (!this.hasBackgroundTaskStatus()) {
            return false;
        }
        return this._allProgressBarCountersTotal > 0L && (!Objects.equals(this._cmd, "publish_to_remote") || this.getPercentage() < 100);
    }

    public String renderDisplayTemplate(Locale locale) {
        if (!this.backgroundTask.isInProgress()) {
            return super.renderDisplayTemplate(locale);
        }
        if (this.hasStagedModelMessage()) {
            return this.getStagedModelMessage(locale);
        }
        return LanguageUtil.get((Locale)locale, (String)this.getStatusMessageKey());
    }

    protected String getStagedModelMessage(Locale locale) {
        StringBundler sb = new StringBundler(8);
        sb.append("<strong>");
        sb.append(LanguageUtil.get((Locale)locale, (String)this.getStatusMessageKey()));
        sb.append("...");
        sb.append("</strong>");
        sb.append(ResourceActionsUtil.getModelResource((Locale)locale, (String)this._stagedModelType));
        sb.append("<em>");
        sb.append(HtmlUtil.escape((String)this._stagedModelName));
        sb.append("</em>");
        return sb.toString();
    }

    protected String getStatusMessageKey() {
        if (Validator.isNotNull((String)this._messageKey)) {
            return this._messageKey;
        }
        this._messageKey = "";
        if (this.hasRemoteMessage()) {
            this._messageKey = "please-wait-as-the-publication-processes-on-the-remote-site";
        } else if (this.hasStagedModelMessage()) {
            this._messageKey = "exporting";
            if (Objects.equals(this._cmd, "import")) {
                this._messageKey = "importing";
            } else if (Objects.equals(this._cmd, "publish_to_live") || Objects.equals(this._cmd, "publish_to_remote")) {
                this._messageKey = "publishing";
            }
        }
        return this._messageKey;
    }

    protected TemplateResource getTemplateResource() {
        Class<?> clazz = ((Object)((Object)this)).getClass();
        ClassLoader classLoader = clazz.getClassLoader();
        return new URLTemplateResource(_DETIALS_TEMPLATE, classLoader.getResource(_DETIALS_TEMPLATE));
    }

    protected Map<String, Object> getTemplateVars() {
        HashMap<String, Object> templateVars = new HashMap<String, Object>();
        templateVars.put("exported", MapUtil.getBoolean((Map)this.backgroundTask.getTaskContextMap(), (String)"exported"));
        templateVars.put("validated", MapUtil.getBoolean((Map)this.backgroundTask.getTaskContextMap(), (String)"validated"));
        templateVars.put("htmlUtil", HtmlUtil.getHtml());
        return templateVars;
    }

    protected boolean hasRemoteMessage() {
        return Objects.equals(this._cmd, "publish_to_remote") && this.getPercentage() == 100;
    }

    protected boolean hasStagedModelMessage() {
        return Validator.isNotNull((String)this._stagedModelName) && Validator.isNotNull((String)this._stagedModelType);
    }
}

