/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.exportimport.background.task;

import com.liferay.exportimport.background.task.BaseStagingBackgroundTaskExecutor;
import com.liferay.exportimport.background.task.LayoutStagingBackgroundTaskStatusMessageTranslator;
import com.liferay.exportimport.kernel.lar.ExportImportHelperUtil;
import com.liferay.exportimport.kernel.lar.ExportImportThreadLocal;
import com.liferay.exportimport.kernel.lar.MissingReferences;
import com.liferay.exportimport.kernel.lifecycle.ExportImportLifecycleManagerUtil;
import com.liferay.exportimport.kernel.model.ExportImportConfiguration;
import com.liferay.exportimport.kernel.service.ExportImportLocalServiceUtil;
import com.liferay.portal.kernel.backgroundtask.BackgroundTask;
import com.liferay.portal.kernel.backgroundtask.BackgroundTaskExecutor;
import com.liferay.portal.kernel.backgroundtask.BackgroundTaskResult;
import com.liferay.portal.kernel.exception.NoSuchLayoutException;
import com.liferay.portal.kernel.exception.PortalException;
import com.liferay.portal.kernel.exception.SystemException;
import com.liferay.portal.kernel.log.Log;
import com.liferay.portal.kernel.log.LogFactoryUtil;
import com.liferay.portal.kernel.model.Layout;
import com.liferay.portal.kernel.security.auth.HttpPrincipal;
import com.liferay.portal.kernel.service.LayoutLocalServiceUtil;
import com.liferay.portal.kernel.util.ClassLoaderUtil;
import com.liferay.portal.kernel.util.FileUtil;
import com.liferay.portal.kernel.util.GetterUtil;
import com.liferay.portal.kernel.util.MapUtil;
import com.liferay.portal.kernel.util.StreamUtil;
import com.liferay.portal.service.http.LayoutServiceHttp;
import com.liferay.portal.util.PropsValues;
import com.liferay.portlet.exportimport.service.http.StagingServiceHttp;
import java.io.Closeable;
import java.io.File;
import java.io.FileInputStream;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;

public class LayoutRemoteStagingBackgroundTaskExecutor
extends BaseStagingBackgroundTaskExecutor {
    private static final Log _log = LogFactoryUtil.getLog(LayoutRemoteStagingBackgroundTaskExecutor.class);

    public LayoutRemoteStagingBackgroundTaskExecutor() {
        this.setBackgroundTaskStatusMessageTranslator(new LayoutStagingBackgroundTaskStatusMessageTranslator());
    }

    public BackgroundTaskExecutor clone() {
        LayoutRemoteStagingBackgroundTaskExecutor layoutRemoteStagingBackgroundTaskExecutor = new LayoutRemoteStagingBackgroundTaskExecutor();
        layoutRemoteStagingBackgroundTaskExecutor.setBackgroundTaskStatusMessageTranslator(this.getBackgroundTaskStatusMessageTranslator());
        layoutRemoteStagingBackgroundTaskExecutor.setIsolationLevel(this.getIsolationLevel());
        return layoutRemoteStagingBackgroundTaskExecutor;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public BackgroundTaskResult execute(BackgroundTask backgroundTask) {
        MissingReferences missingReferences;
        File file;
        block11: {
            ExportImportConfiguration exportImportConfiguration = this.getExportImportConfiguration(backgroundTask);
            this.clearBackgroundTaskStatus(backgroundTask);
            Thread currentThread = Thread.currentThread();
            ClassLoader contextClassLoader = currentThread.getContextClassLoader();
            file = null;
            HttpPrincipal httpPrincipal = null;
            missingReferences = null;
            long stagingRequestId = 0L;
            try {
                currentThread.setContextClassLoader(ClassLoaderUtil.getPortalClassLoader());
                ExportImportThreadLocal.setLayoutStagingInProcess((boolean)true);
                ExportImportLifecycleManagerUtil.fireExportImportLifecycleEvent((int)18, (int)32, (Serializable[])new Serializable[]{exportImportConfiguration});
                Map settingsMap = exportImportConfiguration.getSettingsMap();
                long sourceGroupId = MapUtil.getLong((Map)settingsMap, (String)"sourceGroupId");
                boolean privateLayout = MapUtil.getBoolean((Map)settingsMap, (String)"privateLayout");
                this.initThreadLocals(sourceGroupId, privateLayout);
                Map layoutIdMap = (Map)settingsMap.get("layoutIdMap");
                long targetGroupId = MapUtil.getLong((Map)settingsMap, (String)"targetGroupId");
                Map taskContextMap = backgroundTask.getTaskContextMap();
                httpPrincipal = (HttpPrincipal)taskContextMap.get("httpPrincipal");
                file = this.exportLayoutsAsFile(exportImportConfiguration, layoutIdMap, targetGroupId, httpPrincipal);
                String checksum = FileUtil.getMD5Checksum((File)file);
                stagingRequestId = StagingServiceHttp.createStagingRequest((HttpPrincipal)httpPrincipal, (long)targetGroupId, (String)checksum);
                this.transferFileToRemoteLive(file, stagingRequestId, httpPrincipal);
                this.markBackgroundTask(backgroundTask.getBackgroundTaskId(), "exported");
                missingReferences = StagingServiceHttp.publishStagingRequest((HttpPrincipal)httpPrincipal, (long)stagingRequestId, (ExportImportConfiguration)exportImportConfiguration);
                ExportImportThreadLocal.setLayoutStagingInProcess((boolean)false);
                ExportImportLifecycleManagerUtil.fireExportImportLifecycleEvent((int)17, (int)32, (Serializable[])new Serializable[]{exportImportConfiguration});
                currentThread.setContextClassLoader(contextClassLoader);
                if (stagingRequestId <= 0L || httpPrincipal == null) break block11;
            }
            catch (Throwable t) {
                try {
                    ExportImportThreadLocal.setLayoutStagingInProcess((boolean)false);
                    ExportImportLifecycleManagerUtil.fireExportImportLifecycleEvent((int)16, (int)32, (Serializable[])new Serializable[]{exportImportConfiguration});
                    if (_log.isDebugEnabled()) {
                        _log.debug((Object)t, t);
                    } else if (_log.isWarnEnabled()) {
                        _log.warn((Object)("Unable to publish layout: " + t.getMessage()));
                    }
                    this.deleteTempLarOnFailure(file);
                    throw new SystemException(t);
                }
                catch (Throwable throwable) {
                    currentThread.setContextClassLoader(contextClassLoader);
                    if (stagingRequestId <= 0L) throw throwable;
                    if (httpPrincipal == null) throw throwable;
                    try {
                        StagingServiceHttp.cleanUpStagingRequest(httpPrincipal, (long)stagingRequestId);
                        throw throwable;
                    }
                    catch (PortalException pe) {
                        _log.warn((Object)"Unable to clean up the remote live site");
                    }
                    throw throwable;
                }
            }
            try {
                StagingServiceHttp.cleanUpStagingRequest((HttpPrincipal)httpPrincipal, (long)stagingRequestId);
            }
            catch (PortalException pe) {
                _log.warn((Object)"Unable to clean up the remote live site");
            }
        }
        this.deleteTempLarOnSuccess(file);
        return this.processMissingReferences(backgroundTask.getBackgroundTaskId(), missingReferences);
    }

    protected File exportLayoutsAsFile(ExportImportConfiguration exportImportConfiguration, Map<Long, Boolean> layoutIdMap, long remoteGroupId, HttpPrincipal httpPrincipal) throws PortalException {
        ArrayList<Layout> layouts = new ArrayList<Layout>();
        if (layoutIdMap != null) {
            for (Map.Entry<Long, Boolean> entry : layoutIdMap.entrySet()) {
                long plid = GetterUtil.getLong((String)String.valueOf(entry.getKey()));
                boolean includeChildren = entry.getValue();
                Layout layout = LayoutLocalServiceUtil.getLayout((long)plid);
                if (!layouts.contains(layout)) {
                    layouts.add(layout);
                }
                List<Layout> parentLayouts = this.getMissingRemoteParentLayouts(httpPrincipal, layout, remoteGroupId);
                for (Layout parentLayout : parentLayouts) {
                    if (layouts.contains(parentLayout)) continue;
                    layouts.add(parentLayout);
                }
                if (!includeChildren) continue;
                for (Layout childLayout : layout.getAllChildren()) {
                    if (layouts.contains(childLayout)) continue;
                    layouts.add(childLayout);
                }
            }
        }
        long[] layoutIds = ExportImportHelperUtil.getLayoutIds(layouts);
        Map settingsMap = exportImportConfiguration.getSettingsMap();
        settingsMap.remove("layoutIdMap");
        settingsMap.put("layoutIds", layoutIds);
        return ExportImportLocalServiceUtil.exportLayoutsAsFile((ExportImportConfiguration)exportImportConfiguration);
    }

    protected List<Layout> getMissingRemoteParentLayouts(HttpPrincipal httpPrincipal, Layout layout, long remoteGroupId) throws PortalException {
        ArrayList<Layout> missingRemoteParentLayouts = new ArrayList<Layout>();
        long parentLayoutId = layout.getParentLayoutId();
        while (parentLayoutId > 0L) {
            Layout parentLayout = LayoutLocalServiceUtil.getLayout((long)layout.getGroupId(), (boolean)layout.isPrivateLayout(), (long)parentLayoutId);
            try {
                LayoutServiceHttp.getLayoutByUuidAndGroupId((HttpPrincipal)httpPrincipal, (String)parentLayout.getUuid(), (long)remoteGroupId, (boolean)parentLayout.getPrivateLayout());
                break;
            }
            catch (NoSuchLayoutException nsle) {
                missingRemoteParentLayouts.add(parentLayout);
                parentLayoutId = parentLayout.getParentLayoutId();
            }
        }
        return missingRemoteParentLayouts;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void transferFileToRemoteLive(File file, long stagingRequestId, HttpPrincipal httpPrincipal) throws Exception {
        byte[] bytes = new byte[PropsValues.STAGING_REMOTE_TRANSFER_BUFFER_SIZE];
        int i = 0;
        int j = 0;
        String numberFormat = String.format("%%0%dd", String.valueOf((int)(file.length() / (long)bytes.length)).length() + 1);
        FileInputStream fileInputStream = null;
        try {
            fileInputStream = new FileInputStream(file);
            while ((i = fileInputStream.read(bytes)) >= 0) {
                String fileName = file.getName() + String.format(numberFormat, j++);
                if (i < PropsValues.STAGING_REMOTE_TRANSFER_BUFFER_SIZE) {
                    byte[] tempBytes = new byte[i];
                    System.arraycopy(bytes, 0, tempBytes, 0, i);
                    StagingServiceHttp.updateStagingRequest((HttpPrincipal)httpPrincipal, (long)stagingRequestId, (String)fileName, (byte[])tempBytes);
                } else {
                    StagingServiceHttp.updateStagingRequest((HttpPrincipal)httpPrincipal, (long)stagingRequestId, (String)fileName, (byte[])bytes);
                }
                bytes = new byte[PropsValues.STAGING_REMOTE_TRANSFER_BUFFER_SIZE];
            }
        }
        catch (Throwable throwable) {
            StreamUtil.cleanUp((Closeable[])new Closeable[]{fileInputStream});
            throw throwable;
        }
        StreamUtil.cleanUp((Closeable[])new Closeable[]{fileInputStream});
    }
}

