/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.exportimport.portlet.preferences.processor.base;

import com.liferay.exportimport.kernel.lar.ExportImportThreadLocal;
import com.liferay.exportimport.kernel.lar.PortletDataContext;
import com.liferay.exportimport.kernel.staging.StagingURLHelperUtil;
import com.liferay.exportimport.portlet.preferences.processor.ExportImportPortletPreferencesProcessor;
import com.liferay.petra.lang.SafeCloseable;
import com.liferay.petra.lang.ThreadContextClassLoaderUtil;
import com.liferay.petra.string.StringBundler;
import com.liferay.portal.kernel.log.Log;
import com.liferay.portal.kernel.log.LogFactoryUtil;
import com.liferay.portal.kernel.model.Group;
import com.liferay.portal.kernel.model.Portlet;
import com.liferay.portal.kernel.model.User;
import com.liferay.portal.kernel.security.auth.HttpPrincipal;
import com.liferay.portal.kernel.security.permission.PermissionChecker;
import com.liferay.portal.kernel.security.permission.PermissionThreadLocal;
import com.liferay.portal.kernel.service.GroupLocalServiceUtil;
import com.liferay.portal.kernel.util.GetterUtil;
import com.liferay.portal.kernel.util.PortalClassLoaderUtil;
import com.liferay.portal.kernel.util.StringUtil;
import com.liferay.portal.kernel.util.UnicodeProperties;
import com.liferay.portal.kernel.util.Validator;
import com.liferay.portal.service.http.GroupServiceHttp;
import java.util.Map;
import java.util.Objects;
import javax.portlet.PortletPreferences;
import org.osgi.annotation.versioning.ProviderType;

@ProviderType
public abstract class BaseExportImportPortletPreferencesProcessor
implements ExportImportPortletPreferencesProcessor {
    private static final Log _log = LogFactoryUtil.getLog(BaseExportImportPortletPreferencesProcessor.class);

    protected String getExportPortletPreferencesExternalReferenceCode(PortletDataContext portletDataContext, Portlet portlet, String className, String externalReferenceCode) {
        return null;
    }

    protected abstract String getExportPortletPreferencesValue(PortletDataContext var1, Portlet var2, String var3, long var4) throws Exception;

    protected String getImportPortletPreferencesNewExternalReferenceCode(PortletDataContext portletDataContext, Class<?> clazz, long companyGroupId, Map<String, String[]> primaryKeys, String portletPreferencesOldExternalReferenceCode) throws Exception {
        return null;
    }

    protected abstract Long getImportPortletPreferencesNewValue(PortletDataContext var1, Class<?> var2, long var3, Map<Long, Long> var5, String var6) throws Exception;

    protected void updateExportPortletPreferencesClassPKs(PortletDataContext portletDataContext, Portlet portlet, PortletPreferences portletPreferences, String key, String className) throws Exception {
        String[] oldValues = portletPreferences.getValues(key, null);
        if (oldValues == null) {
            return;
        }
        String[] newValues = new String[oldValues.length];
        for (int i = 0; i < oldValues.length; ++i) {
            String[] primaryKeys;
            String oldValue;
            String newValue = oldValue = oldValues[i];
            for (String primaryKey : primaryKeys = StringUtil.split((String)oldValue)) {
                if (!Validator.isNumber((String)primaryKey)) break;
                long primaryKeyLong = GetterUtil.getLong((String)primaryKey);
                String newPreferencesValue = this.getExportPortletPreferencesValue(portletDataContext, portlet, className, primaryKeyLong);
                if (Validator.isNull((String)newPreferencesValue)) {
                    if (!_log.isWarnEnabled()) continue;
                    _log.warn((Object)StringBundler.concat((Object[])new Object[]{"Unable to export portlet preferences value ", "for class ", className, " with primary key ", primaryKeyLong}));
                    continue;
                }
                newValue = StringUtil.replace((String)newValue, (String)primaryKey, (String)newPreferencesValue);
            }
            newValues[i] = newValue;
        }
        portletPreferences.setValues(key, newValues);
    }

    protected void updateExportPortletPreferencesExternalReferenceCodes(PortletDataContext portletDataContext, Portlet portlet, PortletPreferences portletPreferences, String key, String className) throws Exception {
        String[] oldValues = portletPreferences.getValues(key, null);
        if (oldValues == null) {
            return;
        }
        String[] newValues = new String[oldValues.length];
        for (int i = 0; i < oldValues.length; ++i) {
            String[] externalReferenceCodes;
            String oldValue;
            String newValue = oldValue = oldValues[i];
            for (String externalReferenceCode : externalReferenceCodes = StringUtil.split((String)oldValue)) {
                String newPreferencesValue = null;
                newPreferencesValue = Objects.equals(className, Group.class.getName()) ? this._getGroupExportPortletPreferencesExternalReferenceCode(portletDataContext, externalReferenceCode) : this.getExportPortletPreferencesExternalReferenceCode(portletDataContext, portlet, className, externalReferenceCode);
                if (Validator.isNull((String)newPreferencesValue)) {
                    if (!_log.isWarnEnabled()) continue;
                    _log.warn((Object)StringBundler.concat((String[])new String[]{"Unable to export portlet preferences value ", "for class ", className, " with external ", "reference code", externalReferenceCode}));
                    continue;
                }
                newValue = StringUtil.replace((String)newValue, (String)externalReferenceCode, (String)newPreferencesValue);
            }
            newValues[i] = newValue;
        }
        portletPreferences.setValues(key, newValues);
    }

    protected void updateImportPortletPreferencesClassPKs(PortletDataContext portletDataContext, PortletPreferences portletPreferences, String key, Class<?> clazz, long companyGroupId) throws Exception {
        String[] oldValues = portletPreferences.getValues(key, null);
        if (oldValues == null) {
            return;
        }
        Map primaryKeys = portletDataContext.getNewPrimaryKeysMap(clazz);
        String[] newValues = new String[oldValues.length];
        for (int i = 0; i < oldValues.length; ++i) {
            String[] portletPreferencesOldValues;
            String oldValue;
            String newValue = oldValue = oldValues[i];
            for (String portletPreferencesOldValue : portletPreferencesOldValues = StringUtil.split((String)oldValue)) {
                Long newPrimaryKey = this.getImportPortletPreferencesNewValue(portletDataContext, clazz, companyGroupId, primaryKeys, portletPreferencesOldValue);
                if (Validator.isNull((Long)newPrimaryKey)) {
                    if (!_log.isInfoEnabled()) continue;
                    _log.info((Object)("Unable to import portlet preferences value " + portletPreferencesOldValue));
                    continue;
                }
                newValue = StringUtil.replace((String)newValue, (String)portletPreferencesOldValue, (String)newPrimaryKey.toString());
            }
            newValues[i] = newValue;
        }
        portletPreferences.setValues(key, newValues);
    }

    protected void updateImportPortletPreferencesExternalReferenceCodes(PortletDataContext portletDataContext, PortletPreferences portletPreferences, String key, Class<?> clazz, long companyGroupId) throws Exception {
        String[] oldValues = portletPreferences.getValues(key, null);
        if (oldValues == null) {
            return;
        }
        Map parameterMap = portletDataContext.getParameterMap();
        String[] newValues = new String[oldValues.length];
        for (int i = 0; i < oldValues.length; ++i) {
            String[] portletPreferencesOldValues;
            String oldValue;
            String newValue = oldValue = oldValues[i];
            for (String portletPreferencesOldValue : portletPreferencesOldValues = StringUtil.split((String)oldValue)) {
                String newExternalReferenceCode = this.getImportPortletPreferencesNewExternalReferenceCode(portletDataContext, clazz, companyGroupId, parameterMap, portletPreferencesOldValue);
                if (Validator.isNull((String)newExternalReferenceCode)) {
                    if (!_log.isInfoEnabled()) continue;
                    _log.info((Object)("Unable to import portlet preferences value " + portletPreferencesOldValue));
                    continue;
                }
                newValue = StringUtil.replace((String)newValue, (String)portletPreferencesOldValue, (String)newExternalReferenceCode);
            }
            newValues[i] = newValue;
        }
        portletPreferences.setValues(key, newValues);
    }

    private String _getGroupExportPortletPreferencesExternalReferenceCode(PortletDataContext portletDataContext, String externalReferenceCode) {
        Group group = GroupLocalServiceUtil.fetchGroupByExternalReferenceCode((String)externalReferenceCode, (long)portletDataContext.getCompanyId());
        if (group == null) {
            return externalReferenceCode;
        }
        if (ExportImportThreadLocal.isStagingInProcess() && group.isStagedRemotely()) {
            UnicodeProperties typeSettingsUnicodeProperties = group.getTypeSettingsProperties();
            String remoteGroupExternalReferenceCode = (String)typeSettingsUnicodeProperties.get((Object)"remoteGroupExternalReferenceCode");
            if (Validator.isNull((String)remoteGroupExternalReferenceCode)) {
                remoteGroupExternalReferenceCode = this._getRemoteGroupExternalReferenceCode(typeSettingsUnicodeProperties);
            }
            if (Validator.isNotNull((String)remoteGroupExternalReferenceCode)) {
                externalReferenceCode = remoteGroupExternalReferenceCode;
            }
        }
        if (!group.isStagingGroup()) {
            return externalReferenceCode;
        }
        Group liveGroup = GroupLocalServiceUtil.fetchGroup((long)group.getLiveGroupId());
        if (liveGroup == null) {
            return externalReferenceCode;
        }
        return liveGroup.getExternalReferenceCode();
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private String _getRemoteGroupExternalReferenceCode(UnicodeProperties typeSettingsUnicodeProperties) {
        String remoteAddress = GetterUtil.getString((String)((String)typeSettingsUnicodeProperties.get((Object)"remoteAddress")));
        long remoteGroupId = GetterUtil.getLong((String)((String)typeSettingsUnicodeProperties.get((Object)"remoteGroupId")));
        if (Validator.isNull((String)remoteAddress)) return null;
        if (remoteGroupId <= 0L) {
            return null;
        }
        int remotePort = GetterUtil.getInteger((String)((String)typeSettingsUnicodeProperties.get((Object)"remotePort")));
        String remotePathContext = GetterUtil.getString((String)((String)typeSettingsUnicodeProperties.get((Object)"remotePathContext")));
        boolean secureConnection = GetterUtil.getBoolean((String)((String)typeSettingsUnicodeProperties.get((Object)"secureConnection")));
        String remoteURL = StagingURLHelperUtil.buildRemoteURL((String)remoteAddress, (int)remotePort, (String)remotePathContext, (boolean)secureConnection);
        PermissionChecker permissionChecker = PermissionThreadLocal.getPermissionChecker();
        User user = permissionChecker.getUser();
        try {
            HttpPrincipal httpPrincipal = new HttpPrincipal(remoteURL, user.getLogin(), user.getPassword(), user.isPasswordEncrypted());
            try (SafeCloseable safeCloseable = ThreadContextClassLoaderUtil.swap((ClassLoader)PortalClassLoaderUtil.getClassLoader());){
                Group group = GroupServiceHttp.getGroup((HttpPrincipal)httpPrincipal, (long)remoteGroupId);
                String string = group.getExternalReferenceCode();
                return string;
            }
        }
        catch (Exception exception) {
            if (!_log.isDebugEnabled()) return null;
            _log.debug((Throwable)exception);
            return null;
        }
    }
}

