/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.exportimport.portlet.preferences.processor.base;

import com.liferay.exportimport.kernel.lar.PortletDataContext;
import com.liferay.exportimport.portlet.preferences.processor.ExportImportPortletPreferencesProcessor;
import com.liferay.petra.string.StringBundler;
import com.liferay.portal.kernel.log.Log;
import com.liferay.portal.kernel.log.LogFactoryUtil;
import com.liferay.portal.kernel.model.Portlet;
import com.liferay.portal.kernel.util.GetterUtil;
import com.liferay.portal.kernel.util.StringUtil;
import com.liferay.portal.kernel.util.Validator;
import java.util.Map;
import javax.portlet.PortletPreferences;
import org.osgi.annotation.versioning.ProviderType;

@ProviderType
public abstract class BaseExportImportPortletPreferencesProcessor
implements ExportImportPortletPreferencesProcessor {
    private static final Log _log = LogFactoryUtil.getLog(BaseExportImportPortletPreferencesProcessor.class);

    protected abstract String getExportPortletPreferencesValue(PortletDataContext var1, Portlet var2, String var3, long var4) throws Exception;

    protected abstract Long getImportPortletPreferencesNewValue(PortletDataContext var1, Class<?> var2, long var3, Map<Long, Long> var5, String var6) throws Exception;

    protected void updateExportPortletPreferencesClassPKs(PortletDataContext portletDataContext, Portlet portlet, PortletPreferences portletPreferences, String key, String className) throws Exception {
        String[] oldValues = portletPreferences.getValues(key, null);
        if (oldValues == null) {
            return;
        }
        String[] newValues = new String[oldValues.length];
        for (int i = 0; i < oldValues.length; ++i) {
            String[] primaryKeys;
            String oldValue;
            String newValue = oldValue = oldValues[i];
            for (String primaryKey : primaryKeys = StringUtil.split((String)oldValue)) {
                if (!Validator.isNumber((String)primaryKey)) break;
                long primaryKeyLong = GetterUtil.getLong((String)primaryKey);
                String newPreferencesValue = this.getExportPortletPreferencesValue(portletDataContext, portlet, className, primaryKeyLong);
                if (Validator.isNull((String)newPreferencesValue)) {
                    if (!_log.isWarnEnabled()) continue;
                    StringBundler sb = new StringBundler(5);
                    sb.append("Unable to export portlet preferences ");
                    sb.append("value for class ");
                    sb.append(className);
                    sb.append(" with primary key ");
                    sb.append(primaryKeyLong);
                    _log.warn((Object)sb.toString());
                    continue;
                }
                newValue = StringUtil.replace((String)newValue, (String)primaryKey, (String)newPreferencesValue);
            }
            newValues[i] = newValue;
        }
        portletPreferences.setValues(key, newValues);
    }

    protected void updateImportPortletPreferencesClassPKs(PortletDataContext portletDataContext, PortletPreferences portletPreferences, String key, Class<?> clazz, long companyGroupId) throws Exception {
        String[] oldValues = portletPreferences.getValues(key, null);
        if (oldValues == null) {
            return;
        }
        Map primaryKeys = portletDataContext.getNewPrimaryKeysMap(clazz);
        String[] newValues = new String[oldValues.length];
        for (int i = 0; i < oldValues.length; ++i) {
            String[] portletPreferencesOldValues;
            String oldValue;
            String newValue = oldValue = oldValues[i];
            for (String portletPreferencesOldValue : portletPreferencesOldValues = StringUtil.split((String)oldValue)) {
                Long newPrimaryKey = this.getImportPortletPreferencesNewValue(portletDataContext, clazz, companyGroupId, primaryKeys, portletPreferencesOldValue);
                if (Validator.isNull((Long)newPrimaryKey)) {
                    if (!_log.isInfoEnabled()) continue;
                    _log.info((Object)("Unable to import portlet preferences value " + portletPreferencesOldValue));
                    continue;
                }
                newValue = StringUtil.replace((String)newValue, (String)portletPreferencesOldValue, (String)newPrimaryKey.toString());
            }
            newValues[i] = newValue;
        }
        portletPreferences.setValues(key, newValues);
    }
}

