/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.exportimport.content.processor;

import com.liferay.exportimport.content.processor.ExportImportContentProcessor;
import com.liferay.osgi.util.ServiceTrackerFactory;
import com.liferay.osgi.util.StringPlus;
import com.liferay.portal.kernel.util.ListUtil;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import org.osgi.framework.Bundle;
import org.osgi.framework.BundleContext;
import org.osgi.framework.FrameworkUtil;
import org.osgi.framework.ServiceReference;
import org.osgi.util.tracker.ServiceTracker;
import org.osgi.util.tracker.ServiceTrackerCustomizer;

public class ExportImportContentProcessorRegistryUtil {
    private static final ExportImportContentProcessorRegistryUtil _instance = new ExportImportContentProcessorRegistryUtil();
    private final BundleContext _bundleContext;
    private final Map<String, ExportImportContentProcessor> _exportImportContentProcessors = new ConcurrentHashMap<String, ExportImportContentProcessor>();
    private final ServiceTracker<ExportImportContentProcessor, ExportImportContentProcessor> _serviceTracker;

    public static ExportImportContentProcessor getExportImportContentProcessor(String className) {
        return _instance._getExportImportContentProcessor(className);
    }

    public static List<ExportImportContentProcessor> getExportImportContentProcessors() {
        return _instance._getExportImportContentProcessors();
    }

    private ExportImportContentProcessorRegistryUtil() {
        Bundle bundle = FrameworkUtil.getBundle(ExportImportContentProcessorRegistryUtil.class);
        this._bundleContext = bundle.getBundleContext();
        this._serviceTracker = ServiceTrackerFactory.open((BundleContext)this._bundleContext, ExportImportContentProcessor.class, (ServiceTrackerCustomizer)new ExportImportContentProcessorServiceTrackerCustomizer());
    }

    private ExportImportContentProcessor _getExportImportContentProcessor(String className) {
        return this._exportImportContentProcessors.get(className);
    }

    private List<ExportImportContentProcessor> _getExportImportContentProcessors() {
        Collection<ExportImportContentProcessor> values = this._exportImportContentProcessors.values();
        return ListUtil.fromCollection(values);
    }

    private class ExportImportContentProcessorServiceTrackerCustomizer
    implements ServiceTrackerCustomizer<ExportImportContentProcessor, ExportImportContentProcessor> {
        private ExportImportContentProcessorServiceTrackerCustomizer() {
        }

        public ExportImportContentProcessor addingService(ServiceReference<ExportImportContentProcessor> serviceReference) {
            ExportImportContentProcessor exportImportContentProcessor = (ExportImportContentProcessor)ExportImportContentProcessorRegistryUtil.this._bundleContext.getService(serviceReference);
            List modelClassNames = StringPlus.asList((Object)serviceReference.getProperty("model.class.name"));
            for (String modelClassName : modelClassNames) {
                ExportImportContentProcessorRegistryUtil.this._exportImportContentProcessors.put(modelClassName, exportImportContentProcessor);
            }
            return exportImportContentProcessor;
        }

        public void modifiedService(ServiceReference<ExportImportContentProcessor> serviceReference, ExportImportContentProcessor exportImportContentProcessor) {
            this.removedService(serviceReference, exportImportContentProcessor);
            this.addingService((ServiceReference)serviceReference);
        }

        public void removedService(ServiceReference<ExportImportContentProcessor> serviceReference, ExportImportContentProcessor exportImportContentProcessor) {
            ExportImportContentProcessorRegistryUtil.this._bundleContext.ungetService(serviceReference);
            List modelClassNames = StringPlus.asList((Object)serviceReference.getProperty("model.class.name"));
            for (String modelClassName : modelClassNames) {
                ExportImportContentProcessorRegistryUtil.this._exportImportContentProcessors.remove(modelClassName);
            }
        }
    }
}

