/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.expando.internal.change.tracking.spi.resolver;

import com.liferay.change.tracking.spi.resolver.ConstraintResolver;
import com.liferay.change.tracking.spi.resolver.context.ConstraintResolverContext;
import com.liferay.expando.kernel.model.ExpandoRow;
import com.liferay.expando.kernel.model.ExpandoValue;
import com.liferay.expando.kernel.service.ExpandoRowLocalService;
import com.liferay.expando.kernel.service.ExpandoValueLocalService;
import com.liferay.portal.kernel.exception.PortalException;
import com.liferay.portal.language.LanguageResources;
import java.util.List;
import java.util.Locale;
import java.util.ResourceBundle;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.Reference;

@Component(service={ConstraintResolver.class})
public class ExpandoRowConstraintResolver
implements ConstraintResolver<ExpandoRow> {
    @Reference
    private ExpandoRowLocalService _expandoRowLocalService;
    @Reference
    private ExpandoValueLocalService _expandoValueLocalService;

    public String getConflictDescriptionKey() {
        return "duplicate-expando-row";
    }

    public Class<ExpandoRow> getModelClass() {
        return ExpandoRow.class;
    }

    public String getResolutionDescriptionKey() {
        return "the-conflicting-expando-row-was-deleted";
    }

    public ResourceBundle getResourceBundle(Locale locale) {
        return LanguageResources.getResourceBundle((Locale)locale);
    }

    public String[] getUniqueIndexColumnNames() {
        return new String[]{"tableId", "classPK"};
    }

    public void resolveConflict(ConstraintResolverContext<ExpandoRow> constraintResolverContext) throws PortalException {
        ExpandoRow expandoRow = (ExpandoRow)constraintResolverContext.getSourceCTModel();
        List expandoValues = this._expandoValueLocalService.getRowValues(expandoRow.getRowId());
        this._expandoRowLocalService.deleteRow(expandoRow);
        for (ExpandoValue expandoValue : expandoValues) {
            this._expandoValueLocalService.addValue(expandoValue.getClassNameId(), expandoValue.getTableId(), expandoValue.getColumnId(), expandoValue.getClassPK(), expandoValue.getData());
        }
    }
}

