/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.email.apio.internal.architect.router.base;

import com.liferay.apio.architect.identifier.Identifier;
import com.liferay.apio.architect.pagination.PageItems;
import com.liferay.apio.architect.pagination.Pagination;
import com.liferay.apio.architect.router.NestedCollectionRouter;
import com.liferay.apio.architect.routes.NestedCollectionRoutes;
import com.liferay.email.apio.architect.identifier.EmailIdentifier;
import com.liferay.portal.kernel.exception.PortalException;
import com.liferay.portal.kernel.model.Contact;
import com.liferay.portal.kernel.model.EmailAddress;
import com.liferay.portal.kernel.model.User;
import com.liferay.portal.kernel.service.EmailAddressService;
import com.liferay.portal.kernel.service.UserService;
import java.util.List;
import org.osgi.service.component.annotations.Reference;

public abstract class BaseUserAccountEmailsNestedCollectionRouter<T extends Identifier<Long>>
implements NestedCollectionRouter<EmailAddress, Long, EmailIdentifier, Long, T> {
    @Reference
    protected EmailAddressService emailAddressService;
    @Reference
    protected UserService userService;

    public NestedCollectionRoutes<EmailAddress, Long, Long> collectionRoutes(NestedCollectionRoutes.Builder<EmailAddress, Long, Long> builder) {
        return builder.addGetter(this::_getPageItems).build();
    }

    private PageItems<EmailAddress> _getPageItems(Pagination pagination, long personId) throws PortalException {
        User user = this.userService.getUserById(personId);
        List emailAddresses = this.emailAddressService.getEmailAddresses(Contact.class.getName(), user.getContactId());
        int count = emailAddresses.size();
        int endPosition = Math.min(count, pagination.getEndPosition());
        return new PageItems(emailAddresses.subList(pagination.getStartPosition(), endPosition), count);
    }
}

