/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.email.apio.internal.architect.router;

import com.liferay.apio.architect.pagination.PageItems;
import com.liferay.apio.architect.pagination.Pagination;
import com.liferay.apio.architect.router.NestedCollectionRouter;
import com.liferay.apio.architect.routes.NestedCollectionRoutes;
import com.liferay.email.apio.architect.identifier.EmailIdentifier;
import com.liferay.organization.apio.architect.identifier.OrganizationIdentifier;
import com.liferay.portal.kernel.exception.PortalException;
import com.liferay.portal.kernel.model.EmailAddress;
import com.liferay.portal.kernel.model.Organization;
import com.liferay.portal.kernel.service.EmailAddressService;
import com.liferay.portal.kernel.service.OrganizationService;
import java.util.Collection;
import java.util.List;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.Reference;

@Component(immediate=true, service={NestedCollectionRouter.class})
public class OrganizationEmailsNestedCollectionRouter
implements NestedCollectionRouter<EmailAddress, Long, EmailIdentifier, Long, OrganizationIdentifier> {
    @Reference
    private EmailAddressService _emailAddressService;
    @Reference
    private OrganizationService _organizationService;

    public NestedCollectionRoutes<EmailAddress, Long, Long> collectionRoutes(NestedCollectionRoutes.Builder<EmailAddress, Long, Long> builder) {
        return builder.addGetter(this::_getPageItems).build();
    }

    private PageItems<EmailAddress> _getPageItems(Pagination pagination, long organizationId) throws PortalException {
        Organization organization = this._organizationService.getOrganization(organizationId);
        List emailAddresses = this._emailAddressService.getEmailAddresses(organization.getModelClassName(), organization.getOrganizationId());
        return new PageItems((Collection)emailAddresses, emailAddresses.size());
    }
}

