/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.dynamic.data.mapping.web.internal.exportimport.data.handler;

import com.liferay.dynamic.data.mapping.model.DDMStructure;
import com.liferay.dynamic.data.mapping.model.DDMTemplate;
import com.liferay.dynamic.data.mapping.model.DDMTemplateVersion;
import com.liferay.dynamic.data.mapping.security.permission.DDMPermissionSupport;
import com.liferay.dynamic.data.mapping.service.DDMStructureLocalService;
import com.liferay.dynamic.data.mapping.service.DDMTemplateLocalService;
import com.liferay.dynamic.data.mapping.service.DDMTemplateVersionLocalService;
import com.liferay.dynamic.data.mapping.web.internal.exportimport.content.processor.DDMTemplateExportImportContentProcessor;
import com.liferay.exportimport.data.handler.base.BaseStagedModelDataHandler;
import com.liferay.exportimport.kernel.lar.ExportImportPathUtil;
import com.liferay.exportimport.kernel.lar.PortletDataContext;
import com.liferay.exportimport.kernel.lar.PortletDataException;
import com.liferay.exportimport.kernel.lar.StagedModelDataHandler;
import com.liferay.exportimport.kernel.lar.StagedModelDataHandlerUtil;
import com.liferay.exportimport.kernel.lar.StagedModelModifiedDateComparator;
import com.liferay.petra.string.StringBundler;
import com.liferay.portal.kernel.exception.PortalException;
import com.liferay.portal.kernel.log.Log;
import com.liferay.portal.kernel.log.LogFactoryUtil;
import com.liferay.portal.kernel.model.ClassedModel;
import com.liferay.portal.kernel.model.Group;
import com.liferay.portal.kernel.model.Image;
import com.liferay.portal.kernel.model.StagedModel;
import com.liferay.portal.kernel.service.GroupLocalService;
import com.liferay.portal.kernel.service.ImageLocalService;
import com.liferay.portal.kernel.service.ServiceContext;
import com.liferay.portal.kernel.service.UserLocalService;
import com.liferay.portal.kernel.util.FileUtil;
import com.liferay.portal.kernel.util.GetterUtil;
import com.liferay.portal.kernel.util.MapUtil;
import com.liferay.portal.kernel.util.OrderByComparator;
import com.liferay.portal.kernel.util.Portal;
import com.liferay.portal.kernel.util.Validator;
import com.liferay.portal.kernel.xml.Element;
import java.io.File;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.Reference;

@Component(immediate=true, property={"javax.portlet.name=com_liferay_dynamic_data_mapping_web_portlet_DDMPortlet"}, service={StagedModelDataHandler.class})
public class DDMTemplateStagedModelDataHandler
extends BaseStagedModelDataHandler<DDMTemplate> {
    public static final String[] CLASS_NAMES = new String[]{DDMTemplate.class.getName()};
    @Reference
    protected DDMPermissionSupport ddmPermissionSupport;
    private static final Log _log = LogFactoryUtil.getLog(DDMTemplateStagedModelDataHandler.class);
    private DDMStructureLocalService _ddmStructureLocalService;
    private DDMTemplateExportImportContentProcessor _ddmTemplateExportImportContentProcessor;
    private DDMTemplateLocalService _ddmTemplateLocalService;
    private DDMTemplateVersionLocalService _ddmTemplateVersionLocalService;
    @Reference
    private GroupLocalService _groupLocalService;
    private ImageLocalService _imageLocalService;
    @Reference
    private Portal _portal;
    private UserLocalService _userLocalService;

    public void deleteStagedModel(DDMTemplate template) throws PortalException {
        this._ddmTemplateLocalService.deleteTemplate(template);
    }

    public void deleteStagedModel(String uuid, long groupId, String className, String extraData) throws PortalException {
        DDMTemplate ddmTemplate = this.fetchStagedModelByUuidAndGroupId(uuid, groupId);
        if (ddmTemplate != null) {
            this.deleteStagedModel(ddmTemplate);
        }
    }

    public DDMTemplate fetchStagedModelByUuidAndGroupId(String uuid, long groupId) {
        return this._ddmTemplateLocalService.fetchDDMTemplateByUuidAndGroupId(uuid, groupId);
    }

    public List<DDMTemplate> fetchStagedModelsByUuidAndCompanyId(String uuid, long companyId) {
        return this._ddmTemplateLocalService.getDDMTemplatesByUuidAndCompanyId(uuid, companyId, -1, -1, (OrderByComparator)new StagedModelModifiedDateComparator());
    }

    public String[] getClassNames() {
        return CLASS_NAMES;
    }

    public String getDisplayName(DDMTemplate template) {
        return template.getNameCurrentValue();
    }

    public Map<String, String> getReferenceAttributes(PortletDataContext portletDataContext, DDMTemplate template) {
        HashMap<String, String> referenceAttributes = new HashMap<String, String>();
        referenceAttributes.put("referenced-class-name", template.getClassName());
        referenceAttributes.put("template-key", template.getTemplateKey());
        long defaultUserId = 0L;
        try {
            defaultUserId = this._userLocalService.getDefaultUserId(template.getCompanyId());
        }
        catch (Exception e) {
            return referenceAttributes;
        }
        referenceAttributes.put("preloaded", String.valueOf(this.isPreloadedTemplate(defaultUserId, template)));
        return referenceAttributes;
    }

    public boolean validateReference(PortletDataContext portletDataContext, Element referenceElement) {
        String templateKey;
        this.validateMissingGroupReference(portletDataContext, referenceElement);
        String uuid = referenceElement.attributeValue("uuid");
        Map groupIds = portletDataContext.getNewPrimaryKeysMap(Group.class);
        long groupId = GetterUtil.getLong((String)referenceElement.attributeValue("group-id"));
        groupId = MapUtil.getLong((Map)groupIds, (long)groupId);
        boolean preloaded = GetterUtil.getBoolean((String)referenceElement.attributeValue("preloaded"));
        if (!preloaded) {
            return super.validateMissingReference(uuid, groupId);
        }
        long classNameId = this._portal.getClassNameId(referenceElement.attributeValue("referenced-class-name"));
        DDMTemplate existingTemplate = this.fetchExistingTemplateWithParentGroups(uuid, groupId, classNameId, templateKey = referenceElement.attributeValue("template-key"), preloaded);
        return existingTemplate != null;
    }

    protected void doExportStagedModel(PortletDataContext portletDataContext, DDMTemplate template) throws Exception {
        block11: {
            Element templateElement = portletDataContext.getExportDataElement((ClassedModel)template);
            DDMStructure structure = this._ddmStructureLocalService.fetchStructure(template.getClassPK());
            if (structure != null) {
                StagedModelDataHandlerUtil.exportReferenceStagedModel((PortletDataContext)portletDataContext, (StagedModel)template, (StagedModel)structure, (String)"strong");
            }
            if (template.isSmallImage()) {
                if (Validator.isNotNull((String)template.getSmallImageURL())) {
                    String smallImageURL = this._ddmTemplateExportImportContentProcessor.replaceExportContentReferences(portletDataContext, (StagedModel)template, template.getSmallImageURL() + " ", true, true);
                    template.setSmallImageURL(smallImageURL);
                } else {
                    Image smallImage = this._imageLocalService.fetchImage(template.getSmallImageId());
                    if (smallImage != null && smallImage.getTextObj() != null) {
                        String smallImagePath = ExportImportPathUtil.getModelPath((StagedModel)template, (String)(smallImage.getImageId() + "." + template.getSmallImageType()));
                        templateElement.addAttribute("small-image-path", smallImagePath);
                        template.setSmallImageType(smallImage.getType());
                        portletDataContext.addZipEntry(smallImagePath, smallImage.getTextObj());
                    } else {
                        if (_log.isWarnEnabled()) {
                            StringBundler sb = new StringBundler(4);
                            sb.append("Unable to export small image ");
                            sb.append(template.getSmallImageId());
                            sb.append(" to template ");
                            sb.append(template.getTemplateKey());
                            _log.warn((Object)sb.toString());
                        }
                        template.setSmallImage(false);
                        template.setSmallImageId(0L);
                    }
                }
            }
            String script = this._ddmTemplateExportImportContentProcessor.replaceExportContentReferences(portletDataContext, (StagedModel)template, template.getScript(), portletDataContext.getBooleanParameter("dynamic_data_mapping", "referenced-content"), false);
            template.setScript(script);
            long defaultUserId = this._userLocalService.getDefaultUserId(template.getCompanyId());
            if (this.isPreloadedTemplate(defaultUserId, template)) {
                templateElement.addAttribute("preloaded", "true");
            }
            if (template.getResourceClassNameId() > 0L) {
                templateElement.addAttribute("resource-class-name", this._portal.getClassName(template.getResourceClassNameId()));
            }
            portletDataContext.addClassedModel(templateElement, ExportImportPathUtil.getModelPath((StagedModel)template), (ClassedModel)template);
            try {
                portletDataContext.addPermissions(this.getResourceName(template), template.getPrimaryKey());
            }
            catch (Exception e) {
                if (!_log.isDebugEnabled()) break block11;
                _log.debug((Object)e, (Throwable)e);
            }
        }
    }

    protected void doImportMissingReference(PortletDataContext portletDataContext, Element referenceElement) throws PortletDataException {
        this.importMissingGroupReference(portletDataContext, referenceElement);
        String uuid = referenceElement.attributeValue("uuid");
        Map groupIds = portletDataContext.getNewPrimaryKeysMap(Group.class);
        long groupId = GetterUtil.getLong((String)referenceElement.attributeValue("group-id"));
        groupId = MapUtil.getLong((Map)groupIds, (long)groupId);
        long classNameId = this._portal.getClassNameId(referenceElement.attributeValue("referenced-class-name"));
        String templateKey = referenceElement.attributeValue("template-key");
        boolean preloaded = GetterUtil.getBoolean((String)referenceElement.attributeValue("preloaded"));
        DDMTemplate existingTemplate = !preloaded ? (DDMTemplate)this.fetchMissingReference(uuid, groupId) : this.fetchExistingTemplateWithParentGroups(uuid, groupId, classNameId, templateKey, preloaded);
        if (existingTemplate == null) {
            return;
        }
        Map templateIds = portletDataContext.getNewPrimaryKeysMap(DDMTemplate.class);
        long templateId = GetterUtil.getLong((String)referenceElement.attributeValue("class-pk"));
        templateIds.put(templateId, existingTemplate.getTemplateId());
        Map templateKeys = portletDataContext.getNewPrimaryKeysMap(DDMTemplate.class + ".ddmTemplateKey");
        templateKeys.put(templateKey, existingTemplate.getTemplateKey());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void doImportStagedModel(PortletDataContext portletDataContext, DDMTemplate template) throws Exception {
        long userId = portletDataContext.getUserId(template.getUserUuid());
        long classPK = template.getClassPK();
        if (classPK > 0L) {
            Map structureIds = portletDataContext.getNewPrimaryKeysMap(DDMStructure.class);
            classPK = MapUtil.getLong((Map)structureIds, (long)classPK, (long)classPK);
        }
        Element element = portletDataContext.getImportDataStagedModelElement((StagedModel)template);
        File smallFile = null;
        try {
            DDMTemplate importedTemplate;
            block17: {
                String resourceClassName;
                if (template.isSmallImage()) {
                    byte[] bytes;
                    String smallImagePath = element.attributeValue("small-image-path");
                    if (Validator.isNotNull((String)template.getSmallImageURL())) {
                        String smallImageURL = this._ddmTemplateExportImportContentProcessor.replaceImportContentReferences(portletDataContext, (StagedModel)template, template.getSmallImageURL());
                        template.setSmallImageURL(smallImageURL);
                    } else if (Validator.isNotNull((String)smallImagePath) && (bytes = portletDataContext.getZipEntryAsByteArray(smallImagePath)) != null) {
                        smallFile = FileUtil.createTempFile((String)template.getSmallImageType());
                        FileUtil.write((File)smallFile, (byte[])bytes);
                    }
                }
                String script = this._ddmTemplateExportImportContentProcessor.replaceImportContentReferences(portletDataContext, (StagedModel)template, template.getScript());
                template.setScript(script);
                long resourceClassNameId = 0L;
                if (template.getResourceClassNameId() > 0L && Validator.isNotNull((String)(resourceClassName = element.attributeValue("resource-class-name")))) {
                    resourceClassNameId = this._portal.getClassNameId(resourceClassName);
                }
                ServiceContext serviceContext = portletDataContext.createServiceContext((StagedModel)template);
                importedTemplate = null;
                if (portletDataContext.isDataStrategyMirror()) {
                    boolean preloaded = GetterUtil.getBoolean((String)element.attributeValue("preloaded"));
                    DDMTemplate existingTemplate = this.fetchExistingTemplate(template.getUuid(), portletDataContext.getScopeGroupId(), template.getClassNameId(), template.getTemplateKey(), preloaded);
                    if (existingTemplate == null) {
                        serviceContext.setUuid(template.getUuid());
                        existingTemplate = this._ddmTemplateLocalService.fetchTemplate(portletDataContext.getScopeGroupId(), template.getClassNameId(), template.getTemplateKey());
                        String templateKey = null;
                        if (existingTemplate == null) {
                            templateKey = template.getTemplateKey();
                        }
                        importedTemplate = this._ddmTemplateLocalService.addTemplate(userId, portletDataContext.getScopeGroupId(), template.getClassNameId(), classPK, resourceClassNameId, templateKey, template.getNameMap(), template.getDescriptionMap(), template.getType(), template.getMode(), template.getLanguage(), template.getScript(), template.isCacheable(), template.isSmallImage(), template.getSmallImageURL(), smallFile, serviceContext);
                    } else {
                        importedTemplate = this._ddmTemplateLocalService.updateTemplate(userId, existingTemplate.getTemplateId(), classPK, template.getNameMap(), template.getDescriptionMap(), template.getType(), template.getMode(), template.getLanguage(), template.getScript(), template.isCacheable(), template.isSmallImage(), template.getSmallImageURL(), smallFile, serviceContext);
                    }
                } else {
                    importedTemplate = this._ddmTemplateLocalService.addTemplate(userId, portletDataContext.getScopeGroupId(), template.getClassNameId(), classPK, resourceClassNameId, null, template.getNameMap(), template.getDescriptionMap(), template.getType(), template.getMode(), template.getLanguage(), template.getScript(), template.isCacheable(), template.isSmallImage(), template.getSmallImageURL(), smallFile, serviceContext);
                }
                portletDataContext.importClassedModel((ClassedModel)template, (ClassedModel)importedTemplate);
                try {
                    portletDataContext.importPermissions(this.getResourceName(template), template.getPrimaryKey(), importedTemplate.getPrimaryKey());
                }
                catch (Exception e) {
                    if (!_log.isDebugEnabled()) break block17;
                    _log.debug((Object)e, (Throwable)e);
                }
            }
            Map ddmTemplateKeys = portletDataContext.getNewPrimaryKeysMap(DDMTemplate.class + ".ddmTemplateKey");
            ddmTemplateKeys.put(template.getTemplateKey(), importedTemplate.getTemplateKey());
        }
        finally {
            if (smallFile != null) {
                smallFile.delete();
            }
        }
    }

    protected DDMTemplate fetchExistingTemplate(String uuid, long groupId, long classNameId, String templateKey, boolean preloaded) {
        DDMTemplate existingTemplate = null;
        existingTemplate = !preloaded ? this.fetchStagedModelByUuidAndGroupId(uuid, groupId) : this._ddmTemplateLocalService.fetchTemplate(groupId, classNameId, templateKey);
        return existingTemplate;
    }

    protected DDMTemplate fetchExistingTemplateWithParentGroups(String uuid, long groupId, long classNameId, String templateKey, boolean preloaded) {
        Group group = this._groupLocalService.fetchGroup(groupId);
        if (group == null) {
            return null;
        }
        long companyId = group.getCompanyId();
        while (group != null) {
            DDMTemplate existingTemplate = this.fetchExistingTemplate(uuid, group.getGroupId(), classNameId, templateKey, preloaded);
            if (existingTemplate != null) {
                return existingTemplate;
            }
            group = group.getParentGroup();
        }
        Group companyGroup = this._groupLocalService.fetchCompanyGroup(companyId);
        if (companyGroup == null) {
            return null;
        }
        return this.fetchExistingTemplate(uuid, companyGroup.getGroupId(), classNameId, templateKey, preloaded);
    }

    protected String getResourceName(DDMTemplate template) throws PortalException {
        return this.ddmPermissionSupport.getTemplateModelResourceName(template.getResourceClassName());
    }

    protected boolean isPreloadedTemplate(long defaultUserId, DDMTemplate template) {
        if (defaultUserId == template.getUserId()) {
            return true;
        }
        DDMTemplateVersion ddmTemplateVersion = null;
        try {
            ddmTemplateVersion = this._ddmTemplateVersionLocalService.getTemplateVersion(template.getTemplateId(), "1.0");
        }
        catch (PortalException pe) {
            _log.error((Object)pe, (Throwable)pe);
        }
        return ddmTemplateVersion != null && defaultUserId == ddmTemplateVersion.getUserId();
    }

    @Reference(unbind="-")
    protected void setDDMStructureLocalService(DDMStructureLocalService ddmStructureLocalService) {
        this._ddmStructureLocalService = ddmStructureLocalService;
    }

    @Reference(unbind="-")
    protected void setDDMTemplateExportImportContentProcessor(DDMTemplateExportImportContentProcessor ddmTemplateExportImportContentProcessor) {
        this._ddmTemplateExportImportContentProcessor = ddmTemplateExportImportContentProcessor;
    }

    @Reference(unbind="-")
    protected void setDDMTemplateLocalService(DDMTemplateLocalService ddmTemplateLocalService) {
        this._ddmTemplateLocalService = ddmTemplateLocalService;
    }

    @Reference(unbind="-")
    protected void setDDMTemplateVersionLocalService(DDMTemplateVersionLocalService ddmTemplateVersionLocalService) {
        this._ddmTemplateVersionLocalService = ddmTemplateVersionLocalService;
    }

    @Reference(unbind="-")
    protected void setImageLocalService(ImageLocalService imageLocalService) {
        this._imageLocalService = imageLocalService;
    }

    @Reference(unbind="-")
    protected void setUserLocalService(UserLocalService userLocalService) {
        this._userLocalService = userLocalService;
    }
}

