/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.dynamic.data.mapping.web.internal.portlet.action;

import com.liferay.dynamic.data.mapping.exception.TemplateScriptException;
import com.liferay.dynamic.data.mapping.model.DDMTemplate;
import com.liferay.dynamic.data.mapping.service.DDMTemplateService;
import com.liferay.dynamic.data.mapping.web.internal.portlet.action.DDMBaseMVCActionCommand;
import com.liferay.portal.kernel.portlet.bridges.mvc.MVCActionCommand;
import com.liferay.portal.kernel.service.ServiceContext;
import com.liferay.portal.kernel.service.ServiceContextFactory;
import com.liferay.portal.kernel.upload.UploadPortletRequest;
import com.liferay.portal.kernel.util.FileUtil;
import com.liferay.portal.kernel.util.LocalizationUtil;
import com.liferay.portal.kernel.util.MimeTypesUtil;
import com.liferay.portal.kernel.util.ParamUtil;
import com.liferay.portal.kernel.util.Portal;
import com.liferay.portal.kernel.util.Validator;
import java.io.File;
import java.util.Map;
import javax.portlet.ActionRequest;
import javax.portlet.ActionResponse;
import javax.portlet.PortletRequest;
import javax.servlet.http.HttpServletRequest;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.Reference;

@Component(immediate=true, property={"javax.portlet.name=com_liferay_dynamic_data_mapping_web_portlet_DDMPortlet", "javax.portlet.name=com_liferay_dynamic_data_mapping_web_portlet_PortletDisplayTemplatePortlet", "mvc.command.name=addTemplate"}, service={MVCActionCommand.class})
public class AddTemplateMVCActionCommand
extends DDMBaseMVCActionCommand {
    protected DDMTemplateService ddmTemplateService;
    @Reference
    protected Portal portal;

    protected DDMTemplate addTemplate(ActionRequest actionRequest) throws Exception {
        UploadPortletRequest uploadPortletRequest = this.portal.getUploadPortletRequest((PortletRequest)actionRequest);
        long groupId = ParamUtil.getLong((HttpServletRequest)uploadPortletRequest, (String)"groupId");
        long classNameId = ParamUtil.getLong((HttpServletRequest)uploadPortletRequest, (String)"classNameId");
        long classPK = ParamUtil.getLong((HttpServletRequest)uploadPortletRequest, (String)"classPK");
        long resourceClassNameId = ParamUtil.getLong((HttpServletRequest)uploadPortletRequest, (String)"resourceClassNameId");
        String templateKey = ParamUtil.getString((HttpServletRequest)uploadPortletRequest, (String)"templateKey");
        Map nameMap = LocalizationUtil.getLocalizationMap((HttpServletRequest)uploadPortletRequest, (String)"name");
        Map descriptionMap = LocalizationUtil.getLocalizationMap((HttpServletRequest)uploadPortletRequest, (String)"description");
        String type = ParamUtil.getString((HttpServletRequest)uploadPortletRequest, (String)"type");
        String mode = ParamUtil.getString((HttpServletRequest)uploadPortletRequest, (String)"mode");
        String language = ParamUtil.getString((HttpServletRequest)uploadPortletRequest, (String)"language", (String)"vm");
        String script = this.getScript(uploadPortletRequest);
        boolean cacheable = ParamUtil.getBoolean((HttpServletRequest)uploadPortletRequest, (String)"cacheable");
        boolean smallImage = ParamUtil.getBoolean((HttpServletRequest)uploadPortletRequest, (String)"smallImage");
        String smallImageURL = ParamUtil.getString((HttpServletRequest)uploadPortletRequest, (String)"smallImageURL");
        File smallImageFile = uploadPortletRequest.getFile("smallImageFile");
        ServiceContext serviceContext = ServiceContextFactory.getInstance((String)DDMTemplate.class.getName(), (UploadPortletRequest)uploadPortletRequest);
        return this.ddmTemplateService.addTemplate(groupId, classNameId, classPK, resourceClassNameId, templateKey, nameMap, descriptionMap, type, mode, language, script, cacheable, smallImage, smallImageURL, smallImageFile, serviceContext);
    }

    protected void doProcessAction(ActionRequest actionRequest, ActionResponse actionResponse) throws Exception {
        DDMTemplate template = this.addTemplate(actionRequest);
        this.updatePortletPreferences(actionRequest, template);
        this.addSuccessMessage(actionRequest, actionResponse);
        this.setRedirectAttribute(actionRequest, template);
    }

    protected String getFileScriptContent(UploadPortletRequest uploadPortletRequest) throws Exception {
        File file = uploadPortletRequest.getFile("script");
        if (file == null) {
            return null;
        }
        String fileScriptContent = FileUtil.read((File)file);
        String contentType = MimeTypesUtil.getContentType((File)file);
        if (Validator.isNotNull((String)fileScriptContent) && !this.isValidContentType(contentType)) {
            throw new TemplateScriptException("Invalid contentType " + contentType);
        }
        return fileScriptContent;
    }

    protected String getScript(UploadPortletRequest uploadPortletRequest) throws Exception {
        String fileScriptContent = this.getFileScriptContent(uploadPortletRequest);
        if (Validator.isNotNull((String)fileScriptContent)) {
            return fileScriptContent;
        }
        return ParamUtil.getString((HttpServletRequest)uploadPortletRequest, (String)"scriptContent");
    }

    protected boolean isValidContentType(String contentType) {
        return contentType.equals("application/xslt+xml") || contentType.startsWith("text");
    }

    @Reference(unbind="-")
    protected void setDDMTemplateService(DDMTemplateService ddmTemplateService) {
        this.ddmTemplateService = ddmTemplateService;
    }
}

