/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.dynamic.data.mapping.web.internal.display.context;

import com.liferay.dynamic.data.mapping.configuration.DDMGroupServiceConfiguration;
import com.liferay.dynamic.data.mapping.model.DDMStructure;
import com.liferay.dynamic.data.mapping.model.DDMTemplate;
import com.liferay.dynamic.data.mapping.service.DDMStructureLinkLocalService;
import com.liferay.dynamic.data.mapping.service.DDMStructureService;
import com.liferay.dynamic.data.mapping.service.DDMTemplateService;
import com.liferay.dynamic.data.mapping.storage.StorageAdapterRegistry;
import com.liferay.dynamic.data.mapping.util.DDMDisplay;
import com.liferay.dynamic.data.mapping.util.DDMDisplayRegistry;
import com.liferay.dynamic.data.mapping.util.DDMDisplayTabItem;
import com.liferay.dynamic.data.mapping.util.DDMTemplateHelper;
import com.liferay.dynamic.data.mapping.util.DDMUtil;
import com.liferay.dynamic.data.mapping.web.configuration.DDMWebConfiguration;
import com.liferay.dynamic.data.mapping.web.internal.context.util.DDMWebRequestHelper;
import com.liferay.dynamic.data.mapping.web.internal.search.StructureSearch;
import com.liferay.dynamic.data.mapping.web.internal.search.StructureSearchTerms;
import com.liferay.dynamic.data.mapping.web.internal.search.TemplateSearch;
import com.liferay.dynamic.data.mapping.web.internal.search.TemplateSearchTerms;
import com.liferay.dynamic.data.mapping.web.internal.security.permission.resource.DDMStructurePermission;
import com.liferay.dynamic.data.mapping.web.internal.security.permission.resource.DDMTemplatePermission;
import com.liferay.dynamic.data.mapping.web.internal.util.PortletDisplayTemplateUtil;
import com.liferay.frontend.taglib.clay.servlet.taglib.util.CreationMenu;
import com.liferay.frontend.taglib.clay.servlet.taglib.util.DropdownItem;
import com.liferay.frontend.taglib.clay.servlet.taglib.util.DropdownItemList;
import com.liferay.frontend.taglib.clay.servlet.taglib.util.NavigationItem;
import com.liferay.frontend.taglib.clay.servlet.taglib.util.NavigationItemList;
import com.liferay.portal.kernel.dao.search.SearchContainer;
import com.liferay.portal.kernel.exception.PortalException;
import com.liferay.portal.kernel.language.LanguageUtil;
import com.liferay.portal.kernel.model.Layout;
import com.liferay.portal.kernel.portlet.LiferayPortletRequest;
import com.liferay.portal.kernel.portlet.LiferayPortletResponse;
import com.liferay.portal.kernel.portlet.PortalPreferences;
import com.liferay.portal.kernel.portlet.PortletPreferencesFactoryUtil;
import com.liferay.portal.kernel.portlet.PortletURLUtil;
import com.liferay.portal.kernel.security.permission.PermissionChecker;
import com.liferay.portal.kernel.service.permission.PortletPermissionUtil;
import com.liferay.portal.kernel.template.TemplateHandler;
import com.liferay.portal.kernel.template.TemplateHandlerRegistryUtil;
import com.liferay.portal.kernel.template.comparator.TemplateHandlerComparator;
import com.liferay.portal.kernel.theme.ThemeDisplay;
import com.liferay.portal.kernel.util.GetterUtil;
import com.liferay.portal.kernel.util.ListUtil;
import com.liferay.portal.kernel.util.OrderByComparator;
import com.liferay.portal.kernel.util.ParamUtil;
import com.liferay.portal.kernel.util.PortalUtil;
import com.liferay.portal.kernel.util.Validator;
import com.liferay.portlet.display.template.PortletDisplayTemplate;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.Iterator;
import java.util.List;
import java.util.Objects;
import java.util.Set;
import java.util.function.Consumer;
import javax.portlet.MimeResponse;
import javax.portlet.PortletException;
import javax.portlet.PortletRequest;
import javax.portlet.PortletURL;
import javax.portlet.RenderRequest;
import javax.portlet.RenderResponse;
import javax.servlet.http.HttpServletRequest;

public class DDMDisplayContext {
    private final DDMDisplayRegistry _ddmDisplayRegistry;
    private final DDMStructureLinkLocalService _ddmStructureLinkLocalService;
    private final DDMStructureService _ddmStructureService;
    private final DDMTemplateHelper _ddmTemplateHelper;
    private final DDMTemplateService _ddmTemplateService;
    private final DDMWebConfiguration _ddmWebConfiguration;
    private final DDMWebRequestHelper _ddmWebRequestHelper;
    private final RenderRequest _renderRequest;
    private final RenderResponse _renderResponse;
    private final StorageAdapterRegistry _storageAdapterRegistry;

    public DDMDisplayContext(RenderRequest renderRequest, RenderResponse renderResponse, DDMDisplayRegistry ddmDisplayRegistry, DDMStructureLinkLocalService ddmStructureLinkLocalService, DDMStructureService ddmStructureService, DDMTemplateHelper ddmTemplateHelper, DDMTemplateService ddmTemplateService, DDMWebConfiguration ddmWebConfiguration, StorageAdapterRegistry storageAdapterRegistry) {
        this._renderRequest = renderRequest;
        this._renderResponse = renderResponse;
        this._ddmDisplayRegistry = ddmDisplayRegistry;
        this._ddmStructureLinkLocalService = ddmStructureLinkLocalService;
        this._ddmStructureService = ddmStructureService;
        this._ddmTemplateHelper = ddmTemplateHelper;
        this._ddmTemplateService = ddmTemplateService;
        this._ddmWebConfiguration = ddmWebConfiguration;
        this._storageAdapterRegistry = storageAdapterRegistry;
        HttpServletRequest httpServletRequest = PortalUtil.getHttpServletRequest((PortletRequest)renderRequest);
        this._ddmWebRequestHelper = new DDMWebRequestHelper(httpServletRequest);
    }

    public boolean autogenerateStructureKey() {
        return this._ddmWebConfiguration.autogenerateStructureKey();
    }

    public boolean autogenerateTemplateKey() {
        return this._ddmWebConfiguration.autogenerateTemplateKey();
    }

    public boolean changeableDefaultLanguage() {
        return this._ddmWebConfiguration.changeableDefaultLanguage();
    }

    public boolean containsAddTemplatePermission(String actualTemplateTypeValue) throws PortalException {
        DDMDisplay ddmDisplay = this.getDDMDisplay();
        String expectedTemplateTypeValue = this.getTemplateTypeValue();
        long scopeClassNameId = PortalUtil.getClassNameId((String)ddmDisplay.getStructureType());
        return DDMTemplatePermission.containsAddTemplatePermission(this._ddmWebRequestHelper.getPermissionChecker(), this._ddmWebRequestHelper.getScopeGroupId(), this.getClassNameId(), scopeClassNameId) && (Validator.isNull((String)expectedTemplateTypeValue) || expectedTemplateTypeValue.equals(actualTemplateTypeValue));
    }

    public DDMStructure fetchStructure(DDMTemplate template) {
        return this._ddmTemplateHelper.fetchStructure(template);
    }

    public List<DropdownItem> getActionItemsDropdownItems(final String action) {
        return new DropdownItemList(){
            {
                this.add(dropdownItem -> {
                    dropdownItem.putData("action", action);
                    dropdownItem.setIcon("times");
                    dropdownItem.setLabel(LanguageUtil.get((HttpServletRequest)DDMDisplayContext.this._ddmWebRequestHelper.getRequest(), (String)"delete"));
                    dropdownItem.setQuickAction(true);
                });
            }
        };
    }

    public String getAutocompleteJSON(HttpServletRequest request, String language) throws Exception {
        return this._ddmTemplateHelper.getAutocompleteJSON(request, language);
    }

    public String getClearResultsURL() throws PortletException {
        PortletURL clearResultsURL = PortletURLUtil.clone((PortletURL)this.getPortletURL(), (MimeResponse)this._renderResponse);
        clearResultsURL.setParameter("keywords", "");
        return clearResultsURL.toString();
    }

    public DDMDisplay getDDMDisplay() {
        return this._ddmDisplayRegistry.getDDMDisplay(this.getRefererPortletName());
    }

    public List<DropdownItem> getFilterItemsDropdownItems() {
        return new DropdownItemList(){
            {
                this.addGroup(dropdownGroupItem -> {
                    dropdownGroupItem.setDropdownItems(DDMDisplayContext.this.getFilterNavigationDropdownItems());
                    dropdownGroupItem.setLabel(LanguageUtil.get((HttpServletRequest)DDMDisplayContext.this._ddmWebRequestHelper.getRequest(), (String)"filter-by-navigation"));
                });
                this.addGroup(dropdownGroupItem -> {
                    dropdownGroupItem.setDropdownItems(DDMDisplayContext.this.getOrderByDropdownItems());
                    dropdownGroupItem.setLabel(LanguageUtil.get((HttpServletRequest)DDMDisplayContext.this._ddmWebRequestHelper.getRequest(), (String)"order-by"));
                });
            }
        };
    }

    public List<NavigationItem> getNavigationItem() {
        return new NavigationItemList(){
            {
                this.add(navigationItem -> {
                    navigationItem.setActive(true);
                    navigationItem.setHref((Object)"");
                    navigationItem.setLabel(DDMDisplayContext.this.getScopedStructureLabel());
                });
            }
        };
    }

    public List<NavigationItem> getNavigationItems(final LiferayPortletRequest liferayPortletRequest, final LiferayPortletResponse liferayPortletResponse) throws Exception {
        return new NavigationItemList(){
            {
                DDMDisplay ddmDisplay = DDMDisplayContext.this.getDDMDisplay();
                for (DDMDisplayTabItem ddmDisplayTabItem : ddmDisplay.getTabItems()) {
                    String ddmDisplayTabItemTitle = GetterUtil.getString((String)ddmDisplayTabItem.getTitle(liferayPortletRequest, liferayPortletResponse));
                    DDMDisplayTabItem defaultDDMDisplayTabItem = ddmDisplay.getDefaultTabItem();
                    String defaultDDMDisplayTabItemTitle = GetterUtil.getString((String)defaultDDMDisplayTabItem.getTitle(liferayPortletRequest, liferayPortletResponse));
                    String ddmDisplayTabItemHREF = GetterUtil.getString((String)ddmDisplayTabItem.getURL(liferayPortletRequest, liferayPortletResponse));
                    this.add(navigationItem -> {
                        navigationItem.setActive(Objects.equals(ddmDisplayTabItemTitle, defaultDDMDisplayTabItemTitle));
                        navigationItem.setHref((Object)ddmDisplayTabItemHREF);
                        navigationItem.setLabel(ddmDisplayTabItemTitle);
                    });
                }
            }
        };
    }

    public String getOrderByCol() {
        PortalPreferences portalPreferences = PortletPreferencesFactoryUtil.getPortalPreferences((PortletRequest)this._renderRequest);
        String orderByCol = ParamUtil.getString((PortletRequest)this._renderRequest, (String)"orderByCol");
        if (Validator.isNull((String)orderByCol)) {
            orderByCol = portalPreferences.getValue("com_liferay_dynamic_data_mapping_web_portlet_DDMPortlet", "entries-order-by-col", "modified-date");
        } else {
            portalPreferences.setValue("com_liferay_dynamic_data_mapping_web_portlet_DDMPortlet", "entries-order-by-col", orderByCol);
        }
        return orderByCol;
    }

    public String getOrderByType() {
        PortalPreferences portalPreferences = PortletPreferencesFactoryUtil.getPortalPreferences((PortletRequest)this._renderRequest);
        String orderByType = ParamUtil.getString((PortletRequest)this._renderRequest, (String)"orderByType");
        if (Validator.isNull((String)orderByType)) {
            orderByType = portalPreferences.getValue("com_liferay_dynamic_data_mapping_web_portlet_DDMPortlet", "entries-order-by-type", "asc");
        } else {
            portalPreferences.setValue("com_liferay_dynamic_data_mapping_web_portlet_DDMPortlet", "entries-order-by-type", orderByType);
        }
        return orderByType;
    }

    public String getRefererPortletName() {
        return ParamUtil.getString((HttpServletRequest)this._ddmWebRequestHelper.getRequest(), (String)"refererPortletName", (String)this._ddmWebRequestHelper.getPortletName());
    }

    public CreationMenu getSelectStructureCreationMenu() throws PortalException {
        if (!this.isShowAddStructureButton()) {
            return null;
        }
        return new CreationMenu(){
            {
                PortletURL redirect = DDMDisplayContext.this._renderResponse.createRenderURL();
                redirect.setParameter("mvcPath", "/select_structure.jsp");
                redirect.setParameter("classPK", String.valueOf(DDMDisplayContext.this.getClassPK()));
                redirect.setParameter("eventName", ParamUtil.getString((PortletRequest)DDMDisplayContext.this._renderRequest, (String)"eventName", (String)"selectStructure"));
                this.addPrimaryDropdownItem(dropdownItem -> {
                    dropdownItem.setHref(DDMDisplayContext.this._renderResponse.createRenderURL(), new Object[]{"mvcPath", "/edit_structure.jsp", "redirect", redirect, "groupId", String.valueOf(DDMDisplayContext.this._ddmWebRequestHelper.getScopeGroupId())});
                    dropdownItem.setLabel(LanguageUtil.get((HttpServletRequest)DDMDisplayContext.this._ddmWebRequestHelper.getRequest(), (String)"add"));
                });
            }
        };
    }

    public String getSelectStructureSearchActionURL() {
        PortletURL portletURL = this._renderResponse.createRenderURL();
        portletURL.setParameter("mvcPath", "/select_structure.jsp");
        portletURL.setParameter("classPK", String.valueOf(ParamUtil.getLong((PortletRequest)this._renderRequest, (String)"classPK")));
        portletURL.setParameter("eventName", ParamUtil.getString((PortletRequest)this._renderRequest, (String)"eventName", (String)"selectStructure"));
        return portletURL.toString();
    }

    public String getSelectTemplateSearchActionURL() {
        PortletURL portletURL = this._renderResponse.createRenderURL();
        portletURL.setParameter("mvcPath", "/select_template.jsp");
        portletURL.setParameter("templateId", String.valueOf(ParamUtil.getLong((PortletRequest)this._renderRequest, (String)"templateId")));
        portletURL.setParameter("classNameId", String.valueOf(this.getClassNameId()));
        portletURL.setParameter("classPK", String.valueOf(ParamUtil.getLong((PortletRequest)this._renderRequest, (String)"classPK")));
        portletURL.setParameter("resourceClassNameId", String.valueOf(this.getResourceClassNameId()));
        portletURL.setParameter("eventName", ParamUtil.getString((PortletRequest)this._renderRequest, (String)"eventName", (String)"selectTemplate"));
        return portletURL.toString();
    }

    public String getSortingURL() throws Exception {
        PortletURL sortingURL = PortletURLUtil.clone((PortletURL)this.getPortletURL(), (MimeResponse)this._renderResponse);
        String orderByType = ParamUtil.getString((PortletRequest)this._renderRequest, (String)"orderByType");
        sortingURL.setParameter("orderByType", orderByType.equals("asc") ? "desc" : "asc");
        return sortingURL.toString();
    }

    public Set<String> getStorageTypes() {
        return this._storageAdapterRegistry.getStorageTypes();
    }

    public CreationMenu getStructureCreationMenu() throws PortalException {
        if (!this.isShowAddStructureButton()) {
            return null;
        }
        PortletURL redirect = this._renderResponse.createRenderURL();
        redirect.setParameter("mvcPath", "/view.jsp");
        redirect.setParameter("groupId", String.valueOf(this._ddmWebRequestHelper.getScopeGroupId()));
        final PortletURL addTemplateURL = this._renderResponse.createRenderURL();
        addTemplateURL.setParameter("mvcPath", "/edit_structure.jsp");
        addTemplateURL.setParameter("redirect", redirect.toString());
        addTemplateURL.setParameter("groupId", String.valueOf(this._ddmWebRequestHelper.getScopeGroupId()));
        return new CreationMenu(){
            {
                this.addPrimaryDropdownItem(DDMDisplayContext.this.getCreationMenuDropdownItem(addTemplateURL, "add"));
            }
        };
    }

    public SearchContainer<DDMStructure> getStructureSearch() throws Exception {
        PortletURL portletURL = this.getPortletURL();
        StructureSearch structureSearch = new StructureSearch((PortletRequest)this._renderRequest, portletURL);
        String orderByCol = this.getOrderByCol();
        String orderByType = this.getOrderByType();
        OrderByComparator orderByComparator = DDMUtil.getStructureOrderByComparator((String)this.getOrderByCol(), (String)this.getOrderByType());
        structureSearch.setOrderByCol(orderByCol);
        structureSearch.setOrderByComparator(orderByComparator);
        structureSearch.setOrderByType(orderByType);
        if (structureSearch.isSearch()) {
            structureSearch.setEmptyResultsMessage(LanguageUtil.format((HttpServletRequest)this._ddmWebRequestHelper.getRequest(), (String)"no-x-were-found", (Object)this.getScopedStructureLabel(), (boolean)false));
        } else {
            structureSearch.setEmptyResultsMessage(LanguageUtil.format((HttpServletRequest)this._ddmWebRequestHelper.getRequest(), (String)"there-are-no-x", (Object)this.getScopedStructureLabel(), (boolean)false));
        }
        this.setDDMStructureSearchResults(structureSearch);
        this.setDDMStructureSearchTotal(structureSearch);
        return structureSearch;
    }

    public String getStructureSearchActionURL() {
        PortletURL portletURL = this._renderResponse.createRenderURL();
        portletURL.setParameter("mvcPath", "/view.jsp");
        portletURL.setParameter("tabs1", ParamUtil.getString((PortletRequest)this._renderRequest, (String)"tabs1", (String)"structures"));
        portletURL.setParameter("groupId", String.valueOf(this._ddmWebRequestHelper.getScopeGroupId()));
        return portletURL.toString();
    }

    public String getStructureSearchContainerId() {
        return "ddmStructures";
    }

    public CreationMenu getTemplateCreationMenu() throws PortalException {
        if (!this.isShowAddTemplateButton()) {
            return null;
        }
        return new CreationMenu(){
            {
                String message = "add";
                if (DDMDisplayContext.this.getClassNameId() == PortalUtil.getClassNameId(DDMStructure.class)) {
                    PortletURL addTemplateURL = DDMDisplayContext.this._renderResponse.createRenderURL();
                    addTemplateURL.setParameter("mvcPath", "/edit_template.jsp");
                    addTemplateURL.setParameter("groupId", String.valueOf(DDMDisplayContext.this._ddmWebRequestHelper.getScopeGroupId()));
                    addTemplateURL.setParameter("classNameId", String.valueOf(DDMDisplayContext.this.getClassNameId()));
                    addTemplateURL.setParameter("classPK", String.valueOf(DDMDisplayContext.this.getClassPK()));
                    addTemplateURL.setParameter("resourceClassNameId", String.valueOf(DDMDisplayContext.this.getResourceClassNameId()));
                    if (DDMDisplayContext.this.containsAddTemplatePermission("form")) {
                        addTemplateURL.setParameter("structureAvailableFields", DDMDisplayContext.this._renderResponse.getNamespace() + "getAvailableFields");
                        if (Validator.isNull((String)DDMDisplayContext.this.getTemplateTypeValue())) {
                            message = "add-form-template";
                        }
                        this.addPrimaryDropdownItem(DDMDisplayContext.this.getCreationMenuDropdownItem(addTemplateURL, message));
                    }
                    if (DDMDisplayContext.this.containsAddTemplatePermission("display")) {
                        addTemplateURL.setParameter("type", "display");
                        if (Validator.isNull((String)DDMDisplayContext.this.getTemplateTypeValue())) {
                            message = "add-display-template";
                        }
                        this.addPrimaryDropdownItem(DDMDisplayContext.this.getCreationMenuDropdownItem(addTemplateURL, message));
                    }
                } else {
                    List<TemplateHandler> templateHandlers = DDMDisplayContext.this.getTemplateHandlers();
                    if (!templateHandlers.isEmpty()) {
                        PortletURL addPortletDisplayTemplateURL = DDMDisplayContext.this._renderResponse.createRenderURL();
                        addPortletDisplayTemplateURL.setParameter("mvcPath", "/edit_template.jsp");
                        addPortletDisplayTemplateURL.setParameter("groupId", String.valueOf(DDMDisplayContext.this._ddmWebRequestHelper.getScopeGroupId()));
                        addPortletDisplayTemplateURL.setParameter("type", "display");
                        for (TemplateHandler templateHandler : templateHandlers) {
                            addPortletDisplayTemplateURL.setParameter("classNameId", String.valueOf(PortalUtil.getClassNameId((String)templateHandler.getClassName())));
                            addPortletDisplayTemplateURL.setParameter("classPK", String.valueOf(0));
                            addPortletDisplayTemplateURL.setParameter("resourceClassNameId", String.valueOf(DDMDisplayContext.this.getResourceClassNameId()));
                            this.addPrimaryDropdownItem(DDMDisplayContext.this.getCreationMenuDropdownItem(addPortletDisplayTemplateURL, templateHandler.getName(DDMDisplayContext.this._ddmWebRequestHelper.getLocale())));
                        }
                    }
                }
            }
        };
    }

    public SearchContainer<DDMTemplate> getTemplateSearch() throws Exception {
        PortletURL portletURL = this.getPortletURL();
        TemplateSearch templateSearch = new TemplateSearch((PortletRequest)this._renderRequest, portletURL);
        String orderByCol = this.getOrderByCol();
        String orderByType = this.getOrderByType();
        OrderByComparator orderByComparator = DDMUtil.getTemplateOrderByComparator((String)this.getOrderByCol(), (String)this.getOrderByType());
        templateSearch.setOrderByCol(orderByCol);
        templateSearch.setOrderByComparator(orderByComparator);
        templateSearch.setOrderByType(orderByType);
        if (templateSearch.isSearch()) {
            templateSearch.setEmptyResultsMessage("no-templates-were-found");
        } else {
            templateSearch.setEmptyResultsMessage("there-are-no-templates");
        }
        this.setDDMTemplateInstanceSearchResults(templateSearch);
        this.setDDMTemplateInstanceSearchTotal(templateSearch);
        return templateSearch;
    }

    public String getTemplateSearchActionURL() {
        PortletURL portletURL = this._renderResponse.createRenderURL();
        portletURL.setParameter("mvcPath", "/view_template.jsp");
        portletURL.setParameter("tabs1", ParamUtil.getString((PortletRequest)this._renderRequest, (String)"tabs1", (String)"templates"));
        portletURL.setParameter("templateId", String.valueOf(ParamUtil.getLong((PortletRequest)this._renderRequest, (String)"templateId")));
        portletURL.setParameter("groupId", String.valueOf(this._ddmWebRequestHelper.getScopeGroupId()));
        portletURL.setParameter("classNameId", String.valueOf(this.getClassNameId()));
        portletURL.setParameter("classPK", String.valueOf(this.getClassPK()));
        portletURL.setParameter("resourceClassNameId", String.valueOf(this.getResourceClassNameId()));
        portletURL.setParameter("eventName", ParamUtil.getString((PortletRequest)this._renderRequest, (String)"eventName", (String)"selectTemplate"));
        return portletURL.toString();
    }

    public String getTemplateSearchContainerId() {
        return "ddmTemplates";
    }

    public int getTotalItems(String context) throws Exception {
        Object searchContainer = Objects.equals(context, "DYNAMIC_DATA_MAPPING_STRUCTURE") ? this.getStructureSearch() : this.getTemplateSearch();
        return searchContainer.getTotal();
    }

    public boolean isAutocompleteEnabled(String language) {
        return this._ddmTemplateHelper.isAutocompleteEnabled(language);
    }

    public boolean isDisabledManagementBar(String context) throws Exception {
        return !this.hasResults(context) && !this.isSearch();
    }

    public boolean isSearch() {
        return Validator.isNotNull((String)this.getKeywords());
    }

    public boolean isShowAddStructureButton() throws PortalException {
        ThemeDisplay themeDisplay;
        DDMDisplay ddmDisplay = this.getDDMDisplay();
        return ddmDisplay.isShowAddButton((themeDisplay = (ThemeDisplay)this._renderRequest.getAttribute("LIFERAY_SHARED_THEME_DISPLAY")).getScopeGroup()) && DDMStructurePermission.containsAddStructurePermission(this._ddmWebRequestHelper.getPermissionChecker(), this._ddmWebRequestHelper.getScopeGroupId(), this.getStructureClassNameId());
    }

    public boolean isShowAddTemplateButton() throws PortalException {
        DDMDisplay ddmDisplay = this.getDDMDisplay();
        ThemeDisplay themeDisplay = (ThemeDisplay)this._renderRequest.getAttribute("LIFERAY_SHARED_THEME_DISPLAY");
        long classNameId = this.getClassNameId();
        long resourceClassNameId = PortalUtil.getClassNameId((String)ddmDisplay.getStructureType());
        if (classNameId == 0L || resourceClassNameId == 0L) {
            return true;
        }
        return ddmDisplay.isShowAddButton(themeDisplay.getScopeGroup()) && DDMTemplatePermission.containsAddTemplatePermission(this._ddmWebRequestHelper.getPermissionChecker(), this._ddmWebRequestHelper.getScopeGroupId(), classNameId, resourceClassNameId);
    }

    public String[] smallImageExtensions() {
        DDMGroupServiceConfiguration ddmGroupServiceConfiguration = this._ddmWebRequestHelper.getDDMGroupServiceConfiguration();
        return ddmGroupServiceConfiguration.smallImageExtensions();
    }

    public int smallImageMaxSize() {
        DDMGroupServiceConfiguration ddmGroupServiceConfiguration = this._ddmWebRequestHelper.getDDMGroupServiceConfiguration();
        return ddmGroupServiceConfiguration.smallImageMaxSize();
    }

    protected boolean containsAddPortletDisplayTemplatePermission(String resourceName) throws PortalException {
        return PortletPermissionUtil.contains((PermissionChecker)this._ddmWebRequestHelper.getPermissionChecker(), (Layout)this._ddmWebRequestHelper.getLayout(), (String)resourceName, (String)"ADD_PORTLET_DISPLAY_TEMPLATE");
    }

    protected long getClassNameId() {
        return ParamUtil.getLong((PortletRequest)this._renderRequest, (String)"classNameId");
    }

    protected long getClassPK() {
        return ParamUtil.getLong((PortletRequest)this._renderRequest, (String)"classPK");
    }

    protected Consumer<DropdownItem> getCreationMenuDropdownItem(PortletURL url, String label) {
        return dropdownItem -> {
            dropdownItem.setHref((Object)url);
            dropdownItem.setLabel(LanguageUtil.get((HttpServletRequest)this._ddmWebRequestHelper.getRequest(), (String)label));
        };
    }

    protected List<DropdownItem> getFilterNavigationDropdownItems() {
        return new DropdownItemList(){
            {
                this.add(dropdownItem -> {
                    dropdownItem.setActive(true);
                    dropdownItem.setHref(DDMDisplayContext.this.getPortletURL(), new Object[]{"navigation", "all"});
                    dropdownItem.setLabel(LanguageUtil.get((HttpServletRequest)DDMDisplayContext.this._ddmWebRequestHelper.getRequest(), (String)"all"));
                });
            }
        };
    }

    protected String getKeywords() {
        return ParamUtil.getString((PortletRequest)this._renderRequest, (String)"keywords");
    }

    protected Consumer<DropdownItem> getOrderByDropdownItem(String orderByCol) {
        return dropdownItem -> {
            dropdownItem.setActive(orderByCol.equals(this.getOrderByCol()));
            dropdownItem.setHref(this.getPortletURL(), new Object[]{"orderByCol", orderByCol});
            dropdownItem.setLabel(LanguageUtil.get((HttpServletRequest)this._ddmWebRequestHelper.getRequest(), (String)orderByCol));
        };
    }

    protected List<DropdownItem> getOrderByDropdownItems() {
        return new DropdownItemList(){
            {
                this.add(DDMDisplayContext.this.getOrderByDropdownItem("modified-date"));
                this.add(DDMDisplayContext.this.getOrderByDropdownItem("id"));
            }
        };
    }

    protected PortletURL getPortletURL() {
        boolean showAncestorScopes;
        String orderByType;
        String orderByCol;
        String keywords;
        String delta;
        String refererPortletName;
        long resourceClassNameId;
        long classNameId;
        long templateId;
        String tabs1;
        PortletURL portletURL = this._renderResponse.createRenderURL();
        String mvcPath = ParamUtil.getString((PortletRequest)this._renderRequest, (String)"mvcPath");
        if (Validator.isNotNull((String)mvcPath)) {
            portletURL.setParameter("mvcPath", mvcPath);
        }
        if (Validator.isNotNull((String)(tabs1 = ParamUtil.getString((PortletRequest)this._renderRequest, (String)"tabs1")))) {
            portletURL.setParameter("tabs1", tabs1);
        }
        if ((templateId = ParamUtil.getLong((PortletRequest)this._renderRequest, (String)"templateId")) != 0L) {
            portletURL.setParameter("templateId", String.valueOf(templateId));
        }
        if ((classNameId = this.getClassNameId()) != 0L) {
            portletURL.setParameter("classNameId", String.valueOf(classNameId));
        }
        long classPK = this.getClassPK();
        if (classNameId != 0L) {
            portletURL.setParameter("classPK", String.valueOf(classPK));
        }
        if ((resourceClassNameId = this.getResourceClassNameId()) != 0L) {
            portletURL.setParameter("resourceClassNameId", String.valueOf(resourceClassNameId));
        }
        if (Validator.isNotNull((String)(refererPortletName = this.getRefererPortletName()))) {
            portletURL.setParameter("refererPortletName", refererPortletName);
        }
        if (Validator.isNotNull((String)(delta = ParamUtil.getString((PortletRequest)this._renderRequest, (String)"delta")))) {
            portletURL.setParameter("delta", delta);
        }
        if (Validator.isNotNull((String)(keywords = this.getKeywords()))) {
            portletURL.setParameter("keywords", keywords);
        }
        if (Validator.isNotNull((String)(orderByCol = this.getOrderByCol()))) {
            portletURL.setParameter("orderByCol", orderByCol);
        }
        if (Validator.isNotNull((String)(orderByType = this.getOrderByType()))) {
            portletURL.setParameter("orderByType", orderByType);
        }
        if (showAncestorScopes = this.showAncestorScopes()) {
            portletURL.setParameter("showAncestorScopes", String.valueOf(showAncestorScopes));
        }
        return portletURL;
    }

    protected long getResourceClassNameId() {
        long resourceClassNameId = ParamUtil.getLong((PortletRequest)this._renderRequest, (String)"resourceClassNameId");
        if (resourceClassNameId == 0L) {
            resourceClassNameId = PortalUtil.getClassNameId(PortletDisplayTemplate.class);
        }
        return resourceClassNameId;
    }

    protected String getScopedStructureLabel() {
        String scopeTitle = ParamUtil.getString((PortletRequest)this._renderRequest, (String)"scopeTitle");
        DDMDisplay ddmDisplay = this.getDDMDisplay();
        if (Validator.isNull((String)scopeTitle)) {
            return ddmDisplay.getTitle(this._ddmWebRequestHelper.getLocale());
        }
        return scopeTitle;
    }

    protected long getSearchRestrictionClassNameId() {
        return ParamUtil.getLong((HttpServletRequest)this._ddmWebRequestHelper.getRequest(), (String)"searchRestrictionClassNameId");
    }

    protected long getSearchRestrictionClassPK() {
        return ParamUtil.getLong((HttpServletRequest)this._ddmWebRequestHelper.getRequest(), (String)"searchRestrictionClassPK");
    }

    protected long getStructureClassNameId() {
        DDMDisplay ddmDisplay = this.getDDMDisplay();
        return PortalUtil.getClassNameId((String)ddmDisplay.getStructureType());
    }

    protected long[] getTemplateClassNameIds() {
        DDMDisplay ddmDisplay = this.getDDMDisplay();
        return ddmDisplay.getTemplateClassNameIds(this.getClassNameId());
    }

    protected List<TemplateHandler> getTemplateHandlers() throws PortalException {
        List<Object> templateHandlers = new ArrayList();
        if (this.getClassNameId() > 0L) {
            TemplateHandler templateHandler = TemplateHandlerRegistryUtil.getTemplateHandler((long)this.getClassNameId());
            if (this.containsAddPortletDisplayTemplatePermission(templateHandler.getResourceName())) {
                templateHandlers.add(templateHandler);
            }
        } else {
            templateHandlers = PortletDisplayTemplateUtil.getPortletDisplayTemplateHandlers();
            Iterator<Object> itr = templateHandlers.iterator();
            while (itr.hasNext()) {
                TemplateHandler templateHandler = (TemplateHandler)itr.next();
                if (this.containsAddPortletDisplayTemplatePermission(templateHandler.getResourceName())) continue;
                itr.remove();
            }
        }
        ListUtil.sort(templateHandlers, (Comparator)new TemplateHandlerComparator(this._ddmWebRequestHelper.getLocale()));
        return templateHandlers;
    }

    protected String getTemplateMode() {
        DDMDisplay ddmDisplay = this.getDDMDisplay();
        return ParamUtil.getString((PortletRequest)this._renderRequest, (String)"mode", (String)ddmDisplay.getTemplateMode());
    }

    protected String getTemplateTypeValue() {
        DDMDisplay ddmDisplay = this.getDDMDisplay();
        String scopeTemplateType = ddmDisplay.getTemplateType();
        String templateTypeValue = "";
        if (scopeTemplateType.equals("display")) {
            templateTypeValue = "display";
        } else if (scopeTemplateType.equals("form")) {
            templateTypeValue = "form";
        }
        return templateTypeValue;
    }

    protected boolean hasResults(String context) throws Exception {
        return this.getTotalItems(context) > 0;
    }

    protected void setDDMStructureSearchResults(StructureSearch structureSearch) throws Exception {
        StructureSearchTerms searchTerms = (StructureSearchTerms)structureSearch.getSearchTerms();
        long[] groupIds = new long[]{PortalUtil.getScopeGroupId((HttpServletRequest)this._ddmWebRequestHelper.getRequest(), (String)this.getRefererPortletName(), (boolean)true)};
        if (this.showAncestorScopes()) {
            groupIds = PortalUtil.getCurrentAndAncestorSiteGroupIds((long[])groupIds);
        }
        List results = null;
        results = searchTerms.isSearchRestriction() != false ? this._ddmStructureLinkLocalService.getStructureLinkStructures(this.getSearchRestrictionClassNameId(), this.getSearchRestrictionClassPK(), structureSearch.getStart(), structureSearch.getEnd()) : this._ddmStructureService.search(this._ddmWebRequestHelper.getCompanyId(), groupIds, this.getStructureClassNameId(), searchTerms.getKeywords(), searchTerms.getStatus(), structureSearch.getStart(), structureSearch.getEnd(), structureSearch.getOrderByComparator());
        structureSearch.setResults(results);
    }

    protected void setDDMStructureSearchTotal(StructureSearch structureSearch) throws Exception {
        StructureSearchTerms searchTerms = (StructureSearchTerms)structureSearch.getSearchTerms();
        long[] groupIds = new long[]{PortalUtil.getScopeGroupId((HttpServletRequest)this._ddmWebRequestHelper.getRequest(), (String)this.getRefererPortletName(), (boolean)true)};
        if (this.showAncestorScopes()) {
            groupIds = PortalUtil.getCurrentAndAncestorSiteGroupIds((long[])groupIds);
        }
        int total = 0;
        total = searchTerms.isSearchRestriction() != false ? this._ddmStructureLinkLocalService.getStructureLinksCount(this.getSearchRestrictionClassNameId(), this.getSearchRestrictionClassPK()) : this._ddmStructureService.searchCount(this._ddmWebRequestHelper.getCompanyId(), groupIds, this.getStructureClassNameId(), searchTerms.getKeywords(), searchTerms.getStatus());
        structureSearch.setTotal(total);
    }

    protected void setDDMTemplateInstanceSearchResults(TemplateSearch templateSearch) throws Exception {
        TemplateSearchTerms searchTerms = (TemplateSearchTerms)templateSearch.getSearchTerms();
        DDMDisplay ddmDisplay = this.getDDMDisplay();
        ThemeDisplay themeDisplay = (ThemeDisplay)this._renderRequest.getAttribute("LIFERAY_SHARED_THEME_DISPLAY");
        long[] groupIds = ddmDisplay.getTemplateGroupIds(themeDisplay, this.showAncestorScopes());
        long[] classPKs = ddmDisplay.getTemplateClassPKs(this._ddmWebRequestHelper.getCompanyId(), this.getStructureClassNameId(), this.getClassPK());
        List results = this._ddmTemplateService.search(this._ddmWebRequestHelper.getCompanyId(), groupIds, this.getTemplateClassNameIds(), classPKs, this.getResourceClassNameId(), searchTerms.getKeywords(), searchTerms.getType(), this.getTemplateMode(), searchTerms.getStatus(), templateSearch.getStart(), templateSearch.getEnd(), templateSearch.getOrderByComparator());
        templateSearch.setResults(results);
    }

    protected void setDDMTemplateInstanceSearchTotal(TemplateSearch templateSearch) throws Exception {
        TemplateSearchTerms searchTerms = (TemplateSearchTerms)templateSearch.getSearchTerms();
        DDMDisplay ddmDisplay = this.getDDMDisplay();
        ThemeDisplay themeDisplay = (ThemeDisplay)this._renderRequest.getAttribute("LIFERAY_SHARED_THEME_DISPLAY");
        long[] groupIds = ddmDisplay.getTemplateGroupIds(themeDisplay, this.showAncestorScopes());
        long[] classPKs = ddmDisplay.getTemplateClassPKs(this._ddmWebRequestHelper.getCompanyId(), this.getStructureClassNameId(), this.getClassPK());
        int total = this._ddmTemplateService.searchCount(this._ddmWebRequestHelper.getCompanyId(), groupIds, this.getTemplateClassNameIds(), classPKs, this.getResourceClassNameId(), searchTerms.getKeywords(), searchTerms.getType(), this.getTemplateMode(), searchTerms.getStatus());
        templateSearch.setTotal(total);
    }

    protected boolean showAncestorScopes() {
        return ParamUtil.getBoolean((PortletRequest)this._renderRequest, (String)"showAncestorScopes");
    }
}

