/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.dynamic.data.mapping.web.internal.exportimport.data.handler;

import com.liferay.dynamic.data.mapping.io.DDMFormJSONDeserializer;
import com.liferay.dynamic.data.mapping.io.DDMFormLayoutJSONDeserializer;
import com.liferay.dynamic.data.mapping.model.DDMDataProviderInstance;
import com.liferay.dynamic.data.mapping.model.DDMDataProviderInstanceLink;
import com.liferay.dynamic.data.mapping.model.DDMForm;
import com.liferay.dynamic.data.mapping.model.DDMFormField;
import com.liferay.dynamic.data.mapping.model.DDMFormLayout;
import com.liferay.dynamic.data.mapping.model.DDMStructure;
import com.liferay.dynamic.data.mapping.model.DDMStructureLayout;
import com.liferay.dynamic.data.mapping.model.DDMStructureVersion;
import com.liferay.dynamic.data.mapping.service.DDMDataProviderInstanceLinkLocalService;
import com.liferay.dynamic.data.mapping.service.DDMDataProviderInstanceLocalService;
import com.liferay.dynamic.data.mapping.service.DDMStructureLayoutLocalService;
import com.liferay.dynamic.data.mapping.service.DDMStructureLocalService;
import com.liferay.exportimport.kernel.lar.ExportImportPathUtil;
import com.liferay.exportimport.kernel.lar.PortletDataContext;
import com.liferay.exportimport.kernel.lar.PortletDataException;
import com.liferay.exportimport.kernel.lar.StagedModelDataHandler;
import com.liferay.exportimport.kernel.lar.StagedModelDataHandlerUtil;
import com.liferay.exportimport.kernel.lar.StagedModelModifiedDateComparator;
import com.liferay.exportimport.lar.BaseStagedModelDataHandler;
import com.liferay.portal.kernel.exception.PortalException;
import com.liferay.portal.kernel.log.Log;
import com.liferay.portal.kernel.log.LogFactoryUtil;
import com.liferay.portal.kernel.model.ClassedModel;
import com.liferay.portal.kernel.model.Group;
import com.liferay.portal.kernel.model.StagedModel;
import com.liferay.portal.kernel.service.ServiceContext;
import com.liferay.portal.kernel.service.UserLocalService;
import com.liferay.portal.kernel.util.ArrayUtil;
import com.liferay.portal.kernel.util.DateUtil;
import com.liferay.portal.kernel.util.GetterUtil;
import com.liferay.portal.kernel.util.MapUtil;
import com.liferay.portal.kernel.util.OrderByComparator;
import com.liferay.portal.kernel.util.Portal;
import com.liferay.portal.kernel.util.StringUtil;
import com.liferay.portal.kernel.xml.Element;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.Reference;

@Component(immediate=true, property={"javax.portlet.name=com_liferay_dynamic_data_mapping_web_portlet_DDMPortlet"}, service={StagedModelDataHandler.class})
public class DDMStructureStagedModelDataHandler
extends BaseStagedModelDataHandler<DDMStructure> {
    public static final String[] CLASS_NAMES = new String[]{DDMStructure.class.getName()};
    private static final String _DDM_DATA_PROVIDER_INSTANCE_IDS = "ddm-data-provider-instance-ids";
    private static final Log _log = LogFactoryUtil.getLog(DDMStructureStagedModelDataHandler.class);
    @Reference
    private DDMDataProviderInstanceLinkLocalService _ddmDataProviderInstanceLinkLocalService;
    @Reference
    private DDMDataProviderInstanceLocalService _ddmDataProviderInstanceLocalService;
    private DDMFormJSONDeserializer _ddmFormJSONDeserializer;
    private DDMFormLayoutJSONDeserializer _ddmFormLayoutJSONDeserializer;
    private DDMStructureLayoutLocalService _ddmStructureLayoutLocalService;
    private DDMStructureLocalService _ddmStructureLocalService;
    @Reference
    private Portal _portal;
    private UserLocalService _userLocalService;

    public void deleteStagedModel(DDMStructure structure) throws PortalException {
        this._ddmStructureLocalService.deleteStructure(structure);
    }

    public void deleteStagedModel(String uuid, long groupId, String className, String extraData) throws PortalException {
        DDMStructure ddmStructure = this.fetchStagedModelByUuidAndGroupId(uuid, groupId);
        if (ddmStructure != null) {
            this.deleteStagedModel(ddmStructure);
        }
    }

    public DDMStructure fetchStagedModelByUuidAndGroupId(String uuid, long groupId) {
        return this._ddmStructureLocalService.fetchDDMStructureByUuidAndGroupId(uuid, groupId);
    }

    public List<DDMStructure> fetchStagedModelsByUuidAndCompanyId(String uuid, long companyId) {
        return this._ddmStructureLocalService.getDDMStructuresByUuidAndCompanyId(uuid, companyId, -1, -1, (OrderByComparator)new StagedModelModifiedDateComparator());
    }

    public String[] getClassNames() {
        return CLASS_NAMES;
    }

    public String getDisplayName(DDMStructure structure) {
        return structure.getNameCurrentValue();
    }

    public Map<String, String> getReferenceAttributes(PortletDataContext portletDataContext, DDMStructure structure) {
        HashMap<String, String> referenceAttributes = new HashMap<String, String>();
        referenceAttributes.put("referenced-class-name", structure.getClassName());
        referenceAttributes.put("structure-key", structure.getStructureKey());
        long defaultUserId = 0L;
        try {
            defaultUserId = this._userLocalService.getDefaultUserId(structure.getCompanyId());
        }
        catch (Exception e) {
            return referenceAttributes;
        }
        boolean preloaded = false;
        if (defaultUserId == structure.getUserId()) {
            preloaded = true;
        }
        referenceAttributes.put("preloaded", String.valueOf(preloaded));
        return referenceAttributes;
    }

    public boolean validateReference(PortletDataContext portletDataContext, Element referenceElement) {
        this.validateMissingGroupReference(portletDataContext, referenceElement);
        String uuid = referenceElement.attributeValue("uuid");
        Map groupIds = portletDataContext.getNewPrimaryKeysMap(Group.class);
        long groupId = GetterUtil.getLong((String)referenceElement.attributeValue("group-id"));
        groupId = MapUtil.getLong((Map)groupIds, (long)groupId);
        long classNameId = this._portal.getClassNameId(referenceElement.attributeValue("referenced-class-name"));
        String structureKey = referenceElement.attributeValue("structure-key");
        boolean preloaded = GetterUtil.getBoolean((String)referenceElement.attributeValue("preloaded"));
        DDMStructure existingStructure = this.fetchExistingStructure(uuid, groupId, classNameId, structureKey, preloaded);
        return existingStructure != null;
    }

    protected void doExportStagedModel(PortletDataContext portletDataContext, DDMStructure structure) throws Exception {
        long defaultUserId;
        Element structureElement = portletDataContext.getExportDataElement((ClassedModel)structure);
        if (structure.getParentStructureId() != 0L) {
            DDMStructure parentStructure = this._ddmStructureLocalService.getStructure(structure.getParentStructureId());
            StagedModelDataHandlerUtil.exportReferenceStagedModel((PortletDataContext)portletDataContext, (StagedModel)structure, (StagedModel)parentStructure, (String)"parent");
        }
        if ((defaultUserId = this._userLocalService.getDefaultUserId(structure.getCompanyId())) == structure.getUserId()) {
            structureElement.addAttribute("preloaded", "true");
        }
        this.exportDDMForm(portletDataContext, structure, structureElement);
        this.exportDDMDataProviderInstances(portletDataContext, structure, structureElement);
        this.exportDDMFormLayout(portletDataContext, structure, structureElement);
        portletDataContext.addClassedModel(structureElement, ExportImportPathUtil.getModelPath((StagedModel)structure), (ClassedModel)structure);
    }

    protected void doImportMissingReference(PortletDataContext portletDataContext, Element referenceElement) throws PortletDataException {
        this.importMissingGroupReference(portletDataContext, referenceElement);
        String uuid = referenceElement.attributeValue("uuid");
        Map groupIds = portletDataContext.getNewPrimaryKeysMap(Group.class);
        long groupId = GetterUtil.getLong((String)referenceElement.attributeValue("group-id"));
        groupId = MapUtil.getLong((Map)groupIds, (long)groupId);
        long classNameId = this._portal.getClassNameId(referenceElement.attributeValue("referenced-class-name"));
        String structureKey = referenceElement.attributeValue("structure-key");
        boolean preloaded = GetterUtil.getBoolean((String)referenceElement.attributeValue("preloaded"));
        DDMStructure existingStructure = null;
        existingStructure = this.fetchExistingStructure(uuid, groupId, classNameId, structureKey, preloaded);
        Map structureIds = portletDataContext.getNewPrimaryKeysMap(DDMStructure.class);
        long structureId = GetterUtil.getLong((String)referenceElement.attributeValue("class-pk"));
        structureIds.put(structureId, existingStructure.getStructureId());
        Map structureKeys = portletDataContext.getNewPrimaryKeysMap(DDMStructure.class + ".ddmStructureKey");
        structureKeys.put(structureKey, existingStructure.getStructureKey());
        Map structureUuids = portletDataContext.getNewPrimaryKeysMap(DDMStructure.class + ".ddmStructureUuid");
        structureUuids.put(uuid, existingStructure.getUuid());
    }

    protected void doImportStagedModel(PortletDataContext portletDataContext, DDMStructure structure) throws Exception {
        long userId = portletDataContext.getUserId(structure.getUserUuid());
        Map structureIds = portletDataContext.getNewPrimaryKeysMap(DDMStructure.class);
        long parentStructureId = MapUtil.getLong((Map)structureIds, (long)structure.getParentStructureId(), (long)structure.getParentStructureId());
        Map structureKeys = portletDataContext.getNewPrimaryKeysMap(DDMStructure.class + ".ddmStructureKey");
        Element structureElement = portletDataContext.getImportDataElement((StagedModel)structure);
        DDMForm ddmForm = this.getImportDDMForm(portletDataContext, structureElement);
        this.importDDMDataProviderInstances(portletDataContext, structureElement, ddmForm);
        DDMFormLayout ddmFormLayout = this.getImportDDMFormLayout(portletDataContext, structureElement);
        ServiceContext serviceContext = portletDataContext.createServiceContext((StagedModel)structure);
        DDMStructure importedStructure = null;
        Map groupIds = portletDataContext.getNewPrimaryKeysMap(Group.class);
        long targetGroupId = portletDataContext.getScopeGroupId();
        if (groupIds.containsKey(structure.getGroupId())) {
            targetGroupId = (Long)groupIds.get(structure.getGroupId());
        }
        if (portletDataContext.isDataStrategyMirror()) {
            Element element = portletDataContext.getImportDataStagedModelElement((StagedModel)structure);
            boolean preloaded = GetterUtil.getBoolean((String)element.attributeValue("preloaded"));
            DDMStructure existingStructure = this.fetchExistingStructure(structure.getUuid(), targetGroupId, structure.getClassNameId(), structure.getStructureKey(), preloaded);
            if (existingStructure == null) {
                serviceContext.setUuid(structure.getUuid());
                existingStructure = this._ddmStructureLocalService.fetchStructure(targetGroupId, structure.getClassNameId(), structure.getStructureKey());
                if (existingStructure != null) {
                    structure.setStructureKey(null);
                }
                importedStructure = this._ddmStructureLocalService.addStructure(userId, targetGroupId, parentStructureId, structure.getClassNameId(), structure.getStructureKey(), structure.getNameMap(), structure.getDescriptionMap(), ddmForm, ddmFormLayout, structure.getStorageType(), structure.getType(), serviceContext);
            } else if (this.isModifiedStructure(existingStructure, structure)) {
                importedStructure = this._ddmStructureLocalService.updateStructure(userId, existingStructure.getStructureId(), parentStructureId, structure.getNameMap(), structure.getDescriptionMap(), ddmForm, ddmFormLayout, serviceContext);
            } else {
                if (_log.isDebugEnabled()) {
                    _log.debug((Object)("Not importing DDM structure with key " + structure.getStructureKey() + " since it was not modified"));
                }
                importedStructure = existingStructure;
            }
        } else {
            importedStructure = this._ddmStructureLocalService.addStructure(userId, targetGroupId, parentStructureId, structure.getClassNameId(), null, structure.getNameMap(), structure.getDescriptionMap(), ddmForm, ddmFormLayout, structure.getStorageType(), structure.getType(), serviceContext);
        }
        portletDataContext.importClassedModel((ClassedModel)structure, (ClassedModel)importedStructure);
        structureKeys.put(structure.getStructureKey(), importedStructure.getStructureKey());
    }

    protected void exportDDMDataProviderInstances(PortletDataContext portletDataContext, DDMStructure structure, Element structureElement) throws PortalException {
        HashSet<Long> ddmDataProviderInstanceIdsSet = new HashSet<Long>();
        List ddmDataProviderInstanceLinks = this._ddmDataProviderInstanceLinkLocalService.getDataProviderInstanceLinks(structure.getStructureId());
        for (DDMDataProviderInstanceLink ddmDataProviderInstanceLink : ddmDataProviderInstanceLinks) {
            long ddmDataProviderInstanceId = ddmDataProviderInstanceLink.getDataProviderInstanceId();
            DDMDataProviderInstance ddmDataProviderInstance = this._ddmDataProviderInstanceLocalService.getDDMDataProviderInstance(ddmDataProviderInstanceId);
            StagedModelDataHandlerUtil.exportReferenceStagedModel((PortletDataContext)portletDataContext, (StagedModel)structure, (StagedModel)ddmDataProviderInstance, (String)"strong");
            ddmDataProviderInstanceIdsSet.add(ddmDataProviderInstance.getDataProviderInstanceId());
        }
        String ddmDataProviderInstanceIds = ArrayUtil.toString((Object[])ddmDataProviderInstanceIdsSet.toArray(new Long[ddmDataProviderInstanceIdsSet.size()]), (String)"");
        structureElement.addAttribute(_DDM_DATA_PROVIDER_INSTANCE_IDS, ddmDataProviderInstanceIds);
    }

    protected void exportDDMForm(PortletDataContext portletDataContext, DDMStructure structure, Element structureElement) {
        String ddmFormPath = ExportImportPathUtil.getModelPath((StagedModel)structure, (String)"ddm-form.json");
        structureElement.addAttribute("ddm-form-path", ddmFormPath);
        portletDataContext.addZipEntry(ddmFormPath, structure.getDefinition());
    }

    protected void exportDDMFormLayout(PortletDataContext portletDataContext, DDMStructure structure, Element structureElement) throws PortalException {
        DDMStructureVersion structureVersion = structure.getStructureVersion();
        DDMStructureLayout structureLayout = this._ddmStructureLayoutLocalService.getStructureLayoutByStructureVersionId(structureVersion.getStructureVersionId());
        String ddmFormLayoutPath = ExportImportPathUtil.getModelPath((StagedModel)structure, (String)"ddm-form-layout.json");
        structureElement.addAttribute("ddm-form-layout-path", ddmFormLayoutPath);
        portletDataContext.addZipEntry(ddmFormLayoutPath, structureLayout.getDefinition());
    }

    protected DDMStructure fetchExistingStructure(String uuid, long groupId, long classNameId, String structureKey, boolean preloaded) {
        DDMStructure existingStructure = null;
        existingStructure = !preloaded ? this.fetchStagedModelByUuidAndGroupId(uuid, groupId) : this._ddmStructureLocalService.fetchStructure(groupId, classNameId, structureKey);
        return existingStructure;
    }

    protected DDMForm getImportDDMForm(PortletDataContext portletDataContext, Element structureElement) throws PortalException {
        String ddmFormPath = structureElement.attributeValue("ddm-form-path");
        String serializedDDMForm = portletDataContext.getZipEntryAsString(ddmFormPath);
        return this._ddmFormJSONDeserializer.deserialize(serializedDDMForm);
    }

    protected DDMFormLayout getImportDDMFormLayout(PortletDataContext portletDataContext, Element structureElement) throws PortalException {
        String ddmFormLayoutPath = structureElement.attributeValue("ddm-form-layout-path");
        String serializedDDMFormLayout = portletDataContext.getZipEntryAsString(ddmFormLayoutPath);
        return this._ddmFormLayoutJSONDeserializer.deserialize(serializedDDMFormLayout);
    }

    protected void importDDMDataProviderInstances(PortletDataContext portletDataContext, Element structureElement, DDMForm ddmForm) throws PortletDataException {
        Object[] ddmDataProviderInstanceIds = StringUtil.split((String)structureElement.attributeValue(_DDM_DATA_PROVIDER_INSTANCE_IDS));
        if (ArrayUtil.isEmpty((Object[])ddmDataProviderInstanceIds)) {
            return;
        }
        Map dataProviderInstanceIdsMap = portletDataContext.getNewPrimaryKeysMap(DDMDataProviderInstance.class);
        for (Object ddmDataProviderInstanceId : ddmDataProviderInstanceIds) {
            long oldDDMDataProviderInstanceId = Long.parseLong((String)ddmDataProviderInstanceId);
            long newDDMDataProviderInstanceId = MapUtil.getLong((Map)dataProviderInstanceIdsMap, (long)oldDDMDataProviderInstanceId);
            StagedModelDataHandlerUtil.importReferenceStagedModel((PortletDataContext)portletDataContext, DDMDataProviderInstance.class, (long)newDDMDataProviderInstanceId);
        }
        List ddmFormFields = ddmForm.getDDMFormFields();
        for (DDMFormField ddmFormField : ddmFormFields) {
            if (!ddmFormField.getType().equals("select")) continue;
            long oldDDMDataProviderInstanceId = Long.valueOf(String.valueOf(ddmFormField.getProperty("ddmDataProviderInstanceId")));
            long newDDMDataProviderInstanceId = MapUtil.getLong((Map)dataProviderInstanceIdsMap, (long)oldDDMDataProviderInstanceId);
            ddmFormField.setProperty("ddmDataProviderInstanceId", (Object)newDDMDataProviderInstanceId);
        }
    }

    protected boolean isModifiedStructure(DDMStructure existingStructure, DDMStructure structure) {
        int value = DateUtil.compareTo((Date)existingStructure.getModifiedDate(), (Date)structure.getModifiedDate());
        if (value < 0) {
            return true;
        }
        if (!Objects.equals(existingStructure.getDefinition(), structure.getDefinition())) {
            return true;
        }
        if (!Objects.equals(existingStructure.getDescriptionMap(), structure.getDescriptionMap())) {
            return true;
        }
        if (!Objects.equals(existingStructure.getNameMap(), structure.getNameMap())) {
            return true;
        }
        if (!Objects.equals(existingStructure.getStorageType(), structure.getStorageType())) {
            return true;
        }
        return !Objects.equals(existingStructure.getType(), structure.getType());
    }

    @Reference(unbind="-")
    protected void setDDMFormJSONDeserializer(DDMFormJSONDeserializer ddmFormJSONDeserializer) {
        this._ddmFormJSONDeserializer = ddmFormJSONDeserializer;
    }

    @Reference(unbind="-")
    protected void setDDMFormLayoutJSONDeserializer(DDMFormLayoutJSONDeserializer ddmFormLayoutJSONDeserializer) {
        this._ddmFormLayoutJSONDeserializer = ddmFormLayoutJSONDeserializer;
    }

    @Reference(unbind="-")
    protected void setDDMStructureLayoutLocalService(DDMStructureLayoutLocalService ddmStructureLayoutLocalService) {
        this._ddmStructureLayoutLocalService = ddmStructureLayoutLocalService;
    }

    @Reference(unbind="-")
    protected void setDDMStructureLocalService(DDMStructureLocalService ddmStructureLocalService) {
        this._ddmStructureLocalService = ddmStructureLocalService;
    }

    @Reference(unbind="-")
    protected void setUserLocalService(UserLocalService userLocalService) {
        this._userLocalService = userLocalService;
    }
}

