/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.dynamic.data.mapping.web.display.context;

import com.liferay.dynamic.data.mapping.configuration.DDMGroupServiceConfiguration;
import com.liferay.dynamic.data.mapping.model.DDMStructure;
import com.liferay.dynamic.data.mapping.model.DDMTemplate;
import com.liferay.dynamic.data.mapping.storage.StorageAdapterRegistry;
import com.liferay.dynamic.data.mapping.util.DDMDisplay;
import com.liferay.dynamic.data.mapping.util.DDMDisplayRegistry;
import com.liferay.dynamic.data.mapping.util.DDMTemplateHelper;
import com.liferay.dynamic.data.mapping.web.configuration.DDMWebConfiguration;
import com.liferay.dynamic.data.mapping.web.context.util.DDMWebRequestHelper;
import com.liferay.portal.kernel.exception.PortalException;
import com.liferay.portal.kernel.portlet.PortalPreferences;
import com.liferay.portal.kernel.portlet.PortletPreferencesFactoryUtil;
import com.liferay.portal.kernel.util.ParamUtil;
import com.liferay.portal.kernel.util.PortalUtil;
import com.liferay.portal.kernel.util.Validator;
import java.util.Set;
import javax.portlet.PortletRequest;
import javax.portlet.RenderRequest;
import javax.servlet.http.HttpServletRequest;

public class DDMDisplayContext {
    private final DDMDisplayRegistry _ddmDisplayRegistry;
    private final DDMTemplateHelper _ddmTemplateHelper;
    private final DDMWebConfiguration _ddmWebConfiguration;
    private final DDMWebRequestHelper _ddmWebRequestHelper;
    private final RenderRequest _renderRequest;
    private final StorageAdapterRegistry _storageAdapterRegistry;

    public DDMDisplayContext(RenderRequest renderRequest, DDMDisplayRegistry ddmDisplayRegistry, DDMTemplateHelper ddmTemplateHelper, DDMWebConfiguration ddmWebConfiguration, StorageAdapterRegistry storageAdapterRegistry) throws PortalException {
        this._renderRequest = renderRequest;
        this._ddmDisplayRegistry = ddmDisplayRegistry;
        this._ddmTemplateHelper = ddmTemplateHelper;
        this._ddmWebConfiguration = ddmWebConfiguration;
        this._storageAdapterRegistry = storageAdapterRegistry;
        HttpServletRequest httpServletRequest = PortalUtil.getHttpServletRequest((PortletRequest)renderRequest);
        this._ddmWebRequestHelper = new DDMWebRequestHelper(httpServletRequest);
    }

    public boolean autogenerateStructureKey() {
        return this._ddmWebConfiguration.autogenerateStructureKey();
    }

    public boolean autogenerateTemplateKey() {
        return this._ddmWebConfiguration.autogenerateTemplateKey();
    }

    public boolean changeableDefaultLanguage() {
        return this._ddmWebConfiguration.changeableDefaultLanguage();
    }

    public DDMStructure fetchStructure(DDMTemplate template) {
        return this._ddmTemplateHelper.fetchStructure(template);
    }

    public String getAutocompleteJSON(HttpServletRequest request, String language) throws Exception {
        return this._ddmTemplateHelper.getAutocompleteJSON(request, language);
    }

    public DDMDisplay getDDMDisplay(String portletId) {
        return this._ddmDisplayRegistry.getDDMDisplay(portletId);
    }

    public DDMGroupServiceConfiguration getDDMGroupServiceConfiguration() {
        return this._ddmWebRequestHelper.getDDMGroupServiceConfiguration();
    }

    public String getOrderByCol() {
        PortalPreferences portalPreferences = PortletPreferencesFactoryUtil.getPortalPreferences((PortletRequest)this._renderRequest);
        String orderByCol = ParamUtil.getString((PortletRequest)this._renderRequest, (String)"orderByCol");
        if (Validator.isNull((String)orderByCol)) {
            orderByCol = portalPreferences.getValue("com_liferay_dynamic_data_mapping_web_portlet_DDMPortlet", "entries-order-by-col", "modified-date");
        } else {
            portalPreferences.setValue("com_liferay_dynamic_data_mapping_web_portlet_DDMPortlet", "entries-order-by-col", orderByCol);
        }
        return orderByCol;
    }

    public String getOrderByType() {
        PortalPreferences portalPreferences = PortletPreferencesFactoryUtil.getPortalPreferences((PortletRequest)this._renderRequest);
        String orderByType = ParamUtil.getString((PortletRequest)this._renderRequest, (String)"orderByType");
        if (Validator.isNull((String)orderByType)) {
            orderByType = portalPreferences.getValue("com_liferay_dynamic_data_mapping_web_portlet_DDMPortlet", "entries-order-by-type", "asc");
        } else {
            portalPreferences.setValue("com_liferay_dynamic_data_mapping_web_portlet_DDMPortlet", "entries-order-by-type", orderByType);
        }
        return orderByType;
    }

    public Set<String> getStorageTypes() {
        return this._storageAdapterRegistry.getStorageTypes();
    }

    public boolean isAutocompleteEnabled(String language) {
        return this._ddmTemplateHelper.isAutocompleteEnabled(language);
    }

    public String[] smallImageExtensions() {
        DDMGroupServiceConfiguration ddmGroupServiceConfiguration = this._ddmWebRequestHelper.getDDMGroupServiceConfiguration();
        return ddmGroupServiceConfiguration.smallImageExtensions();
    }

    public int smallImageMaxSize() {
        DDMGroupServiceConfiguration ddmGroupServiceConfiguration = this._ddmWebRequestHelper.getDDMGroupServiceConfiguration();
        return ddmGroupServiceConfiguration.smallImageMaxSize();
    }
}

