/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.dynamic.data.mapping.web.portlet.action;

import com.liferay.dynamic.data.mapping.model.DDMStructure;
import com.liferay.dynamic.data.mapping.model.DDMTemplate;
import com.liferay.dynamic.data.mapping.service.DDMStructureService;
import com.liferay.dynamic.data.mapping.service.DDMTemplateService;
import com.liferay.dynamic.data.mapping.web.portlet.action.DDMBaseMVCActionCommand;
import com.liferay.portal.kernel.portlet.bridges.mvc.MVCActionCommand;
import com.liferay.portal.kernel.service.ServiceContext;
import com.liferay.portal.kernel.service.ServiceContextFactory;
import com.liferay.portal.kernel.theme.ThemeDisplay;
import com.liferay.portal.kernel.util.LocalizationUtil;
import com.liferay.portal.kernel.util.ParamUtil;
import com.liferay.portal.kernel.util.PortalUtil;
import com.liferay.portlet.PortletURLImpl;
import java.util.Map;
import javax.portlet.ActionRequest;
import javax.portlet.ActionResponse;
import javax.portlet.PortletRequest;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.Reference;

@Component(immediate=true, property={"javax.portlet.name=com_liferay_dynamic_data_mapping_web_portlet_DDMPortlet", "mvc.command.name=copyStructure"}, service={MVCActionCommand.class})
public class CopyStructureMVCActionCommand
extends DDMBaseMVCActionCommand {
    private DDMStructureService _ddmStructureService;
    private DDMTemplateService _ddmTemplateService;

    protected DDMStructure copyStructure(ActionRequest actionRequest) throws Exception {
        long classPK = ParamUtil.getLong((PortletRequest)actionRequest, (String)"classPK");
        Map nameMap = LocalizationUtil.getLocalizationMap((PortletRequest)actionRequest, (String)"name");
        Map descriptionMap = LocalizationUtil.getLocalizationMap((PortletRequest)actionRequest, (String)"description");
        ServiceContext serviceContext = ServiceContextFactory.getInstance((String)DDMStructure.class.getName(), (PortletRequest)actionRequest);
        DDMStructure structure = this._ddmStructureService.copyStructure(classPK, nameMap, descriptionMap, serviceContext);
        this.copyTemplates(actionRequest, classPK, structure.getStructureId());
        return structure;
    }

    protected void copyTemplates(ActionRequest actionRequest, long oldClassPK, long newClassPK) throws Exception {
        boolean copyFormTemplates;
        long classNameId = PortalUtil.getClassNameId(DDMStructure.class);
        ServiceContext serviceContext = ServiceContextFactory.getInstance((String)DDMTemplate.class.getName(), (PortletRequest)actionRequest);
        long resourceClassNameId = ParamUtil.getLong((PortletRequest)actionRequest, (String)"resourceClassNameId");
        boolean copyDisplayTemplates = ParamUtil.getBoolean((PortletRequest)actionRequest, (String)"copyDisplayTemplates");
        if (copyDisplayTemplates) {
            this._ddmTemplateService.copyTemplates(classNameId, oldClassPK, resourceClassNameId, newClassPK, "display", serviceContext);
        }
        if (copyFormTemplates = ParamUtil.getBoolean((PortletRequest)actionRequest, (String)"copyFormTemplates")) {
            this._ddmTemplateService.copyTemplates(classNameId, oldClassPK, resourceClassNameId, newClassPK, "form", serviceContext);
        }
    }

    protected void doProcessAction(ActionRequest actionRequest, ActionResponse actionResponse) throws Exception {
        DDMStructure structure = this.copyStructure(actionRequest);
        this.setRedirectAttribute(actionRequest, structure);
    }

    @Override
    protected String getSaveAndContinueRedirect(ActionRequest actionRequest, DDMStructure structure, String redirect) throws Exception {
        ThemeDisplay themeDisplay = (ThemeDisplay)actionRequest.getAttribute("LIFERAY_SHARED_THEME_DISPLAY");
        PortletURLImpl portletURL = new PortletURLImpl((PortletRequest)actionRequest, themeDisplay.getPpid(), themeDisplay.getPlid(), "RENDER_PHASE");
        portletURL.setParameter("mvcPath", "/copy_structure");
        long classNameId = PortalUtil.getClassNameId(DDMStructure.class);
        portletURL.setParameter("classNameId", String.valueOf(classNameId), false);
        portletURL.setParameter("classPK", String.valueOf(structure.getStructureId()), false);
        portletURL.setParameter("copyFormTemplates", ParamUtil.getString((PortletRequest)actionRequest, (String)"copyFormTemplates"), false);
        portletURL.setParameter("copyDisplayTemplates", ParamUtil.getString((PortletRequest)actionRequest, (String)"copyDisplayTemplates"), false);
        portletURL.setWindowState(actionRequest.getWindowState());
        return portletURL.toString();
    }

    @Reference(unbind="-")
    protected void setDDMStructureService(DDMStructureService ddmStructureService) {
        this._ddmStructureService = ddmStructureService;
    }

    @Reference(unbind="-")
    protected void setDDMTemplateService(DDMTemplateService ddmTemplateService) {
        this._ddmTemplateService = ddmTemplateService;
    }
}

