/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.dynamic.data.mapping.uad.anonymizer;

import com.liferay.dynamic.data.mapping.model.DDMFormInstanceRecord;
import com.liferay.dynamic.data.mapping.model.DDMFormInstanceRecordVersion;
import com.liferay.dynamic.data.mapping.service.DDMFormInstanceRecordVersionLocalService;
import com.liferay.dynamic.data.mapping.uad.anonymizer.BaseDDMFormInstanceRecordUADAnonymizer;
import com.liferay.dynamic.data.mapping.uad.constants.DDMUADConstants;
import com.liferay.portal.kernel.dao.orm.ActionableDynamicQuery;
import com.liferay.portal.kernel.dao.orm.Criterion;
import com.liferay.portal.kernel.dao.orm.Disjunction;
import com.liferay.portal.kernel.dao.orm.DynamicQuery;
import com.liferay.portal.kernel.dao.orm.ProjectionFactoryUtil;
import com.liferay.portal.kernel.dao.orm.Property;
import com.liferay.portal.kernel.dao.orm.PropertyFactoryUtil;
import com.liferay.portal.kernel.dao.orm.RestrictionsFactoryUtil;
import com.liferay.portal.kernel.exception.PortalException;
import com.liferay.portal.kernel.model.User;
import com.liferay.user.associated.data.anonymizer.UADAnonymizer;
import java.util.List;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.Reference;

@Component(service={UADAnonymizer.class})
public class DDMFormInstanceRecordUADAnonymizer
extends BaseDDMFormInstanceRecordUADAnonymizer {
    @Reference
    private DDMFormInstanceRecordVersionLocalService _ddmFormInstanceRecordVersionLocalService;

    @Override
    public void autoAnonymize(DDMFormInstanceRecord ddmFormInstanceRecord, long userId, User anonymousUser) throws PortalException {
        super.autoAnonymize(ddmFormInstanceRecord, userId, anonymousUser);
        List ddmFormInstanceRecordVersions = this._ddmFormInstanceRecordVersionLocalService.getFormInstanceRecordVersions(ddmFormInstanceRecord.getFormInstanceRecordId(), -1, -1, null);
        for (DDMFormInstanceRecordVersion ddmFormInstanceRecordVersion : ddmFormInstanceRecordVersions) {
            if (ddmFormInstanceRecordVersion.getUserId() == userId) {
                ddmFormInstanceRecordVersion.setUserId(anonymousUser.getUserId());
                ddmFormInstanceRecordVersion.setUserName(anonymousUser.getFullName());
            }
            if (ddmFormInstanceRecordVersion.getStatusByUserId() == userId) {
                ddmFormInstanceRecordVersion.setStatusByUserId(anonymousUser.getUserId());
                ddmFormInstanceRecordVersion.setStatusByUserName(anonymousUser.getFullName());
            }
            this._ddmFormInstanceRecordVersionLocalService.updateDDMFormInstanceRecordVersion(ddmFormInstanceRecordVersion);
        }
    }

    protected ActionableDynamicQuery getActionableDynamicQuery(long userId) {
        ActionableDynamicQuery actionableDynamicQuery = this.doGetActionableDynamicQuery();
        actionableDynamicQuery.setAddCriteriaMethod(dynamicQuery -> {
            Disjunction disjunction = RestrictionsFactoryUtil.disjunction();
            Property formInstanceRecordIdProperty = PropertyFactoryUtil.forName((String)"formInstanceRecordId");
            for (String userIdFieldName : DDMUADConstants.USER_ID_FIELD_NAMES_DDM_FORM_INSTANCE_RECORD) {
                disjunction.add(RestrictionsFactoryUtil.eq((String)userIdFieldName, (Object)userId));
            }
            DynamicQuery formInstanceRecordIdDynamicQuery = this._ddmFormInstanceRecordVersionLocalService.dynamicQuery();
            formInstanceRecordIdDynamicQuery.add(RestrictionsFactoryUtil.eq((String)"statusByUserId", (Object)userId));
            formInstanceRecordIdDynamicQuery.setProjection(ProjectionFactoryUtil.property((String)"formInstanceRecordId"));
            disjunction.add(formInstanceRecordIdProperty.in(formInstanceRecordIdDynamicQuery));
            dynamicQuery.add((Criterion)disjunction);
        });
        return actionableDynamicQuery;
    }
}

