/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.dynamic.data.mapping.uad.util;

import com.liferay.dynamic.data.mapping.model.DDMFormInstance;
import com.liferay.portal.kernel.log.Log;
import com.liferay.portal.kernel.log.LogFactoryUtil;
import com.liferay.portal.kernel.security.xml.SecureXMLFactoryProviderUtil;
import com.liferay.portal.kernel.util.Time;
import java.io.IOException;
import java.io.StringReader;
import java.util.Date;
import java.util.Map;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import org.w3c.dom.Document;
import org.w3c.dom.Node;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;

public class DDMUADUtil {
    private static final Log _log = LogFactoryUtil.getLog(DDMUADUtil.class);

    public static void formatCreateDate(Map<String, Object> fieldValues) {
        Date createDate = (Date)fieldValues.get("createDate");
        if (createDate != null) {
            fieldValues.put("createDate", Time.getSimpleDate((Date)createDate, (String)"MMM dd yyyy 'at' HH:mm"));
        }
    }

    public static String getFormattedName(DDMFormInstance ddmFormInstance) {
        Document document = DDMUADUtil.toDocument(ddmFormInstance.getName());
        Node firstChildNode = document.getFirstChild();
        return firstChildNode.getTextContent();
    }

    public static Document toDocument(String xml) {
        try {
            DocumentBuilderFactory documentBuilderFactory = SecureXMLFactoryProviderUtil.newDocumentBuilderFactory();
            DocumentBuilder documentBuilder = documentBuilderFactory.newDocumentBuilder();
            return documentBuilder.parse(new InputSource(new StringReader(xml)));
        }
        catch (IOException | ParserConfigurationException | SAXException exception) {
            _log.error((Throwable)exception);
            return null;
        }
    }
}

