/**
 * Copyright (c) 2000-present Liferay, Inc. All rights reserved.
 *
 * This library is free software; you can redistribute it and/or modify it under
 * the terms of the GNU Lesser General Public License as published by the Free
 * Software Foundation; either version 2.1 of the License, or (at your option)
 * any later version.
 *
 * This library is distributed in the hope that it will be useful, but WITHOUT
 * ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or FITNESS
 * FOR A PARTICULAR PURPOSE. See the GNU Lesser General Public License for more
 * details.
 */

package com.liferay.dynamic.data.mapping.uad.anonymizer;

import com.liferay.asset.kernel.model.AssetEntry;
import com.liferay.asset.kernel.service.AssetEntryLocalService;
import com.liferay.dynamic.data.mapping.model.DDMFormInstance;
import com.liferay.dynamic.data.mapping.service.DDMFormInstanceLocalService;
import com.liferay.dynamic.data.mapping.uad.constants.DDMUADConstants;
import com.liferay.portal.kernel.dao.orm.ActionableDynamicQuery;
import com.liferay.portal.kernel.exception.PortalException;
import com.liferay.portal.kernel.model.User;
import com.liferay.user.associated.data.anonymizer.DynamicQueryUADAnonymizer;

import org.osgi.service.component.annotations.Reference;

/**
 * Provides the base implementation for the ddm form instance UAD anonymizer.
 *
 * <p>
 * This implementation exists only as a container for the default methods
 * generated by ServiceBuilder. All custom service methods should be put in
 * {@link DDMFormInstanceUADAnonymizer}.
 * </p>
 *
 * @author Brian Wing Shun Chan
 * @generated
 */
public abstract class BaseDDMFormInstanceUADAnonymizer
	extends DynamicQueryUADAnonymizer<DDMFormInstance> {

	@Override
	public void autoAnonymize(
			DDMFormInstance ddmFormInstance, long userId, User anonymousUser)
		throws PortalException {

		if (ddmFormInstance.getUserId() == userId) {
			ddmFormInstance.setUserId(anonymousUser.getUserId());
			ddmFormInstance.setUserName(anonymousUser.getFullName());

			autoAnonymizeAssetEntry(ddmFormInstance, anonymousUser);
		}

		if (ddmFormInstance.getVersionUserId() == userId) {
			ddmFormInstance.setVersionUserId(anonymousUser.getUserId());
			ddmFormInstance.setVersionUserName(anonymousUser.getFullName());
		}

		ddmFormInstanceLocalService.updateDDMFormInstance(ddmFormInstance);
	}

	@Override
	public void delete(DDMFormInstance ddmFormInstance) throws PortalException {
		ddmFormInstanceLocalService.deleteFormInstance(ddmFormInstance);
	}

	@Override
	public Class<DDMFormInstance> getTypeClass() {
		return DDMFormInstance.class;
	}

	protected void autoAnonymizeAssetEntry(
		DDMFormInstance ddmFormInstance, User anonymousUser) {

		AssetEntry assetEntry = fetchAssetEntry(ddmFormInstance);

		if (assetEntry != null) {
			assetEntry.setUserId(anonymousUser.getUserId());
			assetEntry.setUserName(anonymousUser.getFullName());

			assetEntryLocalService.updateAssetEntry(assetEntry);
		}
	}

	@Override
	protected ActionableDynamicQuery doGetActionableDynamicQuery() {
		return ddmFormInstanceLocalService.getActionableDynamicQuery();
	}

	@Override
	protected String[] doGetUserIdFieldNames() {
		return DDMUADConstants.USER_ID_FIELD_NAMES_DDM_FORM_INSTANCE;
	}

	protected AssetEntry fetchAssetEntry(DDMFormInstance ddmFormInstance) {
		return assetEntryLocalService.fetchEntry(
			DDMFormInstance.class.getName(),
			ddmFormInstance.getFormInstanceId());
	}

	@Reference
	protected AssetEntryLocalService assetEntryLocalService;

	@Reference
	protected DDMFormInstanceLocalService ddmFormInstanceLocalService;

}