/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.dynamic.data.mapping.internal.upgrade.v1_1_2;

import com.liferay.dynamic.data.mapping.io.DDMFormDeserializer;
import com.liferay.dynamic.data.mapping.io.DDMFormSerializer;
import com.liferay.dynamic.data.mapping.io.DDMFormSerializerSerializeRequest;
import com.liferay.dynamic.data.mapping.io.DDMFormSerializerSerializeResponse;
import com.liferay.dynamic.data.mapping.io.DDMFormValuesDeserializer;
import com.liferay.dynamic.data.mapping.io.DDMFormValuesSerializer;
import com.liferay.dynamic.data.mapping.model.DDMForm;
import com.liferay.dynamic.data.mapping.model.DDMFormField;
import com.liferay.dynamic.data.mapping.model.LocalizedValue;
import com.liferay.dynamic.data.mapping.model.Value;
import com.liferay.dynamic.data.mapping.storage.DDMFormFieldValue;
import com.liferay.dynamic.data.mapping.storage.DDMFormValues;
import com.liferay.dynamic.data.mapping.util.DDMFormDeserializeUtil;
import com.liferay.dynamic.data.mapping.util.DDMFormFieldValueTransformer;
import com.liferay.dynamic.data.mapping.util.DDMFormValuesDeserializeUtil;
import com.liferay.dynamic.data.mapping.util.DDMFormValuesSerializeUtil;
import com.liferay.dynamic.data.mapping.util.DDMFormValuesTransformer;
import com.liferay.petra.string.StringBundler;
import com.liferay.portal.kernel.dao.jdbc.AutoBatchPreparedStatementUtil;
import com.liferay.portal.kernel.exception.PortalException;
import com.liferay.portal.kernel.json.JSONArray;
import com.liferay.portal.kernel.json.JSONException;
import com.liferay.portal.kernel.json.JSONFactory;
import com.liferay.portal.kernel.log.Log;
import com.liferay.portal.kernel.log.LogFactoryUtil;
import com.liferay.portal.kernel.upgrade.UpgradeException;
import com.liferay.portal.kernel.upgrade.UpgradeProcess;
import com.liferay.portal.kernel.util.Validator;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;

public class UpgradeDynamicDataMapping
extends UpgradeProcess {
    private static final Log _log = LogFactoryUtil.getLog(UpgradeDynamicDataMapping.class);
    private final DDMFormDeserializer _ddmFormDeserializer;
    private final Map<Long, DDMForm> _ddmForms = new HashMap<Long, DDMForm>();
    private final DDMFormSerializer _ddmFormSerializer;
    private final DDMFormValuesDeserializer _ddmFormValuesDeserializer;
    private final DDMFormValuesSerializer _ddmFormValuesSerializer;
    private final Map<Long, DDMForm> _fullHierarchyDDMForms = new HashMap<Long, DDMForm>();
    private final JSONFactory _jsonFactory;

    public UpgradeDynamicDataMapping(DDMFormDeserializer ddmFormDeserializer, DDMFormSerializer ddmFormSerializer, DDMFormValuesDeserializer ddmFormValuesDeserializer, DDMFormValuesSerializer ddmFormValuesSerializer, JSONFactory jsonFactory) {
        this._ddmFormDeserializer = ddmFormDeserializer;
        this._ddmFormSerializer = ddmFormSerializer;
        this._ddmFormValuesDeserializer = ddmFormValuesDeserializer;
        this._ddmFormValuesSerializer = ddmFormValuesSerializer;
        this._jsonFactory = jsonFactory;
    }

    protected String convertJSONArrayToString(String value) {
        try {
            JSONArray jsonArray = this._jsonFactory.createJSONArray(value);
            if (jsonArray.length() == 0) {
                return "";
            }
            return jsonArray.getString(0);
        }
        catch (JSONException jsonException) {
            if (_log.isWarnEnabled()) {
                _log.warn((Object)jsonException, (Throwable)jsonException);
            }
            return value;
        }
    }

    protected void doUpgrade() throws Exception {
        this.upgradeDDMStructureReferences();
        this.upgradeDDLDDMContentReferences();
        this.upgradeDLDDMContentReferences();
    }

    protected DDMForm getDDMForm(long structureId) throws Exception {
        DDMForm ddmForm = this._ddmForms.get(structureId);
        if (ddmForm != null) {
            return ddmForm;
        }
        try (PreparedStatement ps = this.connection.prepareStatement("select definition from DDMStructure where structureId = ?");){
            ps.setLong(1, structureId);
            try (ResultSet rs = ps.executeQuery();){
                if (rs.next()) {
                    ddmForm = DDMFormDeserializeUtil.deserialize((DDMFormDeserializer)this._ddmFormDeserializer, (String)rs.getString("definition"));
                    this._ddmForms.put(structureId, ddmForm);
                    DDMForm dDMForm = ddmForm;
                    return dDMForm;
                }
            }
        }
        throw new UpgradeException("Unable to find dynamic data mapping structure with ID " + structureId);
    }

    protected DDMForm getFullHierarchyDDMForm(long structureId) throws Exception {
        DDMForm fullHierarchyDDMForm = this._fullHierarchyDDMForms.get(structureId);
        if (fullHierarchyDDMForm != null) {
            return fullHierarchyDDMForm;
        }
        try (PreparedStatement ps = this.connection.prepareStatement("select parentStructureId from DDMStructure where structureId = ?");){
            ps.setLong(1, structureId);
            try (ResultSet rs = ps.executeQuery();){
                if (rs.next()) {
                    long parentStructureId = rs.getLong("parentStructureId");
                    fullHierarchyDDMForm = this.getDDMForm(structureId);
                    if (parentStructureId > 0L) {
                        DDMForm parentDDMForm = this.getFullHierarchyDDMForm(parentStructureId);
                        List ddmFormFields = fullHierarchyDDMForm.getDDMFormFields();
                        ddmFormFields.addAll(parentDDMForm.getDDMFormFields());
                    }
                    this._fullHierarchyDDMForms.put(structureId, fullHierarchyDDMForm);
                    DDMForm dDMForm = fullHierarchyDDMForm;
                    return dDMForm;
                }
            }
        }
        throw new UpgradeException("Unable to find dynamic data mapping structure with ID " + structureId);
    }

    protected String serialize(DDMForm ddmForm) {
        DDMFormSerializerSerializeRequest.Builder builder = DDMFormSerializerSerializeRequest.Builder.newBuilder((DDMForm)ddmForm);
        DDMFormSerializerSerializeResponse ddmFormSerializerSerializeResponse = this._ddmFormSerializer.serialize(builder.build());
        return ddmFormSerializerSerializeResponse.getContent();
    }

    protected void transformDDMFormFieldValues(DDMFormValues ddmFormValues) throws Exception {
        DDMFormValuesTransformer ddmFormValuesTransformer = new DDMFormValuesTransformer(ddmFormValues);
        ddmFormValuesTransformer.addTransformer((DDMFormFieldValueTransformer)new RadioDDMFormFieldValueTransformer());
        ddmFormValuesTransformer.addTransformer((DDMFormFieldValueTransformer)new SelectDDMFormFieldValueTransformer());
        ddmFormValuesTransformer.transform();
    }

    protected void updateDDMFormField(DDMFormField ddmFormField) throws Exception {
        String dataSourceType;
        String type = ddmFormField.getType();
        if (type.equals("radio")) {
            LocalizedValue predefinedValue = ddmFormField.getPredefinedValue();
            for (Locale locale : predefinedValue.getAvailableLocales()) {
                String valueString = predefinedValue.getString(locale);
                if (Validator.isNull((String)valueString)) continue;
                predefinedValue.addString(locale, this.convertJSONArrayToString(valueString));
            }
        } else if (!(!type.equals("select") || (dataSourceType = ddmFormField.getDataSourceType()).startsWith("[") && dataSourceType.endsWith("]"))) {
            ddmFormField.setProperty("dataSourceType", (Object)("[\"" + dataSourceType + "\"]"));
        }
    }

    protected void updateDDMFormFields(DDMForm ddmForm) throws Exception {
        Map ddmFormFieldsMap = ddmForm.getDDMFormFieldsMap(true);
        for (Map.Entry entry : ddmFormFieldsMap.entrySet()) {
            this.updateDDMFormField((DDMFormField)entry.getValue());
        }
    }

    protected void upgradeDDLDDMContentReferences() throws Exception {
        StringBundler sb = new StringBundler(7);
        sb.append("select DDMContent.contentId, DDMContent.data_, ");
        sb.append("DDMStructure.structureId from DDLRecordVersion inner join ");
        sb.append("DDLRecordSet on DDLRecordVersion.recordSetId = ");
        sb.append("DDLRecordSet.recordSetId inner join DDMContent on  ");
        sb.append("DDLRecordVersion.DDMStorageId = DDMContent.contentId ");
        sb.append("inner join DDMStructure on DDLRecordSet.DDMStructureId = ");
        sb.append("DDMStructure.structureId");
        this.upgradeDDMContentReferences(sb.toString());
    }

    protected void upgradeDDMContentReferences(String query) throws Exception {
        try (PreparedStatement ps1 = this.connection.prepareStatement(query);
             PreparedStatement ps2 = AutoBatchPreparedStatementUtil.concurrentAutoBatch((Connection)this.connection, (String)"update DDMContent set data_= ? where contentId = ?");
             ResultSet rs = ps1.executeQuery();){
            while (rs.next()) {
                String data = rs.getString("data_");
                long ddmStructureId = rs.getLong("structureId");
                DDMForm ddmForm = this.getFullHierarchyDDMForm(ddmStructureId);
                DDMFormValues ddmFormValues = DDMFormValuesDeserializeUtil.deserialize((String)data, (DDMForm)ddmForm, (DDMFormValuesDeserializer)this._ddmFormValuesDeserializer);
                this.transformDDMFormFieldValues(ddmFormValues);
                ps2.setString(1, DDMFormValuesSerializeUtil.serialize((DDMFormValues)ddmFormValues, (DDMFormValuesSerializer)this._ddmFormValuesSerializer));
                long contentId = rs.getLong("contentId");
                ps2.setLong(2, contentId);
                ps2.addBatch();
            }
            ps2.executeBatch();
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    protected void upgradeDDMStructureReferences() throws Exception {
        try (PreparedStatement ps1 = this.connection.prepareStatement("select DDMStructure.structureId from DDMStructure");
             PreparedStatement ps2 = AutoBatchPreparedStatementUtil.concurrentAutoBatch((Connection)this.connection, (String)"update DDMStructure set definition = ? where structureId = ?");
             PreparedStatement ps3 = this.connection.prepareStatement("select structureVersionId, definition from DDMStructureVersion where structureId = ?");
             PreparedStatement ps4 = AutoBatchPreparedStatementUtil.concurrentAutoBatch((Connection)this.connection, (String)"update DDMStructureVersion set definition = ? where structureVersionId = ?");){
            try (ResultSet rs = ps1.executeQuery();){
                while (rs.next()) {
                    ResultSet rs2;
                    block71: {
                        long ddmStructureId = rs.getLong("structureId");
                        DDMForm ddmForm = this.getDDMForm(ddmStructureId);
                        this.updateDDMFormFields(ddmForm);
                        ps2.setString(1, this.serialize(ddmForm));
                        ps2.setLong(2, ddmStructureId);
                        ps2.addBatch();
                        ps3.setLong(1, ddmStructureId);
                        rs2 = ps3.executeQuery();
                        Throwable throwable = null;
                        try {
                            while (rs2.next()) {
                                ddmForm = DDMFormDeserializeUtil.deserialize((DDMFormDeserializer)this._ddmFormDeserializer, (String)rs2.getString("definition"));
                                this.updateDDMFormFields(ddmForm);
                                ps4.setString(1, this.serialize(ddmForm));
                                long structureVersionId = rs2.getLong("structureVersionId");
                                ps4.setLong(2, structureVersionId);
                                ps4.addBatch();
                            }
                            if (rs2 == null) continue;
                            if (throwable == null) break block71;
                        }
                        catch (Throwable throwable2) {
                            try {
                                throwable = throwable2;
                                throw throwable2;
                            }
                            catch (Throwable throwable3) {
                                if (rs2 == null) throw throwable3;
                                if (throwable == null) {
                                    rs2.close();
                                    throw throwable3;
                                }
                                try {
                                    rs2.close();
                                    throw throwable3;
                                }
                                catch (Throwable throwable4) {
                                    throwable.addSuppressed(throwable4);
                                    throw throwable3;
                                }
                            }
                        }
                        try {
                            rs2.close();
                            continue;
                        }
                        catch (Throwable throwable5) {
                            throwable.addSuppressed(throwable5);
                            continue;
                        }
                    }
                    rs2.close();
                }
            }
            ps2.executeBatch();
            ps4.executeBatch();
            return;
        }
    }

    protected void upgradeDLDDMContentReferences() throws Exception {
        StringBundler sb = new StringBundler(9);
        sb.append("select DDMContent.contentId, DDMContent.data_,");
        sb.append("DDMStructure.structureId from DLFileEntryMetadata inner ");
        sb.append("join DDMContent on DLFileEntryMetadata.DDMStorageId = ");
        sb.append("DDMContent.contentId inner join DDMStructure on ");
        sb.append("DLFileEntryMetadata.DDMStructureId = DDMStructure.");
        sb.append("structureId inner join DLFileVersion on ");
        sb.append("DLFileEntryMetadata.fileVersionId = DLFileVersion.");
        sb.append("fileVersionId and DLFileEntryMetadata.fileEntryId = ");
        sb.append("DLFileVersion.fileEntryId");
        this.upgradeDDMContentReferences(sb.toString());
    }

    protected class SelectDDMFormFieldValueTransformer
    implements DDMFormFieldValueTransformer {
        protected SelectDDMFormFieldValueTransformer() {
        }

        public String getFieldType() {
            return "select";
        }

        public void transform(DDMFormFieldValue ddmFormFieldValue) throws PortalException {
            Value value = ddmFormFieldValue.getValue();
            if (value != null) {
                for (Locale locale : value.getAvailableLocales()) {
                    String valueString = value.getString(locale);
                    JSONArray jsonArray = this.convertToJSONArray(valueString);
                    value.addString(locale, jsonArray.toString());
                }
            }
        }

        protected JSONArray convertToJSONArray(String value) {
            if (Validator.isNull((String)value)) {
                return UpgradeDynamicDataMapping.this._jsonFactory.createJSONArray();
            }
            try {
                return UpgradeDynamicDataMapping.this._jsonFactory.createJSONArray(value);
            }
            catch (Exception exception) {
                JSONArray jsonArray = UpgradeDynamicDataMapping.this._jsonFactory.createJSONArray();
                jsonArray.put(value);
                return jsonArray;
            }
        }
    }

    protected class RadioDDMFormFieldValueTransformer
    implements DDMFormFieldValueTransformer {
        protected RadioDDMFormFieldValueTransformer() {
        }

        public String getFieldType() {
            return "radio";
        }

        public void transform(DDMFormFieldValue ddmFormFieldValue) throws PortalException {
            Value value = ddmFormFieldValue.getValue();
            if (value != null) {
                for (Locale locale : value.getAvailableLocales()) {
                    String valueString = value.getString(locale);
                    if (Validator.isNull((String)valueString)) continue;
                    value.addString(locale, UpgradeDynamicDataMapping.this.convertJSONArrayToString(valueString));
                }
            }
        }
    }
}

