/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.dynamic.data.mapping.internal.util;

import com.liferay.dynamic.data.mapping.io.DDMFormDeserializer;
import com.liferay.dynamic.data.mapping.io.DDMFormDeserializerDeserializeRequest;
import com.liferay.dynamic.data.mapping.io.DDMFormDeserializerDeserializeResponse;
import com.liferay.dynamic.data.mapping.io.DDMFormLayoutDeserializer;
import com.liferay.dynamic.data.mapping.io.DDMFormLayoutDeserializerDeserializeRequest;
import com.liferay.dynamic.data.mapping.io.DDMFormLayoutDeserializerDeserializeResponse;
import com.liferay.dynamic.data.mapping.model.DDMForm;
import com.liferay.dynamic.data.mapping.model.DDMFormField;
import com.liferay.dynamic.data.mapping.model.DDMFormFieldOptions;
import com.liferay.dynamic.data.mapping.model.DDMFormLayout;
import com.liferay.dynamic.data.mapping.model.DDMStructure;
import com.liferay.dynamic.data.mapping.model.LocalizedValue;
import com.liferay.dynamic.data.mapping.service.DDMStructureLocalService;
import com.liferay.dynamic.data.mapping.service.DDMTemplateLocalService;
import com.liferay.dynamic.data.mapping.storage.StorageType;
import com.liferay.dynamic.data.mapping.util.DDM;
import com.liferay.dynamic.data.mapping.util.DefaultDDMStructureHelper;
import com.liferay.portal.kernel.language.Language;
import com.liferay.portal.kernel.service.ServiceContext;
import com.liferay.portal.kernel.upgrade.util.UpgradeProcessUtil;
import com.liferay.portal.kernel.util.FileUtil;
import com.liferay.portal.kernel.util.GetterUtil;
import com.liferay.portal.kernel.util.Portal;
import com.liferay.portal.kernel.util.ResourceBundleUtil;
import com.liferay.portal.kernel.util.StringUtil;
import com.liferay.portal.kernel.xml.Document;
import com.liferay.portal.kernel.xml.Element;
import com.liferay.portal.kernel.xml.UnsecureSAXReaderUtil;
import java.io.Serializable;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.ResourceBundle;
import java.util.Set;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.Reference;

@Component(immediate=true, service={DefaultDDMStructureHelper.class})
public class DefaultDDMStructureHelperImpl
implements DefaultDDMStructureHelper {
    private DDM _ddm;
    private DDMStructureLocalService _ddmStructureLocalService;
    private DDMTemplateLocalService _ddmTemplateLocalService;
    @Reference(target="(ddm.form.deserializer.type=json)")
    private DDMFormDeserializer _jsonDDMFormDeserializer;
    @Reference(target="(ddm.form.layout.deserializer.type=json)")
    private DDMFormLayoutDeserializer _jsonDDMFormLayoutDeserializer;
    @Reference
    private Language _language;
    @Reference
    private Portal _portal;
    @Reference(target="(ddm.form.deserializer.type=xsd)")
    private DDMFormDeserializer _xsdDDMFormDeserializer;

    public void addDDMStructures(long userId, long groupId, long classNameId, ClassLoader classLoader, String fileName, ServiceContext serviceContext) throws Exception {
        Locale locale = this._portal.getSiteDefaultLocale(groupId);
        List<Element> structureElements = this.getDDMStructures(classLoader, fileName, locale);
        for (Element structureElement : structureElements) {
            String name;
            String ddmStructureKey;
            DDMStructure ddmStructure;
            boolean dynamicStructure = GetterUtil.getBoolean((String)structureElement.elementText("dynamic-structure"));
            if (dynamicStructure || (ddmStructure = this._ddmStructureLocalService.fetchStructure(groupId, classNameId, ddmStructureKey = (name = structureElement.elementText("name")))) != null || name.equals("image-gallery-image") && !UpgradeProcessUtil.isCreateIGImageDocumentType()) continue;
            String description = structureElement.elementText("description");
            HashMap<Locale, String> nameMap = new HashMap<Locale, String>();
            HashMap<Locale, String> descriptionMap = new HashMap<Locale, String>();
            for (Locale curLocale : this._language.getAvailableLocales(groupId)) {
                ResourceBundle resourceBundle = ResourceBundleUtil.getBundle((Locale)curLocale, this.getClass());
                nameMap.put(curLocale, this._language.get(resourceBundle, name));
                descriptionMap.put(curLocale, this._language.get(resourceBundle, description));
            }
            DDMForm ddmForm = this.getDDMForm(groupId, locale, structureElement);
            DDMFormLayout ddmFormLayout = this.getDDMFormLayout(structureElement, ddmForm);
            serviceContext.setAttribute("status", (Serializable)Integer.valueOf(0));
            ddmStructure = this._ddmStructureLocalService.addStructure(userId, groupId, 0L, classNameId, ddmStructureKey, nameMap, descriptionMap, ddmForm, ddmFormLayout, StorageType.JSON.toString(), 0, serviceContext);
            Element templateElement = structureElement.element("template");
            if (templateElement == null) continue;
            String templateFileName = templateElement.elementText("file-name");
            String script = StringUtil.read((ClassLoader)classLoader, (String)(FileUtil.getPath((String)fileName) + "/" + templateFileName));
            boolean cacheable = GetterUtil.getBoolean((String)templateElement.elementText("cacheable"));
            this._ddmTemplateLocalService.addTemplate(userId, groupId, this._portal.getClassNameId(DDMStructure.class), ddmStructure.getStructureId(), ddmStructure.getClassNameId(), name, nameMap, null, "display", "create", "ftl", script, cacheable, false, "", null, serviceContext);
        }
    }

    public String getDynamicDDMStructureDefinition(ClassLoader classLoader, String fileName, String dynamicDDMStructureName, Locale locale) throws Exception {
        List<Element> structureElements = this.getDDMStructures(classLoader, fileName, locale);
        for (Element structureElement : structureElements) {
            String name;
            boolean dynamicStructure = GetterUtil.getBoolean((String)structureElement.elementText("dynamic-structure"));
            if (!dynamicStructure || !(name = structureElement.elementText("name")).equals(dynamicDDMStructureName)) continue;
            Element structureElementRootElement = structureElement.element("root");
            return structureElementRootElement.asXML();
        }
        return null;
    }

    protected DDMForm deserialize(String content, DDMFormDeserializer ddmFormDeserializer) {
        DDMFormDeserializerDeserializeRequest.Builder builder = DDMFormDeserializerDeserializeRequest.Builder.newBuilder((String)content);
        DDMFormDeserializerDeserializeResponse ddmFormDeserializerDeserializeResponse = ddmFormDeserializer.deserialize(builder.build());
        return ddmFormDeserializerDeserializeResponse.getDDMForm();
    }

    protected DDMForm getDDMForm(long groupId, Locale locale, Element structureElement) {
        Element structureElementDefinitionElement = structureElement.element("definition");
        if (structureElementDefinitionElement != null) {
            return this.deserialize(structureElementDefinitionElement.getTextTrim(), this._jsonDDMFormDeserializer);
        }
        Element structureElementRootElement = structureElement.element("root");
        String definition = structureElementRootElement.asXML();
        DDMForm ddmForm = this.deserialize(definition, this._xsdDDMFormDeserializer);
        ddmForm = this._ddm.updateDDMFormDefaultLocale(ddmForm, locale);
        return this._getPopulateDDMForm(ddmForm, locale, this._language.getAvailableLocales(groupId));
    }

    protected DDMFormLayout getDDMFormLayout(Element structureElement, DDMForm ddmForm) {
        Element structureElementLayoutElement = structureElement.element("layout");
        if (structureElementLayoutElement != null) {
            DDMFormLayoutDeserializerDeserializeRequest.Builder builder = DDMFormLayoutDeserializerDeserializeRequest.Builder.newBuilder((String)structureElementLayoutElement.getTextTrim());
            DDMFormLayoutDeserializerDeserializeResponse ddmFormLayoutDeserializerDeserializeResponse = this._jsonDDMFormLayoutDeserializer.deserialize(builder.build());
            return ddmFormLayoutDeserializerDeserializeResponse.getDDMFormLayout();
        }
        return this._ddm.getDefaultDDMFormLayout(ddmForm);
    }

    protected List<Element> getDDMStructures(ClassLoader classLoader, String fileName, Locale locale) throws Exception {
        String xml = StringUtil.read((ClassLoader)classLoader, (String)fileName);
        xml = StringUtil.replace((String)xml, (String)"[$LOCALE_DEFAULT$]", (String)locale.toString());
        Document document = UnsecureSAXReaderUtil.read((String)xml);
        Element rootElement = document.getRootElement();
        return rootElement.elements("structure");
    }

    @Reference(unbind="-")
    protected void setDDM(DDM ddm) {
        this._ddm = ddm;
    }

    @Reference(unbind="-")
    protected void setDDMStructureLocalService(DDMStructureLocalService ddmStructureLocalService) {
        this._ddmStructureLocalService = ddmStructureLocalService;
    }

    @Reference(unbind="-")
    protected void setDDMTemplateLocalService(DDMTemplateLocalService ddmTemplateLocalService) {
        this._ddmTemplateLocalService = ddmTemplateLocalService;
    }

    private DDMForm _getPopulateDDMForm(DDMForm ddmForm, Locale defaultLocale, Set<Locale> locales) {
        for (Locale locale : locales) {
            ddmForm.addAvailableLocale(locale);
        }
        ddmForm.setDDMFormFields(this._getPopulateDDMFormFields(ddmForm.getDDMFormFields(), defaultLocale, locales));
        return ddmForm;
    }

    private List<DDMFormField> _getPopulateDDMFormFields(List<DDMFormField> ddmFormFields, Locale defaultLocale, Set<Locale> locales) {
        for (DDMFormField ddmFormField : ddmFormFields) {
            DDMFormFieldOptions ddmFormFieldOptions = ddmFormField.getDDMFormFieldOptions();
            Map options = ddmFormFieldOptions.getOptions();
            for (Map.Entry entry : options.entrySet()) {
                options.put(entry.getKey(), this._getPopulateLocalizedValue(defaultLocale, locales, (LocalizedValue)entry.getValue()));
            }
            ddmFormField.setDDMFormFieldOptions(ddmFormFieldOptions);
            ddmFormField.setLabel(this._getPopulateLocalizedValue(defaultLocale, locales, ddmFormField.getLabel()));
            ddmFormField.setNestedDDMFormFields(this._getPopulateDDMFormFields(ddmFormField.getNestedDDMFormFields(), defaultLocale, locales));
            ddmFormField.setTip(this._getPopulateLocalizedValue(defaultLocale, locales, ddmFormField.getTip()));
        }
        return ddmFormFields;
    }

    private LocalizedValue _getPopulateLocalizedValue(Locale defaultLocale, Set<Locale> locales, LocalizedValue localizedValue) {
        String defaultValue = localizedValue.getString(defaultLocale);
        for (Locale locale : locales) {
            ResourceBundle resourceBundle = ResourceBundleUtil.getBundle((Locale)locale, this.getClass());
            localizedValue.addString(locale, this._language.get(resourceBundle, defaultValue));
        }
        return localizedValue;
    }
}

