/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.dynamic.data.mapping.internal.upgrade.v3_2_5;

import com.liferay.dynamic.data.mapping.io.DDMFormDeserializer;
import com.liferay.dynamic.data.mapping.io.DDMFormDeserializerDeserializeRequest;
import com.liferay.dynamic.data.mapping.io.DDMFormDeserializerDeserializeResponse;
import com.liferay.dynamic.data.mapping.io.DDMFormSerializer;
import com.liferay.dynamic.data.mapping.io.DDMFormSerializerSerializeRequest;
import com.liferay.dynamic.data.mapping.io.DDMFormSerializerSerializeResponse;
import com.liferay.dynamic.data.mapping.model.DDMForm;
import com.liferay.dynamic.data.mapping.model.DDMFormField;
import com.liferay.dynamic.data.mapping.model.DDMFormFieldValidation;
import com.liferay.dynamic.data.mapping.model.DDMFormFieldValidationExpression;
import com.liferay.portal.kernel.dao.jdbc.AutoBatchPreparedStatementUtil;
import com.liferay.portal.kernel.upgrade.UpgradeProcess;
import com.liferay.portal.kernel.util.PortalUtil;
import com.liferay.portal.kernel.util.Validator;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.util.Map;

public class UpgradeDDMStructureEmptyValidation
extends UpgradeProcess {
    private final DDMFormDeserializer _ddmFormDeserializer;
    private final DDMFormSerializer _ddmFormSerializer;

    public UpgradeDDMStructureEmptyValidation(DDMFormDeserializer ddmFormDeserializer, DDMFormSerializer ddmFormSerializer) {
        this._ddmFormDeserializer = ddmFormDeserializer;
        this._ddmFormSerializer = ddmFormSerializer;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void doUpgrade() throws Exception {
        try (PreparedStatement ps1 = this.connection.prepareStatement("select structureId, definition from DDMStructure where classNameId = ? and definition like '%validation%'");
             PreparedStatement ps2 = AutoBatchPreparedStatementUtil.concurrentAutoBatch((Connection)this.connection, (String)"update DDMStructure set definition = ? where structureId = ?");
             PreparedStatement ps3 = this.connection.prepareStatement("select structureVersionId, definition from DDMStructureVersion where structureId = ?");
             PreparedStatement ps4 = AutoBatchPreparedStatementUtil.concurrentAutoBatch((Connection)this.connection, (String)"update DDMStructureVersion set definition = ? where structureVersionId = ?");){
            ps1.setLong(1, PortalUtil.getClassNameId((String)"com.liferay.dynamic.data.lists.model.DDLRecordSet"));
            try (ResultSet rs = ps1.executeQuery();){
                while (rs.next()) {
                    ResultSet rs2;
                    block71: {
                        String definition = rs.getString("definition");
                        String newDefinition = this._updateDDMFormFieldValidation(definition);
                        if (newDefinition.equals(definition)) continue;
                        ps2.setString(1, newDefinition);
                        ps2.setLong(2, rs.getLong("structureId"));
                        ps2.addBatch();
                        ps3.setLong(1, rs.getLong("structureId"));
                        rs2 = ps3.executeQuery();
                        Throwable throwable = null;
                        try {
                            while (rs2.next()) {
                                definition = rs2.getString("definition");
                                newDefinition = this._updateDDMFormFieldValidation(definition);
                                if (newDefinition.equals(definition)) continue;
                                ps4.setString(1, newDefinition);
                                ps4.setLong(2, rs2.getLong("structureVersionId"));
                                ps4.addBatch();
                            }
                            if (rs2 == null) continue;
                            if (throwable == null) break block71;
                        }
                        catch (Throwable throwable2) {
                            try {
                                throwable = throwable2;
                                throw throwable2;
                            }
                            catch (Throwable throwable3) {
                                if (rs2 == null) throw throwable3;
                                if (throwable == null) {
                                    rs2.close();
                                    throw throwable3;
                                }
                                try {
                                    rs2.close();
                                    throw throwable3;
                                }
                                catch (Throwable throwable4) {
                                    throwable.addSuppressed(throwable4);
                                    throw throwable3;
                                }
                            }
                        }
                        try {
                            rs2.close();
                            continue;
                        }
                        catch (Throwable throwable5) {
                            throwable.addSuppressed(throwable5);
                            continue;
                        }
                    }
                    rs2.close();
                }
                ps2.executeBatch();
                ps4.executeBatch();
                return;
            }
        }
    }

    private String _updateDDMFormFieldValidation(String definition) {
        DDMFormDeserializerDeserializeResponse ddmFormDeserializerDeserializeResponse = this._ddmFormDeserializer.deserialize(DDMFormDeserializerDeserializeRequest.Builder.newBuilder((String)definition).build());
        DDMForm ddmForm = ddmFormDeserializerDeserializeResponse.getDDMForm();
        Map ddmFormFieldsMap = ddmForm.getDDMFormFieldsMap(true);
        for (DDMFormField ddmFormField : ddmFormFieldsMap.values()) {
            DDMFormFieldValidationExpression ddmFormFieldValidationExpression;
            DDMFormFieldValidation ddmFormFieldValidation = ddmFormField.getDDMFormFieldValidation();
            if (ddmFormFieldValidation == null || !Validator.isNull((String)(ddmFormFieldValidationExpression = ddmFormFieldValidation.getDDMFormFieldValidationExpression()).getName()) || !Validator.isNull((String)ddmFormFieldValidationExpression.getValue())) continue;
            ddmFormField.setDDMFormFieldValidation(null);
        }
        DDMFormSerializerSerializeResponse ddmFormSerializerSerializeResponse = this._ddmFormSerializer.serialize(DDMFormSerializerSerializeRequest.Builder.newBuilder((DDMForm)ddmForm).build());
        return ddmFormSerializerSerializeResponse.getContent();
    }
}

