/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.dynamic.data.mapping.service.impl;

import com.liferay.document.library.kernel.util.DLUtil;
import com.liferay.dynamic.data.mapping.exception.FormInstanceRecordGroupIdException;
import com.liferay.dynamic.data.mapping.exception.NoSuchFormInstanceRecordException;
import com.liferay.dynamic.data.mapping.exception.StorageException;
import com.liferay.dynamic.data.mapping.internal.notification.DDMFormEmailNotificationSender;
import com.liferay.dynamic.data.mapping.model.DDMContent;
import com.liferay.dynamic.data.mapping.model.DDMForm;
import com.liferay.dynamic.data.mapping.model.DDMFormInstance;
import com.liferay.dynamic.data.mapping.model.DDMFormInstanceRecord;
import com.liferay.dynamic.data.mapping.model.DDMFormInstanceRecordVersion;
import com.liferay.dynamic.data.mapping.model.DDMFormInstanceSettings;
import com.liferay.dynamic.data.mapping.model.DDMStorageLink;
import com.liferay.dynamic.data.mapping.model.DDMStructure;
import com.liferay.dynamic.data.mapping.model.DDMStructureVersion;
import com.liferay.dynamic.data.mapping.service.DDMFormInstanceRecordVersionLocalService;
import com.liferay.dynamic.data.mapping.service.DDMStorageLinkLocalService;
import com.liferay.dynamic.data.mapping.service.DDMStructureLocalService;
import com.liferay.dynamic.data.mapping.service.base.DDMFormInstanceRecordLocalServiceBaseImpl;
import com.liferay.dynamic.data.mapping.storage.DDMFormValues;
import com.liferay.dynamic.data.mapping.storage.DDMStorageAdapter;
import com.liferay.dynamic.data.mapping.storage.DDMStorageAdapterDeleteRequest;
import com.liferay.dynamic.data.mapping.storage.DDMStorageAdapterGetRequest;
import com.liferay.dynamic.data.mapping.storage.DDMStorageAdapterGetResponse;
import com.liferay.dynamic.data.mapping.storage.DDMStorageAdapterSaveRequest;
import com.liferay.dynamic.data.mapping.storage.DDMStorageAdapterSaveResponse;
import com.liferay.dynamic.data.mapping.storage.DDMStorageAdapterTracker;
import com.liferay.dynamic.data.mapping.storage.StorageType;
import com.liferay.dynamic.data.mapping.validator.DDMFormValuesValidator;
import com.liferay.expando.kernel.model.ExpandoBridge;
import com.liferay.portal.aop.AopService;
import com.liferay.portal.kernel.exception.PortalException;
import com.liferay.portal.kernel.exception.SystemException;
import com.liferay.portal.kernel.language.LanguageUtil;
import com.liferay.portal.kernel.log.Log;
import com.liferay.portal.kernel.log.LogFactoryUtil;
import com.liferay.portal.kernel.model.BaseModel;
import com.liferay.portal.kernel.model.User;
import com.liferay.portal.kernel.search.BaseModelSearchResult;
import com.liferay.portal.kernel.search.Document;
import com.liferay.portal.kernel.search.Hits;
import com.liferay.portal.kernel.search.Indexable;
import com.liferay.portal.kernel.search.IndexableType;
import com.liferay.portal.kernel.search.Indexer;
import com.liferay.portal.kernel.search.IndexerRegistry;
import com.liferay.portal.kernel.search.SearchContext;
import com.liferay.portal.kernel.service.ServiceContext;
import com.liferay.portal.kernel.systemevent.SystemEvent;
import com.liferay.portal.kernel.util.GetterUtil;
import com.liferay.portal.kernel.util.OrderByComparator;
import com.liferay.portal.kernel.util.Portal;
import com.liferay.portal.kernel.util.StringUtil;
import com.liferay.portal.kernel.workflow.WorkflowHandlerRegistryUtil;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Objects;
import java.util.ResourceBundle;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.Reference;

@Component(property={"model.class.name=com.liferay.dynamic.data.mapping.model.DDMFormInstanceRecord"}, service={AopService.class})
public class DDMFormInstanceRecordLocalServiceImpl
extends DDMFormInstanceRecordLocalServiceBaseImpl {
    private static final String[] _SELECTED_FIELD_NAMES = new String[]{"companyId", "entryClassPK", "uid"};
    private static final String _VERSION_DEFAULT = "1.0";
    private static final Log _log = LogFactoryUtil.getLog(DDMFormInstanceRecordLocalServiceImpl.class);
    @Reference
    private DDMFormEmailNotificationSender _ddmFormEmailNotificationSender;
    @Reference
    private DDMFormInstanceRecordVersionLocalService _ddmFormInstanceRecordVersionLocalService;
    @Reference
    private DDMFormValuesValidator _ddmFormValuesValidator;
    @Reference
    private DDMStorageAdapterTracker _ddmStorageAdapterTracker;
    @Reference
    private DDMStorageLinkLocalService _ddmStorageLinkLocalService;
    @Reference
    private DDMStructureLocalService _ddmStructureLocalService;
    @Reference
    private IndexerRegistry _indexerRegistry;
    @Reference
    private Portal _portal;

    @Indexable(type=IndexableType.REINDEX)
    public DDMFormInstanceRecord addFormInstanceRecord(long userId, long groupId, long ddmFormInstanceId, DDMFormValues ddmFormValues, ServiceContext serviceContext) throws PortalException {
        User user = this.userLocalService.getUser(userId);
        DDMFormInstance ddmFormInstance = this.ddmFormInstancePersistence.findByPrimaryKey(ddmFormInstanceId);
        this.validate(groupId, ddmFormInstance);
        long recordId = this.counterLocalService.increment();
        DDMFormInstanceRecord ddmFormInstanceRecord = this.ddmFormInstanceRecordPersistence.create(recordId);
        ddmFormInstanceRecord.setUuid(serviceContext.getUuid());
        ddmFormInstanceRecord.setGroupId(groupId);
        ddmFormInstanceRecord.setCompanyId(user.getCompanyId());
        ddmFormInstanceRecord.setUserId(user.getUserId());
        ddmFormInstanceRecord.setUserName(user.getFullName());
        ddmFormInstanceRecord.setVersionUserId(user.getUserId());
        ddmFormInstanceRecord.setVersionUserName(user.getFullName());
        long ddmStorageId = this.createDDMContent(ddmFormInstanceId, ddmFormValues, serviceContext);
        ddmFormInstanceRecord.setStorageId(ddmStorageId);
        ddmFormInstanceRecord.setFormInstanceId(ddmFormInstanceId);
        ddmFormInstanceRecord.setFormInstanceVersion(ddmFormInstance.getVersion());
        ddmFormInstanceRecord.setVersion(_VERSION_DEFAULT);
        ddmFormInstanceRecord = (DDMFormInstanceRecord)this.ddmFormInstanceRecordPersistence.update((BaseModel)ddmFormInstanceRecord);
        int status = GetterUtil.getInteger((Object)serviceContext.getAttribute("status"), (int)2);
        DDMFormInstanceRecordVersion ddmFormInstanceRecordVersion = this.addFormInstanceRecordVersion(user, ddmFormInstanceRecord, ddmStorageId, status, _VERSION_DEFAULT);
        this.updateAsset(userId, ddmFormInstanceRecord, ddmFormInstanceRecordVersion, serviceContext.getAssetCategoryIds(), serviceContext.getAssetTagNames(), serviceContext.getLocale(), serviceContext.getAssetPriority());
        if (serviceContext.getWorkflowAction() == 1) {
            WorkflowHandlerRegistryUtil.startWorkflowInstance((long)user.getCompanyId(), (long)groupId, (long)userId, (String)DDMFormInstanceRecord.class.getName(), (long)ddmFormInstanceRecordVersion.getFormInstanceRecordVersionId(), (Object)ddmFormInstanceRecordVersion, (ServiceContext)serviceContext);
            if (this.isEmailNotificationEnabled(ddmFormInstance)) {
                this._ddmFormEmailNotificationSender.sendEmailNotification(serviceContext, ddmFormInstanceRecord);
            }
        }
        return ddmFormInstanceRecord;
    }

    @Indexable(type=IndexableType.DELETE)
    @SystemEvent(action=1, type=1)
    public DDMFormInstanceRecord deleteFormInstanceRecord(DDMFormInstanceRecord ddmFormInstanceRecord) throws PortalException {
        this.ddmFormInstanceRecordPersistence.remove((BaseModel)ddmFormInstanceRecord);
        List ddmFormInstanceRecordVersions = this.ddmFormInstanceRecordVersionPersistence.findByFormInstanceRecordId(ddmFormInstanceRecord.getFormInstanceRecordId());
        String storageType = ddmFormInstanceRecord.getStorageType();
        for (DDMFormInstanceRecordVersion ddmFormInstanceRecordVersion : ddmFormInstanceRecordVersions) {
            this.ddmFormInstanceRecordVersionPersistence.remove((BaseModel)ddmFormInstanceRecordVersion);
            long storageId = ddmFormInstanceRecordVersion.getStorageId();
            this.deleteStorage(storageId, storageType);
            this._ddmStorageLinkLocalService.deleteClassStorageLink(storageId);
            this.deleteWorkflowInstanceLink(ddmFormInstanceRecord.getCompanyId(), ddmFormInstanceRecord.getGroupId(), ddmFormInstanceRecordVersion.getPrimaryKey());
        }
        this.assetEntryLocalService.deleteEntry(DDMFormInstanceRecord.class.getName(), ddmFormInstanceRecord.getFormInstanceRecordId());
        return ddmFormInstanceRecord;
    }

    @Indexable(type=IndexableType.DELETE)
    public DDMFormInstanceRecord deleteFormInstanceRecord(long ddmFormInstanceRecordId) throws PortalException {
        DDMFormInstanceRecord ddmFormInstanceRecord = this.ddmFormInstanceRecordPersistence.findByPrimaryKey(ddmFormInstanceRecordId);
        return this.ddmFormInstanceRecordLocalService.deleteFormInstanceRecord(ddmFormInstanceRecord);
    }

    public void deleteFormInstanceRecords(long ddmFormInstanceId) throws PortalException {
        List ddmFormInstanceRecords = this.ddmFormInstanceRecordPersistence.findByFormInstanceId(ddmFormInstanceId);
        for (DDMFormInstanceRecord ddmFormInstanceRecord : ddmFormInstanceRecords) {
            this.deleteFormInstanceRecord(ddmFormInstanceRecord);
        }
    }

    public DDMFormInstanceRecord fetchFormInstanceRecord(long ddmFormInstanceRecordId) {
        return this.ddmFormInstanceRecordPersistence.fetchByPrimaryKey(ddmFormInstanceRecordId);
    }

    public DDMFormValues getDDMFormValues(DDMForm ddmForm, long storageId, String storageType) throws StorageException {
        DDMStorageAdapter ddmStorageAdapter = this.getDDMStorageAdapter(storageType);
        DDMStorageAdapterGetRequest.Builder builder = DDMStorageAdapterGetRequest.Builder.newBuilder((long)storageId, (DDMForm)ddmForm);
        DDMStorageAdapterGetRequest ddmStorageAdapterGetRequest = builder.build();
        DDMStorageAdapterGetResponse ddmStorageAdapterGetResponse = ddmStorageAdapter.get(ddmStorageAdapterGetRequest);
        return ddmStorageAdapterGetResponse.getDDMFormValues();
    }

    @Deprecated
    public DDMFormValues getDDMFormValues(long storageId, DDMForm ddmForm) throws StorageException {
        return this.getDDMFormValues(ddmForm, storageId, StorageType.JSON.toString());
    }

    public DDMFormInstanceRecord getFormInstanceRecord(long ddmFormInstanceRecordId) throws PortalException {
        return this.ddmFormInstanceRecordPersistence.findByPrimaryKey(ddmFormInstanceRecordId);
    }

    public List<DDMFormInstanceRecord> getFormInstanceRecords(long ddmFormInstanceId) {
        return this.ddmFormInstanceRecordPersistence.findByFormInstanceId(ddmFormInstanceId);
    }

    public List<DDMFormInstanceRecord> getFormInstanceRecords(long ddmFormInstanceId, int status, int start, int end, OrderByComparator<DDMFormInstanceRecord> orderByComparator) {
        return this.ddmFormInstanceRecordFinder.findByF_S(ddmFormInstanceId, status, start, end, orderByComparator);
    }

    public List<DDMFormInstanceRecord> getFormInstanceRecords(long ddmFormInstanceId, long userId, int start, int end, OrderByComparator<DDMFormInstanceRecord> orderByComparator) {
        return this.ddmFormInstanceRecordPersistence.findByU_F(userId, ddmFormInstanceId, start, end, orderByComparator);
    }

    public int getFormInstanceRecordsCount(long ddmFormInstanceId) {
        return this.ddmFormInstanceRecordPersistence.countByFormInstanceId(ddmFormInstanceId);
    }

    public int getFormInstanceRecordsCount(long ddmFormInstanceId, int status) {
        return this.ddmFormInstanceRecordFinder.countByF_S(ddmFormInstanceId, status);
    }

    public int getFormInstanceRecordsCount(long ddmFormInstanceId, long userId) {
        return this.ddmFormInstanceRecordPersistence.countByU_F(userId, ddmFormInstanceId);
    }

    public void revertFormInstanceRecord(long userId, long ddmFormInstanceRecordId, String version, ServiceContext serviceContext) throws PortalException {
        DDMFormInstanceRecordVersion ddmFormInstanceRecordVersion = this._ddmFormInstanceRecordVersionLocalService.getFormInstanceRecordVersion(ddmFormInstanceRecordId, version);
        if (!ddmFormInstanceRecordVersion.isApproved()) {
            return;
        }
        DDMFormInstance ddmFormInstance = ddmFormInstanceRecordVersion.getFormInstance();
        DDMFormValues ddmFormValues = this.getDDMFormValues(ddmFormInstanceRecordVersion.getDDMForm(), ddmFormInstanceRecordVersion.getStorageId(), ddmFormInstance.getStorageType());
        serviceContext.setCommand("revert");
        this.updateFormInstanceRecord(userId, ddmFormInstanceRecordId, true, ddmFormValues, serviceContext);
    }

    public BaseModelSearchResult<DDMFormInstanceRecord> searchFormInstanceRecords(SearchContext searchContext) {
        try {
            Indexer<DDMFormInstanceRecord> indexer = this.getDDMFormInstanceRecordIndexer();
            Hits hits = indexer.search(searchContext, _SELECTED_FIELD_NAMES);
            return new BaseModelSearchResult(this.getFormInstanceRecords(hits), hits.getLength());
        }
        catch (Exception exception) {
            throw new SystemException((Throwable)exception);
        }
    }

    @Indexable(type=IndexableType.REINDEX)
    public DDMFormInstanceRecord updateFormInstanceRecord(long userId, long ddmFormInstanceRecordId, boolean majorVersion, DDMFormValues ddmFormValues, ServiceContext serviceContext) throws PortalException {
        this.validate(ddmFormValues, serviceContext);
        User user = this.userLocalService.getUser(userId);
        DDMFormInstanceRecord ddmFormInstanceRecord = this.ddmFormInstanceRecordPersistence.findByPrimaryKey(ddmFormInstanceRecordId);
        ddmFormInstanceRecord.setModifiedDate(serviceContext.getModifiedDate(null));
        ddmFormInstanceRecord = (DDMFormInstanceRecord)this.ddmFormInstanceRecordPersistence.update((BaseModel)ddmFormInstanceRecord);
        DDMFormInstanceRecordVersion ddmFormInstanceRecordVersion = ddmFormInstanceRecord.getLatestFormInstanceRecordVersion();
        DDMFormInstance ddmFormInstance = ddmFormInstanceRecord.getFormInstance();
        if (ddmFormInstanceRecordVersion.isApproved()) {
            long ddmStorageId = this.createDDMContent(ddmFormInstance.getFormInstanceId(), ddmFormValues, serviceContext);
            String version = this.getNextVersion(ddmFormInstanceRecordVersion.getVersion(), majorVersion, serviceContext.getWorkflowAction());
            ddmFormInstanceRecordVersion = this.addFormInstanceRecordVersion(user, ddmFormInstanceRecord, ddmStorageId, 2, version);
        } else {
            this.updateDDMContent(ddmFormInstanceRecordVersion, ddmFormValues, serviceContext);
            String version = ddmFormInstanceRecordVersion.getVersion();
            this.updateFormInstanceRecordVersion(user, ddmFormInstanceRecordVersion, ddmFormInstanceRecordVersion.getStatus(), version, serviceContext);
        }
        this.updateAsset(userId, ddmFormInstanceRecord, ddmFormInstanceRecordVersion, serviceContext.getAssetCategoryIds(), serviceContext.getAssetTagNames(), serviceContext.getLocale(), serviceContext.getAssetPriority());
        if (this.isKeepFormInstanceRecordVersionLabel(ddmFormInstanceRecord.getFormInstanceRecordVersion(), ddmFormInstanceRecordVersion, serviceContext)) {
            this.ddmFormInstanceRecordVersionPersistence.remove((BaseModel)ddmFormInstanceRecordVersion);
            this.deleteStorage(ddmFormInstanceRecordVersion.getStorageId(), ddmFormInstance.getStorageType());
            return ddmFormInstanceRecord;
        }
        if (serviceContext.getWorkflowAction() == 1) {
            WorkflowHandlerRegistryUtil.startWorkflowInstance((long)user.getCompanyId(), (long)ddmFormInstanceRecord.getGroupId(), (long)userId, (String)DDMFormInstanceRecord.class.getName(), (long)ddmFormInstanceRecordVersion.getFormInstanceRecordVersionId(), (Object)ddmFormInstanceRecordVersion, (ServiceContext)serviceContext);
            if (this.isEmailNotificationEnabled(ddmFormInstance)) {
                this._ddmFormEmailNotificationSender.sendEmailNotification(serviceContext, ddmFormInstanceRecord);
            }
        }
        return ddmFormInstanceRecord;
    }

    @Indexable(type=IndexableType.REINDEX)
    public DDMFormInstanceRecord updateStatus(long userId, long recordVersionId, int status, ServiceContext serviceContext) throws PortalException {
        User user = this.userLocalService.getUser(userId);
        DDMFormInstanceRecordVersion formInstanceRecordVersion = this.ddmFormInstanceRecordVersionPersistence.findByPrimaryKey(recordVersionId);
        formInstanceRecordVersion.setStatus(status);
        formInstanceRecordVersion.setStatusByUserId(user.getUserId());
        formInstanceRecordVersion.setStatusByUserName(user.getFullName());
        formInstanceRecordVersion.setStatusDate(new Date());
        formInstanceRecordVersion = (DDMFormInstanceRecordVersion)this.ddmFormInstanceRecordVersionPersistence.update((BaseModel)formInstanceRecordVersion);
        DDMFormInstanceRecord formInstanceRecord = this.ddmFormInstanceRecordPersistence.findByPrimaryKey(formInstanceRecordVersion.getFormInstanceRecordId());
        if (status == 0) {
            int value = DLUtil.compareVersions((String)formInstanceRecord.getVersion(), (String)formInstanceRecordVersion.getVersion());
            if (value <= 0) {
                formInstanceRecord.setVersionUserId(formInstanceRecordVersion.getUserId());
                formInstanceRecord.setVersionUserName(formInstanceRecordVersion.getUserName());
                formInstanceRecord.setFormInstanceId(formInstanceRecordVersion.getFormInstanceId());
                formInstanceRecord.setStorageId(formInstanceRecordVersion.getStorageId());
                formInstanceRecord.setVersion(formInstanceRecordVersion.getVersion());
                formInstanceRecord = (DDMFormInstanceRecord)this.ddmFormInstanceRecordPersistence.update((BaseModel)formInstanceRecord);
            }
        } else if (Objects.equals(formInstanceRecord.getVersion(), formInstanceRecordVersion.getVersion())) {
            String newVersion = _VERSION_DEFAULT;
            List approvedRecordVersions = this.ddmFormInstanceRecordVersionPersistence.findByF_S(formInstanceRecord.getFormInstanceRecordId(), 0);
            if (!approvedRecordVersions.isEmpty()) {
                DDMFormInstanceRecordVersion firstApprovedVersion = (DDMFormInstanceRecordVersion)approvedRecordVersions.get(0);
                newVersion = firstApprovedVersion.getVersion();
            }
            formInstanceRecord = this.ddmFormInstanceRecordPersistence.findByPrimaryKey(formInstanceRecordVersion.getFormInstanceRecordId());
            formInstanceRecord.setVersion(newVersion);
            formInstanceRecord = (DDMFormInstanceRecord)this.ddmFormInstanceRecordPersistence.update((BaseModel)formInstanceRecord);
        }
        return formInstanceRecord;
    }

    protected DDMFormInstanceRecordVersion addFormInstanceRecordVersion(User user, DDMFormInstanceRecord ddmFormInstanceRecord, long ddmStorageId, int status, String version) {
        long ddmFormInstanceRecordVersionId = this.counterLocalService.increment();
        DDMFormInstanceRecordVersion ddmFormInstanceRecordVersion = this.ddmFormInstanceRecordVersionPersistence.create(ddmFormInstanceRecordVersionId);
        ddmFormInstanceRecordVersion.setGroupId(ddmFormInstanceRecord.getGroupId());
        ddmFormInstanceRecordVersion.setCompanyId(ddmFormInstanceRecord.getCompanyId());
        ddmFormInstanceRecordVersion.setUserId(user.getUserId());
        ddmFormInstanceRecordVersion.setUserName(user.getFullName());
        ddmFormInstanceRecordVersion.setCreateDate(ddmFormInstanceRecord.getModifiedDate());
        ddmFormInstanceRecordVersion.setFormInstanceId(ddmFormInstanceRecord.getFormInstanceId());
        ddmFormInstanceRecordVersion.setFormInstanceVersion(ddmFormInstanceRecord.getFormInstanceVersion());
        ddmFormInstanceRecordVersion.setFormInstanceRecordId(ddmFormInstanceRecord.getFormInstanceRecordId());
        ddmFormInstanceRecordVersion.setVersion(version);
        ddmFormInstanceRecordVersion.setStorageId(ddmStorageId);
        ddmFormInstanceRecordVersion.setStatus(status);
        ddmFormInstanceRecordVersion.setStatusByUserId(user.getUserId());
        ddmFormInstanceRecordVersion.setStatusByUserName(user.getFullName());
        ddmFormInstanceRecordVersion.setStatusDate(ddmFormInstanceRecord.getModifiedDate());
        return (DDMFormInstanceRecordVersion)this.ddmFormInstanceRecordVersionPersistence.update((BaseModel)ddmFormInstanceRecordVersion);
    }

    protected long createDDMContent(long ddmFormInstanceId, DDMFormValues ddmFormValues, ServiceContext serviceContext) throws PortalException {
        this.validate(ddmFormValues, serviceContext);
        DDMStorageAdapterSaveRequest.Builder builder = DDMStorageAdapterSaveRequest.Builder.newBuilder((long)serviceContext.getUserId(), (long)serviceContext.getScopeGroupId(), (DDMFormValues)ddmFormValues);
        DDMStorageAdapterSaveRequest ddmStorageAdapterSaveRequest = builder.withUuid(serviceContext.getUuid()).withClassName(DDMStorageLink.class.getName()).build();
        DDMFormInstance ddmFormInstance = this.ddmFormInstancePersistence.findByPrimaryKey(ddmFormInstanceId);
        DDMStorageAdapter ddmStorageAdapter = this.getDDMStorageAdapter(ddmFormInstance.getStorageType());
        DDMStorageAdapterSaveResponse ddmStorageAdapterSaveResponse = ddmStorageAdapter.save(ddmStorageAdapterSaveRequest);
        long primaryKey = ddmStorageAdapterSaveResponse.getPrimaryKey();
        DDMStructure ddmStructure = ddmFormInstance.getStructure();
        DDMStructureVersion ddmStructureVersion = ddmStructure.getLatestStructureVersion();
        this._ddmStorageLinkLocalService.addStorageLink(this._portal.getClassNameId(DDMContent.class.getName()), primaryKey, ddmStructureVersion.getStructureVersionId(), serviceContext);
        return primaryKey;
    }

    protected void deleteStorage(long storageId, String storageType) throws StorageException {
        DDMStorageAdapter ddmStorageAdapter = this.getDDMStorageAdapter(storageType);
        DDMStorageAdapterDeleteRequest.Builder builder = DDMStorageAdapterDeleteRequest.Builder.newBuilder((long)storageId);
        DDMStorageAdapterDeleteRequest ddmStorageAdapterDeleteRequest = builder.build();
        ddmStorageAdapter.delete(ddmStorageAdapterDeleteRequest);
    }

    protected void deleteWorkflowInstanceLink(long companyId, long groupId, long ddmFormInstanceRecordVersionId) throws PortalException {
        this.workflowInstanceLinkLocalService.deleteWorkflowInstanceLinks(companyId, groupId, DDMFormInstanceRecord.class.getName(), ddmFormInstanceRecordVersionId);
    }

    protected Indexer<DDMFormInstanceRecord> getDDMFormInstanceRecordIndexer() {
        return this._indexerRegistry.nullSafeGetIndexer(DDMFormInstanceRecord.class);
    }

    protected DDMStorageAdapter getDDMStorageAdapter(String type) {
        return this._ddmStorageAdapterTracker.getDDMStorageAdapter(GetterUtil.getString((String)type, (String)StorageType.JSON.toString()));
    }

    protected List<DDMFormInstanceRecord> getFormInstanceRecords(Hits hits) throws PortalException {
        ArrayList<DDMFormInstanceRecord> formInstanceRecords = new ArrayList<DDMFormInstanceRecord>();
        for (Document document : hits.toList()) {
            long recordId = GetterUtil.getLong((String)document.get("entryClassPK"));
            try {
                formInstanceRecords.add(this.getFormInstanceRecord(recordId));
            }
            catch (NoSuchFormInstanceRecordException noSuchFormInstanceRecordException) {
                if (_log.isWarnEnabled()) {
                    _log.warn((Object)("DDM form instance record index is stale and contains record " + recordId), (Throwable)noSuchFormInstanceRecordException);
                }
                long companyId = GetterUtil.getLong((String)document.get("companyId"));
                Indexer<DDMFormInstanceRecord> indexer = this.getDDMFormInstanceRecordIndexer();
                indexer.delete(companyId, document.getUID());
            }
        }
        return formInstanceRecords;
    }

    protected String getNextVersion(String version, boolean majorVersion, int workflowAction) {
        if (workflowAction == 2) {
            majorVersion = false;
        }
        int[] versionParts = StringUtil.split((String)version, (String)".", (int)0);
        if (majorVersion) {
            versionParts[0] = versionParts[0] + 1;
            versionParts[1] = 0;
        } else {
            versionParts[1] = versionParts[1] + 1;
        }
        return versionParts[0] + "." + versionParts[1];
    }

    protected ResourceBundle getResourceBundle(Locale defaultLocale) {
        return this._portal.getResourceBundle(defaultLocale);
    }

    protected boolean isEmailNotificationEnabled(DDMFormInstance ddmFormInstance) throws PortalException {
        DDMFormInstanceSettings formInstanceSettings = ddmFormInstance.getSettingsModel();
        return formInstanceSettings.sendEmailNotification();
    }

    protected boolean isKeepFormInstanceRecordVersionLabel(DDMFormInstanceRecordVersion lastDDMFormInstanceRecordVersion, DDMFormInstanceRecordVersion latestDDMFormInstanceRecordVersion, ServiceContext serviceContext) throws PortalException {
        Map latestAttributes;
        if (Objects.equals(serviceContext.getCommand(), "revert")) {
            return false;
        }
        if (serviceContext.getWorkflowAction() == 2) {
            return false;
        }
        if (Objects.equals(lastDDMFormInstanceRecordVersion.getVersion(), latestDDMFormInstanceRecordVersion.getVersion())) {
            return false;
        }
        DDMFormInstance lastFormInstance = lastDDMFormInstanceRecordVersion.getFormInstance();
        DDMFormValues lastDDMFormValues = this.getDDMFormValues(lastDDMFormInstanceRecordVersion.getDDMForm(), lastDDMFormInstanceRecordVersion.getStorageId(), lastFormInstance.getStorageType());
        DDMFormInstance latestFormInstance = latestDDMFormInstanceRecordVersion.getFormInstance();
        DDMFormValues latestDDMFormValues = this.getDDMFormValues(latestDDMFormInstanceRecordVersion.getDDMForm(), latestDDMFormInstanceRecordVersion.getStorageId(), latestFormInstance.getStorageType());
        if (!lastDDMFormValues.equals((Object)latestDDMFormValues)) {
            return false;
        }
        ExpandoBridge lastExpandoBridge = lastDDMFormInstanceRecordVersion.getExpandoBridge();
        ExpandoBridge latestExpandoBridge = latestDDMFormInstanceRecordVersion.getExpandoBridge();
        Map lastAttributes = lastExpandoBridge.getAttributes();
        return lastAttributes.equals(latestAttributes = latestExpandoBridge.getAttributes());
    }

    protected void updateAsset(long userId, DDMFormInstanceRecord formInstanceRecord, DDMFormInstanceRecordVersion formInstanceRecordVersion, long[] assetCategoryIds, String[] assetTagNames, Locale locale, Double priority) throws PortalException {
        int approvedRecordVersionsCount;
        String version;
        boolean addDraftAssetEntry = false;
        if (formInstanceRecordVersion != null && !formInstanceRecordVersion.isApproved() && !(version = formInstanceRecordVersion.getVersion()).equals(_VERSION_DEFAULT) && (approvedRecordVersionsCount = this.ddmFormInstanceRecordVersionPersistence.countByF_S(formInstanceRecord.getFormInstanceRecordId(), 0)) > 0) {
            addDraftAssetEntry = true;
        }
        DDMFormInstance formInstance = formInstanceRecord.getFormInstance();
        String title = LanguageUtil.format((ResourceBundle)this.getResourceBundle(locale), (String)"form-record-for-form-x", (Object)formInstance.getName(locale), (boolean)false);
        if (addDraftAssetEntry) {
            this.assetEntryLocalService.updateEntry(userId, formInstanceRecord.getGroupId(), formInstanceRecord.getCreateDate(), formInstanceRecord.getModifiedDate(), DDMFormInstanceRecord.class.getName(), formInstanceRecordVersion.getFormInstanceRecordVersionId(), formInstanceRecord.getUuid(), 0L, assetCategoryIds, assetTagNames, true, true, null, null, null, null, "text/html", title, null, "", null, null, 0, 0, priority);
        } else {
            this.assetEntryLocalService.updateEntry(userId, formInstanceRecord.getGroupId(), formInstanceRecord.getCreateDate(), formInstanceRecord.getModifiedDate(), DDMFormInstanceRecord.class.getName(), formInstanceRecord.getFormInstanceRecordId(), formInstanceRecord.getUuid(), 0L, assetCategoryIds, assetTagNames, true, true, null, null, null, null, "text/html", title, null, "", null, null, 0, 0, priority);
        }
    }

    protected void updateDDMContent(DDMFormInstanceRecordVersion ddmFormInstanceRecordVersion, DDMFormValues ddmFormValues, ServiceContext serviceContext) throws PortalException {
        this.validate(ddmFormValues, serviceContext);
        DDMStorageAdapterSaveRequest.Builder builder = DDMStorageAdapterSaveRequest.Builder.newBuilder((long)serviceContext.getUserId(), (long)serviceContext.getScopeGroupId(), (DDMFormValues)ddmFormValues);
        DDMStorageAdapterSaveRequest ddmStorageAdapterSaveRequest = builder.withPrimaryKey(ddmFormInstanceRecordVersion.getStorageId()).build();
        DDMFormInstance ddmFormInstance = ddmFormInstanceRecordVersion.getFormInstance();
        DDMStorageAdapter ddmStorageAdapter = this.getDDMStorageAdapter(ddmFormInstance.getStorageType());
        ddmStorageAdapter.save(ddmStorageAdapterSaveRequest);
    }

    protected void updateFormInstanceRecordVersion(User user, DDMFormInstanceRecordVersion ddmFormInstanceRecordVersion, int status, String version, ServiceContext serviceContext) {
        ddmFormInstanceRecordVersion.setUserId(user.getUserId());
        ddmFormInstanceRecordVersion.setUserName(user.getFullName());
        ddmFormInstanceRecordVersion.setVersion(version);
        ddmFormInstanceRecordVersion.setStatus(status);
        ddmFormInstanceRecordVersion.setStatusByUserId(user.getUserId());
        ddmFormInstanceRecordVersion.setStatusByUserName(user.getFullName());
        ddmFormInstanceRecordVersion.setStatusDate(serviceContext.getModifiedDate(null));
        this.ddmFormInstanceRecordVersionPersistence.update((BaseModel)ddmFormInstanceRecordVersion);
    }

    protected void validate(DDMFormValues ddmFormValues, ServiceContext serviceContext) throws PortalException {
        boolean validateDDMFormValues = GetterUtil.getBoolean((Object)serviceContext.getAttribute("validateDDMFormValues"), (boolean)true);
        if (!validateDDMFormValues) {
            return;
        }
        this._ddmFormValuesValidator.validate(ddmFormValues);
    }

    protected void validate(long groupId, DDMFormInstance ddmFormInstance) throws PortalException {
        if (ddmFormInstance.getGroupId() != groupId) {
            throw new FormInstanceRecordGroupIdException("Record group ID is not the same as the form instance group ID");
        }
    }
}

