/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.dynamic.data.mapping.internal.storage;

import com.liferay.dynamic.data.mapping.exception.NoSuchStructureException;
import com.liferay.dynamic.data.mapping.exception.StorageException;
import com.liferay.dynamic.data.mapping.model.DDMStorageLink;
import com.liferay.dynamic.data.mapping.model.DDMStructure;
import com.liferay.dynamic.data.mapping.service.DDMStorageLinkLocalService;
import com.liferay.dynamic.data.mapping.service.DDMStructureLocalService;
import com.liferay.dynamic.data.mapping.storage.DDMFormValues;
import com.liferay.dynamic.data.mapping.storage.StorageAdapter;
import com.liferay.dynamic.data.mapping.storage.StorageAdapterRegistry;
import com.liferay.dynamic.data.mapping.storage.StorageEngine;
import com.liferay.portal.kernel.service.ServiceContext;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.Reference;

@Component(immediate=true, service={StorageEngine.class})
public class StorageEngineImpl
implements StorageEngine {
    private DDMStorageLinkLocalService _ddmStorageLinkLocalService;
    private DDMStructureLocalService _ddmStructureLocalService;
    private StorageAdapterRegistry _storageAdapterRegistry;

    public long create(long companyId, long ddmStructureId, DDMFormValues ddmFormValues, ServiceContext serviceContext) throws StorageException {
        StorageAdapter storageAdapter = this.getStructureStorageAdapter(ddmStructureId);
        return storageAdapter.create(companyId, ddmStructureId, ddmFormValues, serviceContext);
    }

    public void deleteByClass(long classPK) throws StorageException {
        StorageAdapter storageAdapter = this.getClassStorageAdapter(classPK);
        if (storageAdapter != null) {
            storageAdapter.deleteByClass(classPK);
        }
    }

    public void deleteByDDMStructure(long ddmStructureId) throws StorageException {
        StorageAdapter storageAdapter = this.getStructureStorageAdapter(ddmStructureId);
        storageAdapter.deleteByDDMStructure(ddmStructureId);
    }

    public DDMFormValues getDDMFormValues(long classPK) throws StorageException {
        StorageAdapter storageAdapter = this.getClassStorageAdapter(classPK);
        if (storageAdapter == null) {
            return null;
        }
        return storageAdapter.getDDMFormValues(classPK);
    }

    public String getStorageType() {
        throw new UnsupportedOperationException();
    }

    public void update(long classPK, DDMFormValues ddmFormValues, ServiceContext serviceContext) throws StorageException {
        StorageAdapter storageAdapter = this.getClassStorageAdapter(classPK);
        if (storageAdapter != null) {
            storageAdapter.update(classPK, ddmFormValues, serviceContext);
        }
    }

    protected StorageAdapter getClassStorageAdapter(long classPK) throws StorageException {
        try {
            DDMStorageLink ddmStorageLink = this._ddmStorageLinkLocalService.fetchClassStorageLink(classPK);
            if (ddmStorageLink == null) {
                return null;
            }
            return this.getStorageAdapter(ddmStorageLink.getStorageType());
        }
        catch (NoSuchStructureException noSuchStructureException) {
            return this._storageAdapterRegistry.getDefaultStorageAdapter();
        }
        catch (StorageException storageException) {
            throw storageException;
        }
        catch (Exception exception) {
            throw new StorageException((Throwable)exception);
        }
    }

    protected StorageAdapter getStorageAdapter(String storageType) {
        StorageAdapter storageAdapter = this._storageAdapterRegistry.getStorageAdapter(storageType);
        if (storageAdapter != null) {
            return storageAdapter;
        }
        return this._storageAdapterRegistry.getDefaultStorageAdapter();
    }

    protected StorageAdapter getStructureStorageAdapter(long ddmStructureId) throws StorageException {
        try {
            DDMStructure ddmStructure = this._ddmStructureLocalService.getDDMStructure(ddmStructureId);
            return this.getStorageAdapter(ddmStructure.getStorageType());
        }
        catch (NoSuchStructureException noSuchStructureException) {
            return this._storageAdapterRegistry.getDefaultStorageAdapter();
        }
        catch (StorageException storageException) {
            throw storageException;
        }
        catch (Exception exception) {
            throw new StorageException((Throwable)exception);
        }
    }

    @Reference(unbind="-")
    protected void setDDMStorageLinkLocalService(DDMStorageLinkLocalService ddmStorageLinkLocalService) {
        this._ddmStorageLinkLocalService = ddmStorageLinkLocalService;
    }

    @Reference(unbind="-")
    protected void setDDMStructureLocalService(DDMStructureLocalService ddmStructureLocalService) {
        this._ddmStructureLocalService = ddmStructureLocalService;
    }

    @Reference(unbind="-")
    protected void setStorageAdapterRegistry(StorageAdapterRegistry storageAdapterRegistry) {
        this._storageAdapterRegistry = storageAdapterRegistry;
    }
}

